/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom.util;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.util.CrossBarLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.RectanglesHelper;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0010J6\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/base/geom/util/CrossBarHelper;", "", "()V", "buildBoxes", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "rectFactory", "Lkotlin/Function1;", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "buildMidlines", "fatten", "", "legendFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "whiskers", "", "plot-base-portable"})
public final class CrossBarHelper {
    @NotNull
    public static final CrossBarHelper INSTANCE = new CrossBarHelper();

    private CrossBarHelper() {
    }

    public final void buildBoxes(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2, @NotNull Function1<? super DataPointAesthetics, DoubleRectangle> rectFactory) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Intrinsics.checkNotNullParameter(rectFactory, (String)"rectFactory");
        RectanglesHelper helper = new RectanglesHelper(aesthetics, pos, coord, ctx2);
        List<SvgNode> rectangles = helper.createRectangles(rectFactory);
        Iterable $this$forEach$iv = rectangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgNode it = (SvgNode)element$iv;
            boolean bl = false;
            root.add(it);
        }
    }

    public final void buildMidlines(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2, double fatten) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper elementHelper = helper.createSvgElementHelper();
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getWIDTH(), Aes.Companion.getMIDDLE())) {
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double x2 = d;
            Double d2 = p.middle();
            Intrinsics.checkNotNull((Object)d2);
            double middle = d2;
            double width2 = GeomUtil.INSTANCE.widthPx(p, ctx2, 2.0);
            SvgLineElement line2 = elementHelper.createLine(new DoubleVector(x2 - width2 / (double)2, middle), new DoubleVector(x2 + width2 / (double)2, middle), p);
            Object ValueT = line2.strokeWidth().get();
            Intrinsics.checkNotNull(ValueT);
            double thickness = ((Number)ValueT).doubleValue();
            line2.strokeWidth().set(thickness * fatten);
            root.add(line2);
        }
    }

    @NotNull
    public final LegendKeyElementFactory legendFactory(boolean whiskers) {
        return new CrossBarLegendKeyElementFactory(whiskers);
    }
}

