/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jetbrains.datalore.base.event.MouseEventSpec;
import jetbrains.datalore.base.event.awt.AwtEventUtil;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.plot.AwtLiveMapFactoryUtil;
import jetbrains.datalore.plot.AwtPlotFactoryUtil;
import jetbrains.datalore.plot.AwtPlotFactoryUtilKt;
import jetbrains.datalore.plot.DisposableJPanel;
import jetbrains.datalore.plot.MonolithicCommon;
import jetbrains.datalore.plot.builder.PlotContainer;
import jetbrains.datalore.plot.builder.PlotSvgComponent;
import jetbrains.datalore.plot.builder.assemble.PlotAssembler;
import jetbrains.datalore.plot.config.FailureHandler;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.config.PlotConfigClientSide;
import jetbrains.datalore.plot.server.config.PlotConfigServerSide;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\t2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\tH\u0002JM\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00072!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\t2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\tH\u0002JK\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\t2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\tJ\u008a\u0001\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\t2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\t2\u0018\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0006\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0002\u0010\u001eJ\u008a\u0001\u0010\u001f\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00040\t2\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\t2\u0018\u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0006\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0018H\u0002J\u0014\u0010\"\u001a\u00020\u00042\n\u0010#\u001a\u00060$j\u0002`%H\u0002J0\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u00172\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010'\u001a\u00020(H\u0002\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/AwtPlotFactoryUtil;", "", "()V", "buildGGBunchComponent", "Ljavax/swing/JComponent;", "plotInfos", "", "Ljetbrains/datalore/plot/MonolithicCommon$PlotBuildInfo;", "svgComponentFactory", "Lkotlin/Function1;", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "Lkotlin/ParameterName;", "name", "svg", "executor", "Lkotlin/Function0;", "", "buildPlotComponent", "plotBuildInfo", "plotContainer", "Ljetbrains/datalore/plot/builder/PlotContainer;", "buildPlotFromProcessedSpecs", "plotSpec", "", "", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plotMaxWidth", "", "computationMessagesHandler", "(Ljava/util/Map;Ljetbrains/datalore/base/geometry/DoubleVector;Ljava/lang/Double;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljavax/swing/JComponent;", "buildPlotFromRawSpecs", "createErrorLabel", "s", "handleException", "e", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "processSpecs", "frontendOnly", "", "plot-config"})
public final class AwtPlotFactoryUtil {
    @NotNull
    public static final AwtPlotFactoryUtil INSTANCE = new AwtPlotFactoryUtil();

    private AwtPlotFactoryUtil() {
    }

    private final JComponent buildPlotComponent(MonolithicCommon.PlotBuildInfo plotBuildInfo, Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, Function1<? super Function0<Unit>, Unit> executor) {
        PlotAssembler assembler = plotBuildInfo.getPlotAssembler();
        if (assembler.getContainsLiveMap()) {
            return AwtLiveMapFactoryUtil.INSTANCE.buildLiveMapComponent(assembler, plotBuildInfo.getProcessedPlotSpec(), plotBuildInfo.getSize(), svgComponentFactory, executor);
        }
        PlotSvgComponent plot2 = assembler.createPlot();
        PlotContainer plotContainer = new PlotContainer(plot2, plotBuildInfo.getSize());
        return this.buildPlotComponent(plotContainer, svgComponentFactory, executor);
    }

    @NotNull
    public final JComponent buildPlotFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        try {
            Map<String, Object> plotSpec2 = this.processSpecs(plotSpec, false);
            jComponent = this.buildPlotFromProcessedSpecs(plotSpec2, plotSize2, plotMaxWidth, svgComponentFactory, executor, computationMessagesHandler);
        }
        catch (RuntimeException e) {
            jComponent = this.handleException(e);
        }
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JComponent buildPlotFromProcessedSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        try {
            void $this$flatMapTo$iv$iv;
            MonolithicCommon.PlotsBuildResult buildResult = MonolithicCommon.INSTANCE.buildPlotsFromProcessedSpecs(plotSpec, plotSize2, plotMaxWidth);
            if (buildResult.isError()) {
                String errorMessage = ((MonolithicCommon.PlotsBuildResult.Error)buildResult).getError();
                return this.createErrorLabel(errorMessage);
            }
            MonolithicCommon.PlotsBuildResult.Success success2 = (MonolithicCommon.PlotsBuildResult.Success)buildResult;
            Iterable $this$flatMap$iv = success2.getBuildInfos();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MonolithicCommon.PlotBuildInfo it = (MonolithicCommon.PlotBuildInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getComputationMessages();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List computationMessages = (List)destination$iv$iv;
            computationMessagesHandler.invoke((Object)computationMessages);
            if (success2.getBuildInfos().size() == 1) {
                return this.buildPlotComponent(success2.getBuildInfos().get(0), svgComponentFactory, executor);
            }
            return this.buildGGBunchComponent(success2.getBuildInfos(), svgComponentFactory, executor);
        }
        catch (RuntimeException e) {
            JComponent jComponent = this.handleException(e);
            return jComponent;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent buildGGBunchComponent(List<MonolithicCommon.PlotBuildInfo> plotInfos, Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, Function1<? super Function0<Unit>, Unit> executor) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Object bounds;
        void it;
        DisposableJPanel bunchComponent = new DisposableJPanel(null);
        bunchComponent.setBorder(null);
        jetbrains.datalore.base.values.Color color = Colors.INSTANCE.parseColor("white");
        boolean bl = false;
        boolean bl2 = false;
        jetbrains.datalore.base.values.Color color2 = color;
        Object object = bunchComponent;
        boolean bl3 = false;
        Object object2 = new Color(it.getRed(), it.getGreen(), it.getBlue(), it.getAlpha());
        ((JComponent)object).setBackground((Color)object2);
        for (MonolithicCommon.PlotBuildInfo plotInfo : plotInfos) {
            JComponent plotComponent = this.buildPlotComponent(plotInfo, svgComponentFactory, executor);
            bounds = plotInfo.bounds();
            plotComponent.setBounds(new Rectangle((int)((DoubleRectangle)bounds).getOrigin().getX(), (int)((DoubleRectangle)bounds).getOrigin().getY(), (int)((DoubleRectangle)bounds).getDimension().getX(), (int)((DoubleRectangle)bounds).getDimension().getY()));
            bunchComponent.add(plotComponent);
        }
        Iterable $this$map$iv = plotInfos;
        boolean $i$f$map = false;
        bounds = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MonolithicCommon.PlotBuildInfo plotBuildInfo = (MonolithicCommon.PlotBuildInfo)item$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            object2 = it2.bounds();
            object.add(object2);
        }
        $this$map$iv = (List)destination$iv$iv;
        DoubleRectangle initial$iv = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        boolean $i$f$fold = false;
        DoubleRectangle accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bounds2;
            Object item$iv$iv;
            item$iv$iv = (DoubleRectangle)element$iv;
            DoubleRectangle acc = accumulator$iv;
            boolean bl5 = false;
            accumulator$iv = acc.union((DoubleRectangle)bounds2);
        }
        DoubleRectangle bunchBounds = accumulator$iv;
        Dimension bunchDimensions = new Dimension((int)bunchBounds.getWidth(), (int)bunchBounds.getHeight());
        bunchComponent.setPreferredSize(bunchDimensions);
        bunchComponent.setMinimumSize(bunchDimensions);
        bunchComponent.setMaximumSize(bunchDimensions);
        return bunchComponent;
    }

    private final JComponent handleException(RuntimeException e) {
        FailureHandler.FailureInfo failureInfo = FailureHandler.INSTANCE.failureInfo(e);
        if (failureInfo.isInternalError()) {
            AwtPlotFactoryUtilKt.access$getLOG$p().error((Throwable)e, (Function0)handleException.1.INSTANCE);
        }
        return this.createErrorLabel(failureInfo.getMessage());
    }

    private final JComponent createErrorLabel(String s2) {
        JLabel label = new JLabel(s2);
        label.setForeground(Color.RED);
        return label;
    }

    private final Map<String, Object> processSpecs(Map<String, Object> plotSpec, boolean frontendOnly) {
        Map<String, Object> plotSpec2;
        PlotConfig.Companion.assertPlotSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            return plotSpec;
        }
        Map<String, Object> map2 = plotSpec2 = frontendOnly ? plotSpec : PlotConfigServerSide.Companion.processTransform(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec2)) {
            return plotSpec2;
        }
        return PlotConfigClientSide.Companion.processTransform(plotSpec2);
    }

    @NotNull
    public final JComponent buildPlotComponent(@NotNull PlotContainer plotContainer, @NotNull Function1<? super SvgSvgElement, ? extends JComponent> svgComponentFactory, @NotNull Function1<? super Function0<Unit>, Unit> executor) {
        Intrinsics.checkNotNullParameter((Object)plotContainer, (String)"plotContainer");
        Intrinsics.checkNotNullParameter(svgComponentFactory, (String)"svgComponentFactory");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        plotContainer.ensureContentBuilt();
        SvgSvgElement svg = plotContainer.getSvg();
        if (plotContainer.isLiveMap()) {
            svg.addClass("plt-transparent");
        }
        JComponent plotComponent = (JComponent)svgComponentFactory.invoke((Object)svg);
        plotComponent.addMouseMotionListener(new MouseAdapter(executor, plotContainer){
            final /* synthetic */ Function1<Function0<Unit>, Unit> $executor;
            final /* synthetic */ PlotContainer $plotContainer;
            {
                this.$executor = $executor;
                this.$plotContainer = $plotContainer;
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseMoved(e);
                this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                    final /* synthetic */ PlotContainer $plotContainer;
                    final /* synthetic */ MouseEvent $e;
                    {
                        this.$plotContainer = $plotContainer;
                        this.$e = $e;
                        super(0);
                    }

                    public final void invoke() {
                        this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_MOVED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                });
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseDragged(e);
                this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                    final /* synthetic */ PlotContainer $plotContainer;
                    final /* synthetic */ MouseEvent $e;
                    {
                        this.$plotContainer = $plotContainer;
                        this.$e = $e;
                        super(0);
                    }

                    public final void invoke() {
                        this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_DRAGGED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                });
            }
        });
        plotComponent.addMouseListener(new MouseAdapter(executor, plotContainer){
            final /* synthetic */ Function1<Function0<Unit>, Unit> $executor;
            final /* synthetic */ PlotContainer $plotContainer;
            {
                this.$executor = $executor;
                this.$plotContainer = $plotContainer;
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseExited(e);
                this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                    final /* synthetic */ PlotContainer $plotContainer;
                    final /* synthetic */ MouseEvent $e;
                    {
                        this.$plotContainer = $plotContainer;
                        this.$e = $e;
                        super(0);
                    }

                    public final void invoke() {
                        this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_LEFT, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                });
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseClicked(e);
                MouseEventSpec event = e.getClickCount() % 2 == 1 ? MouseEventSpec.MOUSE_CLICKED : MouseEventSpec.MOUSE_DOUBLE_CLICKED;
                this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, event, e){
                    final /* synthetic */ PlotContainer $plotContainer;
                    final /* synthetic */ MouseEventSpec $event;
                    final /* synthetic */ MouseEvent $e;
                    {
                        this.$plotContainer = $plotContainer;
                        this.$event = $event;
                        this.$e = $e;
                        super(0);
                    }

                    public final void invoke() {
                        this.$plotContainer.getMouseEventPeer().dispatch(this.$event, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                });
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mousePressed(e);
                this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                    final /* synthetic */ PlotContainer $plotContainer;
                    final /* synthetic */ MouseEvent $e;
                    {
                        this.$plotContainer = $plotContainer;
                        this.$e = $e;
                        super(0);
                    }

                    public final void invoke() {
                        this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_PRESSED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                });
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseReleased(e);
                this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                    final /* synthetic */ PlotContainer $plotContainer;
                    final /* synthetic */ MouseEvent $e;
                    {
                        this.$plotContainer = $plotContainer;
                        this.$e = $e;
                        super(0);
                    }

                    public final void invoke() {
                        this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_RELEASED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                });
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseEntered(e);
                this.$executor.invoke((Object)new Function0<Unit>(this.$plotContainer, e){
                    final /* synthetic */ PlotContainer $plotContainer;
                    final /* synthetic */ MouseEvent $e;
                    {
                        this.$plotContainer = $plotContainer;
                        this.$e = $e;
                        super(0);
                    }

                    public final void invoke() {
                        this.$plotContainer.getMouseEventPeer().dispatch(MouseEventSpec.MOUSE_ENTERED, AwtEventUtil.translate$default(AwtEventUtil.INSTANCE, this.$e, null, 2, null));
                    }
                });
            }
        });
        return plotComponent;
    }
}

