/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import jetbrains.datalore.base.event.Event;
import jetbrains.datalore.base.event.Key;
import jetbrains.datalore.base.event.KeyStroke;
import jetbrains.datalore.base.event.KeyStrokeSpec;
import jetbrains.datalore.base.event.ModifierKey;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB%\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\fJ'\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u001c\"\u00020\f\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u001c\"\u00020\u0003\u00a2\u0006\u0002\u0010\u001fJ\u001f\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001c\"\u00020 \u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Ljetbrains/datalore/base/event/KeyEvent;", "Ljetbrains/datalore/base/event/Event;", "keyStroke", "Ljetbrains/datalore/base/event/KeyStroke;", "(Ljetbrains/datalore/base/event/KeyStroke;)V", "key", "Ljetbrains/datalore/base/event/Key;", "ch", "", "(Ljetbrains/datalore/base/event/Key;C)V", "modifiers", "", "Ljetbrains/datalore/base/event/ModifierKey;", "(Ljetbrains/datalore/base/event/Key;CLjava/util/Collection;)V", "getKey", "()Ljetbrains/datalore/base/event/Key;", "keyChar", "getKeyChar", "()C", "getKeyStroke", "()Ljetbrains/datalore/base/event/KeyStroke;", "", "getModifiers", "()Ljava/util/Set;", "copy", "has", "", "is", "", "(Ljetbrains/datalore/base/event/Key;[Ljetbrains/datalore/base/event/ModifierKey;)Z", "specs", "([Ljetbrains/datalore/base/event/KeyStroke;)Z", "Ljetbrains/datalore/base/event/KeyStrokeSpec;", "([Ljetbrains/datalore/base/event/KeyStrokeSpec;)Z", "toString", "", "base-portable"})
public final class KeyEvent
extends Event {
    @NotNull
    private final KeyStroke keyStroke;
    private final char keyChar;

    @NotNull
    public final KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public final char getKeyChar() {
        return this.keyChar;
    }

    @NotNull
    public final Key getKey() {
        return this.keyStroke.getKey();
    }

    @NotNull
    public final Set<ModifierKey> getModifiers() {
        return this.keyStroke.getModifiers();
    }

    public KeyEvent(@NotNull KeyStroke keyStroke) {
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        this.keyStroke = keyStroke;
        this.keyChar = '\u0000';
    }

    public KeyEvent(@NotNull Key key, char ch) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        this.keyStroke = new KeyStroke(key, CollectionsKt.emptyList());
        this.keyChar = ch;
    }

    public /* synthetic */ KeyEvent(Key key, char c, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            c = '\u0000';
        }
        this(key, c);
    }

    public KeyEvent(@NotNull Key key, char ch, @NotNull Collection<? extends ModifierKey> modifiers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        this.keyStroke = new KeyStroke(key, modifiers);
        this.keyChar = ch;
    }

    public final boolean is(@NotNull Key key, ModifierKey ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        return this.keyStroke.is(key, Arrays.copyOf(modifiers, modifiers.length));
    }

    public final boolean is(KeyStrokeSpec ... specs) {
        Intrinsics.checkNotNullParameter((Object)specs, (String)"specs");
        for (KeyStrokeSpec s2 : specs) {
            if (!s2.matches(this.keyStroke)) continue;
            return true;
        }
        return false;
    }

    public final boolean is(KeyStroke ... specs) {
        Intrinsics.checkNotNullParameter((Object)specs, (String)"specs");
        for (KeyStroke s2 : specs) {
            if (!s2.matches(this.keyStroke)) continue;
            return true;
        }
        return false;
    }

    public final boolean has(@NotNull ModifierKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return this.keyStroke.has(key);
    }

    @NotNull
    public final KeyEvent copy() {
        return new KeyEvent(this.getKey(), this.keyChar, (Collection<? extends ModifierKey>)this.getModifiers());
    }

    @NotNull
    public String toString() {
        return this.keyStroke.toString();
    }
}

