/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.datetime.tz;

import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.Duration;
import jetbrains.datalore.base.datetime.Instant;
import jetbrains.datalore.base.datetime.Month;
import jetbrains.datalore.base.datetime.Time;
import jetbrains.datalore.base.datetime.WeekDay;
import jetbrains.datalore.base.datetime.tz.DateSpec;
import jetbrains.datalore.base.datetime.tz.DateSpecs;
import jetbrains.datalore.base.datetime.tz.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\tJ\u0016\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fJ\u0016\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/datalore/base/datetime/tz/TimeZones;", "", "()V", "MILLIS_IN_DAY", "", "MILLIS_IN_HOUR", "MILLIS_IN_MINUTE", "MILLIS_IN_SECOND", "offset", "Ljetbrains/datalore/base/datetime/tz/TimeZone;", "id", "", "Ljetbrains/datalore/base/datetime/Duration;", "base", "toDateTime", "Ljetbrains/datalore/base/datetime/DateTime;", "instant", "Ljetbrains/datalore/base/datetime/Instant;", "toInstant", "dateTime", "toMillis", "date", "Ljetbrains/datalore/base/datetime/Date;", "time", "Ljetbrains/datalore/base/datetime/Time;", "utc", "withEuSummerTime", "withUsSummerTime", "DSTimeZone", "base-portable"})
public final class TimeZones {
    @NotNull
    public static final TimeZones INSTANCE = new TimeZones();
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;

    private TimeZones() {
    }

    private final DateTime toDateTime(Instant instant, Duration offset2) {
        Instant instant2 = instant;
        instant2 = instant2.add(offset2);
        int days = (int)(instant2.getTimeSinceEpoch() / 86400000L);
        Date date = Date.Companion.getEPOCH().addDays(days);
        long rest = instant2.getTimeSinceEpoch() % 86400000L;
        int hour = (int)(rest / 3600000L);
        int minutes = (int)((rest %= 3600000L) / 60000L);
        int seconds = (int)((rest %= 60000L) / 1000L);
        int milliseconds = (int)((rest %= 1000L) % 1000L);
        return new DateTime(date, new Time(hour, minutes, seconds, milliseconds));
    }

    private final Instant toInstant(DateTime dateTime, Duration offset2) {
        return new Instant(this.toMillis(dateTime.getDate()) + this.toMillis(dateTime.getTime())).sub(offset2);
    }

    private final long toMillis(Time time2) {
        long minutes = (long)time2.getHours() * 60L + (long)time2.getMinutes();
        long seconds = minutes * (long)60 + (long)time2.getSeconds();
        return seconds * (long)1000 + (long)time2.getMilliseconds();
    }

    private final long toMillis(Date date) {
        return (long)date.daysFrom(Date.Companion.getEPOCH()) * 86400000L;
    }

    @NotNull
    public final TimeZone utc() {
        return new TimeZone(){

            @NotNull
            public DateTime toDateTime(@NotNull Instant instant) {
                Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
                return TimeZones.access$toDateTime(TimeZones.INSTANCE, instant, new Duration(0L));
            }

            @NotNull
            public Instant toInstant(@NotNull DateTime dateTime) {
                Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
                return TimeZones.access$toInstant(TimeZones.INSTANCE, dateTime, new Duration(0L));
            }
        };
    }

    @NotNull
    public final TimeZone offset(@Nullable String id, @NotNull Duration offset2, @NotNull TimeZone base) {
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        return new TimeZone(base, offset2, id){
            final /* synthetic */ TimeZone $base;
            final /* synthetic */ Duration $offset;
            final /* synthetic */ String $id;
            {
                this.$base = $base;
                this.$offset = $offset;
                this.$id = $id;
                super($id);
            }

            @NotNull
            public DateTime toDateTime(@NotNull Instant instant) {
                Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
                return this.$base.toDateTime(instant.add(this.$offset));
            }

            @NotNull
            public Instant toInstant(@NotNull DateTime dateTime) {
                Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
                return this.$base.toInstant(dateTime).sub(this.$offset);
            }
        };
    }

    @NotNull
    public final TimeZone withEuSummerTime(@NotNull String id, @NotNull Duration offset2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        DateSpec startSpec = DateSpecs.INSTANCE.last(WeekDay.SUNDAY, Month.Companion.getMARCH());
        DateSpec endSpec = DateSpecs.INSTANCE.last(WeekDay.SUNDAY, Month.Companion.getOCTOBER());
        Time utcChangeTime = new Time(1, 0, 0, 0, 12, null);
        return new DSTimeZone(startSpec, utcChangeTime, endSpec, id, offset2){
            final /* synthetic */ DateSpec $startSpec;
            final /* synthetic */ Time $utcChangeTime;
            final /* synthetic */ DateSpec $endSpec;
            final /* synthetic */ String $id;
            final /* synthetic */ Duration $offset;
            {
                this.$startSpec = $startSpec;
                this.$utcChangeTime = $utcChangeTime;
                this.$endSpec = $endSpec;
                this.$id = $id;
                this.$offset = $offset;
                super($id, $offset);
            }

            @NotNull
            protected Instant getStartInstant(int year) {
                return TimeZone.Companion.getUTC().toInstant(new DateTime(this.$startSpec.getDate(year), this.$utcChangeTime));
            }

            @NotNull
            protected Instant getEndInstant(int year) {
                return TimeZone.Companion.getUTC().toInstant(new DateTime(this.$endSpec.getDate(year), this.$utcChangeTime));
            }
        };
    }

    @NotNull
    public final TimeZone withUsSummerTime(@NotNull String id, @NotNull Duration offset2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        DateSpec startSpec = DateSpecs.INSTANCE.first(WeekDay.SUNDAY, Month.Companion.getMARCH(), 2);
        DateSpec endSpec = DateSpecs.first$default(DateSpecs.INSTANCE, WeekDay.SUNDAY, Month.Companion.getNOVEMBER(), 0, 4, null);
        return new DSTimeZone(startSpec, offset2, endSpec, id){
            final /* synthetic */ DateSpec $startSpec;
            final /* synthetic */ Duration $offset;
            final /* synthetic */ DateSpec $endSpec;
            final /* synthetic */ String $id;
            {
                this.$startSpec = $startSpec;
                this.$offset = $offset;
                this.$endSpec = $endSpec;
                this.$id = $id;
                super($id, $offset);
            }

            @NotNull
            protected Instant getStartInstant(int year) {
                return TimeZone.Companion.getUTC().toInstant(new DateTime(this.$startSpec.getDate(year), new Time(2, 0, 0, 0, 12, null))).sub(this.$offset);
            }

            @NotNull
            protected Instant getEndInstant(int year) {
                return TimeZone.Companion.getUTC().toInstant(new DateTime(this.$endSpec.getDate(year), new Time(2, 0, 0, 0, 12, null))).sub(this.$offset.add(Duration.Companion.getHOUR()));
            }
        };
    }

    public static final /* synthetic */ DateTime access$toDateTime(TimeZones $this, Instant instant, Duration offset2) {
        return $this.toDateTime(instant, offset2);
    }

    public static final /* synthetic */ Instant access$toInstant(TimeZones $this, DateTime dateTime, Duration offset2) {
        return $this.toInstant(dateTime, offset2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/base/datetime/tz/TimeZones$DSTimeZone;", "Ljetbrains/datalore/base/datetime/tz/TimeZone;", "id", "", "offset", "Ljetbrains/datalore/base/datetime/Duration;", "(Ljava/lang/String;Ljetbrains/datalore/base/datetime/Duration;)V", "mySummerTz", "myTz", "getEndInstant", "Ljetbrains/datalore/base/datetime/Instant;", "year", "", "getStartInstant", "toDateTime", "Ljetbrains/datalore/base/datetime/DateTime;", "instant", "toInstant", "dateTime", "base-portable"})
    private static abstract class DSTimeZone
    extends TimeZone {
        @NotNull
        private final TimeZone myTz;
        @NotNull
        private final TimeZone mySummerTz;

        public DSTimeZone(@NotNull String id, @NotNull Duration offset2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
            super(id);
            this.myTz = INSTANCE.offset(null, offset2, TimeZone.Companion.getUTC());
            this.mySummerTz = INSTANCE.offset(null, offset2.add(Duration.Companion.getHOUR()), TimeZone.Companion.getUTC());
        }

        @Override
        @NotNull
        public DateTime toDateTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            DateTime tzDt = this.myTz.toDateTime(instant);
            Instant start2 = this.getStartInstant(tzDt.getYear());
            Instant end = this.getEndInstant(tzDt.getYear());
            return instant.compareTo(start2) > 0 && instant.compareTo(end) < 0 ? this.mySummerTz.toDateTime(instant) : tzDt;
        }

        @Override
        @NotNull
        public Instant toInstant(@NotNull DateTime dateTime) {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            DateTime startDt = this.toDateTime(this.getStartInstant(dateTime.getYear()));
            DateTime endDt = this.toDateTime(this.getEndInstant(dateTime.getYear()));
            return dateTime.compareTo(startDt) > 0 && dateTime.compareTo(endDt) < 0 ? this.mySummerTz.toInstant(dateTime) : this.myTz.toInstant(dateTime);
        }

        @NotNull
        protected abstract Instant getStartInstant(int var1);

        @NotNull
        protected abstract Instant getEndInstant(int var1);
    }
}

