/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.util.VectorAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0004Jd\u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/util/ArrowSupport;", "", "()V", "MIN_HEAD_LENGTH", "", "MIN_TAIL_LENGTH", "arrowPadding", "angle", "onStart", "", "onEnd", "atStart", "strokeSize", "createArrowHeads", "Lkotlin/Pair;", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "lineString", "arrowLength", "closed", "minTailLength", "minHeadLength", "miterLength", "ArrowHelper", "commons"})
public final class ArrowSupport {
    @NotNull
    public static final ArrowSupport INSTANCE = new ArrowSupport();
    public static final double MIN_TAIL_LENGTH = 10.0;
    public static final double MIN_HEAD_LENGTH = 5.0;

    private ArrowSupport() {
    }

    @NotNull
    public final Pair<List<DoubleVector>, List<DoubleVector>> createArrowHeads(@NotNull List<DoubleVector> lineString, double angle, double arrowLength, boolean onStart, boolean onEnd, boolean closed, double minTailLength, double minHeadLength) {
        Intrinsics.checkNotNullParameter(lineString, (String)"lineString");
        ArrowHelper<DoubleVector> arrowHelper = new ArrowHelper<DoubleVector>(VectorAdapter.Companion.getDOUBLE_VECTOR_ADAPTER());
        return arrowHelper.createArrowHeads(lineString, angle, arrowLength, onStart, onEnd, closed, minTailLength, minHeadLength);
    }

    public final double arrowPadding(double angle, boolean onStart, boolean onEnd, boolean atStart, double strokeSize) {
        boolean hasArrow;
        boolean bl = hasArrow = atStart ? onStart : onEnd;
        if (!hasArrow) {
            return 0.0;
        }
        double miterLength = this.miterLength(angle, strokeSize);
        double miterSign = Math.signum(Math.sin(angle * (double)2));
        return miterLength * miterSign / (double)2;
    }

    public final double miterLength(double angle, double strokeSize) {
        return strokeSize / Math.sin(angle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002JT\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002Jd\u0010\u0019\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00150\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u001a\u0010\u001e\u001a\u00028\u0000*\u00028\u00002\u0006\u0010\u001f\u001a\u00028\u0000H\u0082\u0002\u00a2\u0006\u0002\u0010 J\u0011\u0010!\u001a\u00028\u0000*\u00020\"H\u0002\u00a2\u0006\u0002\u0010#R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00020\u0007*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00020\u0007*\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/util/ArrowSupport$ArrowHelper;", "T", "", "vec", "Lorg/jetbrains/letsPlot/commons/intern/util/VectorAdapter;", "(Lorg/jetbrains/letsPlot/commons/intern/util/VectorAdapter;)V", "x", "", "getX", "(Ljava/lang/Object;)D", "y", "getY", "adjustArrowHeadLength", "lineLength", "onStart", "", "onEnd", "arrowLength", "minTailLength", "minHeadLength", "createArrowHeadGeometry", "", "lineString", "angle", "closed", "createArrowHeads", "Lkotlin/Pair;", "pointIndexAtDistance", "", "distanceFromEnd", "minus", "other", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "toVec", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)Ljava/lang/Object;", "commons"})
    @SourceDebugExtension(value={"SMAP\nArrowSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrowSupport.kt\norg/jetbrains/letsPlot/commons/intern/util/ArrowSupport$ArrowHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n1774#3,4:200\n*S KotlinDebug\n*F\n+ 1 ArrowSupport.kt\norg/jetbrains/letsPlot/commons/intern/util/ArrowSupport$ArrowHelper\n*L\n182#1:200,4\n*E\n"})
    public static final class ArrowHelper<T> {
        @NotNull
        private final VectorAdapter<T> vec;

        public ArrowHelper(@NotNull VectorAdapter<T> vec) {
            Intrinsics.checkNotNullParameter(vec, (String)"vec");
            this.vec = vec;
        }

        @NotNull
        public final Pair<List<T>, List<T>> createArrowHeads(@NotNull List<? extends T> lineString, double angle, double arrowLength, boolean onStart, boolean onEnd, boolean closed, double minTailLength, double minHeadLength) {
            List<? extends T> list;
            List<T> list2;
            Intrinsics.checkNotNullParameter(lineString, (String)"lineString");
            boolean bl = onStart;
            if (bl) {
                list2 = this.createArrowHeadGeometry(CollectionsKt.asReversed(lineString), angle, arrowLength, onStart, onEnd, closed, minTailLength, minHeadLength);
            } else if (!bl) {
                list2 = CollectionsKt.emptyList();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<T> startHead = list2;
            boolean bl2 = onEnd;
            if (bl2) {
                list = this.createArrowHeadGeometry(lineString, angle, arrowLength, onStart, onEnd, closed, minTailLength, minHeadLength);
            } else if (!bl2) {
                list = CollectionsKt.emptyList();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<? extends T> endHead = list;
            return TuplesKt.to(startHead, (Object)endHead);
        }

        private final int pointIndexAtDistance(List<? extends T> lineString, double distanceFromEnd) {
            T prev;
            T cur;
            int i = CollectionsKt.getLastIndex(lineString);
            for (double length = 0.0; i > 0 && length < distanceFromEnd; length += MathKt.distance(this.getX(cur), this.getY(cur), this.getX(prev), this.getY(prev))) {
                cur = lineString.get(i);
                prev = lineString.get(--i);
            }
            return i;
        }

        private final List<T> createArrowHeadGeometry(List<? extends T> lineString, double angle, double arrowLength, boolean onStart, boolean onEnd, boolean closed, double minTailLength, double minHeadLength) {
            List list;
            Object object;
            if (lineString.size() < 2) {
                return CollectionsKt.emptyList();
            }
            Iterable iterable = CollectionsKt.windowed$default((Iterable)lineString, (int)2, (int)0, (boolean)false, (int)6, null);
            double d = 0.0;
            for (Object t : iterable) {
                List list2 = (List)t;
                double d2 = d;
                boolean bl = false;
                Object a = list2.get(0);
                Object b = list2.get(1);
                double d3 = MathKt.distance(this.getX(a), this.getY(a), this.getX(b), this.getY(b));
                d = d2 + d3;
            }
            double lineLength = d;
            double headLength = this.adjustArrowHeadLength(lineLength, onStart, onEnd, arrowLength, minTailLength, minHeadLength);
            switch (lineString.size()) {
                case 0: 
                case 1: {
                    throw new IllegalStateException("Invalid geometry".toString());
                }
                case 2: {
                    object = CollectionsKt.first(lineString);
                    break;
                }
                default: {
                    object = lineString.get(this.pointIndexAtDistance(lineString, headLength));
                }
            }
            Object basePoint = object;
            Object tipPoint = CollectionsKt.last(lineString);
            double abscissa = this.getX(tipPoint) - this.getX(basePoint);
            double ordinate = this.getY(tipPoint) - this.getY(basePoint);
            if (abscissa == 0.0 && ordinate == 0.0) {
                return CollectionsKt.emptyList();
            }
            double polarAngle = Math.atan2(ordinate, abscissa);
            Object length = this.minus(tipPoint, this.vec.create((Number)headLength, (Number)0));
            T side1 = this.toVec(MathKt.rotateAround(this.getX(length), this.getY(length), this.getX(tipPoint), this.getY(tipPoint), polarAngle - angle));
            T side2 = this.toVec(MathKt.rotateAround(this.getX(length), this.getY(length), this.getX(tipPoint), this.getY(tipPoint), polarAngle + angle));
            boolean bl = closed;
            if (bl) {
                Object[] objectArray = new Object[]{side1, tipPoint, side2, side1};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else if (!bl) {
                Object[] objectArray = new Object[]{side1, tipPoint, side2};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return list;
        }

        private final double adjustArrowHeadLength(double lineLength, boolean onStart, boolean onEnd, double arrowLength, double minTailLength, double minHeadLength) {
            double d;
            boolean bl;
            int n;
            Object[] objectArray = new Boolean[]{onStart, onEnd};
            Iterable $this$count$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl2 = false;
                    if (!it || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int headsCount = n;
            double headsLength = arrowLength * (double)headsCount;
            double tailLength = lineLength - headsLength;
            boolean bl3 = bl = tailLength < minTailLength;
            if (bl) {
                d = Math.max((lineLength - minTailLength) / (double)headsCount, minHeadLength);
            } else if (!bl) {
                d = arrowLength;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return d;
        }

        public final double getX(T $this$x) {
            return this.vec.x($this$x);
        }

        public final double getY(T $this$y) {
            return this.vec.y($this$y);
        }

        private final T minus(T $this$minus, T other) {
            return this.vec.create(this.getX($this$minus) - this.getX(other), this.getY($this$minus) - this.getY(other));
        }

        private final T toVec(DoubleVector $this$toVec) {
            return this.vec.create($this$toVec.getX(), $this$toVec.getY());
        }
    }
}

