/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.json.JsonSupportKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001J\u0014\u0010\r\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u000e\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0012H\u0002J \u0010\u0013\u001a\u00020\b2\u0016\u0010\u0014\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\u0018\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002J,\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u0002H\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\u001c\u0018\u00010\u001a\"\u0004\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter;", "", "pretty", "", "(Z)V", "output", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output;", "append", "", "s", "", "formatJson", "o", "handleList", "list", "", "handleMap", "map", "", "handlePair", "pair", "", "handleString", "v", "handleValue", "headTail", "Lkotlin/Pair;", "E", "Lkotlin/sequences/Sequence;", "", "Output", "Pretty", "Simple", "commons"})
@SourceDebugExtension(value={"SMAP\nJsonFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFormatter.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,200:1\n1#2:201\n1313#3,2:202\n1313#3,2:204\n*S KotlinDebug\n*F\n+ 1 JsonFormatter.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonFormatter\n*L\n23#1:202,2\n38#1:204,2\n*E\n"})
public final class JsonFormatter {
    @NotNull
    private final Output output;

    public JsonFormatter(boolean pretty) {
        this.output = pretty ? (Output)new Pretty() : (Output)new Simple();
    }

    public /* synthetic */ JsonFormatter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public final String formatJson(@NotNull Object o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        this.handleValue(o);
        return this.output.asString();
    }

    private final void handleList(List<?> list) {
        Output.CollectionContext ctx = this.output.newCollectionContext((Collection)list);
        this.output.startList(ctx);
        Pair pair2 = this.headTail((Collection)list);
        if (pair2 != null) {
            Pair pair3 = pair2;
            boolean bl = false;
            Object head = pair3.component1();
            Sequence tail = (Sequence)pair3.component2();
            this.output.firstItem(ctx);
            this.handleValue(head);
            Sequence $this$forEach$iv = tail;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl2 = false;
                this.output.nextItem(ctx);
                this.handleValue(it);
            }
        }
        this.output.endList(ctx);
    }

    private final void handleMap(Map<?, ?> map2) {
        Output.CollectionContext ctx = this.output.newCollectionContext(map2.values());
        this.output.startMap(ctx);
        Pair pair2 = this.headTail((Collection)map2.entrySet());
        if (pair2 != null) {
            Pair pair3 = pair2;
            boolean bl = false;
            Map.Entry head = (Map.Entry)pair3.component1();
            Sequence tail = (Sequence)pair3.component2();
            this.output.firstItem(ctx);
            this.handlePair(head);
            Sequence $this$forEach$iv = tail;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl2 = false;
                this.output.nextItem(ctx);
                this.handlePair(it);
            }
        }
        this.output.endMap(ctx);
    }

    private final void handleValue(Object v) {
        Object object = v;
        if (object == null) {
            this.append("null");
        } else if (object instanceof String) {
            this.handleString(v);
        } else if (object instanceof Boolean) {
            this.append(String.valueOf((Boolean)v));
        } else if (object instanceof Number) {
            this.append(((Number)v).toString());
        } else if (object instanceof Object[]) {
            this.handleList(ArraysKt.asList((Object[])((Object[])v)));
        } else if (object instanceof List) {
            this.handleList((List)v);
        } else if (object instanceof Map) {
            this.handleMap((Map)v);
        } else {
            throw new IllegalArgumentException("Can't serialize object `" + v + "`(type " + Reflection.getOrCreateKotlinClass(v.getClass()).getSimpleName() + "`)");
        }
    }

    private final void handlePair(Map.Entry<? extends Object, ? extends Object> pair2) {
        this.handleString(pair2.getKey());
        this.append(": ");
        this.handleValue(pair2.getValue());
    }

    private final void handleString(Object v) {
        Object object = v;
        if (object != null) {
            if (object instanceof String) {
                this.append('\"' + JsonSupportKt.escape((String)v) + '\"');
            } else {
                throw new IllegalArgumentException("Expected a string, but got '" + Reflection.getOrCreateKotlinClass(v.getClass()).getSimpleName() + '\'');
            }
        }
    }

    private final void append(String s) {
        this.output.append(s);
    }

    private final <E> Pair<E, Sequence<E>> headTail(Collection<? extends E> $this$headTail) {
        if ($this$headTail.isEmpty()) {
            return null;
        }
        return new Pair(CollectionsKt.first((Iterable)$this$headTail), (Object)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)$this$headTail), (int)1));
    }

    public JsonFormatter() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0001\u0012J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\u0014\u0010\f\u001a\u00020\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output;", "", "append", "", "s", "", "asString", "endList", "ctx", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output$CollectionContext;", "endMap", "firstItem", "newCollectionContext", "c", "", "nextItem", "startList", "startMap", "CollectionContext", "commons"})
    public static interface Output {
        @NotNull
        public CollectionContext newCollectionContext(@NotNull Collection<?> var1);

        public void append(@NotNull String var1);

        public void startList(@NotNull CollectionContext var1);

        public void endList(@NotNull CollectionContext var1);

        public void startMap(@NotNull CollectionContext var1);

        public void endMap(@NotNull CollectionContext var1);

        public void firstItem(@NotNull CollectionContext var1);

        public void nextItem(@NotNull CollectionContext var1);

        @NotNull
        public String asString();

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output$CollectionContext;", "", "commons"})
        public static interface CollectionContext {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0006\u001a\u00020\u000bH\u0002J\u0014\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Pretty;", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output;", "()V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "", "append", "", "s", "", "asString", "endList", "ctx", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output$CollectionContext;", "endMap", "firstItem", "newCollectionContext", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Pretty$PrettyContext;", "c", "", "nextItem", "startList", "startMap", "PrettyContext", "commons"})
    public static final class Pretty
    implements Output {
        private int indent;
        @NotNull
        private StringBuilder buffer = new StringBuilder();

        @Override
        @NotNull
        public PrettyContext newCollectionContext(@NotNull Collection<?> c) {
            Intrinsics.checkNotNullParameter(c, (String)"c");
            return new PrettyContext(c);
        }

        @Override
        public void startList(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.buffer.append("[");
            int n = this.indent;
            this.indent = n + 1;
        }

        @Override
        public void endList(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            int n = this.indent;
            this.indent = n + -1;
            if (((PrettyContext)ctx).getSplitLines()) {
                this.buffer.append("\n");
                this.buffer.append(this.indent());
            } else {
                this.buffer.append(" ");
            }
            this.buffer.append("]");
        }

        @Override
        public void startMap(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.buffer.append("{");
            int n = this.indent;
            this.indent = n + 1;
        }

        @Override
        public void endMap(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            int n = this.indent;
            this.indent = n + -1;
            if (((PrettyContext)ctx).getSplitLines()) {
                this.buffer.append("\n");
                this.buffer.append(this.indent());
            } else {
                this.buffer.append(" ");
            }
            this.buffer.append("}");
        }

        @Override
        @NotNull
        public String asString() {
            String string = this.buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public void append(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.buffer.append(s);
        }

        private final String indent() {
            return StringsKt.repeat((CharSequence)"  ", (int)(this.indent * 2));
        }

        @Override
        public void firstItem(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (((PrettyContext)ctx).getSplitLines()) {
                this.buffer.append("\n");
                this.buffer.append(this.indent());
            } else {
                this.buffer.append(" ");
            }
        }

        @Override
        public void nextItem(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.buffer.append(", ");
            if (((PrettyContext)ctx).getSplitLines()) {
                this.buffer.append("\n");
                this.buffer.append(this.indent());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Pretty$PrettyContext;", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output$CollectionContext;", "collection", "", "(Ljava/util/Collection;)V", "splitLines", "", "getSplitLines", "()Z", "commons"})
        @SourceDebugExtension(value={"SMAP\nJsonFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonFormatter.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Pretty$PrettyContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1747#2,3:201\n*S KotlinDebug\n*F\n+ 1 JsonFormatter.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Pretty$PrettyContext\n*L\n126#1:201,3\n*E\n"})
        public static final class PrettyContext
        implements Output.CollectionContext {
            private final boolean splitLines;

            /*
             * Unable to fully structure code
             */
            public PrettyContext(@NotNull Collection<?> collection) {
                block5: {
                    Intrinsics.checkNotNullParameter(collection, (String)"collection");
                    super();
                    v0 = this;
                    if (collection.size() > 10) ** GOTO lbl-1000
                    var2_2 = collection;
                    var8_3 = v0;
                    $i$f$any = false;
                    if (((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        var4_5 = $this$any$iv.iterator();
                        while (var4_5.hasNext()) {
                            it = element$iv = var4_5.next();
                            $i$a$-any-JsonFormatter$Pretty$PrettyContext$splitLines$1 = false;
                            if (!(it instanceof Collection != false || it instanceof Map != false)) continue;
                            v1 = true;
                            break block5;
                        }
                        v1 = false;
                    }
                }
                var9_9 = v1;
                v0 = var8_3;
                if (var9_9) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                v0.splitLines = v2;
            }

            public final boolean getSplitLines() {
                return this.splitLines;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u0010\u001a\u00020\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Simple;", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output;", "()V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "append", "", "s", "", "asString", "endList", "ctx", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonFormatter$Output$CollectionContext;", "endMap", "firstItem", "newCollectionContext", "c", "", "nextItem", "startList", "startMap", "commons"})
    public static final class Simple
    implements Output {
        @NotNull
        private StringBuilder buffer = new StringBuilder();

        @Override
        @NotNull
        public Output.CollectionContext newCollectionContext(@NotNull Collection<?> c) {
            Intrinsics.checkNotNullParameter(c, (String)"c");
            return new Output.CollectionContext(){};
        }

        @Override
        public void startList(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.append("[");
        }

        @Override
        public void endList(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.append("]");
        }

        @Override
        public void startMap(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.append("{");
        }

        @Override
        public void endMap(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.append("}");
        }

        @Override
        @NotNull
        public String asString() {
            String string = this.buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @Override
        public void firstItem(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        }

        @Override
        public void nextItem(@NotNull Output.CollectionContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            this.buffer.append(",");
        }

        @Override
        public void append(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            this.buffer.append(s);
        }
    }
}

