/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.formatting.string;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormat;
import org.jetbrains.letsPlot.commons.formatting.datetime.Pattern;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.Instant;
import org.jetbrains.letsPlot.commons.intern.datetime.tz.TimeZone;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00152\u00020\u0001:\u0003\u0015\u0016\u0017B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0001J\u0014\u0010\u0010\u001a\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eJ.\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat;", "", "pattern", "", "formatType", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$FormatType;", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$FormatType;Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;)V", "argsNumber", "", "getArgsNumber", "()I", "myFormatters", "", "Lkotlin/Function1;", "format", "value", "values", "initFormatter", "formatPattern", "Companion", "ExponentFormat", "FormatType", "commons"})
public final class StringFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pattern;
    @NotNull
    private final FormatType formatType;
    @NotNull
    private final List<Function1<Object, String>> myFormatters;
    private final int argsNumber;
    @NotNull
    private static final Regex BRACES_REGEX = new Regex("(?![^{]|\\{\\{)(\\{([^{}]*)\\})(?=[^}]|\\}\\}|$)");
    private static final int TEXT_IN_BRACES = 2;

    private StringFormat(String pattern, FormatType formatType, final ExponentFormat expFormat) {
        List list;
        this.pattern = pattern;
        this.formatType = formatType;
        switch (WhenMappings.$EnumSwitchMapping$0[this.formatType.ordinal()]) {
            case 1: 
            case 2: {
                list = CollectionsKt.listOf(this.initFormatter(this.pattern, this.formatType, expFormat));
                break;
            }
            case 3: {
                list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)BRACES_REGEX, (CharSequence)this.pattern, (int)0, (int)2, null), (Function1)1.INSTANCE), (Function1)((Function1)new Function1<String, Function1<? super Object, ? extends String>>(){

                    @NotNull
                    public final Function1<Object, String> invoke(@NotNull String pattern) {
                        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                        FormatType formatType = Companion.detectFormatType(pattern);
                        boolean bl = formatType == FormatType.NUMBER_FORMAT || formatType == FormatType.DATETIME_FORMAT;
                        StringFormat stringFormat = this;
                        if (!bl) {
                            boolean bl2 = false;
                            throw new IllegalStateException(("Can't detect type of pattern '" + pattern + "' used in string pattern '" + stringFormat.pattern + '\'').toString());
                        }
                        return this.initFormatter(pattern, formatType, expFormat);
                    }
                })));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.myFormatters = list;
        this.argsNumber = this.myFormatters.size();
    }

    public final int getArgsNumber() {
        return this.argsNumber;
    }

    @NotNull
    public final String format(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.format(CollectionsKt.listOf((Object)value));
    }

    @NotNull
    public final String format(@NotNull List<? extends Object> values) {
        String string;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        if (this.argsNumber != values.size()) {
            throw new IllegalStateException(("Can't format values " + values + " with pattern '" + this.pattern + "'. Wrong number of arguments: expected " + this.argsNumber + " instead of " + values.size()).toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.formatType.ordinal()]) {
            case 1: 
            case 2: {
                if (!(this.myFormatters.size() == 1)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                string = (String)((Function1)CollectionsKt.single(this.myFormatters)).invoke(CollectionsKt.single(values));
                break;
            }
            case 3: {
                Ref.IntRef index = new Ref.IntRef();
                string = StringsKt.replace$default((String)StringsKt.replace$default((String)BRACES_REGEX.replace((CharSequence)this.pattern, (Function1)new Function1<MatchResult, CharSequence>(values, index, this){
                    final /* synthetic */ List<Object> $values;
                    final /* synthetic */ Ref.IntRef $index;
                    final /* synthetic */ StringFormat this$0;
                    {
                        this.$values = $values;
                        this.$index = $index;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull MatchResult it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Object originalValue = this.$values.get(this.$index.element);
                        int n = this.$index.element;
                        this.$index.element = n + 1;
                        Function1 formatter = (Function1)StringFormat.access$getMyFormatters$p(this.this$0).get(n);
                        return (CharSequence)formatter.invoke(originalValue);
                    }
                }), (String)"{{", (String)"{", (boolean)false, (int)4, null), (String)"}}", (String)"}", (boolean)false, (int)4, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final Function1<Object, String> initFormatter(String formatPattern, FormatType formatType, ExponentFormat expFormat) {
        if (((CharSequence)formatPattern).length() == 0) {
            return initFormatter.1.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[formatType.ordinal()]) {
            case 1: {
                Object object;
                Object object2;
                NumberFormat.Spec formatSpec = NumberFormat.Companion.parseSpec(formatPattern);
                Object object3 = expFormat;
                if (object3 == null || (object3 = object3.getNotationType()) == null) {
                    object3 = formatSpec.getExpType();
                }
                NumberFormat.Spec spec = NumberFormat.Spec.copy$default(formatSpec, null, null, null, null, false, 0, false, 0, null, false, (NumberFormat.ExponentNotationType)((Object)object3), (object2 = expFormat) != null && (object2 = ((ExponentFormat)object2).getMin()) != null ? ((Integer)object2).intValue() : formatSpec.getMinExp(), (object = expFormat) != null && (object = ((ExponentFormat)object).getMax()) != null ? ((Integer)object).intValue() : formatSpec.getMaxExp(), 1023, null);
                NumberFormat numberFormatter = new NumberFormat(spec);
                return (Function1)new Function1<Object, String>(numberFormatter){
                    final /* synthetic */ NumberFormat $numberFormatter;
                    {
                        this.$numberFormatter = $numberFormatter;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull Object value) {
                        Object object;
                        block3: {
                            block4: {
                                block5: {
                                    Object object2;
                                    block2: {
                                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                        object2 = value;
                                        if (!(object2 instanceof Number)) break block2;
                                        object = this.$numberFormatter.apply((Number)value);
                                        break block3;
                                    }
                                    if (!(object2 instanceof String)) break block4;
                                    object = StringsKt.toFloatOrNull((String)((String)value));
                                    if (object == null) break block5;
                                    Object object3 = object;
                                    NumberFormat numberFormat = this.$numberFormatter;
                                    Number p0 = (Number)object3;
                                    boolean bl = false;
                                    String string = numberFormat.apply(p0);
                                    object = string;
                                    if (string != null) break block3;
                                }
                                object = (String)value;
                                break block3;
                            }
                            throw new IllegalStateException(("Failed to format value with type " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName() + ". Supported types are Number and String.").toString());
                        }
                        return object;
                    }
                };
            }
            case 2: {
                DateTimeFormat dateTimeFormatter = new DateTimeFormat(formatPattern);
                return (Function1)new Function1<Object, String>(dateTimeFormatter){
                    final /* synthetic */ DateTimeFormat $dateTimeFormatter;
                    {
                        this.$dateTimeFormatter = $dateTimeFormatter;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull Object value) {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        if (!(value instanceof Number)) {
                            boolean bl = false;
                            throw new IllegalStateException(("Value '" + value + "' to be formatted as DateTime expected to be a Number, but was " + Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName()).toString());
                        }
                        long p0 = ((Number)value).longValue();
                        boolean bl = false;
                        Comparable<Instant> comparable = new Instant(p0);
                        Object object = TimeZone.Companion.getUTC();
                        Instant p02 = comparable;
                        boolean bl2 = false;
                        comparable = ((TimeZone)object).toDateTime(p02);
                        object = this.$dateTimeFormatter;
                        p02 = comparable;
                        boolean bl3 = false;
                        return ((DateTimeFormat)object).apply((DateTime)((Object)p02));
                    }
                };
            }
        }
        throw new IllegalStateException(("Undefined format pattern " + formatPattern).toString());
    }

    public static final /* synthetic */ List access$getMyFormatters$p(StringFormat $this) {
        return $this.myFormatters;
    }

    public /* synthetic */ StringFormat(String pattern, FormatType formatType, ExponentFormat expFormat, DefaultConstructorMarker $constructor_marker) {
        this(pattern, formatType, expFormat);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J0\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$Companion;", "", "()V", "BRACES_REGEX", "Lkotlin/text/Regex;", "TEXT_IN_BRACES", "", "create", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat;", "pattern", "", "type", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$FormatType;", "formatFor", "expectedArgs", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "create$commons", "detectFormatType", "forNArgs", "argCount", "forOneArg", "valueInLinePattern", "commons"})
    @SourceDebugExtension(value={"SMAP\nStringFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringFormat.kt\norg/jetbrains/letsPlot/commons/formatting/string/StringFormat$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1#2:185\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String valueInLinePattern() {
            return "{}";
        }

        @NotNull
        public final StringFormat forOneArg(@NotNull String pattern, @Nullable FormatType type, @Nullable String formatFor, @NotNull ExponentFormat expFormat) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)expFormat, (String)"expFormat");
            return this.create$commons(pattern, type, formatFor, 1, expFormat);
        }

        public static /* synthetic */ StringFormat forOneArg$default(Companion companion, String string, FormatType formatType, String string2, ExponentFormat exponentFormat, int n, Object object) {
            if ((n & 2) != 0) {
                formatType = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                exponentFormat = new ExponentFormat(NumberFormat.ExponentNotationType.POW, null, null, 6, null);
            }
            return companion.forOneArg(string, formatType, string2, exponentFormat);
        }

        @NotNull
        public final StringFormat forNArgs(@NotNull String pattern, int argCount, @Nullable String formatFor, @NotNull ExponentFormat expFormat) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)expFormat, (String)"expFormat");
            return this.create$commons(pattern, FormatType.STRING_FORMAT, formatFor, argCount, expFormat);
        }

        public static /* synthetic */ StringFormat forNArgs$default(Companion companion, String string, int n, String string2, ExponentFormat exponentFormat, int n2, Object object) {
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            if ((n2 & 8) != 0) {
                exponentFormat = new ExponentFormat(NumberFormat.ExponentNotationType.POW, null, null, 6, null);
            }
            return companion.forNArgs(string, n, string2, exponentFormat);
        }

        private final FormatType detectFormatType(String pattern) {
            return NumberFormat.Companion.isValidPattern(pattern) ? FormatType.NUMBER_FORMAT : (Pattern.Companion.isDateTimeFormat(pattern) ? FormatType.DATETIME_FORMAT : FormatType.STRING_FORMAT);
        }

        @NotNull
        public final StringFormat create$commons(@NotNull String pattern, @Nullable FormatType type, @Nullable String formatFor, int expectedArgs, @Nullable ExponentFormat expFormat) {
            StringFormat stringFormat;
            block4: {
                String string;
                StringFormat it;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
                        FormatType formatType = type;
                        if (formatType == null) {
                            formatType = this.detectFormatType(pattern);
                        }
                        FormatType formatType2 = formatType;
                        it = stringFormat = new StringFormat(pattern, formatType2, expFormat, null);
                        boolean bl = false;
                        if (expectedArgs <= 0 || it.getArgsNumber() == expectedArgs) break block4;
                        boolean bl2 = false;
                        string = formatFor;
                        if (string == null) break block5;
                        String it2 = string;
                        boolean bl3 = false;
                        String string2 = "to format '" + formatFor + '\'';
                        string = string2;
                        if (string2 != null) break block6;
                    }
                    string = "";
                }
                String formatFor2 = string;
                String string3 = "Wrong number of arguments in pattern '" + pattern + "' " + formatFor2 + ". Expected " + expectedArgs + ' ' + (expectedArgs > 1 ? "arguments" : "argument") + " instead of " + it.getArgsNumber();
                throw new IllegalArgumentException(string3.toString());
            }
            return stringFormat;
        }

        public static /* synthetic */ StringFormat create$commons$default(Companion companion, String string, FormatType formatType, String string2, int n, ExponentFormat exponentFormat, int n2, Object object) {
            if ((n2 & 2) != 0) {
                formatType = null;
            }
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            if ((n2 & 8) != 0) {
                n = -1;
            }
            if ((n2 & 0x10) != 0) {
                exponentFormat = null;
            }
            return companion.create$commons(string, formatType, string2, n, exponentFormat);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ0\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "", "notationType", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "min", "", "max", "(Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;Ljava/lang/Integer;Ljava/lang/Integer;)V", "getMax", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMin", "getNotationType", "()Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;", "component1", "component2", "component3", "copy", "(Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat$ExponentNotationType;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "equals", "", "other", "hashCode", "toString", "", "Companion", "commons"})
    public static final class ExponentFormat {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final NumberFormat.ExponentNotationType notationType;
        @Nullable
        private final Integer min;
        @Nullable
        private final Integer max;
        @NotNull
        private static final ExponentFormat DEF_EXPONENT_FORMAT = new ExponentFormat(NumberFormat.ExponentNotationType.E, null, null, 6, null);

        public ExponentFormat(@NotNull NumberFormat.ExponentNotationType notationType, @Nullable Integer min, @Nullable Integer max) {
            Intrinsics.checkNotNullParameter((Object)((Object)notationType), (String)"notationType");
            this.notationType = notationType;
            this.min = min;
            this.max = max;
        }

        public /* synthetic */ ExponentFormat(NumberFormat.ExponentNotationType exponentNotationType, Integer n, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = null;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            this(exponentNotationType, n, n2);
        }

        @NotNull
        public final NumberFormat.ExponentNotationType getNotationType() {
            return this.notationType;
        }

        @Nullable
        public final Integer getMin() {
            return this.min;
        }

        @Nullable
        public final Integer getMax() {
            return this.max;
        }

        @NotNull
        public final NumberFormat.ExponentNotationType component1() {
            return this.notationType;
        }

        @Nullable
        public final Integer component2() {
            return this.min;
        }

        @Nullable
        public final Integer component3() {
            return this.max;
        }

        @NotNull
        public final ExponentFormat copy(@NotNull NumberFormat.ExponentNotationType notationType, @Nullable Integer min, @Nullable Integer max) {
            Intrinsics.checkNotNullParameter((Object)((Object)notationType), (String)"notationType");
            return new ExponentFormat(notationType, min, max);
        }

        public static /* synthetic */ ExponentFormat copy$default(ExponentFormat exponentFormat, NumberFormat.ExponentNotationType exponentNotationType, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                exponentNotationType = exponentFormat.notationType;
            }
            if ((n3 & 2) != 0) {
                n = exponentFormat.min;
            }
            if ((n3 & 4) != 0) {
                n2 = exponentFormat.max;
            }
            return exponentFormat.copy(exponentNotationType, n, n2);
        }

        @NotNull
        public String toString() {
            return "ExponentFormat(notationType=" + (Object)((Object)this.notationType) + ", min=" + this.min + ", max=" + this.max + ')';
        }

        public int hashCode() {
            int result = this.notationType.hashCode();
            result = result * 31 + (this.min == null ? 0 : ((Object)this.min).hashCode());
            result = result * 31 + (this.max == null ? 0 : ((Object)this.max).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExponentFormat)) {
                return false;
            }
            ExponentFormat exponentFormat = (ExponentFormat)other;
            if (this.notationType != exponentFormat.notationType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.min, (Object)exponentFormat.min)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.max, (Object)exponentFormat.max);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat$Companion;", "", "()V", "DEF_EXPONENT_FORMAT", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "getDEF_EXPONENT_FORMAT", "()Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "commons"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ExponentFormat getDEF_EXPONENT_FORMAT() {
                return DEF_EXPONENT_FORMAT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$FormatType;", "", "(Ljava/lang/String;I)V", "NUMBER_FORMAT", "DATETIME_FORMAT", "STRING_FORMAT", "commons"})
    public static final class FormatType
    extends Enum<FormatType> {
        public static final /* enum */ FormatType NUMBER_FORMAT = new FormatType();
        public static final /* enum */ FormatType DATETIME_FORMAT = new FormatType();
        public static final /* enum */ FormatType STRING_FORMAT = new FormatType();
        private static final /* synthetic */ FormatType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FormatType[] values() {
            return (FormatType[])$VALUES.clone();
        }

        public static FormatType valueOf(String value) {
            return Enum.valueOf(FormatType.class, value);
        }

        @NotNull
        public static EnumEntries<FormatType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = formatTypeArray = new FormatType[]{FormatType.NUMBER_FORMAT, FormatType.DATETIME_FORMAT, FormatType.STRING_FORMAT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormatType.values().length];
            try {
                nArray[FormatType.NUMBER_FORMAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatType.DATETIME_FORMAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatType.STRING_FORMAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

