/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.interval;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.NumSpan;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u0011\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "Lorg/jetbrains/letsPlot/commons/interval/NumSpan;", "lower", "", "upper", "(DD)V", "length", "getLength", "()D", "lowerEnd", "getLowerEnd", "()Ljava/lang/Double;", "upperEnd", "getUpperEnd", "connected", "", "other", "contains", "v", "encloses", "expanded", "expand", "intersection", "union", "Companion", "commons"})
public final class DoubleSpan
extends NumSpan {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double lowerEnd;
    private final double upperEnd;
    private final double length;

    public DoubleSpan(double lower, double upper) {
        this.lowerEnd = Math.min(lower, upper);
        this.upperEnd = Math.max(lower, upper);
        this.length = this.getUpperEnd() - this.getLowerEnd();
        double d = lower;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d) && !Double.isInfinite(d = upper) && !Double.isNaN(d))) {
            boolean bl = false;
            String string = "Ends must be finite: lower=" + lower + " upper=" + upper;
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public Double getLowerEnd() {
        return this.lowerEnd;
    }

    @Override
    @NotNull
    public Double getUpperEnd() {
        return this.upperEnd;
    }

    public final double getLength() {
        return this.length;
    }

    public final boolean contains(double v) {
        return v >= this.getLowerEnd() && v <= this.getUpperEnd();
    }

    public final boolean contains(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getLowerEnd() <= other.getLowerEnd() && this.getUpperEnd() >= other.getUpperEnd();
    }

    public final boolean encloses(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getLowerEnd() <= other.getLowerEnd() && this.getUpperEnd() >= other.getUpperEnd();
    }

    public final boolean connected(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !(this.getLowerEnd() > other.getUpperEnd()) && !(this.getUpperEnd() < other.getLowerEnd());
    }

    @NotNull
    public final DoubleSpan union(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.encloses(other)) {
            return this;
        }
        return other.encloses(this) ? other : new DoubleSpan(Math.min(this.getLowerEnd(), other.getLowerEnd()), Math.max(this.getUpperEnd(), other.getUpperEnd()));
    }

    @NotNull
    public final DoubleSpan intersection(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.connected(other)) {
            throw new IllegalArgumentException("Ranges are not connected: this=" + this + " other=" + other);
        }
        if (this.encloses(other)) {
            return other;
        }
        return other.encloses(this) ? this : new DoubleSpan(Math.max(this.getLowerEnd(), other.getLowerEnd()), Math.min(this.getUpperEnd(), other.getUpperEnd()));
    }

    @NotNull
    public final DoubleSpan expanded(double expand) {
        double expand2 = expand >= 0.0 ? expand : -Math.min(this.length / (double)2, Math.abs(expand));
        return new DoubleSpan(this.getLowerEnd() - expand2, this.getUpperEnd() + expand2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan$Companion;", "", "()V", "encloseAll", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "values", "", "", "singleton", "v", "withLowerEnd", "lowerEnd", "length", "withUpperEnd", "upperEnd", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleSpan withLowerEnd(double lowerEnd, double length) {
            return new DoubleSpan(lowerEnd, lowerEnd + length);
        }

        @NotNull
        public final DoubleSpan withUpperEnd(double upperEnd, double length) {
            return new DoubleSpan(upperEnd - length, upperEnd);
        }

        @NotNull
        public final DoubleSpan singleton(double v) {
            return new DoubleSpan(v, v);
        }

        @NotNull
        public final DoubleSpan encloseAll(@NotNull Iterable<Double> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Double min = CollectionsKt.minOrNull((Iterable)CollectionsKt.filterNotNull(values));
            Double max = CollectionsKt.maxOrNull((Iterable)CollectionsKt.filterNotNull(values));
            if (min == null || max == null) {
                throw new NoSuchElementException("Can't create DoubleSpan: the input is empty or contains NULLs.");
            }
            return new DoubleSpan(min, max);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

