/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.observable.collections;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.observable.collections.CollectionListener;
import org.jetbrains.letsPlot.commons.intern.observable.event.ListenerEvent;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002:\u0001\u001dB)\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/observable/collections/CollectionItemEvent;", "ItemT", "Lorg/jetbrains/letsPlot/commons/intern/observable/event/ListenerEvent;", "Lorg/jetbrains/letsPlot/commons/intern/observable/collections/CollectionListener;", "oldItem", "newItem", "index", "", "type", "Lorg/jetbrains/letsPlot/commons/intern/observable/collections/CollectionItemEvent$EventType;", "(Ljava/lang/Object;Ljava/lang/Object;ILorg/jetbrains/letsPlot/commons/intern/observable/collections/CollectionItemEvent$EventType;)V", "getIndex", "()I", "getNewItem", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getOldItem", "getType", "()Lorg/jetbrains/letsPlot/commons/intern/observable/collections/CollectionItemEvent$EventType;", "dispatch", "", "l", "equals", "", "other", "", "hashCode", "toString", "", "EventType", "commons"})
public final class CollectionItemEvent<ItemT>
implements ListenerEvent<CollectionListener<ItemT>> {
    @Nullable
    private final ItemT oldItem;
    @Nullable
    private final ItemT newItem;
    private final int index;
    @NotNull
    private final EventType type;

    public CollectionItemEvent(@Nullable ItemT oldItem, @Nullable ItemT newItem, int index, @NotNull EventType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.oldItem = oldItem;
        this.newItem = newItem;
        this.index = index;
        this.type = type;
        if (EventType.ADD == this.type && this.oldItem != null || EventType.REMOVE == this.type && this.newItem != null) {
            throw new IllegalStateException();
        }
    }

    @Nullable
    public final ItemT getOldItem() {
        return this.oldItem;
    }

    @Nullable
    public final ItemT getNewItem() {
        return this.newItem;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final EventType getType() {
        return this.type;
    }

    @Override
    public void dispatch(@NotNull CollectionListener<ItemT> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        if (EventType.ADD == this.type) {
            l.onItemAdded(this);
        } else if (EventType.SET == this.type) {
            l.onItemSet(this);
        } else {
            l.onItemRemoved(this);
        }
    }

    @NotNull
    public String toString() {
        return EventType.ADD == this.type ? this.newItem + " added at " + this.index : (EventType.SET == this.type ? this.oldItem + " replaced with " + this.newItem + " at " + this.index : this.oldItem + " removed at " + this.index);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CollectionItemEvent cfr_ignored_0 = (CollectionItemEvent)other;
        if (!Intrinsics.areEqual(this.oldItem, ((CollectionItemEvent)other).oldItem)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.newItem, ((CollectionItemEvent)other).newItem)) {
            return false;
        }
        if (this.index != ((CollectionItemEvent)other).index) {
            return false;
        }
        return this.type == ((CollectionItemEvent)other).type;
    }

    public int hashCode() {
        ItemT ItemT = this.oldItem;
        int result = ItemT != null ? ItemT.hashCode() : 0;
        ItemT ItemT2 = this.newItem;
        result = 31 * result + (ItemT2 != null ? ItemT2.hashCode() : 0);
        result = 31 * result + this.index;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/observable/collections/CollectionItemEvent$EventType;", "", "(Ljava/lang/String;I)V", "ADD", "SET", "REMOVE", "commons"})
    public static final class EventType
    extends Enum<EventType> {
        public static final /* enum */ EventType ADD = new EventType();
        public static final /* enum */ EventType SET = new EventType();
        public static final /* enum */ EventType REMOVE = new EventType();
        private static final /* synthetic */ EventType[] $VALUES;

        public static EventType[] values() {
            return (EventType[])$VALUES.clone();
        }

        public static EventType valueOf(String value) {
            return Enum.valueOf(EventType.class, value);
        }

        static {
            $VALUES = eventTypeArray = new EventType[]{EventType.ADD, EventType.SET, EventType.REMOVE};
        }
    }
}

