/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.spatial;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator;
import jetbrains.datalore.base.spatial.GeoBoundingBoxCalculatorKt;
import jetbrains.datalore.base.spatial.LongitudeSegment;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Rect;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0015*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0015B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJH\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u001c\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000b2\u001c\u0010\u000f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000bJ6\u0010\u0010\u001a\u00020\u00112\u001c\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator;", "TypeT", "", "myMapRect", "Ljetbrains/datalore/base/typedGeometry/Rect;", "myLoopX", "", "myLoopY", "(Ljetbrains/datalore/base/typedGeometry/Rect;ZZ)V", "calculateBoundingBox", "xSegments", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "Ljetbrains/datalore/base/spatial/Segment;", "ySegments", "calculateBoundingRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "segments", "mapRange", "loop", "Companion", "base-portable"})
public final class GeoBoundingBoxCalculator<TypeT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Rect<TypeT> myMapRect;
    private final boolean myLoopX;
    private final boolean myLoopY;

    public GeoBoundingBoxCalculator(@NotNull Rect<TypeT> myMapRect, boolean myLoopX, boolean myLoopY) {
        Intrinsics.checkNotNullParameter(myMapRect, (String)"myMapRect");
        this.myMapRect = myMapRect;
        this.myLoopX = myLoopX;
        this.myLoopY = myLoopY;
    }

    @NotNull
    public final Rect<TypeT> calculateBoundingBox(@NotNull Sequence<Pair<Double, Double>> xSegments, @NotNull Sequence<Pair<Double, Double>> ySegments) {
        Intrinsics.checkNotNullParameter(xSegments, (String)"xSegments");
        Intrinsics.checkNotNullParameter(ySegments, (String)"ySegments");
        DoubleSpan xRange = this.calculateBoundingRange(xSegments, FunctionsKt.xRange(this.myMapRect), this.myLoopX);
        DoubleSpan yRange = this.calculateBoundingRange(ySegments, FunctionsKt.yRange(this.myMapRect), this.myLoopY);
        return new Rect(xRange.getLowerEnd(), yRange.getLowerEnd(), GeoBoundingBoxCalculator.Companion.length(xRange), GeoBoundingBoxCalculator.Companion.length(yRange));
    }

    private final DoubleSpan calculateBoundingRange(Sequence<Pair<Double, Double>> segments, DoubleSpan mapRange, boolean loop) {
        DoubleSpan doubleSpan;
        if (loop) {
            doubleSpan = Companion.calculateLoopLimitRange$base_portable(segments, mapRange);
        } else {
            Double d = SequencesKt.minOrNull((Sequence)SequencesKt.map(segments, (Function1)((Function1)calculateBoundingRange.1.INSTANCE)));
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = SequencesKt.maxOrNull((Sequence)SequencesKt.map(segments, (Function1)((Function1)calculateBoundingRange.2.INSTANCE)));
            Intrinsics.checkNotNull((Object)d3);
            doubleSpan = new DoubleSpan(d2, d3);
        }
        return doubleSpan;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\u001c\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t0\u00062\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000bJ\u001e\u0010\f\u001a\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\f\u0010\u0012\u001a\u00020\b*\u00020\u0004H\u0002\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/base/spatial/GeoBoundingBoxCalculator$Companion;", "", "()V", "calculateLoopLimitRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "segments", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "Ljetbrains/datalore/base/spatial/Segment;", "mapRange", "calculateLoopLimitRange$base_portable", "findMaxGapBetweenRanges", "ranges", "width", "invertRange", "range", "normalizeCenter", "length", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleSpan calculateLoopLimitRange$base_portable(@NotNull Sequence<Pair<Double, Double>> segments, @NotNull DoubleSpan mapRange) {
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            Intrinsics.checkNotNullParameter((Object)mapRange, (String)"mapRange");
            Sequence $this$calculateLoopLimitRange_u24lambda_u2d0 = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map(segments, (Function1)((Function1)new Function1<Pair<? extends Double, ? extends Double>, List<? extends DoubleSpan>>(mapRange){
                final /* synthetic */ DoubleSpan $mapRange;
                {
                    this.$mapRange = $mapRange;
                    super(1);
                }

                @NotNull
                public final List<DoubleSpan> invoke(@NotNull Pair<Double, Double> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return LongitudeSegment.Companion.splitSegment(GeoBoundingBoxCalculatorKt.getStart(it), GeoBoundingBoxCalculatorKt.getEnd(it), this.$mapRange.getLowerEnd(), this.$mapRange.getUpperEnd());
                }
            })));
            boolean bl = false;
            DoubleSpan $this$calculateLoopLimitRange_u24lambda_u2d1 = Companion.findMaxGapBetweenRanges((Sequence<DoubleSpan>)$this$calculateLoopLimitRange_u24lambda_u2d0, Companion.length(mapRange));
            boolean bl2 = false;
            DoubleSpan $this$calculateLoopLimitRange_u24lambda_u2d2 = Companion.invertRange($this$calculateLoopLimitRange_u24lambda_u2d1, Companion.length(mapRange));
            boolean bl3 = false;
            return Companion.normalizeCenter($this$calculateLoopLimitRange_u24lambda_u2d2, mapRange);
        }

        private final DoubleSpan normalizeCenter(DoubleSpan range, DoubleSpan mapRange) {
            return mapRange.contains((range.getUpperEnd() + range.getLowerEnd()) / (double)2) ? range : new DoubleSpan(range.getLowerEnd() - this.length(mapRange), range.getUpperEnd() - this.length(mapRange));
        }

        private final DoubleSpan findMaxGapBetweenRanges(Sequence<DoubleSpan> ranges, double width) {
            Object v0;
            Sequence sortedRanges;
            Sequence<DoubleSpan> $this$sortedBy$iv = ranges;
            boolean $i$f$sortedBy = false;
            Sequence $this$maxByOrNull$iv = sortedRanges = SequencesKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    DoubleSpan p0 = (DoubleSpan)a;
                    boolean bl = false;
                    Comparable comparable = p0.getLowerEnd();
                    p0 = (DoubleSpan)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)p0.getLowerEnd());
                }
            });
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    DoubleSpan p0 = (DoubleSpan)maxElem$iv;
                    boolean bl = false;
                    double maxValue$iv = p0.getUpperEnd();
                    do {
                        Object e$iv = iterator$iv.next();
                        DoubleSpan p02 = (DoubleSpan)e$iv;
                        $i$a$-maxByOrNull-GeoBoundingBoxCalculator$Companion$findMaxGapBetweenRanges$prevUpper$1 = false;
                        double v$iv = p02.getUpperEnd();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            double prevUpper = ((DoubleSpan)v0).getUpperEnd();
            double nextLower = ((DoubleSpan)SequencesKt.first((Sequence)sortedRanges)).getLowerEnd();
            double gapRight = Math.max(width + nextLower, prevUpper);
            DoubleSpan maxGapRange = new DoubleSpan(prevUpper, gapRight);
            Iterator it = sortedRanges.iterator();
            prevUpper = ((DoubleSpan)it.next()).getUpperEnd();
            while (it.hasNext()) {
                DoubleSpan range = (DoubleSpan)it.next();
                nextLower = range.getLowerEnd();
                if (nextLower > prevUpper && nextLower - prevUpper > this.length(maxGapRange)) {
                    maxGapRange = new DoubleSpan(prevUpper, nextLower);
                }
                prevUpper = Math.max(prevUpper, range.getUpperEnd());
            }
            return maxGapRange;
        }

        private final DoubleSpan invertRange(DoubleSpan range, double width) {
            return this.length(range) > width ? new DoubleSpan(range.getLowerEnd(), range.getLowerEnd()) : (range.getUpperEnd() > width ? jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator$Companion.invertRange$safeRange(range.getUpperEnd() - width, range.getLowerEnd()) : jetbrains.datalore.base.spatial.GeoBoundingBoxCalculator$Companion.invertRange$safeRange(range.getUpperEnd(), width + range.getLowerEnd()));
        }

        private final double length(DoubleSpan $this$length) {
            return $this$length.getUpperEnd() - $this$length.getLowerEnd();
        }

        private static final DoubleSpan invertRange$safeRange(double first2, double second) {
            return new DoubleSpan(Math.min(first2, second), Math.max(first2, second));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

