/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.gcommon.collect;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ComparatorOrdering;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0004\u0012\u0002H\u00010\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bJ%\u0010\t\u001a\u0002H\n\"\b\b\u0001\u0010\n*\u00028\u00002\u0006\u0010\u000b\u001a\u0002H\n2\u0006\u0010\f\u001a\u0002H\n\u00a2\u0006\u0002\u0010\rJ#\u0010\t\u001a\u0002H\n\"\b\b\u0001\u0010\n*\u00028\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\n0\b\u00a2\u0006\u0002\u0010\u000eJ#\u0010\t\u001a\u0002H\n\"\b\b\u0001\u0010\n*\u00028\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u0002H\n\"\b\b\u0001\u0010\n*\u00028\u00002\u0006\u0010\u000b\u001a\u0002H\n2\u0006\u0010\f\u001a\u0002H\n\u00a2\u0006\u0002\u0010\rJ#\u0010\u0012\u001a\u0002H\n\"\b\b\u0001\u0010\n*\u00028\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\n0\b\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u0012\u001a\u0002H\n\"\b\b\u0001\u0010\n*\u00028\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\n0\u0015\"\b\b\u0001\u0010\n*\u00028\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\n0\b\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/base/gcommon/collect/Ordering;", "T", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "()V", "isOrdered", "", "iterable", "", "max", "E", "a", "b", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/Iterable;)Ljava/lang/Object;", "iterator", "", "(Ljava/util/Iterator;)Ljava/lang/Object;", "min", "reverse", "sortedCopy", "", "elements", "Companion", "base-portable"})
public abstract class Ordering<T>
implements Comparator<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isOrdered(@NotNull Iterable<? extends T> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (this.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    @NotNull
    public final <E extends T> List<E> sortedCopy(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return CollectionsKt.sortedWith(elements, (Comparator)new Comparator<E>(this){
            final /* synthetic */ Ordering<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public int compare(E a, E b) {
                return this.this$0.compare(a, b);
            }
        });
    }

    @NotNull
    public final Ordering<T> reverse() {
        Comparator comparator = this.reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed()");
        return new ComparatorOrdering(comparator);
    }

    public final <E extends T> E min(E a, E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    public final <E extends T> E min(@NotNull Iterable<? extends E> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        return this.min(iterable.iterator());
    }

    public final <E extends T> E min(@NotNull Iterator<? extends E> iterator2) {
        Intrinsics.checkNotNullParameter(iterator2, (String)"iterator");
        E result = iterator2.next();
        while (iterator2.hasNext()) {
            result = this.min(result, iterator2.next());
        }
        return result;
    }

    public final <E extends T> E max(E a, E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    public final <E extends T> E max(@NotNull Iterable<? extends E> iterable) {
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        return this.max(iterable.iterator());
    }

    public final <E extends T> E max(@NotNull Iterator<? extends E> iterator2) {
        Intrinsics.checkNotNullParameter(iterator2, (String)"iterator");
        E result = iterator2.next();
        while (iterator2.hasNext()) {
            result = this.max(result, iterator2.next());
        }
        return result;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u0002H\u00050\u0007j\b\u0012\u0004\u0012\u0002H\u0005`\bJ\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/base/gcommon/collect/Ordering$Companion;", "", "()V", "from", "Ljetbrains/datalore/base/gcommon/collect/Ordering;", "T", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "natural", "", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Ordering<T> from(@NotNull Comparator<T> comparator) {
            Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
            return comparator instanceof Ordering ? (Ordering)comparator : (Ordering)new ComparatorOrdering<T>(comparator);
        }

        @NotNull
        public final <T extends Comparable<? super T>> Ordering<T> natural() {
            return new ComparatorOrdering(ComparisonsKt.naturalOrder());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

