/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.transformation;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.transformation.InstrumentationMode;
import org.jetbrains.kotlinx.lincheck.transformation.LincheckClassVisitor;
import org.jetbrains.kotlinx.lincheck.transformation.LincheckJavaAgent;
import org.jetbrains.kotlinx.lincheck.transformation.SafeClassWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import sun.nio.ch.lincheck.TestThread;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J<\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\"\u0010\u001b\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/lincheck/transformation/LincheckClassFileTransformer;", "Ljava/lang/instrument/ClassFileTransformer;", "()V", "transformedClassesCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "getTransformedClassesCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "transformedClassesModelChecking", "getTransformedClassesModelChecking", "transformedClassesStress", "getTransformedClassesStress", "shouldTransform", "", "className", "instrumentationMode", "Lorg/jetbrains/kotlinx/lincheck/transformation/InstrumentationMode;", "transform", "loader", "Ljava/lang/ClassLoader;", "internalClassName", "classBeingRedefined", "Ljava/lang/Class;", "protectionDomain", "Ljava/security/ProtectionDomain;", "classBytes", "transformImpl", "lincheck"})
@SourceDebugExtension(value={"SMAP\nLincheckJavaAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LincheckJavaAgent.kt\norg/jetbrains/kotlinx/lincheck/transformation/LincheckClassFileTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlinx/lincheck/UtilsKt\n*L\n1#1,435:1\n263#2,16:436\n*S KotlinDebug\n*F\n+ 1 LincheckJavaAgent.kt\norg/jetbrains/kotlinx/lincheck/transformation/LincheckClassFileTransformer\n*L\n345#1:436,16\n*E\n"})
public final class LincheckClassFileTransformer
implements ClassFileTransformer {
    @NotNull
    public static final LincheckClassFileTransformer INSTANCE = new LincheckClassFileTransformer();
    @NotNull
    private static final ConcurrentHashMap<String, byte[]> transformedClassesModelChecking = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, byte[]> transformedClassesStress = new ConcurrentHashMap();

    private LincheckClassFileTransformer() {
    }

    @NotNull
    public final ConcurrentHashMap<String, byte[]> getTransformedClassesModelChecking() {
        return transformedClassesModelChecking;
    }

    @NotNull
    public final ConcurrentHashMap<String, byte[]> getTransformedClassesStress() {
        return transformedClassesStress;
    }

    private final ConcurrentHashMap<String, byte[]> getTransformedClassesCache() {
        ConcurrentHashMap<String, byte[]> concurrentHashMap;
        switch (WhenMappings.$EnumSwitchMapping$0[LincheckJavaAgent.INSTANCE.getInstrumentationMode().ordinal()]) {
            case 1: {
                concurrentHashMap = transformedClassesStress;
                break;
            }
            case 2: {
                concurrentHashMap = transformedClassesModelChecking;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return concurrentHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @NotNull String internalClassName, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @NotNull byte[] classBytes) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)classBytes, (String)"classBytes");
        LincheckClassFileTransformer $this$runInIgnoredSection$iv = this;
        boolean $i$f$runInIgnoredSection = false;
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
        Thread currentThread$iv$iv = thread;
        boolean $i$f$runInIgnoredSection2 = false;
        if (currentThread$iv$iv instanceof TestThread && ((TestThread)currentThread$iv$iv).inTestingCode && !((TestThread)currentThread$iv$iv).inIgnoredSection) {
            ((TestThread)currentThread$iv$iv).inIgnoredSection = true;
            try {
                boolean bl = false;
                if (!INSTANCE.shouldTransform(UtilsKt.getCanonicalClassName(internalClassName), LincheckJavaAgent.INSTANCE.getInstrumentationMode())) {
                    byte[] byArray = null;
                    return byArray;
                }
                if (!LincheckJavaAgent.INSTANCE.getINSTRUMENT_ALL_CLASSES$lincheck() && LincheckJavaAgent.INSTANCE.getInstrumentationMode() == InstrumentationMode.MODEL_CHECKING && !LincheckJavaAgent.INSTANCE.getInstrumentedClasses().contains(UtilsKt.getCanonicalClassName(internalClassName))) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = INSTANCE.transformImpl(loader, internalClassName, classBytes);
                return byArray;
            }
            finally {
                ((TestThread)currentThread$iv$iv).inIgnoredSection = false;
            }
        }
        boolean bl = false;
        if (!INSTANCE.shouldTransform(UtilsKt.getCanonicalClassName(internalClassName), LincheckJavaAgent.INSTANCE.getInstrumentationMode())) {
            return null;
        }
        if (!LincheckJavaAgent.INSTANCE.getINSTRUMENT_ALL_CLASSES$lincheck() && LincheckJavaAgent.INSTANCE.getInstrumentationMode() == InstrumentationMode.MODEL_CHECKING && !LincheckJavaAgent.INSTANCE.getInstrumentedClasses().contains(UtilsKt.getCanonicalClassName(internalClassName))) {
            return null;
        }
        return INSTANCE.transformImpl(loader, internalClassName, classBytes);
    }

    private final byte[] transformImpl(ClassLoader loader, String internalClassName, byte[] classBytes) {
        byte[] byArray = this.getTransformedClassesCache().computeIfAbsent(UtilsKt.getCanonicalClassName(internalClassName), arg_0 -> LincheckClassFileTransformer.transformImpl$lambda$1((Function1)new Function1<String, byte[]>(classBytes, loader, internalClassName){
            final /* synthetic */ byte[] $classBytes;
            final /* synthetic */ ClassLoader $loader;
            final /* synthetic */ String $internalClassName;
            {
                this.$classBytes = $classBytes;
                this.$loader = $loader;
                this.$internalClassName = $internalClassName;
                super(1);
            }

            @NotNull
            public final byte[] invoke(@NotNull String it) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ClassReader reader = new ClassReader(this.$classBytes);
                SafeClassWriter writer = new SafeClassWriter(reader, this.$loader, 2);
                LincheckClassVisitor visitor = new LincheckClassVisitor(LincheckJavaAgent.INSTANCE.getInstrumentationMode(), (ClassVisitor)writer);
                try {
                    reader.accept((ClassVisitor)visitor, 8);
                    byArray = writer.toByteArray();
                }
                catch (Throwable e) {
                    System.err.println("Unable to transform " + this.$internalClassName);
                    e.printStackTrace();
                    byArray = this.$classBytes;
                }
                return byArray;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"computeIfAbsent(...)");
        return byArray;
    }

    public final boolean shouldTransform(@NotNull String className, @NotNull InstrumentationMode instrumentationMode) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)((Object)instrumentationMode), (String)"instrumentationMode");
        if (instrumentationMode == InstrumentationMode.STRESS && (StringsKt.startsWith$default((String)className, (String)"java.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)className, (String)"kotlin.", (boolean)false, (int)2, null))) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"java.", (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)className, (String)"java.util.concurrent.", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)className, (CharSequence)"Atomic", (boolean)false, (int)2, null)) {
                return false;
            }
            if (StringsKt.startsWith$default((String)className, (String)"java.util.", (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)className, (String)"com.sun.", (boolean)false, (int)2, null)) {
                return false;
            }
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"sun.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"javax.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"jdk.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"kotlin.", (boolean)false, (int)2, null)) {
            if (StringsKt.startsWith$default((String)className, (String)"kotlin.collections.", (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)className, (String)"kotlin.jvm.internal.Array", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)className, (CharSequence)"Iterator", (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)className, (String)"kotlin.ranges.", (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)className, (String)"kotlin.random.", (boolean)false, (int)2, null)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)className, (String)"kotlin.coroutines.jvm.internal.", (boolean)false, (int)2, null)) {
                return false;
            }
            return StringsKt.startsWith$default((String)className, (String)"kotlin.coroutines.", (boolean)false, (int)2, null);
        }
        if (StringsKt.startsWith$default((String)className, (String)"kotlinx.atomicfu.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"kotlinx.coroutines.debug.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)className, (Object)"kotlinx.coroutines.DebugKt")) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"com.intellij.rt.coverage.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"com.esotericsoftware.kryo.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"net.bytebuddy.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"net.rubygrapefruit.platform.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"io.mockk.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"it.unimi.dsi.fastutil.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"worker.org.gradle.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"org.objectweb.asm.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"org.gradle.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"org.slf4j.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"org.apache.commons.lang.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"org.junit.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"junit.framework.", (boolean)false, (int)2, null)) {
            return false;
        }
        if (StringsKt.startsWith$default((String)className, (String)"org.jetbrains.kotlinx.lincheck.", (boolean)false, (int)2, null)) {
            return false;
        }
        return !StringsKt.startsWith$default((String)className, (String)"sun.nio.ch.lincheck.", (boolean)false, (int)2, null);
    }

    private static final byte[] transformImpl$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (byte[])$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InstrumentationMode.values().length];
            try {
                nArray[InstrumentationMode.STRESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstrumentationMode.MODEL_CHECKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

