/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.transformation;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.transformation.FinalFields;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0007`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/lincheck/transformation/FinalFields;", "", "()V", "classToFieldsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlinx/lincheck/transformation/FinalFields$FieldInfo;", "Lkotlin/collections/HashMap;", "addFieldsInfoFromSuperclass", "", "superType", "type", "addFinalField", "internalClassName", "fieldName", "addMutableField", "collectFieldInformation", "", "fields", "", "getClassReader", "Lorg/objectweb/asm/ClassReader;", "isFinalField", "FieldInfo", "FinalFieldsVisitor", "lincheck"})
@SourceDebugExtension(value={"SMAP\nCodeLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeLocations.kt\norg/jetbrains/kotlinx/lincheck/transformation/FinalFields\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,221:1\n1#2:222\n1855#3,2:223\n1855#3,2:225\n1855#3,2:227\n215#4,2:229\n*S KotlinDebug\n*F\n+ 1 CodeLocations.kt\norg/jetbrains/kotlinx/lincheck/transformation/FinalFields\n*L\n140#1:223,2\n141#1:225,2\n153#1:227,2\n178#1:229,2\n*E\n"})
public final class FinalFields {
    @NotNull
    public static final FinalFields INSTANCE = new FinalFields();
    @NotNull
    private static final ConcurrentHashMap<String, HashMap<String, FieldInfo>> classToFieldsMap = new ConcurrentHashMap();

    private FinalFields() {
    }

    public final void addFinalField(@NotNull String internalClassName, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        HashMap hashMap = classToFieldsMap.computeIfAbsent(internalClassName, arg_0 -> FinalFields.addFinalField$lambda$0(addFinalField.fields.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"computeIfAbsent(...)");
        HashMap fields2 = hashMap;
        ((Map)fields2).put(fieldName, FieldInfo.FINAL);
    }

    public final void addMutableField(@NotNull String internalClassName, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        HashMap hashMap = classToFieldsMap.computeIfAbsent(internalClassName, arg_0 -> FinalFields.addMutableField$lambda$1(addMutableField.fields.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"computeIfAbsent(...)");
        HashMap fields2 = hashMap;
        ((Map)fields2).put(fieldName, FieldInfo.MUTABLE);
    }

    public final boolean isFinalField(@NotNull String internalClassName, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        HashMap hashMap = classToFieldsMap.computeIfAbsent(internalClassName, arg_0 -> FinalFields.isFinalField$lambda$2(isFinalField.fields.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"computeIfAbsent(...)");
        HashMap fields2 = hashMap;
        FieldInfo fieldInfo = (FieldInfo)((Object)fields2.get(fieldName));
        if (fieldInfo != null) {
            FieldInfo it = fieldInfo;
            boolean bl = false;
            return it == FieldInfo.FINAL;
        }
        this.collectFieldInformation(internalClassName, fieldName, fields2);
        FieldInfo fieldInfo2 = (FieldInfo)((Object)fields2.get(fieldName));
        if (fieldInfo2 == null) {
            throw new IllegalStateException(("Internal error: can't find field with " + fieldName + " in class " + internalClassName).toString());
        }
        FieldInfo fieldInfo3 = fieldInfo2;
        return fieldInfo3 == FieldInfo.FINAL;
    }

    private final boolean collectFieldInformation(String internalClassName, String fieldName, Map<String, FieldInfo> fields2) {
        String field;
        ClassReader classReader = this.getClassReader(internalClassName);
        FinalFieldsVisitor visitor = new FinalFieldsVisitor();
        classReader.accept((ClassVisitor)visitor, 0);
        Iterable $this$forEach$iv = visitor.getFinalFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            field = (String)element$iv;
            boolean bl = false;
            fields2.put(field, FieldInfo.FINAL);
        }
        $this$forEach$iv = visitor.getMutableFields();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            field = (String)element$iv;
            boolean bl = false;
            fields2.put(field, FieldInfo.MUTABLE);
        }
        if (visitor.getFinalFields().contains(fieldName) || visitor.getMutableFields().contains(fieldName)) {
            return true;
        }
        String string = visitor.getSuperClassName();
        if (string != null) {
            String internalSuperClassName = string;
            boolean bl = false;
            HashMap hashMap = classToFieldsMap.computeIfAbsent(internalSuperClassName, arg_0 -> FinalFields.collectFieldInformation$lambda$7$lambda$6(collectFieldInformation.3.superClassFields.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"computeIfAbsent(...)");
            HashMap superClassFields2 = hashMap;
            boolean fieldFound = INSTANCE.collectFieldInformation(internalSuperClassName, fieldName, superClassFields2);
            INSTANCE.addFieldsInfoFromSuperclass(internalSuperClassName, internalClassName);
            if (fieldFound) {
                return true;
            }
        }
        $this$forEach$iv = visitor.getImplementedInterfaces();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HashMap interfaceFields2;
            String interfaceName = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)classToFieldsMap.computeIfAbsent(interfaceName, arg_0 -> FinalFields.collectFieldInformation$lambda$9$lambda$8(collectFieldInformation.4.interfaceFields.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
            boolean fieldFound = INSTANCE.collectFieldInformation(interfaceName, fieldName, interfaceFields2);
            INSTANCE.addFieldsInfoFromSuperclass(interfaceName, internalClassName);
            if (!fieldFound) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ClassReader getClassReader(String internalClassName) {
        ClassReader classReader;
        String resource = internalClassName + ".class";
        Closeable closeable = ClassLoader.getSystemClassLoader().getResourceAsStream(resource);
        if (closeable == null) {
            throw new IllegalStateException(("Cannot create ClassReader for type " + internalClassName).toString());
        }
        InputStream inputStream = closeable;
        closeable = inputStream;
        Throwable throwable = null;
        try {
            Closeable it = closeable;
            boolean bl = false;
            classReader = new ClassReader(inputStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return classReader;
    }

    private final void addFieldsInfoFromSuperclass(String superType, String type) {
        HashMap<String, FieldInfo> hashMap = classToFieldsMap.get(superType);
        if (hashMap == null) {
            return;
        }
        HashMap<String, FieldInfo> superFields = hashMap;
        HashMap hashMap2 = classToFieldsMap.computeIfAbsent(type, arg_0 -> FinalFields.addFieldsInfoFromSuperclass$lambda$11(addFieldsInfoFromSuperclass.fields.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)hashMap2, (String)"computeIfAbsent(...)");
        HashMap fields2 = hashMap2;
        Map $this$forEach$iv = superFields;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String fieldName = (String)entry.getKey();
            FieldInfo isFinal = (FieldInfo)((Object)entry.getValue());
            if (((Map)fields2).containsKey(fieldName)) continue;
            ((Map)fields2).put(fieldName, isFinal);
        }
    }

    private static final HashMap addFinalField$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashMap)$tmp0.invoke(p0);
    }

    private static final HashMap addMutableField$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashMap)$tmp0.invoke(p0);
    }

    private static final HashMap isFinalField$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashMap)$tmp0.invoke(p0);
    }

    private static final HashMap collectFieldInformation$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashMap)$tmp0.invoke(p0);
    }

    private static final HashMap collectFieldInformation$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashMap)$tmp0.invoke(p0);
    }

    private static final HashMap addFieldsInfoFromSuperclass$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HashMap)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlinx/lincheck/transformation/FinalFields$FieldInfo;", "", "(Ljava/lang/String;I)V", "FINAL", "MUTABLE", "lincheck"})
    private static final class FieldInfo
    extends Enum<FieldInfo> {
        public static final /* enum */ FieldInfo FINAL = new FieldInfo();
        public static final /* enum */ FieldInfo MUTABLE = new FieldInfo();
        private static final /* synthetic */ FieldInfo[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FieldInfo[] values() {
            return (FieldInfo[])$VALUES.clone();
        }

        public static FieldInfo valueOf(String value) {
            return Enum.valueOf(FieldInfo.class, value);
        }

        @NotNull
        public static EnumEntries<FieldInfo> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fieldInfoArray = new FieldInfo[]{FieldInfo.FINAL, FieldInfo.MUTABLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ8\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlinx/lincheck/transformation/FinalFields$FinalFieldsVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "()V", "finalFields", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getFinalFields", "()Ljava/util/ArrayList;", "implementedInterfaces", "getImplementedInterfaces", "mutableFields", "getMutableFields", "superClassName", "getSuperClassName", "()Ljava/lang/String;", "setSuperClassName", "(Ljava/lang/String;)V", "visit", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "descriptor", "value", "", "lincheck"})
    @SourceDebugExtension(value={"SMAP\nCodeLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeLocations.kt\norg/jetbrains/kotlinx/lincheck/transformation/FinalFields$FinalFieldsVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
    private static final class FinalFieldsVisitor
    extends ClassVisitor {
        @NotNull
        private final ArrayList<String> implementedInterfaces = new ArrayList();
        @NotNull
        private final ArrayList<String> finalFields = new ArrayList();
        @NotNull
        private final ArrayList<String> mutableFields = new ArrayList();
        @Nullable
        private String superClassName;

        public FinalFieldsVisitor() {
            super(589824);
        }

        @NotNull
        public final ArrayList<String> getImplementedInterfaces() {
            return this.implementedInterfaces;
        }

        @NotNull
        public final ArrayList<String> getFinalFields() {
            return this.finalFields;
        }

        @NotNull
        public final ArrayList<String> getMutableFields() {
            return this.mutableFields;
        }

        @Nullable
        public final String getSuperClassName() {
            return this.superClassName;
        }

        public final void setSuperClassName(@Nullable String string) {
            this.superClassName = string;
        }

        public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.superClassName = superName;
            if (interfaces != null) {
                String[] it = interfaces;
                boolean bl = false;
                CollectionsKt.addAll((Collection)this.implementedInterfaces, (Object[])interfaces);
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Nullable
        public FieldVisitor visitField(int access, @NotNull String name, @Nullable String descriptor, @Nullable String signature, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if ((access & 0x10) != 0) {
                this.finalFields.add(name);
            } else {
                this.mutableFields.add(name);
            }
            return super.visitField(access, name, descriptor, signature, value);
        }
    }
}

