/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ExceptionNumberAndStacktrace;
import org.jetbrains.kotlinx.lincheck.ExceptionStackTracesResult;
import org.jetbrains.kotlinx.lincheck.ExceptionsProcessingResult;
import org.jetbrains.kotlinx.lincheck.IdeaPluginKt;
import org.jetbrains.kotlinx.lincheck.InternalLincheckBugResult;
import org.jetbrains.kotlinx.lincheck.ReporterKt;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionResult;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.runner.ExecutionPart;
import org.jetbrains.kotlinx.lincheck.runner.InvocationResult;
import org.jetbrains.kotlinx.lincheck.strategy.IncorrectResultsFailure;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailure;
import org.jetbrains.kotlinx.lincheck.strategy.ManagedDeadlockFailure;
import org.jetbrains.kotlinx.lincheck.strategy.ObstructionFreedomViolationFailure;
import org.jetbrains.kotlinx.lincheck.strategy.TimeoutFailure;
import org.jetbrains.kotlinx.lincheck.strategy.UnexpectedExceptionFailure;
import org.jetbrains.kotlinx.lincheck.strategy.ValidationFailure;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ActorNode;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ActorResultNode;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CallNode;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategy;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ObjectLabelFactory;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ObstructionFreedomViolationExecutionAbortTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.SpinCycleStartTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.SwitchEventTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.SwitchReason;
import org.jetbrains.kotlinx.lincheck.strategy.managed.Trace;
import org.jetbrains.kotlinx.lincheck.strategy.managed.TraceLeafEvent;
import org.jetbrains.kotlinx.lincheck.strategy.managed.TraceNode;
import org.jetbrains.kotlinx.lincheck.strategy.managed.TracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.TraceReporterKt;
import org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking.ModelCheckingCTestConfiguration;
import org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking.ModelCheckingStrategy;
import sun.nio.ch.lincheck.TestThread;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0000\u0018\u0000 <2\u00020\u0001:\b;<=>?@ABB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0014H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u0002J\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0(2\u0006\u0010&\u001a\u00020\u001bH\u0002J#\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001a0,2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\u001fH\u0014J\b\u00103\u001a\u00020\u001fH\u0014J\b\u00104\u001a\u00020\rH\u0016J\u0018\u00105\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00142\u0006\u00106\u001a\u00020\rH\u0014J\u0015\u00107\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b8J\b\u00109\u001a\u00020\rH\u0016J\u0010\u0010:\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0014H\u0014R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy;", "testCfg", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingCTestConfiguration;", "testClass", "Ljava/lang/Class;", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "validationFunction", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "stateRepresentation", "Ljava/lang/reflect/Method;", "replay", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingCTestConfiguration;Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;Lorg/jetbrains/kotlinx/lincheck/Actor;Ljava/lang/reflect/Method;Z)V", "currentInterleaving", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "generationRandom", "Lkotlin/random/Random;", "maxNumberOfSwitches", "", "getReplay", "()Z", "root", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "type", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;", "getType", "(Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;)Ljava/lang/String;", "beforePart", "", "part", "Lorg/jetbrains/kotlinx/lincheck/runner/ExecutionPart;", "chooseThread", "iThread", "collectExceptionsForPlugin", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ExceptionProcessingResult;", "failure", "collectExceptionsOrEmpty", "", "", "Lorg/jetbrains/kotlinx/lincheck/ExceptionNumberAndStacktrace;", "constructTraceForPlugin", "", "trace", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/Trace;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;Lorg/jetbrains/kotlinx/lincheck/strategy/managed/Trace;)[Ljava/lang/String;", "doReplay", "Lorg/jetbrains/kotlinx/lincheck/runner/InvocationResult;", "enableSpinCycleReplay", "initializeInvocation", "nextInvocation", "onNewSwitch", "mustSwitch", "runReplayIfPluginEnabled", "runReplayIfPluginEnabled$lincheck", "shouldInvokeBeforeEvent", "shouldSwitch", "Choice", "Companion", "ExceptionProcessingResult", "Interleaving", "InterleavingBuilder", "InterleavingTreeNode", "SwitchChoosingNode", "ThreadChoosingNode", "lincheck"})
@SourceDebugExtension(value={"SMAP\nModelCheckingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,535:1\n26#2:536\n26#2:537\n1045#3:538\n1549#3:539\n1620#3,3:540\n1#4:543\n37#5,2:544\n37#5,2:546\n*S KotlinDebug\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy\n*L\n140#1:536\n142#1:537\n151#1:538\n152#1:539\n152#1:540,3\n156#1:544,2\n257#1:546,2\n*E\n"})
public final class ModelCheckingStrategy
extends ManagedStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean replay;
    private int maxNumberOfSwitches;
    @NotNull
    private InterleavingTreeNode root;
    @NotNull
    private final Random generationRandom;
    private Interleaving currentInterleaving;
    @NotNull
    private static final Lazy<String> lincheckVersion$delegate = LazyKt.lazy((Function0)Companion.lincheckVersion.2.INSTANCE);

    public ModelCheckingStrategy(@NotNull ModelCheckingCTestConfiguration testCfg, @NotNull Class<?> testClass, @NotNull ExecutionScenario scenario, @Nullable Actor validationFunction, @Nullable Method stateRepresentation, boolean replay) {
        Intrinsics.checkNotNullParameter((Object)testCfg, (String)"testCfg");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        super(testClass, scenario, validationFunction, stateRepresentation, testCfg);
        this.replay = replay;
        this.root = new ThreadChoosingNode(CollectionsKt.toList((Iterable)((Iterable)RangesKt.until((int)0, (int)this.getNThreads()))));
        this.generationRandom = RandomKt.Random((int)0);
    }

    public final boolean getReplay() {
        return this.replay;
    }

    @Override
    public boolean nextInvocation() {
        Interleaving interleaving = this.root.nextInterleaving();
        if (interleaving == null) {
            return false;
        }
        this.currentInterleaving = interleaving;
        return true;
    }

    @Override
    protected void initializeInvocation() {
        super.initializeInvocation();
        Interleaving interleaving = this.currentInterleaving;
        if (interleaving == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving = null;
        }
        interleaving.initialize();
    }

    @Override
    protected void enableSpinCycleReplay() {
        super.enableSpinCycleReplay();
        Interleaving interleaving = this.currentInterleaving;
        if (interleaving == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving = null;
        }
        interleaving.rollbackAfterSpinCycleFound();
    }

    public final void runReplayIfPluginEnabled$lincheck(@NotNull LincheckFailure failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        if (this.replay && failure.getTrace() != null) {
            String[] trace = this.constructTraceForPlugin(failure, failure.getTrace());
            ExceptionProcessingResult exceptionProcessingResult = this.collectExceptionsForPlugin(failure);
            String[] exceptionsRepresentation = exceptionProcessingResult.component1();
            boolean internalBugOccurred = exceptionProcessingResult.component2();
            if (internalBugOccurred) {
                return;
            }
            IdeaPluginKt.testFailed(this.getType(failure), trace, Companion.getLincheckVersion$lincheck(), "0.2", exceptionsRepresentation);
            this.doReplay();
            while (IdeaPluginKt.shouldReplayInterleaving()) {
                this.doReplay();
            }
        }
    }

    public boolean shouldInvokeBeforeEvent() {
        return this.replay && this.getCollectTrace() && Thread.currentThread() instanceof TestThread && this.getSuddenInvocationResult() == null;
    }

    private final String getType(LincheckFailure $this$type) {
        String string;
        LincheckFailure lincheckFailure = $this$type;
        if (lincheckFailure instanceof IncorrectResultsFailure) {
            string = "INCORRECT_RESULTS";
        } else if (lincheckFailure instanceof ObstructionFreedomViolationFailure) {
            string = "OBSTRUCTION_FREEDOM_VIOLATION";
        } else if (lincheckFailure instanceof UnexpectedExceptionFailure) {
            string = "UNEXPECTED_EXCEPTION";
        } else if (lincheckFailure instanceof ValidationFailure) {
            string = "VALIDATION_FAILURE";
        } else if (lincheckFailure instanceof ManagedDeadlockFailure ? true : lincheckFailure instanceof TimeoutFailure) {
            string = "DEADLOCK";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final InvocationResult doReplay() {
        ObjectLabelFactory.INSTANCE.cleanObjectNumeration$lincheck();
        Interleaving interleaving = this.currentInterleaving;
        if (interleaving == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving = null;
        }
        this.currentInterleaving = interleaving.copy();
        this.resetEventIdProvider();
        return this.runInvocation();
    }

    /*
     * WARNING - void declaration
     */
    private final ExceptionProcessingResult collectExceptionsForPlugin(LincheckFailure failure) {
        ExceptionProcessingResult exceptionProcessingResult;
        Object object;
        LincheckFailure lincheckFailure = failure;
        if (lincheckFailure instanceof IncorrectResultsFailure) {
            object = failure instanceof IncorrectResultsFailure ? (IncorrectResultsFailure)failure : null;
            if (object == null || (object = ((LincheckFailure)object).getResults()) == null) {
                boolean $i$f$emptyArray2 = false;
                return new ExceptionProcessingResult(new String[0], false);
            }
        } else {
            if (lincheckFailure instanceof ValidationFailure) {
                String[] stringArray = new String[]{UtilsKt.getText(((ValidationFailure)failure).getException())};
                return new ExceptionProcessingResult(stringArray, false);
            }
            boolean $i$f$emptyArray = false;
            return new ExceptionProcessingResult(new String[0], false);
        }
        Object results = object;
        ExceptionsProcessingResult exceptionsProcessingResult = ReporterKt.collectExceptionStackTraces((ExecutionResult)results);
        if (exceptionsProcessingResult instanceof InternalLincheckBugResult) {
            String[] $i$f$emptyArray = new String[]{UtilsKt.getText(((InternalLincheckBugResult)exceptionsProcessingResult).getException())};
            ExceptionProcessingResult exceptionProcessingResult2 = new ExceptionProcessingResult($i$f$emptyArray, true);
            exceptionProcessingResult = exceptionProcessingResult2;
        } else if (exceptionsProcessingResult instanceof ExceptionStackTracesResult) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedBy$iv;
            Iterable $i$f$emptyArray = ((ExceptionStackTracesResult)exceptionsProcessingResult).getExceptionStackTraces().entrySet();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry entry = (Map.Entry)a;
                    boolean bl = false;
                    ExceptionNumberAndStacktrace numberAndStackTrace = (ExceptionNumberAndStacktrace)entry.getValue();
                    entry = (Map.Entry)b;
                    Comparable comparable = Integer.valueOf(numberAndStackTrace.getNumber());
                    bl = false;
                    numberAndStackTrace = (ExceptionNumberAndStacktrace)entry.getValue();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(numberAndStackTrace.getNumber()));
                }
            });
            boolean $i$f$map = false;
            void $i$f$emptyArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Throwable exception = (Throwable)entry.getKey();
                ExceptionNumberAndStacktrace numberAndStackTrace = (ExceptionNumberAndStacktrace)entry.getValue();
                String header = exception.getClass().getCanonicalName() + ": " + exception.getMessage();
                collection.add(header + CollectionsKt.joinToString$default((Iterable)numberAndStackTrace.getStackTrace(), (CharSequence)"", null, null, (int)0, null, (Function1)collectExceptionsForPlugin.2.1.INSTANCE, (int)30, null));
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ExceptionProcessingResult exceptionProcessingResult3 = new ExceptionProcessingResult(thisCollection$iv.toArray(new String[0]), false);
            exceptionProcessingResult = exceptionProcessingResult3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exceptionProcessingResult;
    }

    private final String[] constructTraceForPlugin(LincheckFailure failure, Trace trace) {
        ExecutionResult results = failure.getResults();
        List<TraceNode> nodesList = TraceReporterKt.constructTraceGraph(failure, results, trace, this.collectExceptionsOrEmpty(failure));
        int sectionIndex = 0;
        TraceNode node2 = (TraceNode)CollectionsKt.firstOrNull(nodesList);
        List representations = new ArrayList();
        while (node2 != null) {
            TraceNode traceNode = node2;
            if (traceNode instanceof TraceLeafEvent) {
                int type;
                TracePoint event = ((TraceLeafEvent)node2).getEvent$lincheck();
                int eventId = event.getEventId();
                String representation = event.toStringImpl$lincheck(false);
                TracePoint tracePoint = event;
                int n = tracePoint instanceof SwitchEventTracePoint ? (WhenMappings.$EnumSwitchMapping$0[((SwitchEventTracePoint)event).getReason().ordinal()] == 1 ? 5 : 3) : (type = tracePoint instanceof SpinCycleStartTracePoint ? 4 : (tracePoint instanceof ObstructionFreedomViolationExecutionAbortTracePoint ? 6 : 0));
                if (((CharSequence)representation).length() > 0) {
                    representations.add(type + ";" + ((TraceLeafEvent)node2).getIThread() + ";" + ((TraceLeafEvent)node2).getCallDepth() + ";" + ((TraceLeafEvent)node2).shouldBeExpanded(false) + ";" + eventId + ";" + representation);
                }
            } else if (traceNode instanceof CallNode) {
                int beforeEventId = ((CallNode)node2).getCall$lincheck().getEventId();
                String representation = ((CallNode)node2).getCall$lincheck().toStringImpl$lincheck(false);
                if (((CharSequence)representation).length() > 0) {
                    representations.add("0;" + ((CallNode)node2).getIThread() + ";" + ((CallNode)node2).getCallDepth() + ";" + ((CallNode)node2).shouldBeExpanded(false) + ";" + beforeEventId + ";" + representation);
                }
            } else if (traceNode instanceof ActorNode) {
                int beforeEventId = -1;
                String representation = ((ActorNode)node2).getActorRepresentation$lincheck();
                if (((CharSequence)representation).length() > 0) {
                    representations.add("1;" + ((ActorNode)node2).getIThread() + ";" + ((ActorNode)node2).getCallDepth() + ";" + ((ActorNode)node2).shouldBeExpanded(false) + ";" + beforeEventId + ";" + representation);
                }
            } else if (traceNode instanceof ActorResultNode) {
                int beforeEventId = -1;
                String representation = String.valueOf(((ActorResultNode)node2).getResultRepresentation$lincheck());
                Integer n = ((ActorResultNode)node2).getExceptionNumberIfExceptionResult$lincheck();
                representations.add("2;" + ((ActorResultNode)node2).getIThread() + ";" + ((ActorResultNode)node2).getCallDepth() + ";" + ((ActorResultNode)node2).shouldBeExpanded(false) + ";" + beforeEventId + ";" + representation + ";" + (n != null ? n : -1));
            }
            if ((node2 = node2.getNext()) != null || sectionIndex == CollectionsKt.getLastIndex(nodesList)) continue;
            node2 = nodesList.get(++sectionIndex);
        }
        Collection $this$toTypedArray$iv = representations;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final Map<Throwable, ExceptionNumberAndStacktrace> collectExceptionsOrEmpty(LincheckFailure failure) {
        Map map;
        if (failure instanceof ValidationFailure) {
            Throwable throwable = ((ValidationFailure)failure).getException();
            StackTraceElement[] stackTraceElementArray = ((ValidationFailure)failure).getException().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)throwable, (Object)new ExceptionNumberAndStacktrace(1, ArraysKt.toList((Object[])stackTraceElementArray))));
        }
        Object object = failure instanceof IncorrectResultsFailure ? (IncorrectResultsFailure)failure : null;
        if (object == null || (object = ((LincheckFailure)object).getResults()) == null) {
            return MapsKt.emptyMap();
        }
        Object results = object;
        ExceptionsProcessingResult result2 = ReporterKt.collectExceptionStackTraces((ExecutionResult)results);
        if (result2 instanceof ExceptionStackTracesResult) {
            map = ((ExceptionStackTracesResult)result2).getExceptionStackTraces();
        } else if (result2 instanceof InternalLincheckBugResult) {
            map = MapsKt.emptyMap();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map;
    }

    @Override
    protected void onNewSwitch(int iThread, boolean mustSwitch) {
        if (this.replay && this.getCollectTrace()) {
            IdeaPluginKt.onThreadSwitchesOrActorFinishes();
        }
        if (mustSwitch) {
            Interleaving interleaving = this.currentInterleaving;
            if (interleaving == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
                interleaving = null;
            }
            interleaving.newExecutionPosition(iThread);
        }
    }

    @Override
    protected boolean shouldSwitch(int iThread) {
        if (!(iThread == this.getCurrentThread())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Interleaving interleaving = this.currentInterleaving;
        if (interleaving == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving = null;
        }
        interleaving.newExecutionPosition(iThread);
        Interleaving interleaving2 = this.currentInterleaving;
        if (interleaving2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving2 = null;
        }
        return interleaving2.isSwitchPosition();
    }

    @Override
    public void beforePart(@NotNull ExecutionPart part) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)part), (String)"part");
        super.beforePart(part);
        switch (WhenMappings.$EnumSwitchMapping$1[part.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                Interleaving interleaving = this.currentInterleaving;
                if (interleaving == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
                    interleaving = null;
                }
                n = interleaving.chooseThread(0);
                break;
            }
            case 3: {
                n = 0;
                break;
            }
            case 4: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int nextThread = n;
        this.getLoopDetector$lincheck().beforePart(nextThread);
        this.setCurrentThread(nextThread);
    }

    @Override
    protected int chooseThread(int iThread) {
        int n;
        Interleaving interleaving = this.currentInterleaving;
        if (interleaving == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentInterleaving");
            interleaving = null;
        }
        int it = n = interleaving.chooseThread(iThread);
        boolean bl = false;
        if (!this.switchableThreads(iThread).contains(it)) {
            boolean bl2 = false;
            String string = StringsKt.trimIndent((String)("\n               Trying to switch the execution to thread " + it + ",\n               but only the following threads are eligible to switch: " + this.switchableThreads(iThread) + "\n           "));
            throw new IllegalStateException(string.toString());
        }
        return n;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Choice;", "", "node", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "value", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;I)V", "getNode", "()Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "getValue", "()I", "toString", "", "lincheck"})
    private final class Choice {
        @NotNull
        private final InterleavingTreeNode node;
        private final int value;

        public Choice(InterleavingTreeNode node2, int value) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            this.node = node2;
            this.value = value;
        }

        @NotNull
        public final InterleavingTreeNode getNode() {
            return this.node;
        }

        public final int getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return "Choice(node=" + this.node + ", value=" + this.value + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Companion;", "", "()V", "lincheckVersion", "", "kotlin.jvm.PlatformType", "getLincheckVersion$lincheck", "()Ljava/lang/String;", "lincheckVersion$delegate", "Lkotlin/Lazy;", "lincheck"})
    public static final class Companion {
        private Companion() {
        }

        public final String getLincheckVersion$lincheck() {
            Lazy lazy = lincheckVersion$delegate;
            return (String)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J(\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ExceptionProcessingResult;", "", "exceptionsRepresentation", "", "", "isInternalBugOccurred", "", "([Ljava/lang/String;Z)V", "getExceptionsRepresentation", "()[Ljava/lang/String;", "[Ljava/lang/String;", "()Z", "component1", "component2", "copy", "([Ljava/lang/String;Z)Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ExceptionProcessingResult;", "equals", "other", "hashCode", "", "toString", "lincheck"})
    private static final class ExceptionProcessingResult {
        @NotNull
        private final String[] exceptionsRepresentation;
        private final boolean isInternalBugOccurred;

        public ExceptionProcessingResult(@NotNull String[] exceptionsRepresentation, boolean isInternalBugOccurred) {
            Intrinsics.checkNotNullParameter((Object)exceptionsRepresentation, (String)"exceptionsRepresentation");
            this.exceptionsRepresentation = exceptionsRepresentation;
            this.isInternalBugOccurred = isInternalBugOccurred;
        }

        @NotNull
        public final String[] getExceptionsRepresentation() {
            return this.exceptionsRepresentation;
        }

        public final boolean isInternalBugOccurred() {
            return this.isInternalBugOccurred;
        }

        @NotNull
        public final String[] component1() {
            return this.exceptionsRepresentation;
        }

        public final boolean component2() {
            return this.isInternalBugOccurred;
        }

        @NotNull
        public final ExceptionProcessingResult copy(@NotNull String[] exceptionsRepresentation, boolean isInternalBugOccurred) {
            Intrinsics.checkNotNullParameter((Object)exceptionsRepresentation, (String)"exceptionsRepresentation");
            return new ExceptionProcessingResult(exceptionsRepresentation, isInternalBugOccurred);
        }

        public static /* synthetic */ ExceptionProcessingResult copy$default(ExceptionProcessingResult exceptionProcessingResult, String[] stringArray, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                stringArray = exceptionProcessingResult.exceptionsRepresentation;
            }
            if ((n & 2) != 0) {
                bl = exceptionProcessingResult.isInternalBugOccurred;
            }
            return exceptionProcessingResult.copy(stringArray, bl);
        }

        @NotNull
        public String toString() {
            return "ExceptionProcessingResult(exceptionsRepresentation=" + Arrays.toString(this.exceptionsRepresentation) + ", isInternalBugOccurred=" + this.isInternalBugOccurred + ")";
        }

        public int hashCode() {
            int result2 = Arrays.hashCode(this.exceptionsRepresentation);
            result2 = result2 * 31 + Boolean.hashCode(this.isInternalBugOccurred);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExceptionProcessingResult)) {
                return false;
            }
            ExceptionProcessingResult exceptionProcessingResult = (ExceptionProcessingResult)other;
            if (!Intrinsics.areEqual((Object)this.exceptionsRepresentation, (Object)exceptionProcessingResult.exceptionsRepresentation)) {
                return false;
            }
            return this.isInternalBugOccurred == exceptionProcessingResult.isInternalBugOccurred;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\n\u0010\u0015\u001a\u00060\u0000R\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u001b\u001a\u00020\u0017R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0018\u00010\u0007R\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0018\u00010\u0007R\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\b\u0012\u00060\u0010R\u00020\b\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "", "switchPositions", "", "", "threadSwitchChoices", "initialLastNotInitializedNode", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$SwitchChoosingNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$SwitchChoosingNode;)V", "executionPosition", "interleavingFinishingRandom", "Lkotlin/random/Random;", "lastNotInitializedNode", "lastNotInitializedNodeChoices", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Choice;", "nextThreadToSwitch", "", "chooseThread", "iThread", "copy", "initialize", "", "isSwitchPosition", "", "newExecutionPosition", "rollbackAfterSpinCycleFound", "lincheck"})
    private final class Interleaving {
        @NotNull
        private final List<Integer> switchPositions;
        @NotNull
        private final List<Integer> threadSwitchChoices;
        @Nullable
        private final SwitchChoosingNode initialLastNotInitializedNode;
        @Nullable
        private SwitchChoosingNode lastNotInitializedNode;
        private Random interleavingFinishingRandom;
        private Iterator<Integer> nextThreadToSwitch;
        @Nullable
        private List<Choice> lastNotInitializedNodeChoices;
        private int executionPosition;

        public Interleaving(@NotNull List<Integer> switchPositions, @Nullable List<Integer> threadSwitchChoices, SwitchChoosingNode initialLastNotInitializedNode) {
            Intrinsics.checkNotNullParameter(switchPositions, (String)"switchPositions");
            Intrinsics.checkNotNullParameter(threadSwitchChoices, (String)"threadSwitchChoices");
            this.switchPositions = switchPositions;
            this.threadSwitchChoices = threadSwitchChoices;
            this.lastNotInitializedNode = this.initialLastNotInitializedNode = initialLastNotInitializedNode;
        }

        /*
         * WARNING - void declaration
         */
        public final void initialize() {
            block0: {
                void choices;
                List list;
                this.executionPosition = -1;
                this.interleavingFinishingRandom = RandomKt.Random((int)2);
                this.nextThreadToSwitch = this.threadSwitchChoices.iterator();
                ModelCheckingStrategy.this.getLoopDetector$lincheck().initialize();
                this.lastNotInitializedNodeChoices = null;
                SwitchChoosingNode switchChoosingNode = this.lastNotInitializedNode;
                if (switchChoosingNode == null) break block0;
                SwitchChoosingNode it = switchChoosingNode;
                boolean bl = false;
                List list2 = list = (List)new ArrayList();
                Interleaving interleaving = this;
                boolean bl2 = false;
                it.setChoices((List<Choice>)choices);
                interleaving.lastNotInitializedNodeChoices = list;
                this.lastNotInitializedNode = null;
            }
        }

        public final void rollbackAfterSpinCycleFound() {
            block0: {
                this.lastNotInitializedNode = this.initialLastNotInitializedNode;
                List<Choice> list = this.lastNotInitializedNodeChoices;
                if (list == null) break block0;
                list.clear();
            }
        }

        public final int chooseThread(int iThread) {
            int n;
            Iterator<Integer> iterator = this.nextThreadToSwitch;
            if (iterator == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadToSwitch");
                iterator = null;
            }
            if (iterator.hasNext()) {
                Iterator<Integer> iterator2 = this.nextThreadToSwitch;
                if (iterator2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"nextThreadToSwitch");
                    iterator2 = null;
                }
                n = ((Number)iterator2.next()).intValue();
            } else {
                this.lastNotInitializedNodeChoices = null;
                Collection collection = ModelCheckingStrategy.this.switchableThreads(iThread);
                Random random = this.interleavingFinishingRandom;
                if (random == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"interleavingFinishingRandom");
                    random = null;
                }
                n = ((Number)CollectionsKt.random((Collection)collection, (Random)random)).intValue();
            }
            return n;
        }

        public final boolean isSwitchPosition() {
            return this.switchPositions.contains(this.executionPosition);
        }

        public final void newExecutionPosition(int iThread) {
            block1: {
                int n = this.executionPosition;
                this.executionPosition = n + 1;
                Integer n2 = (Integer)CollectionsKt.lastOrNull(this.switchPositions);
                if (this.executionPosition <= (n2 != null ? n2 : -1)) break block1;
                List<Choice> list = this.lastNotInitializedNodeChoices;
                if (list != null) {
                    list.add(new Choice(new ThreadChoosingNode(ModelCheckingStrategy.this.switchableThreads(iThread)), this.executionPosition));
                }
            }
        }

        @NotNull
        public final Interleaving copy() {
            return new Interleaving(this.switchPositions, this.threadSwitchChoices, this.lastNotInitializedNode);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007J\n\u0010\u0013\u001a\u00060\u0014R\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingBuilder;", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;)V", "lastNoninitializedNode", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$SwitchChoosingNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "numberOfSwitches", "", "getNumberOfSwitches", "()I", "switchPositions", "", "threadSwitchChoices", "addLastNoninitializedNode", "", "addSwitchPosition", "switchPosition", "addThreadSwitchChoice", "iThread", "build", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "lincheck"})
    private final class InterleavingBuilder {
        @NotNull
        private final List<Integer> switchPositions = new ArrayList();
        @NotNull
        private final List<Integer> threadSwitchChoices = new ArrayList();
        @Nullable
        private SwitchChoosingNode lastNoninitializedNode;

        public final int getNumberOfSwitches() {
            return this.switchPositions.size();
        }

        public final void addSwitchPosition(int switchPosition) {
            this.switchPositions.add(switchPosition);
        }

        public final void addThreadSwitchChoice(int iThread) {
            this.threadSwitchChoices.add(iThread);
        }

        public final void addLastNoninitializedNode(@NotNull SwitchChoosingNode lastNoninitializedNode) {
            Intrinsics.checkNotNullParameter((Object)lastNoninitializedNode, (String)"lastNoninitializedNode");
            this.lastNoninitializedNode = lastNoninitializedNode;
        }

        @NotNull
        public final Interleaving build() {
            return new Interleaving(this.switchPositions, this.threadSwitchChoices, this.lastNoninitializedNode);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0014\u001a\u00060\u0005R\u00020\u0006H\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\b\u0018\u00010\u0018R\u00020\u0006J\u0018\u0010\u0017\u001a\u00060\u0018R\u00020\u00062\n\u0010\u0019\u001a\u00060\u001aR\u00020\u0006H&J\b\u0010\u001b\u001a\u00020\u0016H\u0004J\b\u0010\u001c\u001a\u00020\u0016H\u0004R$\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00060\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;)V", "choices", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Choice;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "getChoices", "()Ljava/util/List;", "setChoices", "(Ljava/util/List;)V", "fractionUnexplored", "", "<set-?>", "", "isFullyExplored", "()Z", "setFullyExplored", "(Z)V", "isInitialized", "chooseUnexploredNode", "finishExploration", "", "nextInterleaving", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "interleavingBuilder", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingBuilder;", "resetExploration", "updateExplorationStatistics", "lincheck"})
    @SourceDebugExtension(value={"SMAP\nModelCheckingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,535:1\n1855#2,2:536\n1789#2,3:539\n1726#2,3:542\n1855#2,2:545\n451#2,6:547\n1#3:538\n*S KotlinDebug\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode\n*L\n344#1:536,2\n360#1:539,3\n364#1:542,3\n373#1:545,2\n379#1:547,6\n*E\n"})
    private abstract class InterleavingTreeNode {
        private double fractionUnexplored = 1.0;
        public List<Choice> choices;
        private boolean isFullyExplored;

        @NotNull
        public final List<Choice> getChoices() {
            List<Choice> list = this.choices;
            if (list != null) {
                return list;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"choices");
            return null;
        }

        public final void setChoices(@NotNull List<Choice> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.choices = list;
        }

        public final boolean isFullyExplored() {
            return this.isFullyExplored;
        }

        protected final void setFullyExplored(boolean bl) {
            this.isFullyExplored = bl;
        }

        public final boolean isInitialized() {
            return this.choices != null;
        }

        @Nullable
        public final Interleaving nextInterleaving() {
            if (this.isFullyExplored) {
                ModelCheckingStrategy modelCheckingStrategy = ModelCheckingStrategy.this;
                int n = modelCheckingStrategy.maxNumberOfSwitches;
                modelCheckingStrategy.maxNumberOfSwitches = n + 1;
                this.resetExploration();
            }
            if (this.isFullyExplored) {
                return null;
            }
            return this.nextInterleaving(new InterleavingBuilder());
        }

        @NotNull
        public abstract Interleaving nextInterleaving(@NotNull InterleavingBuilder var1);

        protected final void resetExploration() {
            if (!this.isInitialized()) {
                this.isFullyExplored = false;
                this.fractionUnexplored = 1.0;
                return;
            }
            Iterable $this$forEach$iv = this.getChoices();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Choice it = (Choice)element$iv;
                boolean bl = false;
                it.getNode().resetExploration();
            }
            this.updateExplorationStatistics();
        }

        public final void finishExploration() {
            this.isFullyExplored = true;
            this.fractionUnexplored = 0.0;
        }

        /*
         * WARNING - void declaration
         */
        protected final void updateExplorationStatistics() {
            boolean bl;
            boolean bl2;
            block6: {
                void $this$all$iv;
                Iterable $this$fold$iv;
                if (!this.isInitialized()) {
                    boolean bl3 = false;
                    String string = "An interleaving tree node was not initialized properly. Probably caused by non-deterministic behaviour (WeakHashMap, Object.hashCode, etc)";
                    throw new IllegalStateException(string.toString());
                }
                if (this.getChoices().isEmpty()) {
                    this.finishExploration();
                    return;
                }
                Iterable iterable = this.getChoices();
                double initial$iv = 0.0;
                boolean $i$f$fold = false;
                double accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void choice;
                    Choice choice2 = (Choice)element$iv;
                    double acc = accumulator$iv;
                    boolean bl4 = false;
                    accumulator$iv = acc + choice.getNode().fractionUnexplored;
                }
                double total = accumulator$iv;
                this.fractionUnexplored = total / (double)this.getChoices().size();
                $this$fold$iv = this.getChoices();
                InterleavingTreeNode interleavingTreeNode = this;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Choice it = (Choice)element$iv;
                        boolean bl5 = false;
                        if (it.getNode().isFullyExplored) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            interleavingTreeNode.isFullyExplored = bl = bl2;
        }

        @NotNull
        protected final Choice chooseUnexploredNode() {
            Choice element$iv;
            block4: {
                if (this.getChoices().size() == 1) {
                    return (Choice)CollectionsKt.first(this.getChoices());
                }
                Iterable iterable = this.getChoices();
                double d = 0.0;
                for (Object t : iterable) {
                    Iterator<T> it;
                    Choice choice = (Choice)t;
                    double d2 = d;
                    boolean bl = false;
                    double d3 = ((Choice)((Object)it)).getNode().fractionUnexplored;
                    d = d2 + d3;
                }
                double total = d;
                double random = ModelCheckingStrategy.this.generationRandom.nextDouble() * total;
                double sumWeight = 0.0;
                Iterable $this$forEach$iv = this.getChoices();
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Choice choice = (Choice)element$iv2;
                    boolean bl = false;
                    if (!((sumWeight += choice.getNode().fractionUnexplored) >= random)) continue;
                    return choice;
                }
                List<Choice> $this$last$iv = this.getChoices();
                boolean $i$f$last = false;
                ListIterator<Choice> iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Choice it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(!it.getNode().isFullyExplored)) continue;
                    break block4;
                }
                throw new NoSuchElementException("List contains no element matching the predicate.");
            }
            return element$iv;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00060\u0005R\u00020\u00022\n\u0010\u0006\u001a\u00060\u0007R\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$SwitchChoosingNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;)V", "nextInterleaving", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "interleavingBuilder", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingBuilder;", "lincheck"})
    private final class SwitchChoosingNode
    extends InterleavingTreeNode {
        @Override
        @NotNull
        public Interleaving nextInterleaving(@NotNull InterleavingBuilder interleavingBuilder) {
            boolean isLeaf;
            Intrinsics.checkNotNullParameter((Object)interleavingBuilder, (String)"interleavingBuilder");
            boolean bl = isLeaf = ModelCheckingStrategy.this.maxNumberOfSwitches == interleavingBuilder.getNumberOfSwitches();
            if (isLeaf) {
                this.finishExploration();
                if (!this.isInitialized()) {
                    interleavingBuilder.addLastNoninitializedNode(this);
                }
                return interleavingBuilder.build();
            }
            Choice choice = this.chooseUnexploredNode();
            interleavingBuilder.addSwitchPosition(choice.getValue());
            Interleaving interleaving = choice.getNode().nextInterleaving(interleavingBuilder);
            this.updateExplorationStatistics();
            return interleaving;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00060\bR\u00020\u00022\n\u0010\t\u001a\u00060\nR\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ThreadChoosingNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingTreeNode;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;", "switchableThreads", "", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy;Ljava/util/List;)V", "nextInterleaving", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$Interleaving;", "interleavingBuilder", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$InterleavingBuilder;", "lincheck"})
    @SourceDebugExtension(value={"SMAP\nModelCheckingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ThreadChoosingNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,535:1\n1549#2:536\n1620#2,3:537\n*S KotlinDebug\n*F\n+ 1 ModelCheckingStrategy.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/modelchecking/ModelCheckingStrategy$ThreadChoosingNode\n*L\n388#1:536\n388#1:537,3\n*E\n"})
    private final class ThreadChoosingNode
    extends InterleavingTreeNode {
        /*
         * WARNING - void declaration
         */
        public ThreadChoosingNode(List<Integer> switchableThreads) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(switchableThreads, (String)"switchableThreads");
            Iterable iterable = switchableThreads;
            ModelCheckingStrategy modelCheckingStrategy = ModelCheckingStrategy.this;
            ThreadChoosingNode threadChoosingNode = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(modelCheckingStrategy.new Choice(modelCheckingStrategy.new SwitchChoosingNode(), (int)it));
            }
            threadChoosingNode.setChoices((List)destination$iv$iv);
        }

        @Override
        @NotNull
        public Interleaving nextInterleaving(@NotNull InterleavingBuilder interleavingBuilder) {
            Intrinsics.checkNotNullParameter((Object)interleavingBuilder, (String)"interleavingBuilder");
            Choice child = this.chooseUnexploredNode();
            interleavingBuilder.addThreadSwitchChoice(child.getValue());
            Interleaving interleaving = child.getNode().nextInterleaving(interleavingBuilder);
            this.updateExplorationStatistics();
            return interleaving;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SwitchReason.values().length];
            try {
                nArray[SwitchReason.ACTIVE_LOCK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ExecutionPart.values().length];
            try {
                nArray[ExecutionPart.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionPart.PARALLEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionPart.POST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionPart.VALIDATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

