/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.strategy.managed.UnsafeName;
import org.jetbrains.kotlinx.lincheck.util.UnsafeHolder;
import sun.misc.Unsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/UnsafeNames;", "", "()V", "getMethodCallType", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/UnsafeName;", "parameters", "", "getMethodCallType$lincheck", "([Ljava/lang/Object;)Lorg/jetbrains/kotlinx/lincheck/strategy/managed/UnsafeName;", "lincheck"})
public final class UnsafeNames {
    @NotNull
    public static final UnsafeNames INSTANCE = new UnsafeNames();

    private UnsafeNames() {
    }

    @NotNull
    public final UnsafeName getMethodCallType$lincheck(@NotNull Object[] parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (parameters.length < 2) {
            return UnsafeName.TreatAsDefaultMethod.INSTANCE;
        }
        Object firstParameter = parameters[0];
        Object secondParameter = parameters[1];
        if (secondParameter instanceof Long) {
            UnsafeName unsafeName;
            if (firstParameter instanceof Class) {
                String string = UtilsKt.findFieldNameByOffset((Class)firstParameter, ((Number)secondParameter).longValue());
                if (string == null) {
                    return UnsafeName.TreatAsDefaultMethod.INSTANCE;
                }
                String fieldName = string;
                unsafeName = new UnsafeName.UnsafeStaticMethod((Class)firstParameter, fieldName, ArraysKt.drop((Object[])parameters, (int)2));
            } else if (firstParameter != null && firstParameter.getClass().isArray()) {
                Unsafe unsafe = UnsafeHolder.INSTANCE.getUNSAFE();
                int arrayBaseOffset = unsafe.arrayBaseOffset(firstParameter.getClass());
                int arrayIndexScale = unsafe.arrayIndexScale(firstParameter.getClass());
                long index = (((Number)secondParameter).longValue() - (long)arrayBaseOffset) / (long)arrayIndexScale;
                unsafeName = new UnsafeName.UnsafeArrayMethod(firstParameter, (int)index, ArraysKt.drop((Object[])parameters, (int)2));
            } else if (firstParameter != null) {
                String string = UtilsKt.findFieldNameByOffset(firstParameter.getClass(), ((Number)secondParameter).longValue());
                if (string == null) {
                    return UnsafeName.TreatAsDefaultMethod.INSTANCE;
                }
                String fieldName = string;
                unsafeName = new UnsafeName.UnsafeInstanceMethod(firstParameter, fieldName, ArraysKt.drop((Object[])parameters, (int)2));
            } else {
                unsafeName = UnsafeName.TreatAsDefaultMethod.INSTANCE;
            }
            return unsafeName;
        }
        return UnsafeName.TreatAsDefaultMethod.INSTANCE;
    }
}

