/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.strategy.managed.InterleavingHistoryNode;
import org.jetbrains.kotlinx.lincheck.strategy.managed.LoopDetector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u0006R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0015j\b\u0012\u0004\u0012\u00020\t`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ReplayModeLoopDetectorHelper;", "", "interleavingHistory", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingHistoryNode;", "failDueToDeadlockInTheEnd", "", "(Ljava/util/List;Z)V", "currentCyclePeriod", "", "getCurrentCyclePeriod", "()I", "currentHistoryNode", "getCurrentHistoryNode", "()Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingHistoryNode;", "currentInterleavingNodeIndex", "currentlyInSpinCycle", "getCurrentlyInSpinCycle", "()Z", "executionsPerformedInCurrentThread", "threadsRan", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "detectLivelock", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "initialize", "", "onNextExecution", "onNextSwitch", "shouldSwitch", "lincheck"})
final class ReplayModeLoopDetectorHelper {
    @NotNull
    private final List<InterleavingHistoryNode> interleavingHistory;
    private final boolean failDueToDeadlockInTheEnd;
    private int currentInterleavingNodeIndex;
    private int executionsPerformedInCurrentThread;
    @NotNull
    private final HashSet<Integer> threadsRan;

    public ReplayModeLoopDetectorHelper(@NotNull List<InterleavingHistoryNode> interleavingHistory, boolean failDueToDeadlockInTheEnd) {
        Intrinsics.checkNotNullParameter(interleavingHistory, (String)"interleavingHistory");
        this.interleavingHistory = interleavingHistory;
        this.failDueToDeadlockInTheEnd = failDueToDeadlockInTheEnd;
        this.threadsRan = new HashSet();
    }

    public final int getCurrentCyclePeriod() {
        return this.interleavingHistory.get(this.currentInterleavingNodeIndex).getSpinCyclePeriod();
    }

    private final InterleavingHistoryNode getCurrentHistoryNode() {
        return this.interleavingHistory.get(this.currentInterleavingNodeIndex);
    }

    public final boolean getCurrentlyInSpinCycle() {
        return this.getCurrentHistoryNode().getCycleOccurred() && this.getCurrentHistoryNode().getExecutions() <= this.executionsPerformedInCurrentThread;
    }

    public final void initialize() {
        this.currentInterleavingNodeIndex = 0;
        this.executionsPerformedInCurrentThread = 0;
        this.threadsRan.clear();
    }

    public final void onNextExecution() {
        int n = this.executionsPerformedInCurrentThread;
        this.executionsPerformedInCurrentThread = n + 1;
    }

    public final void onNextSwitch() {
        int n = this.currentInterleavingNodeIndex;
        this.currentInterleavingNodeIndex = n + 1;
        this.executionsPerformedInCurrentThread = 0;
    }

    public final boolean shouldSwitch() {
        if (!(this.currentInterleavingNodeIndex <= CollectionsKt.getLastIndex(this.interleavingHistory))) {
            boolean bl = false;
            String string = "Internal error";
            throw new IllegalArgumentException(string.toString());
        }
        InterleavingHistoryNode historyNode = this.interleavingHistory.get(this.currentInterleavingNodeIndex);
        return this.executionsPerformedInCurrentThread > historyNode.getSpinCyclePeriod() + historyNode.getExecutions();
    }

    @NotNull
    public final LoopDetector.Decision detectLivelock() {
        int cyclePeriod = this.interleavingHistory.get(this.currentInterleavingNodeIndex).getSpinCyclePeriod();
        if (this.currentInterleavingNodeIndex == CollectionsKt.getLastIndex(this.interleavingHistory) && this.failDueToDeadlockInTheEnd) {
            return new LoopDetector.Decision.LivelockFailureDetected(cyclePeriod);
        }
        return cyclePeriod != 0 ? (LoopDetector.Decision)new LoopDetector.Decision.LivelockThreadSwitch(cyclePeriod) : (LoopDetector.Decision)LoopDetector.Decision.Idle.INSTANCE;
    }
}

