/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CallStackTraceElement;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CodeLocationTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ForcibleExecutionFinishError;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ReturnedValueResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\nJ\u0014\u0010\u001b\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0006J\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u0019J\b\u0010!\u001a\u00020\nH\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MethodCallTracePoint;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationTracePoint;", "iThread", "", "actorId", "callStackTrace", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTraceElement;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTrace;", "methodName", "", "stackTraceElement", "Ljava/lang/StackTraceElement;", "(IILjava/util/List;Ljava/lang/String;Ljava/lang/StackTraceElement;)V", "ownerName", "parameters", "returnedValue", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ReturnedValueResult;", "thrownException", "", "wasSuspended", "", "getWasSuspended", "()Z", "initializeCoroutineSuspendedResult", "", "initializeOwnerName", "initializeParameters", "initializeReturnedValue", "valueRepresentation", "initializeThrownException", "exception", "initializeVoidReturnedValue", "toStringCompact", "lincheck"})
public final class MethodCallTracePoint
extends CodeLocationTracePoint {
    @NotNull
    private final String methodName;
    @NotNull
    private ReturnedValueResult returnedValue;
    @Nullable
    private Throwable thrownException;
    @Nullable
    private List<String> parameters;
    @Nullable
    private String ownerName;

    public MethodCallTracePoint(int iThread, int actorId, @NotNull List<CallStackTraceElement> callStackTrace, @NotNull String methodName, @NotNull StackTraceElement stackTraceElement) {
        Intrinsics.checkNotNullParameter(callStackTrace, (String)"callStackTrace");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)stackTraceElement, (String)"stackTraceElement");
        super(iThread, actorId, callStackTrace, stackTraceElement);
        this.methodName = methodName;
        this.returnedValue = ReturnedValueResult.NoValue.INSTANCE;
    }

    public final boolean getWasSuspended() {
        return Intrinsics.areEqual((Object)this.returnedValue, (Object)ReturnedValueResult.CoroutineSuspended.INSTANCE);
    }

    @Override
    @NotNull
    protected String toStringCompact() {
        StringBuilder stringBuilder;
        StringBuilder $this$toStringCompact_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.ownerName != null) {
            $this$toStringCompact_u24lambda_u240.append(this.ownerName + ".");
        }
        $this$toStringCompact_u24lambda_u240.append(this.methodName + "(");
        List<String> parameters = this.parameters;
        if (parameters != null) {
            $this$toStringCompact_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)parameters, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        $this$toStringCompact_u24lambda_u240.append(")");
        ReturnedValueResult returnedValue = this.returnedValue;
        if (returnedValue instanceof ReturnedValueResult.ValueResult) {
            $this$toStringCompact_u24lambda_u240.append(": " + ((ReturnedValueResult.ValueResult)returnedValue).getValueRepresentation());
        } else if (returnedValue instanceof ReturnedValueResult.CoroutineSuspended) {
            $this$toStringCompact_u24lambda_u240.append(": COROUTINE_SUSPENDED");
        } else if (this.thrownException != null && !Intrinsics.areEqual((Object)this.thrownException, (Object)ForcibleExecutionFinishError.INSTANCE)) {
            Throwable throwable = this.thrownException;
            Intrinsics.checkNotNull((Object)throwable);
            $this$toStringCompact_u24lambda_u240.append(": threw " + throwable.getClass().getSimpleName());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void initializeVoidReturnedValue() {
        this.returnedValue = ReturnedValueResult.VoidResult.INSTANCE;
    }

    public final void initializeCoroutineSuspendedResult() {
        this.returnedValue = ReturnedValueResult.CoroutineSuspended.INSTANCE;
    }

    public final void initializeReturnedValue(@NotNull String valueRepresentation) {
        Intrinsics.checkNotNullParameter((Object)valueRepresentation, (String)"valueRepresentation");
        this.returnedValue = new ReturnedValueResult.ValueResult(valueRepresentation);
    }

    public final void initializeThrownException(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.thrownException = exception;
    }

    public final void initializeParameters(@NotNull List<String> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.parameters = parameters;
    }

    public final void initializeOwnerName(@NotNull String ownerName) {
        Intrinsics.checkNotNullParameter((Object)ownerName, (String)"ownerName");
        this.ownerName = ownerName;
    }
}

