/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CycleInfo;
import org.jetbrains.kotlinx.lincheck.strategy.managed.InterleavingHistoryNode;
import org.jetbrains.kotlinx.lincheck.strategy.managed.InterleavingSequenceTrackableSet;
import org.jetbrains.kotlinx.lincheck.strategy.managed.InterleavingSequenceTrackableSetKt;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ReplayModeLoopDetectorHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u001d\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003OPQB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020#2\b\u0010%\u001a\u0004\u0018\u00010\u0001J#\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00032\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010)\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0003J\u0016\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\u0003J\u0010\u00100\u001a\u00020#2\b\u00101\u001a\u0004\u0018\u00010\u0001J \u00102\u001a\u00020#2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\u00032\b\u0010%\u001a\u0004\u0018\u00010\u0001J\u001a\u00103\u001a\u00020#2\b\u00101\u001a\u0004\u0018\u00010\u00012\b\u0010%\u001a\u0004\u0018\u00010\u0001J\u000e\u00104\u001a\u00020#2\u0006\u00105\u001a\u00020\u000eJ\u0006\u00106\u001a\u00020#J\u000e\u00107\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0003J\u000e\u00108\u001a\u00020#2\u0006\u00109\u001a\u00020\u0003J\u000e\u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020\u0003J\u0010\u0010<\u001a\u00020#2\u0006\u0010,\u001a\u00020\u0003H\u0002J\u000e\u0010=\u001a\u00020#2\u0006\u00109\u001a\u00020\u0003J\u000e\u0010>\u001a\u00020#2\u0006\u00109\u001a\u00020\u0003J\u001b\u0010?\u001a\u00020#2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010)\u00a2\u0006\u0002\u0010@J\u0012\u0010A\u001a\u00020#2\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u0002J\b\u0010C\u001a\u00020#H\u0002J\u0010\u0010D\u001a\u00020#2\u0006\u00109\u001a\u00020\u0003H\u0002J\u0006\u0010E\u001a\u00020\u000eJ\r\u0010F\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ\u001c\u0010I\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010K\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030L0JH\u0002J\u0016\u0010M\u001a\u00020N2\u0006\u00109\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector;", "", "hangingDetectionThreshold", "", "(I)V", "currentInterleavingHistory", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingHistoryNode;", "currentThreadCodeLocationVisitCountMap", "", "currentThreadCodeLocationsHistory", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$CodeIdentity;", "firstThreadSet", "", "getFirstThreadSet", "()Z", "interleavingsLeadToSpinLockSet", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet;", "lastExecutedThread", "loopTrackingCursor", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/InterleavingSequenceTrackableSet$Cursor;", "mode", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Mode;", "replayModeCurrentCyclePeriod", "getReplayModeCurrentCyclePeriod", "()I", "replayModeCurrentlyInSpinCycle", "getReplayModeCurrentlyInSpinCycle", "replayModeEnabled", "getReplayModeEnabled", "replayModeLoopDetectorHelper", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ReplayModeLoopDetectorHelper;", "totalExecutionsCount", "afterMethodCall", "", "afterRead", "value", "beforeMethodCall", "codeLocation", "params", "", "(I[Ljava/lang/Object;)V", "beforePart", "nextThread", "beforeReadArrayElement", "array", "index", "beforeReadField", "receiver", "beforeWriteArrayElement", "beforeWriteField", "enableReplayMode", "failDueToDeadlockInTheEnd", "initialize", "initializeFirstCodeLocationAfterSwitch", "onActorStart", "iThread", "onNextExecutionPoint", "executionIdentity", "onNextThreadSwitchPoint", "onThreadFinish", "onThreadSwitch", "passParameters", "([Ljava/lang/Object;)V", "passValue", "obj", "registerCycle", "setFirstThread", "shouldSwitchInReplayMode", "treeToString", "", "treeToString$lincheck", "tryFindCycleWithParamsOrWithout", "Lkotlin/Pair;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CycleInfo;", "", "visitCodeLocation", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "CodeIdentity", "Decision", "Mode", "lincheck"})
@SourceDebugExtension(value={"SMAP\nLoopDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoopDetector.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,957:1\n1#2:958\n1#2:971\n13309#3,2:959\n1603#4,9:961\n1855#4:970\n1856#4:972\n1612#4:973\n*S KotlinDebug\n*F\n+ 1 LoopDetector.kt\norg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector\n*L\n490#1:971\n300#1:959,2\n490#1:961,9\n490#1:970\n490#1:972\n490#1:973\n*E\n"})
public final class LoopDetector {
    private final int hangingDetectionThreshold;
    private int lastExecutedThread;
    @NotNull
    private final Map<Integer, Integer> currentThreadCodeLocationVisitCountMap;
    @NotNull
    private final List<CodeIdentity> currentThreadCodeLocationsHistory;
    @NotNull
    private final ArrayList<InterleavingHistoryNode> currentInterleavingHistory;
    @NotNull
    private final InterleavingSequenceTrackableSet interleavingsLeadToSpinLockSet;
    @NotNull
    private final InterleavingSequenceTrackableSet.Cursor loopTrackingCursor;
    private int totalExecutionsCount;
    @Nullable
    private ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper;
    @NotNull
    private Mode mode;

    public LoopDetector(int hangingDetectionThreshold) {
        this.hangingDetectionThreshold = hangingDetectionThreshold;
        this.lastExecutedThread = -1;
        this.currentThreadCodeLocationVisitCountMap = new LinkedHashMap();
        this.currentThreadCodeLocationsHistory = new ArrayList();
        this.currentInterleavingHistory = new ArrayList();
        this.interleavingsLeadToSpinLockSet = new InterleavingSequenceTrackableSet();
        this.loopTrackingCursor = this.interleavingsLeadToSpinLockSet.getCursor();
        this.mode = Mode.DEFAULT;
    }

    private final boolean getFirstThreadSet() {
        return this.lastExecutedThread != -1;
    }

    private final int getReplayModeCurrentCyclePeriod() {
        ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
        return replayModeLoopDetectorHelper != null ? replayModeLoopDetectorHelper.getCurrentCyclePeriod() : 0;
    }

    public final boolean getReplayModeEnabled() {
        return this.replayModeLoopDetectorHelper != null;
    }

    public final boolean getReplayModeCurrentlyInSpinCycle() {
        ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
        Intrinsics.checkNotNull((Object)replayModeLoopDetectorHelper);
        return replayModeLoopDetectorHelper.getCurrentlyInSpinCycle();
    }

    public final void enableReplayMode(boolean failDueToDeadlockInTheEnd) {
        int n;
        CycleInfo cycleInfo = InterleavingSequenceTrackableSetKt.findMaxPrefixLengthWithNoCycleOnSuffix((List)this.currentInterleavingHistory);
        if (cycleInfo != null) {
            CycleInfo it = cycleInfo;
            boolean bl = false;
            n = it.getExecutionsBeforeCycle() + it.getCyclePeriod();
        } else {
            n = this.currentInterleavingHistory.size();
        }
        int contextSwitchesBeforeHalt = n;
        List spinCycleInterleavingHistory = CollectionsKt.take((Iterable)this.currentInterleavingHistory, (int)contextSwitchesBeforeHalt);
        this.interleavingsLeadToSpinLockSet.clear();
        this.loopTrackingCursor.clear();
        this.replayModeLoopDetectorHelper = new ReplayModeLoopDetectorHelper(spinCycleInterleavingHistory, failDueToDeadlockInTheEnd);
    }

    public final boolean shouldSwitchInReplayMode() {
        ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
        Intrinsics.checkNotNull((Object)replayModeLoopDetectorHelper);
        ReplayModeLoopDetectorHelper $this$shouldSwitchInReplayMode_u24lambda_u241 = replayModeLoopDetectorHelper;
        boolean bl = false;
        $this$shouldSwitchInReplayMode_u24lambda_u241.onNextExecution();
        return $this$shouldSwitchInReplayMode_u24lambda_u241.shouldSwitch();
    }

    @NotNull
    public final Decision visitCodeLocation(int iThread, int codeLocation) {
        ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
        if (replayModeLoopDetectorHelper != null) {
            ReplayModeLoopDetectorHelper it = replayModeLoopDetectorHelper;
            boolean bl = false;
            return it.shouldSwitch() ? it.detectLivelock() : (Decision)Decision.Idle.INSTANCE;
        }
        int n = this.totalExecutionsCount;
        this.totalExecutionsCount = n + 1;
        if (!(this.lastExecutedThread == iThread)) {
            boolean $i$a$-check-LoopDetector$visitCodeLocation$32 = false;
            String $i$a$-check-LoopDetector$visitCodeLocation$32 = "reset expected!";
            throw new IllegalStateException($i$a$-check-LoopDetector$visitCodeLocation$32.toString());
        }
        if (codeLocation == -1) {
            return Decision.Idle.INSTANCE;
        }
        int count = ((Number)this.currentThreadCodeLocationVisitCountMap.getOrDefault(codeLocation, 0)).intValue() + 1;
        Integer it = codeLocation;
        Integer bl = count;
        this.currentThreadCodeLocationVisitCountMap.put(it, bl);
        ((Collection)this.currentThreadCodeLocationsHistory).add(new CodeIdentity.RegularCodeLocationIdentity(codeLocation));
        boolean detectedFirstTime = count > this.hangingDetectionThreshold;
        boolean detectedEarly = this.loopTrackingCursor.isInCycle();
        if (detectedFirstTime && !detectedEarly) {
            if (this.mode == Mode.DEFAULT) {
                this.mode = Mode.CYCLE_PERIOD_CALCULATION;
                return Decision.LivelockReplayToDetectCycleRequired.INSTANCE;
            }
            this.registerCycle();
            this.mode = Mode.DEFAULT;
            if (this.totalExecutionsCount > 10001) {
                return Decision.EventsThresholdReached.INSTANCE;
            }
            return Decision.LivelockReplayRequired.INSTANCE;
        }
        if (!detectedFirstTime && detectedEarly) {
            this.totalExecutionsCount += this.hangingDetectionThreshold;
            InterleavingHistoryNode lastNode = (InterleavingHistoryNode)CollectionsKt.last((List)this.currentInterleavingHistory);
            if (lastNode.getSpinCyclePeriod() == 0) {
                int cyclePeriod = this.loopTrackingCursor.getCyclePeriod();
                lastNode.setExecutions(lastNode.getExecutions() - cyclePeriod);
                lastNode.setSpinCyclePeriod(cyclePeriod);
                lastNode.setExecutionHash(this.loopTrackingCursor.getCycleLocationsHash());
            }
            if (this.totalExecutionsCount > 10001) {
                return Decision.EventsThresholdReached.INSTANCE;
            }
        }
        int cyclePeriod = this.getReplayModeCurrentCyclePeriod();
        return detectedFirstTime || detectedEarly ? (Decision)new Decision.LivelockThreadSwitch(cyclePeriod) : (Decision)Decision.Idle.INSTANCE;
    }

    public final void beforeMethodCall(int codeLocation, @NotNull Object[] params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
        if (replayModeLoopDetectorHelper != null) {
            ReplayModeLoopDetectorHelper it = replayModeLoopDetectorHelper;
            boolean bl = false;
            it.onNextExecution();
            return;
        }
        ((Collection)this.currentThreadCodeLocationsHistory).add(new CodeIdentity.RegularCodeLocationIdentity(codeLocation));
        this.passParameters(params);
        InterleavingHistoryNode lastInterleavingHistoryNode = (InterleavingHistoryNode)CollectionsKt.last((List)this.currentInterleavingHistory);
        if (lastInterleavingHistoryNode.getCycleOccurred()) {
            return;
        }
        lastInterleavingHistoryNode.addExecution(codeLocation);
        this.loopTrackingCursor.onNextExecutionPoint();
    }

    public final void afterMethodCall() {
        ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
        if (replayModeLoopDetectorHelper != null) {
            ReplayModeLoopDetectorHelper it = replayModeLoopDetectorHelper;
            boolean bl = false;
            it.onNextExecution();
            return;
        }
        CodeIdentity.RegularCodeLocationIdentity methodExitLocationIdentity = new CodeIdentity.RegularCodeLocationIdentity(0);
        ((Collection)this.currentThreadCodeLocationsHistory).add(methodExitLocationIdentity);
        InterleavingHistoryNode lastInterleavingHistoryNode = (InterleavingHistoryNode)CollectionsKt.last((List)this.currentInterleavingHistory);
        if (lastInterleavingHistoryNode.getCycleOccurred()) {
            return;
        }
        lastInterleavingHistoryNode.addExecution(methodExitLocationIdentity.getLocation());
        this.loopTrackingCursor.onNextExecutionPoint();
    }

    public final void passParameters(@NotNull Object[] params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.mode == Mode.DEFAULT) {
            return;
        }
        Object[] $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object element$iv;
            Object param = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ((Collection)this.currentThreadCodeLocationsHistory).add(new CodeIdentity.ValueRepresentationIdentity(UtilsKt.primitiveOrIdentityHashCode(param)));
        }
    }

    public final void beforeReadField(@Nullable Object receiver) {
        this.passValue(receiver);
    }

    public final void afterRead(@Nullable Object value) {
        this.passValue(value);
    }

    public final void beforeReadArrayElement(@NotNull Object array, int index) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.passValue(array);
        this.passValue(index);
    }

    public final void beforeWriteField(@Nullable Object receiver, @Nullable Object value) {
        this.passValue(receiver);
        this.passValue(value);
    }

    public final void beforeWriteArrayElement(@NotNull Object array, int index, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.passValue(array);
        this.passValue(index);
        this.passValue(value);
    }

    public final void onActorStart(int iThread) {
        if (!(iThread == this.lastExecutedThread)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.currentThreadCodeLocationVisitCountMap.clear();
    }

    public final void onThreadSwitch(int iThread) {
        this.lastExecutedThread = iThread;
        this.currentThreadCodeLocationVisitCountMap.clear();
        this.currentThreadCodeLocationsHistory.clear();
        this.onNextThreadSwitchPoint(iThread);
    }

    public final void onThreadFinish(int iThread) {
        if (!(iThread == this.lastExecutedThread)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.onNextExecutionPoint(-iThread);
    }

    private final void onNextThreadSwitchPoint(int nextThread) {
        block1: {
            if (!((Collection)this.currentInterleavingHistory).isEmpty() && ((InterleavingHistoryNode)CollectionsKt.last((List)this.currentInterleavingHistory)).getThreadId() == nextThread) {
                return;
            }
            this.currentInterleavingHistory.add(new InterleavingHistoryNode(nextThread, 0, 0, 0, 12, null));
            this.loopTrackingCursor.onNextSwitchPoint(nextThread);
            ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
            if (replayModeLoopDetectorHelper == null) break block1;
            replayModeLoopDetectorHelper.onNextSwitch();
        }
    }

    public final void initializeFirstCodeLocationAfterSwitch(int codeLocation) {
        ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
        if (replayModeLoopDetectorHelper != null) {
            ReplayModeLoopDetectorHelper helper = replayModeLoopDetectorHelper;
            boolean bl = false;
            helper.onNextExecution();
            return;
        }
        this.onNextExecutionPoint(codeLocation);
        int n = this.totalExecutionsCount;
        this.totalExecutionsCount = n + 1;
        int count = ((Number)this.currentThreadCodeLocationVisitCountMap.getOrDefault(codeLocation, 0)).intValue() + 1;
        Integer n2 = codeLocation;
        Integer n3 = count;
        this.currentThreadCodeLocationVisitCountMap.put(n2, n3);
        ((Collection)this.currentThreadCodeLocationsHistory).add(new CodeIdentity.RegularCodeLocationIdentity(codeLocation));
    }

    public final void onNextExecutionPoint(int executionIdentity) {
        InterleavingHistoryNode lastInterleavingHistoryNode = (InterleavingHistoryNode)CollectionsKt.last((List)this.currentInterleavingHistory);
        if (lastInterleavingHistoryNode.getCycleOccurred()) {
            return;
        }
        lastInterleavingHistoryNode.addExecution(executionIdentity);
        this.loopTrackingCursor.onNextExecutionPoint();
    }

    private final void passValue(Object obj) {
        if (this.mode == Mode.DEFAULT) {
            return;
        }
        ((Collection)this.currentThreadCodeLocationsHistory).add(new CodeIdentity.ValueRepresentationIdentity(UtilsKt.primitiveOrIdentityHashCode(obj)));
    }

    private final void registerCycle() {
        Pair<CycleInfo, List<Integer>> pair = this.tryFindCycleWithParamsOrWithout();
        CycleInfo cycleInfo = (CycleInfo)pair.component1();
        List switchPointsCodeLocationsHistory = (List)pair.component2();
        if (cycleInfo == null) {
            InterleavingHistoryNode lastNode = (InterleavingHistoryNode)CollectionsKt.last((List)this.currentInterleavingHistory);
            InterleavingHistoryNode cycleStateLastNode = lastNode.asNodeCorrespondingToCycle(switchPointsCodeLocationsHistory.size() - 1, 0, lastNode.getExecutionHash());
            this.currentInterleavingHistory.set(CollectionsKt.getLastIndex((List)this.currentInterleavingHistory), cycleStateLastNode);
            this.interleavingsLeadToSpinLockSet.addBranch((List<InterleavingHistoryNode>)this.currentInterleavingHistory);
            return;
        }
        int cycleExecutionLocationsHash = ((Number)switchPointsCodeLocationsHistory.get(cycleInfo.getExecutionsBeforeCycle())).intValue();
        int n = cycleInfo.getExecutionsBeforeCycle() + cycleInfo.getCyclePeriod();
        for (int i = cycleInfo.getExecutionsBeforeCycle() + 1; i < n; ++i) {
            cycleExecutionLocationsHash ^= ((Number)switchPointsCodeLocationsHistory.get(i)).intValue();
        }
        InterleavingHistoryNode cycleStateLastNode = ((InterleavingHistoryNode)CollectionsKt.last((List)this.currentInterleavingHistory)).asNodeCorrespondingToCycle(cycleInfo.getExecutionsBeforeCycle(), cycleInfo.getCyclePeriod(), cycleExecutionLocationsHash);
        this.currentInterleavingHistory.set(CollectionsKt.getLastIndex((List)this.currentInterleavingHistory), cycleStateLastNode);
        this.interleavingsLeadToSpinLockSet.addBranch((List<InterleavingHistoryNode>)this.currentInterleavingHistory);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<CycleInfo, List<Integer>> tryFindCycleWithParamsOrWithout() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.currentThreadCodeLocationsHistory;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CodeIdentity it = (CodeIdentity)element$iv$iv;
            boolean bl2 = false;
            CodeIdentity.RegularCodeLocationIdentity regularCodeLocationIdentity = it instanceof CodeIdentity.RegularCodeLocationIdentity ? (CodeIdentity.RegularCodeLocationIdentity)it : null;
            if ((regularCodeLocationIdentity != null ? Integer.valueOf(regularCodeLocationIdentity.getLocation()) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List historyWithoutParams = (List)destination$iv$iv;
        CycleInfo cycleInfo = InterleavingSequenceTrackableSetKt.findMaxPrefixLengthWithNoCycleOnSuffix(this.currentThreadCodeLocationsHistory);
        if (cycleInfo == null) {
            return TuplesKt.to((Object)InterleavingSequenceTrackableSetKt.findMaxPrefixLengthWithNoCycleOnSuffix(historyWithoutParams), (Object)historyWithoutParams);
        }
        CycleInfo cycleInfo2 = cycleInfo;
        int operationsBefore = 0;
        int cyclePeriod = 0;
        int operationsBeforeWithParams = 0;
        int cyclePeriodWithParams = 0;
        int i = 0;
        while (operationsBeforeWithParams < cycleInfo2.getExecutionsBeforeCycle()) {
            if (this.currentThreadCodeLocationsHistory.get(i) instanceof CodeIdentity.RegularCodeLocationIdentity) {
                ++operationsBefore;
            }
            ++operationsBeforeWithParams;
            ++i;
        }
        while (cyclePeriodWithParams < cycleInfo2.getCyclePeriod()) {
            if (this.currentThreadCodeLocationsHistory.get(i) instanceof CodeIdentity.RegularCodeLocationIdentity) {
                ++cyclePeriod;
            }
            ++cyclePeriodWithParams;
            ++i;
        }
        return TuplesKt.to((Object)new CycleInfo(operationsBefore, cyclePeriod), (Object)historyWithoutParams);
    }

    public final void beforePart(int nextThread) {
        if (!this.getFirstThreadSet()) {
            this.setFirstThread(nextThread);
        } else if (this.lastExecutedThread != nextThread) {
            this.onThreadSwitch(nextThread);
        }
    }

    public final void initialize() {
        this.lastExecutedThread = -1;
    }

    private final void setFirstThread(int iThread) {
        block0: {
            this.lastExecutedThread = iThread;
            this.currentThreadCodeLocationVisitCountMap.clear();
            this.currentThreadCodeLocationsHistory.clear();
            this.totalExecutionsCount = 0;
            this.loopTrackingCursor.reset(iThread);
            this.currentInterleavingHistory.clear();
            this.currentInterleavingHistory.add(new InterleavingHistoryNode(iThread, 0, 0, 0, 14, null));
            ReplayModeLoopDetectorHelper replayModeLoopDetectorHelper = this.replayModeLoopDetectorHelper;
            if (replayModeLoopDetectorHelper == null) break block0;
            replayModeLoopDetectorHelper.initialize();
        }
    }

    @NotNull
    public final String treeToString$lincheck() {
        return this.interleavingsLeadToSpinLockSet.treeToString$lincheck();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$CodeIdentity;", "", "RegularCodeLocationIdentity", "ValueRepresentationIdentity", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$CodeIdentity$RegularCodeLocationIdentity;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$CodeIdentity$ValueRepresentationIdentity;", "lincheck"})
    private static interface CodeIdentity {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$CodeIdentity$RegularCodeLocationIdentity;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$CodeIdentity;", "location", "", "(I)V", "getLocation", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "lincheck"})
        public static final class RegularCodeLocationIdentity
        implements CodeIdentity {
            private final int location;

            public RegularCodeLocationIdentity(int location) {
                this.location = location;
            }

            public final int getLocation() {
                return this.location;
            }

            public final int component1() {
                return this.location;
            }

            @NotNull
            public final RegularCodeLocationIdentity copy(int location) {
                return new RegularCodeLocationIdentity(location);
            }

            public static /* synthetic */ RegularCodeLocationIdentity copy$default(RegularCodeLocationIdentity regularCodeLocationIdentity, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = regularCodeLocationIdentity.location;
                }
                return regularCodeLocationIdentity.copy(n);
            }

            @NotNull
            public String toString() {
                return "RegularCodeLocationIdentity(location=" + this.location + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.location);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RegularCodeLocationIdentity)) {
                    return false;
                }
                RegularCodeLocationIdentity regularCodeLocationIdentity = (RegularCodeLocationIdentity)other;
                return this.location == regularCodeLocationIdentity.location;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$CodeIdentity$ValueRepresentationIdentity;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$CodeIdentity;", "identity", "", "(I)V", "getIdentity", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "lincheck"})
        public static final class ValueRepresentationIdentity
        implements CodeIdentity {
            private final int identity;

            public ValueRepresentationIdentity(int identity) {
                this.identity = identity;
            }

            public final int getIdentity() {
                return this.identity;
            }

            public final int component1() {
                return this.identity;
            }

            @NotNull
            public final ValueRepresentationIdentity copy(int identity) {
                return new ValueRepresentationIdentity(identity);
            }

            public static /* synthetic */ ValueRepresentationIdentity copy$default(ValueRepresentationIdentity valueRepresentationIdentity, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = valueRepresentationIdentity.identity;
                }
                return valueRepresentationIdentity.copy(n);
            }

            @NotNull
            public String toString() {
                return "ValueRepresentationIdentity(identity=" + this.identity + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.identity);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ValueRepresentationIdentity)) {
                    return false;
                }
                ValueRepresentationIdentity valueRepresentationIdentity = (ValueRepresentationIdentity)other;
                return this.identity == valueRepresentationIdentity.identity;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0006\t\n\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "", "()V", "EventsThresholdReached", "Idle", "LivelockFailureDetected", "LivelockReplayRequired", "LivelockReplayToDetectCycleRequired", "LivelockThreadSwitch", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$EventsThresholdReached;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$Idle;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$LivelockFailureDetected;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$LivelockReplayRequired;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$LivelockReplayToDetectCycleRequired;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$LivelockThreadSwitch;", "lincheck"})
    public static abstract class Decision {
        private Decision() {
        }

        public /* synthetic */ Decision(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$EventsThresholdReached;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "lincheck"})
        public static final class EventsThresholdReached
        extends Decision {
            @NotNull
            public static final EventsThresholdReached INSTANCE = new EventsThresholdReached();

            private EventsThresholdReached() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "EventsThresholdReached";
            }

            public int hashCode() {
                return 1750932090;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EventsThresholdReached)) {
                    return false;
                }
                EventsThresholdReached cfr_ignored_0 = (EventsThresholdReached)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$Idle;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "lincheck"})
        public static final class Idle
        extends Decision {
            @NotNull
            public static final Idle INSTANCE = new Idle();

            private Idle() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Idle";
            }

            public int hashCode() {
                return -55599314;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Idle)) {
                    return false;
                }
                Idle cfr_ignored_0 = (Idle)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$LivelockFailureDetected;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "cyclePeriod", "", "(I)V", "getCyclePeriod", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "lincheck"})
        public static final class LivelockFailureDetected
        extends Decision {
            private final int cyclePeriod;

            public LivelockFailureDetected(int cyclePeriod) {
                super(null);
                this.cyclePeriod = cyclePeriod;
            }

            public final int getCyclePeriod() {
                return this.cyclePeriod;
            }

            public final int component1() {
                return this.cyclePeriod;
            }

            @NotNull
            public final LivelockFailureDetected copy(int cyclePeriod) {
                return new LivelockFailureDetected(cyclePeriod);
            }

            public static /* synthetic */ LivelockFailureDetected copy$default(LivelockFailureDetected livelockFailureDetected, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = livelockFailureDetected.cyclePeriod;
                }
                return livelockFailureDetected.copy(n);
            }

            @NotNull
            public String toString() {
                return "LivelockFailureDetected(cyclePeriod=" + this.cyclePeriod + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.cyclePeriod);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LivelockFailureDetected)) {
                    return false;
                }
                LivelockFailureDetected livelockFailureDetected = (LivelockFailureDetected)other;
                return this.cyclePeriod == livelockFailureDetected.cyclePeriod;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$LivelockReplayRequired;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "lincheck"})
        public static final class LivelockReplayRequired
        extends Decision {
            @NotNull
            public static final LivelockReplayRequired INSTANCE = new LivelockReplayRequired();

            private LivelockReplayRequired() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "LivelockReplayRequired";
            }

            public int hashCode() {
                return 1476162935;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LivelockReplayRequired)) {
                    return false;
                }
                LivelockReplayRequired cfr_ignored_0 = (LivelockReplayRequired)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$LivelockReplayToDetectCycleRequired;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "lincheck"})
        public static final class LivelockReplayToDetectCycleRequired
        extends Decision {
            @NotNull
            public static final LivelockReplayToDetectCycleRequired INSTANCE = new LivelockReplayToDetectCycleRequired();

            private LivelockReplayToDetectCycleRequired() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "LivelockReplayToDetectCycleRequired";
            }

            public int hashCode() {
                return 492403567;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LivelockReplayToDetectCycleRequired)) {
                    return false;
                }
                LivelockReplayToDetectCycleRequired cfr_ignored_0 = (LivelockReplayToDetectCycleRequired)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision$LivelockThreadSwitch;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Decision;", "cyclePeriod", "", "(I)V", "getCyclePeriod", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "lincheck"})
        public static final class LivelockThreadSwitch
        extends Decision {
            private final int cyclePeriod;

            public LivelockThreadSwitch(int cyclePeriod) {
                super(null);
                this.cyclePeriod = cyclePeriod;
            }

            public final int getCyclePeriod() {
                return this.cyclePeriod;
            }

            public final int component1() {
                return this.cyclePeriod;
            }

            @NotNull
            public final LivelockThreadSwitch copy(int cyclePeriod) {
                return new LivelockThreadSwitch(cyclePeriod);
            }

            public static /* synthetic */ LivelockThreadSwitch copy$default(LivelockThreadSwitch livelockThreadSwitch, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = livelockThreadSwitch.cyclePeriod;
                }
                return livelockThreadSwitch.copy(n);
            }

            @NotNull
            public String toString() {
                return "LivelockThreadSwitch(cyclePeriod=" + this.cyclePeriod + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.cyclePeriod);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LivelockThreadSwitch)) {
                    return false;
                }
                LivelockThreadSwitch livelockThreadSwitch = (LivelockThreadSwitch)other;
                return this.cyclePeriod == livelockThreadSwitch.cyclePeriod;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector$Mode;", "", "(Ljava/lang/String;I)V", "DEFAULT", "CYCLE_PERIOD_CALCULATION", "lincheck"})
    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode DEFAULT = new Mode();
        public static final /* enum */ Mode CYCLE_PERIOD_CALCULATION = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.DEFAULT, Mode.CYCLE_PERIOD_CALCULATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

