/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CycleInfo;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b\"\u0004\b\u0000\u0010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0000\u00a8\u0006\t"}, d2={"findLastIndexNotRelatedToCycle", "", "T", "elements", "", "cycleLength", "startPosition", "findMaxPrefixLengthWithNoCycleOnSuffix", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CycleInfo;", "lincheck"})
public final class InterleavingSequenceTrackableSetKt {
    @Nullable
    public static final <T> CycleInfo findMaxPrefixLengthWithNoCycleOnSuffix(@NotNull List<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty() || elements.size() == 1) {
            return null;
        }
        int lastIndex = CollectionsKt.getLastIndex(elements);
        int targetCycleLength = elements.size();
        int minLastPositionNotRelatedToCycle = CollectionsKt.getLastIndex(elements);
        int i = lastIndex - 1;
        int n = elements.size() / 2 - 1;
        if (n <= i) {
            while (true) {
                int j = 0;
                while (i - j >= 0 && Intrinsics.areEqual(elements.get(i - j), elements.get(lastIndex - j)) && lastIndex - j > i) {
                    ++j;
                }
                if (lastIndex - j == i) {
                    int lastPositionNotRelatedToCycle;
                    int cycleLength = elements.size() - (i + 1);
                    int n2 = lastPositionNotRelatedToCycle = i - j >= 0 ? InterleavingSequenceTrackableSetKt.findLastIndexNotRelatedToCycle(elements, cycleLength, i - j) : -1;
                    if (minLastPositionNotRelatedToCycle > lastPositionNotRelatedToCycle) {
                        minLastPositionNotRelatedToCycle = lastPositionNotRelatedToCycle;
                        targetCycleLength = cycleLength;
                    }
                }
                if (i == n) break;
                --i;
            }
        }
        return targetCycleLength == elements.size() ? null : new CycleInfo(minLastPositionNotRelatedToCycle + 1, targetCycleLength);
    }

    private static final <T> int findLastIndexNotRelatedToCycle(List<? extends T> elements, int cycleLength, int startPosition) {
        for (int position = startPosition; position >= 0; --position) {
            T elementToMatch;
            T elementFromCycle = elements.get(CollectionsKt.getLastIndex(elements) - (CollectionsKt.getLastIndex(elements) - position) % cycleLength);
            if (Intrinsics.areEqual(elementFromCycle, elementToMatch = elements.get(position))) continue;
            return position;
        }
        return -1;
    }
}

