/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.runner;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.runner.Done;
import org.jetbrains.kotlinx.lincheck.runner.FixedActiveThreadsExecutorKt;
import org.jetbrains.kotlinx.lincheck.runner.Shutdown;
import org.jetbrains.kotlinx.lincheck.runner.TestThreadExecution;
import org.jetbrains.kotlinx.lincheck.util.Spinner;
import org.jetbrains.kotlinx.lincheck.util.SpinnerKt;
import sun.nio.ch.lincheck.TestThread;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00122\u0006\u0010\u001a\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0018\u0010$\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\rH\u0002J\b\u0010&\u001a\u00020!H\u0002J#\u0010'\u001a\u00020\u00182\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00122\u0006\u0010\u001a\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010(\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\rH\u0002J\u001d\u0010*\u001a\u00020!2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0012H\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor;", "Ljava/io/Closeable;", "testName", "", "nThreads", "", "(Ljava/lang/String;I)V", "hangDetected", "", "resultSpinner", "Lorg/jetbrains/kotlinx/lincheck/util/Spinner;", "results", "Lkotlinx/atomicfu/AtomicArray;", "", "taskSpinners", "", "tasks", "threads", "", "Lsun/nio/ch/lincheck/TestThread;", "getThreads", "()[Lsun/nio/ch/lincheck/TestThread;", "[Lsun/nio/ch/lincheck/TestThread;", "await", "", "Lorg/jetbrains/kotlinx/lincheck/runner/TestThreadExecution;", "timeoutNano", "([Lorg/jetbrains/kotlinx/lincheck/runner/TestThreadExecution;J)J", "awaitTask", "", "iThread", "deadline", "close", "", "getResult", "getTask", "setResult", "any", "shutdown", "submitAndAwait", "submitTask", "task", "submitTasks", "([Lorg/jetbrains/kotlinx/lincheck/runner/TestThreadExecution;)V", "testThreadRunnable", "Ljava/lang/Runnable;", "lincheck"})
@SourceDebugExtension(value={"SMAP\nFixedActiveThreadsExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedActiveThreadsExecutor.kt\norg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Spinner.kt\norg/jetbrains/kotlinx/lincheck/util/SpinnerKt\n+ 5 Spinner.kt\norg/jetbrains/kotlinx/lincheck/util/Spinner\n+ 6 Utils.kt\norg/jetbrains/kotlinx/lincheck/UtilsKt\n*L\n1#1,220:1\n12271#2,2:221\n11667#2,8:223\n13309#2,2:268\n1#3:231\n97#4:232\n98#4,4:237\n103#4:249\n97#4:250\n98#4,4:255\n103#4:267\n70#5,4:233\n74#5,8:241\n70#5,4:251\n74#5,8:259\n259#6,20:270\n259#6,20:290\n259#6,20:310\n*S KotlinDebug\n*F\n+ 1 FixedActiveThreadsExecutor.kt\norg/jetbrains/kotlinx/lincheck/runner/FixedActiveThreadsExecutor\n*L\n88#1:221,2\n91#1:223,8\n210#1:268,2\n145#1:232\n145#1:237,4\n145#1:249\n183#1:250\n183#1:255,4\n183#1:267\n145#1:233,4\n145#1:241,8\n183#1:251,4\n183#1:259,8\n164#1:270,20\n174#1:290,20\n177#1:310,20\n*E\n"})
public final class FixedActiveThreadsExecutor
implements Closeable {
    @NotNull
    private final String testName;
    private final int nThreads;
    @NotNull
    private /* synthetic */ AtomicReferenceArray tasks;
    @NotNull
    private final List<Spinner> taskSpinners;
    @NotNull
    private /* synthetic */ AtomicReferenceArray results;
    @NotNull
    private final Spinner resultSpinner;
    private boolean hangDetected;
    @NotNull
    private final TestThread[] threads;

    /*
     * WARNING - void declaration
     */
    public FixedActiveThreadsExecutor(@NotNull String testName, int nThreads) {
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        this.testName = testName;
        this.nThreads = nThreads;
        this.tasks = new AtomicReferenceArray(this.nThreads);
        this.taskSpinners = SpinnerKt.SpinnerGroup(this.nThreads);
        this.results = new AtomicReferenceArray(this.nThreads);
        this.resultSpinner = new Spinner(this.nThreads + 1);
        int n = 0;
        int n2 = this.nThreads;
        TestThread[] testThreadArray = new TestThread[n2];
        FixedActiveThreadsExecutor fixedActiveThreadsExecutor = this;
        while (n < n2) {
            void it;
            TestThread testThread;
            int n3 = n++;
            TestThread testThread2 = testThread = new TestThread(this.testName, n3, this.testThreadRunnable(n3));
            int n4 = n3;
            TestThread[] testThreadArray2 = testThreadArray;
            boolean bl = false;
            it.start();
            Unit unit = Unit.INSTANCE;
            testThreadArray2[n4] = testThread;
        }
        fixedActiveThreadsExecutor.threads = testThreadArray;
    }

    @NotNull
    public final TestThread[] getThreads() {
        return this.threads;
    }

    public final long submitAndAwait(@NotNull TestThreadExecution[] tasks, long timeoutNano) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
            TestThreadExecution[] $this$all$iv = tasks;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                TestThreadExecution element$iv;
                TestThreadExecution it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                int n2 = this.nThreads;
                int n3 = it.iThread;
                if (0 <= n3 ? n3 < n2 : false) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (!bl) {
            boolean $i$a$-require-FixedActiveThreadsExecutor$submitAndAwait$32 = false;
            String $i$a$-require-FixedActiveThreadsExecutor$submitAndAwait$32 = "Submitted tasks contain thread index outside of current executor bounds.";
            throw new IllegalArgumentException($i$a$-require-FixedActiveThreadsExecutor$submitAndAwait$32.toString());
        }
        TestThreadExecution[] $this$distinctBy$iv = tasks;
        boolean $i$f$distinctBy = false;
        HashSet<Integer> set$iv = new HashSet<Integer>();
        ArrayList<TestThreadExecution> list$iv = new ArrayList<TestThreadExecution>();
        int n = $this$distinctBy$iv.length;
        for (int i = 0; i < n; ++i) {
            TestThreadExecution e$iv;
            TestThreadExecution it = e$iv = $this$distinctBy$iv[i];
            boolean bl3 = false;
            Integer key$iv = it.iThread;
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        if (!(((List)list$iv).size() == tasks.length)) {
            boolean bl4 = false;
            String string = "Submitted tasks have duplicate thread indices.";
            throw new IllegalArgumentException(string.toString());
        }
        this.submitTasks(tasks);
        return this.await(tasks, timeoutNano);
    }

    private final void submitTasks(TestThreadExecution[] tasks) {
        for (TestThreadExecution task : tasks) {
            int i = task.iThread;
            this.submitTask(i, task);
        }
    }

    private final void shutdown() {
        int n = this.nThreads;
        for (int i = 0; i < n; ++i) {
            this.submitTask(i, Shutdown.INSTANCE);
        }
    }

    private final void submitTask(int iThread, Object task) {
        this.results.set(iThread, null);
        Object old = this.tasks.getAndSet(iThread, task);
        if (old instanceof TestThread) {
            LockSupport.unpark((Thread)old);
        }
    }

    private final long await(TestThreadExecution[] tasks, long timeoutNano) {
        long startTime = System.nanoTime();
        long deadline = startTime + timeoutNano;
        Throwable exception = null;
        for (TestThreadExecution task : tasks) {
            Throwable e = this.awaitTask(task.iThread, deadline);
            if (e == null) continue;
            if (exception == null) {
                exception = e;
                continue;
            }
            ExceptionsKt.addSuppressed((Throwable)exception, (Throwable)e);
        }
        Throwable throwable = exception;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new ExecutionException(it);
        }
        return System.nanoTime() - startTime;
    }

    private final Throwable awaitTask(int iThread, long deadline) {
        Object result2 = this.getResult(iThread, deadline);
        return result2 instanceof Throwable ? (Throwable)result2 : null;
    }

    private final Object getResult(int iThread, long deadline) {
        Object result2;
        Object e;
        block8: {
            Spinner $this$spinWaitBoundedFor$iv = this.resultSpinner;
            boolean $i$f$spinWaitBoundedFor = false;
            Spinner spinner = $this$spinWaitBoundedFor$iv;
            Spinner $this$spinWaitBoundedUntil$iv$iv = $this$spinWaitBoundedFor$iv;
            boolean $i$f$spinWaitBoundedUntil = false;
            int counter$iv$iv = 0;
            int exitLimit$iv$iv = $this$spinWaitBoundedUntil$iv$iv.getShouldSpin() ? 1000000 : 0;
            boolean result$iv$iv = true;
            while (true) {
                boolean bl = false;
                boolean bl2 = false;
                Object result$iv = this.results.get(iThread);
                if (result$iv != null) {
                    e = result$iv;
                    break block8;
                }
                if (false) break;
                if (counter$iv$iv == exitLimit$iv$iv) {
                    bl = false;
                    bl2 = false;
                    result$iv = this.results.get(iThread);
                    if (result$iv != null) {
                        e = result$iv;
                        break block8;
                    }
                    result$iv$iv = false;
                    break;
                }
                Thread.onSpinWait();
                ++counter$iv$iv;
            }
            e = null;
        }
        Object e2 = result2 = e;
        if (e2 != null) {
            return e2;
        }
        Thread currentThread = Thread.currentThread();
        if (this.results.compareAndSet(iThread, null, currentThread)) {
            while (this.results.get(iThread) == currentThread) {
                long timeLeft = deadline - System.nanoTime();
                if (timeLeft <= 0L) {
                    this.hangDetected = true;
                    throw new TimeoutException();
                }
                LockSupport.parkNanos(timeLeft);
            }
        }
        Object e3 = this.results.get(iThread);
        Intrinsics.checkNotNull(e3);
        return e3;
    }

    private final Runnable testThreadRunnable(int iThread) {
        return () -> FixedActiveThreadsExecutor.testThreadRunnable$lambda$10(this, iThread);
    }

    private final Object getTask(int iThread) {
        Object task;
        Object e;
        block7: {
            Spinner $this$spinWaitBoundedFor$iv = this.taskSpinners.get(iThread);
            boolean $i$f$spinWaitBoundedFor = false;
            Spinner spinner = $this$spinWaitBoundedFor$iv;
            Spinner $this$spinWaitBoundedUntil$iv$iv = $this$spinWaitBoundedFor$iv;
            boolean $i$f$spinWaitBoundedUntil = false;
            int counter$iv$iv = 0;
            int exitLimit$iv$iv = $this$spinWaitBoundedUntil$iv$iv.getShouldSpin() ? 1000000 : 0;
            boolean result$iv$iv = true;
            while (true) {
                boolean bl = false;
                boolean bl2 = false;
                Object result$iv = this.tasks.get(iThread);
                if (result$iv != null) {
                    e = result$iv;
                    break block7;
                }
                if (false) break;
                if (counter$iv$iv == exitLimit$iv$iv) {
                    bl = false;
                    bl2 = false;
                    result$iv = this.tasks.get(iThread);
                    if (result$iv != null) {
                        e = result$iv;
                        break block7;
                    }
                    result$iv$iv = false;
                    break;
                }
                Thread.onSpinWait();
                ++counter$iv$iv;
            }
            e = null;
        }
        Object e2 = task = e;
        if (e2 != null) {
            return e2;
        }
        Thread currentThread = Thread.currentThread();
        if (this.tasks.compareAndSet(iThread, null, currentThread)) {
            while (this.tasks.get(iThread) == currentThread) {
                LockSupport.park();
            }
        }
        Object e3 = this.tasks.get(iThread);
        Intrinsics.checkNotNull(e3);
        return e3;
    }

    private final void setResult(int iThread, Object any) {
        if (this.results.compareAndSet(iThread, null, any)) {
            return;
        }
        Object e = this.results.get(iThread);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type java.lang.Thread");
        Thread thread = (Thread)e;
        this.results.set(iThread, any);
        LockSupport.unpark(thread);
    }

    @Override
    public void close() {
        this.shutdown();
        if (this.hangDetected) {
            Integer n = FixedActiveThreadsExecutorKt.access$getMajorJavaVersion$p();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"access$getMajorJavaVersion$p(...)");
            if (((Number)n).intValue() < 20) {
                TestThread[] $this$forEach$iv = this.threads;
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv.length;
                for (int i = 0; i < n2; ++i) {
                    TestThread element$iv;
                    TestThread it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    it.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void testThreadRunnable$lambda$10(FixedActiveThreadsExecutor this$0, int $iThread) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (true) {
            boolean bl;
            TestThreadExecution testThreadExecution;
            TestThreadExecution testThreadExecution2;
            Object task;
            boolean bl2;
            Thread currentThread$iv$iv;
            FixedActiveThreadsExecutor $this$runInIgnoredSection$iv = this$0;
            boolean $i$f$runInIgnoredSection = false;
            Intrinsics.checkNotNullExpressionValue((Object)Thread.currentThread(), (String)"currentThread(...)");
            boolean $i$f$runInIgnoredSection2 = false;
            if (currentThread$iv$iv instanceof TestThread && ((TestThread)currentThread$iv$iv).inTestingCode && !((TestThread)currentThread$iv$iv).inIgnoredSection) {
                ((TestThread)currentThread$iv$iv).inIgnoredSection = true;
                try {
                    bl2 = false;
                    task = this$0.getTask($iThread);
                    if (task == Shutdown.INSTANCE) {
                        return;
                    }
                    this$0.tasks.set($iThread, null);
                    Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.lincheck.runner.TestThreadExecution");
                    testThreadExecution2 = (TestThreadExecution)task;
                }
                finally {
                    ((TestThread)currentThread$iv$iv).inIgnoredSection = false;
                }
                testThreadExecution = testThreadExecution2;
            } else {
                bl2 = false;
                task = this$0.getTask($iThread);
                if (task == Shutdown.INSTANCE) {
                    return;
                }
                this$0.tasks.set($iThread, null);
                Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.lincheck.runner.TestThreadExecution");
                testThreadExecution = (TestThreadExecution)task;
            }
            TestThreadExecution task2 = testThreadExecution;
            if (!(task2.iThread == $iThread)) {
                String $i$f$runInIgnoredSection3 = "Check failed.";
                throw new IllegalStateException($i$f$runInIgnoredSection3.toString());
            }
            try {
                task2.run();
            }
            catch (Throwable e) {
                boolean bl3;
                Thread currentThread$iv$iv2;
                FixedActiveThreadsExecutor $this$runInIgnoredSection$iv2 = this$0;
                boolean $i$f$runInIgnoredSection4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)Thread.currentThread(), (String)"currentThread(...)");
                boolean $i$f$runInIgnoredSection5 = false;
                if (currentThread$iv$iv2 instanceof TestThread && ((TestThread)currentThread$iv$iv2).inTestingCode && !((TestThread)currentThread$iv$iv2).inIgnoredSection) {
                    ((TestThread)currentThread$iv$iv2).inIgnoredSection = true;
                    try {
                        bl3 = false;
                        this$0.setResult($iThread, e);
                        testThreadExecution2 = Unit.INSTANCE;
                        continue;
                    }
                    finally {
                        ((TestThread)currentThread$iv$iv2).inIgnoredSection = false;
                        continue;
                    }
                }
                bl3 = false;
                this$0.setResult($iThread, e);
                continue;
            }
            $this$runInIgnoredSection$iv = this$0;
            $i$f$runInIgnoredSection = false;
            Thread thread = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
            currentThread$iv$iv = thread;
            $i$f$runInIgnoredSection2 = false;
            if (currentThread$iv$iv instanceof TestThread && ((TestThread)currentThread$iv$iv).inTestingCode && !((TestThread)currentThread$iv$iv).inIgnoredSection) {
                ((TestThread)currentThread$iv$iv).inIgnoredSection = true;
                try {
                    bl = false;
                    this$0.setResult($iThread, Done.INSTANCE);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    ((TestThread)currentThread$iv$iv).inIgnoredSection = false;
                }
                continue;
            }
            bl = false;
            this$0.setResult($iThread, Done.INSTANCE);
        }
    }
}

