/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.paramgen;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.RandomProvider;
import org.jetbrains.kotlinx.lincheck.paramgen.ExpandingRangeIntGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/lincheck/paramgen/DoubleGen;", "Lorg/jetbrains/kotlinx/lincheck/paramgen/ParameterGenerator;", "", "randomProvider", "Lorg/jetbrains/kotlinx/lincheck/RandomProvider;", "configuration", "", "(Lorg/jetbrains/kotlinx/lincheck/RandomProvider;Ljava/lang/String;)V", "begin", "intGenerator", "Lorg/jetbrains/kotlinx/lincheck/paramgen/ExpandingRangeIntGenerator;", "step", "generate", "()Ljava/lang/Double;", "reset", "", "Companion", "lincheck"})
@SourceDebugExtension(value={"SMAP\nParameterGenerators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParameterGenerators.kt\norg/jetbrains/kotlinx/lincheck/paramgen/DoubleGen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,402:1\n1#2:403\n*E\n"})
public final class DoubleGen
implements ParameterGenerator<Double> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExpandingRangeIntGenerator intGenerator;
    private final double step;
    private final double begin;
    private static final float DEFAULT_STEP = 0.1f;

    public DoubleGen(@NotNull RandomProvider randomProvider, @NotNull String configuration) {
        Intrinsics.checkNotNullParameter((Object)randomProvider, (String)"randomProvider");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        double begin = 0.0;
        double end = 0.0;
        double step = 0.0;
        if (((CharSequence)configuration).length() == 0) {
            begin = -2.147483648E9;
            end = 2.147483647E9;
            step = 0.1f;
        } else {
            String[] stringArray = new String[]{":"};
            List args = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)configuration, (String)"\\s", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            switch (args.size()) {
                case 2: {
                    begin = Double.parseDouble((String)args.get(0));
                    end = Double.parseDouble((String)args.get(1));
                    step = (end - begin) / (double)100;
                    break;
                }
                case 3: {
                    begin = Double.parseDouble((String)args.get(0));
                    step = Double.parseDouble((String)args.get(1));
                    end = Double.parseDouble((String)args.get(2));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Configuration should have two (begin and end) or three (begin, step and end) arguments separated by colon");
                }
            }
        }
        if (!(begin < end)) {
            boolean bl = false;
            String string = "Illegal range for type double: begin must be < end";
            throw new IllegalArgumentException(string.toString());
        }
        double delta = end - begin;
        int maxSteps = (int)(delta / step);
        this.intGenerator = new ExpandingRangeIntGenerator(randomProvider.createRandom(), 0, maxSteps);
        this.step = step;
        this.begin = begin;
    }

    @Override
    @NotNull
    public Double generate() {
        return this.begin + this.step * (double)this.intGenerator.nextInt();
    }

    @Override
    public void reset() {
        this.intGenerator.resetRange();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlinx/lincheck/paramgen/DoubleGen$Companion;", "", "()V", "DEFAULT_STEP", "", "lincheck"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

