/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.CTestConfiguration;
import org.jetbrains.kotlinx.lincheck.CTestConfigurationKt;
import org.jetbrains.kotlinx.lincheck.CTestStructure;
import org.jetbrains.kotlinx.lincheck.IdeaPluginKt;
import org.jetbrains.kotlinx.lincheck.LinChecker;
import org.jetbrains.kotlinx.lincheck.LinCheckerKt;
import org.jetbrains.kotlinx.lincheck.LoggingLevel;
import org.jetbrains.kotlinx.lincheck.Options;
import org.jetbrains.kotlinx.lincheck.RandomProvider;
import org.jetbrains.kotlinx.lincheck.Reporter;
import org.jetbrains.kotlinx.lincheck.ReporterKt;
import org.jetbrains.kotlinx.lincheck.annotations.LogLevel;
import org.jetbrains.kotlinx.lincheck.annotations.Operation;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionGenerator;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenarioKt;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailure;
import org.jetbrains.kotlinx.lincheck.strategy.Strategy;
import org.jetbrains.kotlinx.lincheck.strategy.StrategyKt;
import org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking.ModelCheckingCTestConfiguration;
import org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking.ModelCheckingStrategy;
import org.jetbrains.kotlinx.lincheck.strategy.stress.StressCTestConfiguration;
import org.jetbrains.kotlinx.lincheck.transformation.InstrumentationMode;
import org.jetbrains.kotlinx.lincheck.transformation.LincheckJavaAgent;
import org.jetbrains.kotlinx.lincheck.verifier.Verifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0001+B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\u00142\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J/\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u001e\b\u0002\u0010\u0018\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0019j\u0004\u0018\u0001`\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u000bH\u0002J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010 \u001a\u00020!*\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\n \u000e*\u0004\u0018\u00010%0%*\u00020\u000bH\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010\u0017*\u00020#2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020%H\u0002J\u001c\u0010)\u001a\u00020\u0014*\u00020\u000b2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010(\u001a\u00020%H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlinx/lincheck/LinChecker;", "", "testClass", "Ljava/lang/Class;", "options", "Lorg/jetbrains/kotlinx/lincheck/Options;", "(Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/Options;)V", "reporter", "Lorg/jetbrains/kotlinx/lincheck/Reporter;", "testConfigurations", "", "Lorg/jetbrains/kotlinx/lincheck/CTestConfiguration;", "testStructure", "Lorg/jetbrains/kotlinx/lincheck/CTestStructure;", "kotlin.jvm.PlatformType", "invocationsPerIteration", "", "getInvocationsPerIteration", "(Lorg/jetbrains/kotlinx/lincheck/CTestConfiguration;)I", "check", "", "checkAtLeastOneMethodIsMarkedAsOperation", "checkImpl", "Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;", "cont", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/lincheck/LincheckFailureContinuation;", "checkImpl$lincheck", "createExecutionGenerator", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionGenerator;", "randomProvider", "Lorg/jetbrains/kotlinx/lincheck/RandomProvider;", "createStrategy", "Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "createVerifier", "Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;", "run", "testCfg", "verifier", "runReplayForPlugin", "failure", "Companion", "lincheck"})
@SourceDebugExtension(value={"SMAP\nLinChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinChecker.kt\norg/jetbrains/kotlinx/lincheck/LinChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LincheckJavaAgent.kt\norg/jetbrains/kotlinx/lincheck/transformation/LincheckJavaAgentKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,339:1\n1855#2:340\n1855#2,2:341\n1856#2:343\n1#3:344\n42#4,6:345\n1324#5,3:351\n12474#6,2:354\n*S KotlinDebug\n*F\n+ 1 LinChecker.kt\norg/jetbrains/kotlinx/lincheck/LinChecker\n*L\n38#1:340\n39#1:341,2\n38#1:343\n64#1:345,6\n93#1:351,3\n181#1:354,2\n*E\n"})
public final class LinChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<?> testClass;
    private final CTestStructure testStructure;
    @NotNull
    private final List<CTestConfiguration> testConfigurations;
    @NotNull
    private final Reporter reporter;
    private static final int VERIFIER_REFRESH_CYCLE = 100;

    public LinChecker(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this.testClass = testClass;
        this.testStructure = CTestStructure.getFromTestClass(this.testClass);
        Object object = options;
        if (object == null || (object = object.getLogLevel$lincheck()) == null) {
            LogLevel logLevel = this.testClass.getAnnotation(LogLevel.class);
            object = logLevel != null ? logLevel.value() : ReporterKt.DEFAULT_LOG_LEVEL;
        }
        Object logLevel = object;
        this.reporter = new Reporter((LoggingLevel)((Object)logLevel));
        Options<?, ?> options2 = options;
        this.testConfigurations = options2 != null ? CollectionsKt.listOf(options2.createTestConfigurations(this.testClass)) : CTestConfigurationKt.createFromTestClassAnnotations(this.testClass);
        Iterable $this$forEach$iv = this.testConfigurations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CTestConfiguration cTestConfiguration = (CTestConfiguration)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = cTestConfiguration.getCustomScenarios();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ExecutionScenario it = (ExecutionScenario)element$iv2;
                boolean bl2 = false;
                it.setValidationFunction(this.testStructure.validationFunction);
            }
        }
    }

    public final void check() {
        this.checkImpl$lincheck((Function1<? super LincheckFailure, Unit>)((Function1)check.1.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final synchronized LincheckFailure checkImpl$lincheck(@Nullable Function1<? super LincheckFailure, Unit> cont) {
        if (!(!((Collection)this.testConfigurations).isEmpty())) {
            boolean $i$a$-check-LinChecker$checkImpl$22 = false;
            String $i$a$-check-LinChecker$checkImpl$22 = "No Lincheck test configuration to run";
            throw new IllegalStateException($i$a$-check-LinChecker$checkImpl$22.toString());
        }
        IdeaPluginKt.lincheckVerificationStarted();
        for (CTestConfiguration testCfg : this.testConfigurations) {
            InstrumentationMode instrumentationMode$iv = testCfg.getInstrumentationMode$lincheck();
            boolean $i$f$withLincheckJavaAgent = false;
            LincheckJavaAgent.INSTANCE.install(instrumentationMode$iv);
            try {
                boolean bl = false;
                LincheckFailure failure = this.checkImpl(testCfg);
                if (failure == null) continue;
                if (cont != null) {
                    cont.invoke((Object)failure);
                }
                LincheckFailure lincheckFailure = failure;
                return lincheckFailure;
            }
            finally {
                LincheckJavaAgent.INSTANCE.uninstall();
            }
        }
        if (cont != null) {
            cont.invoke(null);
        }
        return null;
    }

    public static /* synthetic */ LincheckFailure checkImpl$lincheck$default(LinChecker linChecker, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return linChecker.checkImpl$lincheck((Function1<? super LincheckFailure, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final LincheckFailure checkImpl(CTestConfiguration $this$checkImpl) {
        Verifier verifier = null;
        verifier = this.createVerifier($this$checkImpl);
        RandomProvider randomProvider = this.testStructure.randomProvider;
        Intrinsics.checkNotNullExpressionValue((Object)randomProvider, (String)"randomProvider");
        ExecutionGenerator generator = this.createExecutionGenerator($this$checkImpl, randomProvider);
        Sequence randomScenarios2 = SequencesKt.generateSequence((Function0)((Function0)new Function0<ExecutionScenario>(generator, this){
            final /* synthetic */ ExecutionGenerator $generator;
            final /* synthetic */ LinChecker this$0;
            {
                this.$generator = $generator;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ExecutionScenario invoke() {
                ExecutionScenario executionScenario = this.$generator.nextExecution();
                LinChecker linChecker = this.this$0;
                ExecutionScenario it = executionScenario;
                boolean bl = false;
                List<ParameterGenerator<?>> list = LinChecker.access$getTestStructure$p((LinChecker)linChecker).parameterGenerators;
                Intrinsics.checkNotNullExpressionValue(list, (String)"parameterGenerators");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ParameterGenerator it2 = (ParameterGenerator)element$iv;
                    boolean bl2 = false;
                    it2.reset();
                }
                return executionScenario;
            }
        }));
        Sequence scenarios = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)$this$checkImpl.getCustomScenarios()), (Sequence)SequencesKt.take((Sequence)randomScenarios2, (int)$this$checkImpl.getIterations()));
        int scenariosSize = $this$checkImpl.getCustomScenarios().size() + $this$checkImpl.getIterations();
        Sequence $this$forEachIndexed$iv = scenarios;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void scenario;
            boolean isCustomScenario;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ExecutionScenario executionScenario = (ExecutionScenario)item$iv;
            int i = n;
            boolean bl = false;
            boolean bl2 = isCustomScenario = i < $this$checkImpl.getCustomScenarios().size();
            if ((i + 1) % 100 == 0) {
                verifier = this.createVerifier($this$checkImpl);
            }
            ExecutionScenarioKt.validate((ExecutionScenario)scenario);
            this.reporter.logIteration(i + 1, scenariosSize, (ExecutionScenario)scenario);
            Verifier verifier2 = verifier;
            Intrinsics.checkNotNullExpressionValue((Object)verifier2, (String)"element");
            LincheckFailure failure = this.run((ExecutionScenario)scenario, $this$checkImpl, verifier2);
            if (failure == null) continue;
            if ($this$checkImpl.getMinimizeFailedScenario() && !isCustomScenario) {
                this.reporter.logScenarioMinimization((ExecutionScenario)scenario);
                failure = LinCheckerKt.access$minimize(failure, (Function1)new Function1<ExecutionScenario, LincheckFailure>(this, $this$checkImpl){
                    final /* synthetic */ LinChecker this$0;
                    final /* synthetic */ CTestConfiguration $this_checkImpl;
                    {
                        this.this$0 = $receiver;
                        this.$this_checkImpl = $receiver2;
                        super(1);
                    }

                    @Nullable
                    public final LincheckFailure invoke(@NotNull ExecutionScenario minimizedScenario) {
                        Intrinsics.checkNotNullParameter((Object)minimizedScenario, (String)"minimizedScenario");
                        Verifier verifier = LinChecker.access$createVerifier(this.this$0, this.$this_checkImpl);
                        Intrinsics.checkNotNullExpressionValue((Object)verifier, (String)"access$createVerifier(...)");
                        return LinChecker.access$run(this.this$0, minimizedScenario, this.$this_checkImpl, verifier);
                    }
                });
            }
            Reporter.logFailedIteration$default(this.reporter, failure, null, 2, null);
            this.runReplayForPlugin($this$checkImpl, failure, verifier);
            return failure;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runReplayForPlugin(CTestConfiguration $this$runReplayForPlugin, LincheckFailure failure, Verifier verifier) {
        if (IdeaPluginKt.ideaPluginEnabled() && $this$runReplayForPlugin instanceof ModelCheckingCTestConfiguration) {
            this.reporter.logFailedIteration(failure, LoggingLevel.WARN);
            ((ModelCheckingCTestConfiguration)$this$runReplayForPlugin).enableReplayModeForIdeaPlugin$lincheck();
            Strategy strategy = this.createStrategy($this$runReplayForPlugin, failure.getScenario());
            if (!(strategy instanceof ModelCheckingStrategy)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Closeable closeable = strategy;
            Throwable throwable = null;
            try {
                ModelCheckingStrategy it = (ModelCheckingStrategy)closeable;
                boolean bl = false;
                LincheckFailure replayedFailure = StrategyKt.runIteration(it, ((ModelCheckingCTestConfiguration)$this$runReplayForPlugin).getInvocationsPerIteration(), verifier);
                if (!(replayedFailure != null)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                ((ModelCheckingStrategy)strategy).runReplayIfPluginEnabled$lincheck(replayedFailure);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            Reporter.logFailedIteration$default(this.reporter, failure, null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LincheckFailure run(ExecutionScenario $this$run, CTestConfiguration testCfg, Verifier verifier) {
        LincheckFailure lincheckFailure;
        Strategy strategy = this.createStrategy(testCfg, $this$run);
        Closeable closeable = strategy;
        Throwable throwable = null;
        try {
            Strategy it = (Strategy)closeable;
            boolean bl = false;
            lincheckFailure = StrategyKt.runIteration(it, this.getInvocationsPerIteration(testCfg), verifier);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return lincheckFailure;
    }

    private final Strategy createStrategy(CTestConfiguration $this$createStrategy, ExecutionScenario scenario) {
        return $this$createStrategy.createStrategy($this$createStrategy.getTestClass(), scenario, this.testStructure.validationFunction, this.testStructure.stateRepresentation);
    }

    private final Verifier createVerifier(CTestConfiguration $this$createVerifier) {
        Object[] objectArray = new Class[]{Class.class};
        Constructor<? extends Verifier> constructor = $this$createVerifier.getVerifierClass().getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{$this$createVerifier.getSequentialSpecification()};
        return constructor.newInstance(objectArray);
    }

    private final ExecutionGenerator createExecutionGenerator(CTestConfiguration $this$createExecutionGenerator, RandomProvider randomProvider) {
        if ($this$createExecutionGenerator.getIterations() > 0) {
            this.checkAtLeastOneMethodIsMarkedAsOperation($this$createExecutionGenerator.getTestClass());
        }
        Class[] classArray = new Class[]{CTestConfiguration.class, CTestStructure.class, RandomProvider.class};
        Constructor<? extends ExecutionGenerator> constructor = $this$createExecutionGenerator.getGeneratorClass().getConstructor(classArray);
        Object[] objectArray = new Object[]{$this$createExecutionGenerator, this.testStructure, randomProvider};
        ExecutionGenerator executionGenerator = constructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)executionGenerator, (String)"newInstance(...)");
        return executionGenerator;
    }

    private final int getInvocationsPerIteration(CTestConfiguration $this$invocationsPerIteration) {
        int n;
        CTestConfiguration cTestConfiguration = $this$invocationsPerIteration;
        if (cTestConfiguration instanceof ModelCheckingCTestConfiguration) {
            n = ((ModelCheckingCTestConfiguration)$this$invocationsPerIteration).getInvocationsPerIteration();
        } else if (cTestConfiguration instanceof StressCTestConfiguration) {
            n = ((StressCTestConfiguration)$this$invocationsPerIteration).getInvocationsPerIteration();
        } else {
            throw new IllegalStateException("unexpected".toString());
        }
        return n;
    }

    private final void checkAtLeastOneMethodIsMarkedAsOperation(Class<?> testClass) {
        boolean bl;
        block2: {
            Method[] methodArray = testClass.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
            Object[] $this$any$iv = methodArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Method it = (Method)element$iv;
                boolean bl2 = false;
                if (!it.isAnnotationPresent(Operation.class)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "You must specify at least one operation to test. Please refer to the user guide: https://kotlinlang.org/docs/introduction.html";
            throw new IllegalStateException(string.toString());
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final void check(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
        Companion.check(testClass, options);
    }

    @JvmStatic
    @JvmOverloads
    public static final void check(@NotNull Class<?> testClass) {
        Companion.check(testClass);
    }

    public static final /* synthetic */ CTestStructure access$getTestStructure$p(LinChecker $this) {
        return $this.testStructure;
    }

    public static final /* synthetic */ LincheckFailure access$run(LinChecker $this, ExecutionScenario $receiver, CTestConfiguration testCfg, Verifier verifier) {
        return $this.run($receiver, testCfg, verifier);
    }

    public static final /* synthetic */ Verifier access$createVerifier(LinChecker $this, CTestConfiguration $receiver) {
        return $this.createVerifier($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0012\b\u0002\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/LinChecker$Companion;", "", "()V", "VERIFIER_REFRESH_CYCLE", "", "check", "", "testClass", "Ljava/lang/Class;", "options", "Lorg/jetbrains/kotlinx/lincheck/Options;", "lincheck"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void check(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
            Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
            new LinChecker(testClass, options).check();
        }

        public static /* synthetic */ void check$default(Companion companion, Class clazz, Options options, int n, Object object) {
            if ((n & 2) != 0) {
                options = null;
            }
            companion.check(clazz, options);
        }

        @JvmStatic
        @JvmOverloads
        public final void check(@NotNull Class<?> testClass) {
            Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
            org.jetbrains.kotlinx.lincheck.LinChecker$Companion.check$default(this, testClass, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

