/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.ObjectTraverserKt;
import org.jetbrains.kotlinx.lincheck.runner.ParallelThreadsRunner;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyRunner;
import org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking.ModelCheckingStrategy;
import sun.nio.ch.lincheck.EventTracker;
import sun.nio.ch.lincheck.TestThread;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0013\u001a!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u0006\u0010\u0016\u001a\u00020\u0007\u001a\u0006\u0010\u0017\u001a\u00020\u0007\u001a\u0006\u0010\u0018\u001a\u00020\u0003\u001aA\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\u0010\u001f\u001a\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070!2\u0006\u0010\"\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010#\u001a=\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010)\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006*"}, d2={"MINIMAL_PLUGIN_VERSION", "", "eventIdStrictOrderingCheck", "", "getEventIdStrictOrderingCheck", "()Z", "beforeEvent", "", "eventId", "", "type", "createContinuationToThreadIdMap", "", "", "threads", "Lsun/nio/ch/lincheck/TestThread;", "([Lsun/nio/ch/lincheck/TestThread;)[Ljava/lang/Object;", "createObjectToNumberMapAsArray", "testObject", "(Ljava/lang/Object;)[Ljava/lang/Object;", "createThreadToLincheckThreadIdMap", "ideaPluginEnabled", "lincheckVerificationStarted", "onThreadSwitchesOrActorFinishes", "shouldReplayInterleaving", "testFailed", "failureType", "trace", "version", "minimalPluginVersion", "exceptions", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visualize", "Lkotlin/Result;", "strategyObject", "(Ljava/lang/Object;)Ljava/lang/Object;", "visualizeInstance", "testInstance", "numbersArrayMap", "threadsArrayMap", "threadToLincheckThreadIdMap", "(Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)V", "lincheck"})
@JvmName(name="IdeaPluginKt")
@SourceDebugExtension(value={"SMAP\nIdeaPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaPlugin.kt\norg/jetbrains/kotlinx/lincheck/IdeaPluginKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,187:1\n215#2,2:188\n37#3,2:190\n37#3,2:192\n37#3,2:194\n*S KotlinDebug\n*F\n+ 1 IdeaPlugin.kt\norg/jetbrains/kotlinx/lincheck/IdeaPluginKt\n*L\n148#1:188,2\n152#1:190,2\n169#1:192,2\n186#1:194,2\n*E\n"})
public final class IdeaPluginKt {
    @NotNull
    public static final String MINIMAL_PLUGIN_VERSION = "0.2";
    private static final boolean eventIdStrictOrderingCheck = System.getProperty("lincheck.debug.withEventIdSequentialCheck") != null;

    public static final void testFailed(@NotNull String failureType, @NotNull String[] trace, @Nullable String version, @NotNull String minimalPluginVersion, @NotNull String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)failureType, (String)"failureType");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)minimalPluginVersion, (String)"minimalPluginVersion");
        Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
    }

    public static final boolean ideaPluginEnabled() {
        return eventIdStrictOrderingCheck;
    }

    public static final void lincheckVerificationStarted() {
    }

    public static final boolean shouldReplayInterleaving() {
        return false;
    }

    public static final void beforeEvent(int eventId, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Thread thread = Thread.currentThread();
        TestThread testThread = thread instanceof TestThread ? (TestThread)thread : null;
        Object object = testThread != null ? testThread.eventTracker : null;
        if (object == null) {
            return;
        }
        EventTracker strategy = object;
        IdeaPluginKt.visualize(strategy);
    }

    public static final void visualizeInstance(@NotNull Object testInstance, @NotNull Object[] numbersArrayMap, @NotNull Object[] threadsArrayMap, @NotNull Object[] threadToLincheckThreadIdMap) {
        Intrinsics.checkNotNullParameter((Object)testInstance, (String)"testInstance");
        Intrinsics.checkNotNullParameter((Object)numbersArrayMap, (String)"numbersArrayMap");
        Intrinsics.checkNotNullParameter((Object)threadsArrayMap, (String)"threadsArrayMap");
        Intrinsics.checkNotNullParameter((Object)threadToLincheckThreadIdMap, (String)"threadToLincheckThreadIdMap");
    }

    public static final void onThreadSwitchesOrActorFinishes() {
    }

    public static final boolean getEventIdStrictOrderingCheck() {
        return eventIdStrictOrderingCheck;
    }

    private static final Object visualize(Object strategyObject) {
        Object object;
        try {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)strategyObject, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.lincheck.strategy.managed.modelchecking.ModelCheckingStrategy");
            ModelCheckingStrategy strategy = (ModelCheckingStrategy)strategyObject;
            ManagedStrategyRunner managedStrategyRunner = strategy.getRunner$lincheck();
            Intrinsics.checkNotNull((Object)managedStrategyRunner, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.lincheck.runner.ParallelThreadsRunner");
            ParallelThreadsRunner runner = managedStrategyRunner;
            Object testObject = runner.getTestInstance$lincheck();
            TestThread[] threads = runner.getExecutor$lincheck().getThreads();
            Object[] objectToNumberMap = IdeaPluginKt.createObjectToNumberMapAsArray(testObject);
            Object[] continuationToLincheckThreadIdMap = IdeaPluginKt.createContinuationToThreadIdMap(threads);
            Object[] threadToLincheckThreadIdMap = IdeaPluginKt.createThreadToLincheckThreadIdMap(threads);
            IdeaPluginKt.visualizeInstance(testObject, objectToNumberMap, continuationToLincheckThreadIdMap, threadToLincheckThreadIdMap);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    private static final Object[] createObjectToNumberMapAsArray(Object testObject) {
        Map<Object, Integer> numbersMap;
        ArrayList<Object> resultArray = new ArrayList<Object>();
        Map<Object, Integer> $this$forEach$iv = numbersMap = ObjectTraverserKt.enumerateObjects(testObject);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Object, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Integer> element$iv;
            Map.Entry<Object, Integer> entry = element$iv = iterator.next();
            boolean bl = false;
            Object any = entry.getKey();
            int objectNumber = ((Number)entry.getValue()).intValue();
            resultArray.add(any);
            resultArray.add(objectNumber);
        }
        Collection $this$toTypedArray$iv = resultArray;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    private static final Object[] createThreadToLincheckThreadIdMap(TestThread[] threads) {
        ArrayList<Object> array = new ArrayList<Object>();
        for (TestThread thread : threads) {
            array.add(thread);
            array.add(thread.threadId);
        }
        Collection $this$toTypedArray$iv = array;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    private static final Object[] createContinuationToThreadIdMap(TestThread[] threads) {
        ArrayList<Object> array = new ArrayList<Object>();
        for (TestThread thread : threads) {
            Object object = thread.suspendedContinuation;
            if (object == null) continue;
            array.add(object);
            array.add(thread.threadId);
        }
        Collection $this$toTypedArray$iv = array;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }
}

