/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.runner.CompletedInvocationResult;
import org.jetbrains.kotlinx.lincheck.runner.DeadlockInvocationResult;
import org.jetbrains.kotlinx.lincheck.runner.FixedActiveThreadsExecutor;
import org.jetbrains.kotlinx.lincheck.runner.InvocationResult;
import org.jetbrains.kotlinx.lincheck.runner.ObstructionFreedomViolationInvocationResult;
import org.jetbrains.kotlinx.lincheck.runner.Runner;
import org.jetbrains.kotlinx.lincheck.runner.UnexpectedExceptionInvocationResult;
import org.jetbrains.kotlinx.lincheck.runner.UseClocks;
import org.jetbrains.kotlinx.lincheck.runner.ValidationFailureInvocationResult;
import org.jetbrains.kotlinx.lincheck.strategy.IncorrectResultsFailure;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailure;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailureKt;
import org.jetbrains.kotlinx.lincheck.strategy.Strategy;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CallStackTraceElement;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CodeLocationIdProvider;
import org.jetbrains.kotlinx.lincheck.strategy.managed.CoroutineCancellationTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.FinishThreadTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ForcibleExecutionFinishException;
import org.jetbrains.kotlinx.lincheck.strategy.managed.LoopDetector;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedCTestConfiguration;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategy;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyRunner;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyStateHolder;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ManagedStrategyTransformer;
import org.jetbrains.kotlinx.lincheck.strategy.managed.MethodCallTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.MonitorEnterTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.MonitorExitTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.MonitorTracker;
import org.jetbrains.kotlinx.lincheck.strategy.managed.NotifyTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ParkTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.ReadTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.StateRepresentationTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.SwitchEventTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.SwitchReason;
import org.jetbrains.kotlinx.lincheck.strategy.managed.Trace;
import org.jetbrains.kotlinx.lincheck.strategy.managed.TracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.UnparkTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.WaitTracePoint;
import org.jetbrains.kotlinx.lincheck.strategy.managed.WriteTracePoint;
import org.jetbrains.kotlinx.lincheck.verifier.Verifier;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u00ae\u0001BA\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010I\u001a\u00020J2\u0006\u0010D\u001a\u00020%J\u0015\u0010K\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0000\u00a2\u0006\u0002\bLJ\u0015\u0010M\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0000\u00a2\u0006\u0002\bNJ\u0015\u0010O\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0000\u00a2\u0006\u0002\bPJ\u001d\u0010Q\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\u0006\u0010R\u001a\u00020SH\u0000\u00a2\u0006\u0002\bTJ/\u0010U\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020YH\u0000\u00a2\u0006\u0002\bZJ\u0010\u0010[\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0002J\u001d\u0010\\\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%H\u0000\u00a2\u0006\u0002\b]J/\u0010^\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010_2\u0006\u0010`\u001a\u00020YH\u0000\u00a2\u0006\u0002\baJ/\u0010b\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010c2\u0006\u0010`\u001a\u00020YH\u0000\u00a2\u0006\u0002\bdJ%\u0010e\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\u0006\u0010R\u001a\u00020SH\u0000\u00a2\u0006\u0002\bfJ7\u0010g\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010h2\u0006\u0010`\u001a\u00020Y2\u0006\u0010i\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\bjJ/\u0010k\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010l2\u0006\u0010m\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\bnJ'\u0010o\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010pH\u0000\u00a2\u0006\u0002\bqJ'\u0010r\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010sH\u0000\u00a2\u0006\u0002\btJ7\u0010u\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010v2\u0006\u0010`\u001a\u00020Y2\u0006\u0010m\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\bwJ\u0010\u0010x\u001a\u00020J2\u0006\u0010y\u001a\u00020%H\u0002J\u0012\u0010z\u001a\u0004\u0018\u00010{2\u0006\u0010|\u001a\u000208H\u0004J\u0010\u0010}\u001a\u00020%2\u0006\u0010D\u001a\u00020%H$J\b\u0010~\u001a\u00020JH\u0016J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u007f2\u0007\u0010\u0080\u0001\u001a\u000208H\u0002J\u0012\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001H\u0000\u00a2\u0006\u0003\b\u0083\u0001J\t\u0010\u0084\u0001\u001a\u000206H\u0002J\u0010\u0010\u0085\u0001\u001a\u00020G2\u0007\u0010\u0086\u0001\u001a\u00020%J\u0014\u0010\u0087\u0001\u001a\u00030\u0088\u00012\b\u0010\u0089\u0001\u001a\u00030\u0088\u0001H\u0016J\u0007\u0010\u008a\u0001\u001a\u00020%Je\u0010\u008b\u0001\u001a\u0003H\u008c\u0001\"\t\b\u0000\u0010\u008c\u0001*\u00020G2H\u0010\u008d\u0001\u001aC\u0012\u0013\u0012\u00110%\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0013\u0012\u00110%\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(E\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00130\nj\u0002`F\u0012\u0005\u0012\u0003H\u008c\u00010AH\u0002\u00a2\u0006\u0003\u0010\u008e\u0001J\u001c\u0010\u008f\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\t\b\u0002\u0010\u0090\u0001\u001a\u00020\u0018H\u0002J\u0017\u0010\u0091\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u0092\u0001J\u001a\u0010\u0093\u0001\u001a\u00020J2\u000f\u0010\u0094\u0001\u001a\n\u0012\u0005\u0012\u00030\u0096\u00010\u0095\u0001H\u0002J\u0011\u0010\u0097\u0001\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%H\u0002J\t\u0010\u0098\u0001\u001a\u00020JH\u0014J\u0011\u0010\u0099\u0001\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%H\u0002J\u0011\u0010\u009a\u0001\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%H\u0002J\u0017\u0010\u009b\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0000\u00a2\u0006\u0003\b\u009c\u0001J\t\u0010\u009d\u0001\u001a\u00020\u0018H\u0016J#\u0010\u009e\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\u0006\u0010V\u001a\u00020%2\b\u0010R\u001a\u0004\u0018\u00010GH\u0002J\u0011\u0010\u009f\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0016J\u001b\u0010\u00a0\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001H\u0016J\u0011\u0010\u00a3\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0016J\u001a\u0010\u00a4\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\u0007\u0010\u0090\u0001\u001a\u00020\u0018H\u0014J\u0011\u0010\u00a5\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%H\u0016J\u000b\u0010\u00a6\u0001\u001a\u0004\u0018\u00010{H\u0016J\u000b\u0010\u00a7\u0001\u001a\u0004\u0018\u00010{H$J\t\u0010\u00a8\u0001\u001a\u000208H\u0004J\u0011\u0010\u00a9\u0001\u001a\u00020\u00182\u0006\u0010D\u001a\u00020%H$J(\u0010\u00aa\u0001\u001a\u00020J2\u0006\u0010D\u001a\u00020%2\n\b\u0002\u0010\u00ab\u0001\u001a\u00030\u00ac\u00012\t\b\u0002\u0010\u0090\u0001\u001a\u00020\u0018H\u0002J\u0017\u0010\u00ad\u0001\u001a\b\u0012\u0004\u0012\u00020%0\n2\u0006\u0010D\u001a\u00020%H\u0004R\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001aR\u0014\u0010 \u001a\u00020!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\u00020%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010'R\u000e\u00105\u001a\u000206X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00107\u001a\u0004\u0018\u000108X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001c\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\b\u0018\u00010?R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000RX\u0010@\u001aL\u0012H\u0012F\u0012\u0013\u0012\u00110%\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(D\u0012\u0013\u0012\u00110%\u00a2\u0006\f\bB\u0012\b\bC\u0012\u0004\b\b(E\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00130\nj\u0002`F\u0012\u0004\u0012\u00020G0Aj\u0002`H0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00af\u0001"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy;", "Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "Ljava/io/Closeable;", "testClass", "Ljava/lang/Class;", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "verifier", "Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;", "validationFunctions", "", "Ljava/lang/reflect/Method;", "stateRepresentationFunction", "testCfg", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedCTestConfiguration;", "(Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;Ljava/util/List;Ljava/lang/reflect/Method;Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedCTestConfiguration;)V", "callStackTrace", "", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTraceElement;", "[Ljava/util/List;", "codeLocationIdProvider", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CodeLocationIdProvider;", "collectStateRepresentation", "", "getCollectStateRepresentation", "()Z", "collectTrace", "concurrentActorCausesBlocking", "getConcurrentActorCausesBlocking", "curActorIsBlocking", "getCurActorIsBlocking", "currentActorId", "", "getCurrentActorId", "()[I", "currentThread", "", "getCurrentThread", "()I", "setCurrentThread", "(I)V", "finished", "", "ignoredSectionDepth", "isSuspended", "loopDetector", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector;", "methodCallNumber", "monitorTracker", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorTracker;", "nThreads", "getNThreads", "runner", "Lorg/jetbrains/kotlinx/lincheck/runner/Runner;", "suddenInvocationResult", "Lorg/jetbrains/kotlinx/lincheck/runner/InvocationResult;", "getSuddenInvocationResult", "()Lorg/jetbrains/kotlinx/lincheck/runner/InvocationResult;", "setSuddenInvocationResult", "(Lorg/jetbrains/kotlinx/lincheck/runner/InvocationResult;)V", "suspendedFunctionsStack", "traceCollector", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy$TraceCollector;", "tracePointConstructors", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "iThread", "actorId", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CallStackTrace;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePoint;", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePointConstructor;", "addStateRepresentation", "", "afterCoroutineCancelled", "afterCoroutineCancelled$lincheck", "afterCoroutineResumed", "afterCoroutineResumed$lincheck", "afterCoroutineSuspended", "afterCoroutineSuspended$lincheck", "afterMethodCall", "tracePoint", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MethodCallTracePoint;", "afterMethodCall$lincheck", "afterUnpark", "codeLocation", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/UnparkTracePoint;", "thread", "", "afterUnpark$lincheck", "awaitTurn", "beforeAtomicMethodCall", "beforeAtomicMethodCall$lincheck", "beforeLockAcquire", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorEnterTracePoint;", "monitor", "beforeLockAcquire$lincheck", "beforeLockRelease", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/MonitorExitTracePoint;", "beforeLockRelease$lincheck", "beforeMethodCall", "beforeMethodCall$lincheck", "beforeNotify", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/NotifyTracePoint;", "notifyAll", "beforeNotify$lincheck", "beforePark", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ParkTracePoint;", "withTimeout", "beforePark$lincheck", "beforeSharedVariableRead", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ReadTracePoint;", "beforeSharedVariableRead$lincheck", "beforeSharedVariableWrite", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/WriteTracePoint;", "beforeSharedVariableWrite$lincheck", "beforeWait", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/WaitTracePoint;", "beforeWait$lincheck", "checkLiveLockHappened", "interleavingEventsCount", "checkResult", "Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;", "result", "chooseThread", "close", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/Trace;", "failingResult", "createAndLogCancellationTracePoint", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/CoroutineCancellationTracePoint;", "createAndLogCancellationTracePoint$lincheck", "createRunner", "createTracePoint", "constructorId", "createTransformer", "Lorg/objectweb/asm/ClassVisitor;", "cv", "currentThreadNumber", "doCreateTracePoint", "T", "constructor", "(Lkotlin/jvm/functions/Function3;)Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePoint;", "doSwitchCurrentThread", "mustSwitch", "enterIgnoredSection", "enterIgnoredSection$lincheck", "failIfObstructionFreedomIsRequired", "lazyMessage", "Lkotlin/Function0;", "", "inIgnoredSection", "initializeInvocation", "isActive", "isTestThread", "leaveIgnoredSection", "leaveIgnoredSection$lincheck", "needsTransformation", "newSwitchPoint", "onActorStart", "onFailure", "exception", "", "onFinish", "onNewSwitch", "onStart", "run", "runImpl", "runInvocation", "shouldSwitch", "switchCurrentThread", "reason", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/SwitchReason;", "switchableThreads", "TraceCollector", "lincheck"})
public abstract class ManagedStrategy
extends Strategy
implements Closeable {
    @NotNull
    private final Class<?> testClass;
    @NotNull
    private final Verifier verifier;
    @NotNull
    private final List<Method> validationFunctions;
    @Nullable
    private final Method stateRepresentationFunction;
    @NotNull
    private final ManagedCTestConfiguration testCfg;
    private final int nThreads;
    @NotNull
    private Runner runner;
    @NotNull
    private final CodeLocationIdProvider codeLocationIdProvider;
    private volatile int currentThread;
    @NotNull
    private final boolean[] finished;
    @NotNull
    private final boolean[] isSuspended;
    @NotNull
    private final int[] currentActorId;
    @NotNull
    private final int[] ignoredSectionDepth;
    private LoopDetector loopDetector;
    private MonitorTracker monitorTracker;
    @Nullable
    private volatile InvocationResult suddenInvocationResult;
    private boolean collectTrace;
    @NotNull
    private final List<Function3<Integer, Integer, List<CallStackTraceElement>, TracePoint>> tracePointConstructors;
    @Nullable
    private TraceCollector traceCollector;
    @NotNull
    private final List<CallStackTraceElement>[] callStackTrace;
    private int methodCallNumber;
    @NotNull
    private final List<Integer>[] suspendedFunctionsStack;

    public ManagedStrategy(@NotNull Class<?> testClass, @NotNull ExecutionScenario scenario, @NotNull Verifier verifier, @NotNull List<Method> validationFunctions, @Nullable Method stateRepresentationFunction, @NotNull ManagedCTestConfiguration testCfg) {
        int n;
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        Intrinsics.checkNotNullParameter(validationFunctions, (String)"validationFunctions");
        Intrinsics.checkNotNullParameter((Object)testCfg, (String)"testCfg");
        super(scenario);
        this.testClass = testClass;
        this.verifier = verifier;
        this.validationFunctions = validationFunctions;
        this.stateRepresentationFunction = stateRepresentationFunction;
        this.testCfg = testCfg;
        this.nThreads = scenario.parallelExecution.size();
        this.codeLocationIdProvider = new CodeLocationIdProvider();
        int n2 = 0;
        int n3 = this.nThreads;
        Object[] objectArray = new boolean[n3];
        ManagedStrategy managedStrategy = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = false;
        }
        managedStrategy.finished = objectArray;
        n2 = 0;
        n3 = this.nThreads;
        objectArray = new boolean[n3];
        managedStrategy = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = false;
        }
        managedStrategy.isSuspended = objectArray;
        this.currentActorId = new int[this.nThreads];
        n2 = 0;
        n3 = this.nThreads;
        objectArray = new int[n3];
        managedStrategy = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = false;
        }
        managedStrategy.ignoredSectionDepth = (int[])objectArray;
        this.tracePointConstructors = new ArrayList();
        n2 = 0;
        n3 = this.nThreads;
        objectArray = new List[n3];
        managedStrategy = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = new ArrayList();
        }
        managedStrategy.callStackTrace = (List<CallStackTraceElement>[])objectArray;
        n2 = 0;
        n3 = this.nThreads;
        objectArray = new List[n3];
        managedStrategy = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = new ArrayList();
        }
        managedStrategy.suspendedFunctionsStack = (List<Integer>[])objectArray;
        this.runner = this.createRunner();
        try {
            ManagedStrategyStateHolder.INSTANCE.setState(this.runner.getClassLoader(), this, this.testClass);
            this.runner.initialize();
        }
        catch (Throwable t) {
            this.runner.close();
            throw t;
        }
    }

    protected final int getNThreads() {
        return this.nThreads;
    }

    protected final int getCurrentThread() {
        return this.currentThread;
    }

    protected final void setCurrentThread(int n) {
        this.currentThread = n;
    }

    @NotNull
    protected final int[] getCurrentActorId() {
        return this.currentActorId;
    }

    @Nullable
    protected final InvocationResult getSuddenInvocationResult() {
        return this.suddenInvocationResult;
    }

    protected final void setSuddenInvocationResult(@Nullable InvocationResult invocationResult) {
        this.suddenInvocationResult = invocationResult;
    }

    private final boolean getCollectStateRepresentation() {
        return this.collectTrace && this.stateRepresentationFunction != null;
    }

    private final Runner createRunner() {
        return new ManagedStrategyRunner(this, this.testClass, this.validationFunctions, this.stateRepresentationFunction, this.testCfg.getTimeoutMs(), UseClocks.ALWAYS);
    }

    @Override
    @NotNull
    public ClassVisitor createTransformer(@NotNull ClassVisitor cv) {
        Intrinsics.checkNotNullParameter((Object)cv, (String)"cv");
        return new ManagedStrategyTransformer(cv, this.tracePointConstructors, this.testCfg.getGuarantees(), this.testCfg.getEliminateLocalObjects(), this.getCollectStateRepresentation(), this.collectTrace, this.codeLocationIdProvider);
    }

    @Override
    public boolean needsTransformation() {
        return true;
    }

    @Override
    @Nullable
    public LincheckFailure run() {
        LincheckFailure lincheckFailure;
        LincheckFailure it = lincheckFailure = this.runImpl();
        boolean bl = false;
        this.close();
        return lincheckFailure;
    }

    @Nullable
    protected abstract LincheckFailure runImpl();

    protected void onNewSwitch(int iThread, boolean mustSwitch) {
    }

    protected abstract boolean shouldSwitch(int var1);

    protected abstract int chooseThread(int var1);

    protected void initializeInvocation() {
        List<CallStackTraceElement> it;
        List<Object> element$iv;
        int n;
        ArraysKt.fill$default((boolean[])this.finished, (boolean)false, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((boolean[])this.isSuspended, (boolean)false, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((int[])this.currentActorId, (int)-1, (int)0, (int)0, (int)6, null);
        this.loopDetector = new LoopDetector(this.testCfg.getHangingDetectionThreshold());
        this.monitorTracker = new MonitorTracker(this.nThreads);
        this.traceCollector = this.collectTrace ? new TraceCollector() : null;
        this.suddenInvocationResult = null;
        ArraysKt.fill$default((int[])this.ignoredSectionDepth, (int)0, (int)0, (int)0, (int)6, null);
        List<Object>[] $this$forEach$iv = this.callStackTrace;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.clear();
        }
        $this$forEach$iv = this.suspendedFunctionsStack;
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.clear();
        }
        ManagedStrategyStateHolder.INSTANCE.setState(this.runner.getClassLoader(), this, this.testClass);
    }

    @Nullable
    protected final LincheckFailure checkResult(@NotNull InvocationResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        return result2 instanceof CompletedInvocationResult ? (LincheckFailure)(this.verifier.verifyResults(this.getScenario(), ((CompletedInvocationResult)result2).getResults()) ? null : new IncorrectResultsFailure(this.getScenario(), ((CompletedInvocationResult)result2).getResults(), this.collectTrace(result2))) : LincheckFailureKt.toLincheckFailure(result2, this.getScenario(), this.collectTrace(result2));
    }

    private final Trace collectTrace(InvocationResult failingResult) {
        boolean canCollectTrace;
        boolean detectedByStrategy = this.suddenInvocationResult != null;
        boolean bl = detectedByStrategy ? true : (failingResult instanceof CompletedInvocationResult ? true : (canCollectTrace = failingResult instanceof ValidationFailureInvocationResult));
        if (!canCollectTrace) {
            return null;
        }
        this.collectTrace = true;
        this.runner.close();
        this.runner = this.createRunner();
        ManagedStrategyStateHolder.INSTANCE.setState(this.runner.getClassLoader(), this, this.testClass);
        this.runner.initialize();
        InvocationResult loggedResults = this.runInvocation();
        boolean sameResultTypes = Intrinsics.areEqual(loggedResults.getClass(), failingResult.getClass());
        boolean sameResults = !(loggedResults instanceof CompletedInvocationResult) || !(failingResult instanceof CompletedInvocationResult) || Intrinsics.areEqual((Object)((CompletedInvocationResult)loggedResults).getResults(), (Object)((CompletedInvocationResult)failingResult).getResults());
        if (!(sameResultTypes && sameResults)) {
            StringBuilder stringBuilder;
            boolean bl2 = false;
            StringBuilder $this$collectTrace_u24lambda_u2d4_u24lambda_u2d3 = stringBuilder = new StringBuilder();
            boolean bl3 = false;
            StringBuilder stringBuilder2 = $this$collectTrace_u24lambda_u2d4_u24lambda_u2d3.append("Non-determinism found. Probably caused by non-deterministic code (WeakHashMap, Object.hashCode, etc).");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            StringBuilder stringBuilder3 = $this$collectTrace_u24lambda_u2d4_u24lambda_u2d3.append("== Reporting the first execution without execution trace ==");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            StringBuilder stringBuilder4 = $this$collectTrace_u24lambda_u2d4_u24lambda_u2d3.append(LincheckFailureKt.toLincheckFailure(failingResult, this.getScenario(), null));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            StringBuilder stringBuilder5 = $this$collectTrace_u24lambda_u2d4_u24lambda_u2d3.append("== Reporting the second execution ==");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            ExecutionScenario executionScenario = this.getScenario();
            TraceCollector traceCollector = this.traceCollector;
            Intrinsics.checkNotNull((Object)traceCollector);
            StringBuilder stringBuilder6 = $this$collectTrace_u24lambda_u2d4_u24lambda_u2d3.append(LincheckFailureKt.toLincheckFailure(loggedResults, executionScenario, new Trace(traceCollector.getTrace())).toString());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026\n            }.toString()");
            String string2 = string;
            throw new IllegalStateException(string2.toString());
        }
        TraceCollector traceCollector = this.traceCollector;
        Intrinsics.checkNotNull((Object)traceCollector);
        return new Trace(traceCollector.getTrace());
    }

    @NotNull
    protected final InvocationResult runInvocation() {
        this.initializeInvocation();
        InvocationResult result2 = this.runner.run();
        InvocationResult invocationResult = this.suddenInvocationResult;
        if (invocationResult != null) {
            InvocationResult it = invocationResult;
            boolean bl = false;
            return it;
        }
        return result2;
    }

    private final void failIfObstructionFreedomIsRequired(Function0<String> lazyMessage) {
        if (this.testCfg.getCheckObstructionFreedom() && !this.getCurActorIsBlocking() && !this.getConcurrentActorCausesBlocking()) {
            this.suddenInvocationResult = new ObstructionFreedomViolationInvocationResult((String)lazyMessage.invoke());
            throw ForcibleExecutionFinishException.INSTANCE;
        }
    }

    private final boolean getCurActorIsBlocking() {
        return this.getScenario().parallelExecution.get(this.currentThread).get(this.currentActorId[this.currentThread]).getBlocking();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean getConcurrentActorCausesBlocking() {
        boolean bl;
        block4: {
            void $this$mapIndexedTo$iv$iv;
            int[] $this$mapIndexed$iv = this.currentActorId;
            boolean $i$f$mapIndexed = false;
            Object object = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void actorId;
                void iThread;
                int n = index$iv$iv++;
                void var10_11 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(iThread != this.currentThread && !this.finished[iThread] ? this.getScenario().parallelExecution.get((int)iThread).get((int)actorId) : null);
            }
            Iterable $this$any$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    Actor it = (Actor)element$iv;
                    boolean bl3 = false;
                    if (!it.getCausesBlocking()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void checkLiveLockHappened(int interleavingEventsCount) {
        if (interleavingEventsCount > 10001) {
            this.suddenInvocationResult = new DeadlockInvocationResult(UtilsKt.collectThreadDump(this.runner));
            throw ForcibleExecutionFinishException.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.runner.close();
    }

    private final void newSwitchPoint(int iThread, int codeLocation, TracePoint tracePoint) {
        block7: {
            boolean shouldSwitch;
            if (!this.isTestThread(iThread)) {
                return;
            }
            if (this.inIgnoredSection(iThread)) {
                return;
            }
            if (!(iThread == this.currentThread)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            boolean isLoop = false;
            LoopDetector loopDetector = this.loopDetector;
            if (loopDetector == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loopDetector");
                loopDetector = null;
            }
            if (loopDetector.visitCodeLocation(iThread, codeLocation)) {
                this.failIfObstructionFreedomIsRequired((Function0<String>)((Function0)new Function0<String>(this, tracePoint){
                    final /* synthetic */ ManagedStrategy this$0;
                    final /* synthetic */ TracePoint $tracePoint;
                    {
                        this.this$0 = $receiver;
                        this.$tracePoint = $tracePoint;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        block0: {
                            TraceCollector traceCollector = ManagedStrategy.access$getTraceCollector$p(this.this$0);
                            if (traceCollector == null) break block0;
                            traceCollector.passCodeLocation(this.$tracePoint);
                        }
                        return "Obstruction-freedom is required but an active lock has been found";
                    }
                }));
                LoopDetector loopDetector2 = this.loopDetector;
                if (loopDetector2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"loopDetector");
                    loopDetector2 = null;
                }
                this.checkLiveLockHappened(loopDetector2.getTotalOperations());
                isLoop = true;
            }
            if (shouldSwitch = this.shouldSwitch(iThread) | isLoop) {
                SwitchReason reason = isLoop ? SwitchReason.ACTIVE_LOCK : SwitchReason.STRATEGY_SWITCH;
                ManagedStrategy.switchCurrentThread$default(this, iThread, reason, false, 4, null);
            }
            TraceCollector traceCollector = this.traceCollector;
            if (traceCollector == null) break block7;
            traceCollector.passCodeLocation(tracePoint);
        }
    }

    public void onStart(int iThread) {
        this.awaitTurn(iThread);
    }

    public void onFinish(int iThread) {
        this.awaitTurn(iThread);
        this.finished[iThread] = true;
        TraceCollector traceCollector = this.traceCollector;
        if (traceCollector != null) {
            traceCollector.finishThread(iThread);
        }
        this.doSwitchCurrentThread(iThread, true);
    }

    public void onFailure(int iThread, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception == ForcibleExecutionFinishException.INSTANCE) {
            return;
        }
        this.suddenInvocationResult = new UnexpectedExceptionInvocationResult(UtilsKt.wrapInvalidAccessFromUnnamedModuleExceptionWithDescription(exception));
    }

    @Override
    public void onActorStart(int iThread) {
        int[] nArray = this.currentActorId;
        int n = nArray[iThread];
        nArray[iThread] = n + 1;
        this.callStackTrace[iThread].clear();
        this.suspendedFunctionsStack[iThread].clear();
        LoopDetector loopDetector = this.loopDetector;
        if (loopDetector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loopDetector");
            loopDetector = null;
        }
        loopDetector.reset(iThread);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isActive(int iThread) {
        if (this.finished[iThread]) return false;
        MonitorTracker monitorTracker = this.monitorTracker;
        if (monitorTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"monitorTracker");
            monitorTracker = null;
        }
        if (monitorTracker.isWaiting(iThread)) return false;
        if (!this.isSuspended[iThread]) return true;
        if (!this.runner.isCoroutineResumed(iThread, this.currentActorId[iThread])) return false;
        return true;
    }

    private final void awaitTurn(int iThread) {
        while (this.currentThread != iThread) {
            if (this.suddenInvocationResult != null) {
                throw ForcibleExecutionFinishException.INSTANCE;
            }
            Thread.yield();
        }
    }

    private final void switchCurrentThread(int iThread, SwitchReason reason, boolean mustSwitch) {
        TraceCollector traceCollector = this.traceCollector;
        if (traceCollector != null) {
            traceCollector.newSwitch(iThread, reason);
        }
        this.doSwitchCurrentThread(iThread, mustSwitch);
        this.awaitTurn(iThread);
    }

    static /* synthetic */ void switchCurrentThread$default(ManagedStrategy managedStrategy, int n, SwitchReason switchReason, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: switchCurrentThread");
        }
        if ((n2 & 2) != 0) {
            switchReason = SwitchReason.STRATEGY_SWITCH;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        managedStrategy.switchCurrentThread(n, switchReason, bl);
    }

    private final void doSwitchCurrentThread(int iThread, boolean mustSwitch) {
        int nextThreadId;
        this.onNewSwitch(iThread, mustSwitch);
        List<Integer> switchableThreads = this.switchableThreads(iThread);
        if (switchableThreads.isEmpty()) {
            if (mustSwitch) {
                boolean bl;
                int it;
                block6: {
                    boolean[] $this$all$iv = this.finished;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        int element$iv;
                        it = element$iv = $this$all$iv[i];
                        boolean bl2 = false;
                        if (it != 0) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (!bl) {
                    Object v1;
                    block7: {
                        Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)this.nThreads);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = ((Number)element$iv).intValue();
                            boolean bl3 = false;
                            if (!(!this.finished[it] && this.isSuspended[it])) continue;
                            v1 = element$iv;
                            break block7;
                        }
                        v1 = null;
                    }
                    Integer nextThread = v1;
                    if (nextThread == null) {
                        this.suddenInvocationResult = new DeadlockInvocationResult(UtilsKt.collectThreadDump(this.runner));
                        throw ForcibleExecutionFinishException.INSTANCE;
                    }
                    this.currentThread = nextThread;
                }
            }
            return;
        }
        this.currentThread = nextThreadId = this.chooseThread(iThread);
    }

    static /* synthetic */ void doSwitchCurrentThread$default(ManagedStrategy managedStrategy, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doSwitchCurrentThread");
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        managedStrategy.doSwitchCurrentThread(n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Integer> switchableThreads(int iThread) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)this.nThreads);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it != iThread && this.isActive(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isTestThread(int iThread) {
        return iThread < this.nThreads;
    }

    private final boolean inIgnoredSection(int iThread) {
        return !this.isTestThread(iThread) || this.ignoredSectionDepth[iThread] > 0 || this.suddenInvocationResult != null;
    }

    public final void beforeSharedVariableRead$lincheck(int iThread, int codeLocation, @Nullable ReadTracePoint tracePoint) {
        this.newSwitchPoint(iThread, codeLocation, tracePoint);
    }

    public final void beforeSharedVariableWrite$lincheck(int iThread, int codeLocation, @Nullable WriteTracePoint tracePoint) {
        this.newSwitchPoint(iThread, codeLocation, tracePoint);
    }

    public final void beforeAtomicMethodCall$lincheck(int iThread, int codeLocation) {
        if (!this.isTestThread(iThread)) {
            return;
        }
        CallStackTraceElement callStackTraceElement = (CallStackTraceElement)CollectionsKt.lastOrNull(this.callStackTrace[iThread]);
        this.newSwitchPoint(iThread, codeLocation, callStackTraceElement != null ? callStackTraceElement.getCall() : null);
    }

    public final boolean beforeLockAcquire$lincheck(int iThread, int codeLocation, @Nullable MonitorEnterTracePoint tracePoint, @NotNull Object monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        if (!this.isTestThread(iThread)) {
            return true;
        }
        if (this.inIgnoredSection(iThread)) {
            return false;
        }
        this.newSwitchPoint(iThread, codeLocation, tracePoint);
        MonitorTracker monitorTracker = this.monitorTracker;
        if (monitorTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"monitorTracker");
            monitorTracker = null;
        }
        if (!monitorTracker.acquireMonitor(iThread, monitor)) {
            this.failIfObstructionFreedomIsRequired((Function0<String>)((Function0)beforeLockAcquire.1.INSTANCE));
            this.switchCurrentThread(iThread, SwitchReason.LOCK_WAIT, true);
            MonitorTracker monitorTracker2 = this.monitorTracker;
            if (monitorTracker2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"monitorTracker");
                monitorTracker2 = null;
            }
            if (!monitorTracker2.acquireMonitor(iThread, monitor)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        return false;
    }

    public final boolean beforeLockRelease$lincheck(int iThread, int codeLocation, @Nullable MonitorExitTracePoint tracePoint, @NotNull Object monitor) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
            if (!this.isTestThread(iThread)) {
                return true;
            }
            if (this.inIgnoredSection(iThread)) {
                return false;
            }
            MonitorTracker monitorTracker = this.monitorTracker;
            if (monitorTracker == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"monitorTracker");
                monitorTracker = null;
            }
            monitorTracker.releaseMonitor(monitor);
            TraceCollector traceCollector = this.traceCollector;
            if (traceCollector == null) break block3;
            traceCollector.passCodeLocation(tracePoint);
        }
        return false;
    }

    public final boolean beforePark$lincheck(int iThread, int codeLocation, @Nullable ParkTracePoint tracePoint, boolean withTimeout) {
        this.newSwitchPoint(iThread, codeLocation, tracePoint);
        return false;
    }

    public final void afterUnpark$lincheck(int iThread, int codeLocation, @Nullable UnparkTracePoint tracePoint, @NotNull Object thread) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            if (!this.isTestThread(iThread)) {
                return;
            }
            TraceCollector traceCollector = this.traceCollector;
            if (traceCollector == null) break block1;
            traceCollector.passCodeLocation(tracePoint);
        }
    }

    public final boolean beforeWait$lincheck(int iThread, int codeLocation, @Nullable WaitTracePoint tracePoint, @NotNull Object monitor, boolean withTimeout) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        if (!this.isTestThread(iThread)) {
            return true;
        }
        if (this.inIgnoredSection(iThread)) {
            return false;
        }
        this.newSwitchPoint(iThread, codeLocation, tracePoint);
        this.failIfObstructionFreedomIsRequired((Function0<String>)((Function0)beforeWait.1.INSTANCE));
        if (withTimeout) {
            return false;
        }
        MonitorTracker monitorTracker = this.monitorTracker;
        if (monitorTracker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"monitorTracker");
            monitorTracker = null;
        }
        monitorTracker.waitOnMonitor(iThread, monitor);
        this.switchCurrentThread(iThread, SwitchReason.MONITOR_WAIT, true);
        MonitorTracker monitorTracker2 = this.monitorTracker;
        if (monitorTracker2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"monitorTracker");
            monitorTracker2 = null;
        }
        if (!monitorTracker2.acquireMonitor(iThread, monitor)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return false;
    }

    public final boolean beforeNotify$lincheck(int iThread, int codeLocation, @Nullable NotifyTracePoint tracePoint, @NotNull Object monitor, boolean notifyAll) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
            if (!this.isTestThread(iThread)) {
                return true;
            }
            if (notifyAll) {
                MonitorTracker monitorTracker = this.monitorTracker;
                if (monitorTracker == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"monitorTracker");
                    monitorTracker = null;
                }
                monitorTracker.notifyAll(monitor);
            } else {
                MonitorTracker monitorTracker = this.monitorTracker;
                if (monitorTracker == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"monitorTracker");
                    monitorTracker = null;
                }
                monitorTracker.notify(monitor);
            }
            TraceCollector traceCollector = this.traceCollector;
            if (traceCollector == null) break block5;
            traceCollector.passCodeLocation(tracePoint);
        }
        return false;
    }

    public final void afterCoroutineSuspended$lincheck(int iThread) {
        if (!(this.currentThread == iThread)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.isSuspended[iThread] = true;
        if (this.runner.isCoroutineResumed(iThread, this.currentActorId[iThread])) {
            this.newSwitchPoint(iThread, -1, null);
        } else {
            this.switchCurrentThread(iThread, SwitchReason.SUSPENDED, true);
        }
    }

    public final void afterCoroutineResumed$lincheck(int iThread) {
        if (!(this.currentThread == iThread)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.isSuspended[iThread] = false;
    }

    public final void afterCoroutineCancelled$lincheck(int iThread) {
        if (!(this.currentThread == iThread)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.isSuspended[iThread] = false;
        this.suspendedFunctionsStack[iThread].clear();
    }

    public final void enterIgnoredSection$lincheck(int iThread) {
        if (this.isTestThread(iThread)) {
            int[] nArray = this.ignoredSectionDepth;
            int n = nArray[iThread];
            nArray[iThread] = n + 1;
        }
    }

    public final void leaveIgnoredSection$lincheck(int iThread) {
        if (this.isTestThread(iThread)) {
            int[] nArray = this.ignoredSectionDepth;
            int n = nArray[iThread];
            nArray[iThread] = n + -1;
        }
    }

    public final void beforeMethodCall$lincheck(int iThread, int codeLocation, @NotNull MethodCallTracePoint tracePoint) {
        Intrinsics.checkNotNullParameter((Object)tracePoint, (String)"tracePoint");
        if (this.isTestThread(iThread) && !this.inIgnoredSection(iThread)) {
            int n;
            if (!this.collectTrace) {
                boolean $i$a$-check-ManagedStrategy$beforeMethodCall$22 = false;
                String $i$a$-check-ManagedStrategy$beforeMethodCall$22 = "This method should be called only when logging is enabled";
                throw new IllegalStateException($i$a$-check-ManagedStrategy$beforeMethodCall$22.toString());
            }
            List<CallStackTraceElement> callStackTrace = this.callStackTrace[iThread];
            List<Integer> suspendedMethodStack = this.suspendedFunctionsStack[iThread];
            if (!((Collection)suspendedMethodStack).isEmpty()) {
                int lastId = ((Number)CollectionsKt.last(suspendedMethodStack)).intValue();
                suspendedMethodStack.remove(CollectionsKt.getLastIndex(suspendedMethodStack));
                n = lastId;
            } else {
                int n2 = this.methodCallNumber;
                this.methodCallNumber = n2 + 1;
                n = n2;
            }
            int methodId = n;
            callStackTrace.add(new CallStackTraceElement(tracePoint, methodId));
        }
    }

    public final void afterMethodCall$lincheck(int iThread, @NotNull MethodCallTracePoint tracePoint) {
        Intrinsics.checkNotNullParameter((Object)tracePoint, (String)"tracePoint");
        if (this.isTestThread(iThread) && !this.inIgnoredSection(iThread)) {
            if (!this.collectTrace) {
                boolean bl = false;
                String string = "This method should be called only when logging is enabled";
                throw new IllegalStateException(string.toString());
            }
            List<CallStackTraceElement> callStackTrace = this.callStackTrace[iThread];
            if (tracePoint.getWasSuspended()) {
                this.suspendedFunctionsStack[iThread].add(((CallStackTraceElement)CollectionsKt.last(callStackTrace)).getIdentifier());
            }
            callStackTrace.remove(CollectionsKt.getLastIndex(callStackTrace));
        }
    }

    @NotNull
    public final TracePoint createTracePoint(int constructorId) {
        return this.doCreateTracePoint(this.tracePointConstructors.get(constructorId));
    }

    @Nullable
    public final CoroutineCancellationTracePoint createAndLogCancellationTracePoint$lincheck() {
        if (this.collectTrace) {
            CoroutineCancellationTracePoint cancellationTracePoint2 = (CoroutineCancellationTracePoint)this.doCreateTracePoint(createAndLogCancellationTracePoint.cancellationTracePoint.1.INSTANCE);
            TraceCollector traceCollector = this.traceCollector;
            if (traceCollector != null) {
                traceCollector.passCodeLocation(cancellationTracePoint2);
            }
            return cancellationTracePoint2;
        }
        return null;
    }

    private final <T extends TracePoint> T doCreateTracePoint(Function3<? super Integer, ? super Integer, ? super List<CallStackTraceElement>, ? extends T> constructor) {
        int iThread = this.currentThreadNumber();
        int actorId = !this.isTestThread(iThread) ? Integer.MIN_VALUE : this.currentActorId[iThread];
        Integer n = iThread;
        Integer n2 = actorId;
        List list = (List)ArraysKt.getOrNull((Object[])this.callStackTrace, (int)iThread);
        if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
            list = CollectionsKt.emptyList();
        }
        return (T)((TracePoint)constructor.invoke((Object)n, (Object)n2, (Object)list));
    }

    public final void addStateRepresentation(int iThread) {
        block2: {
            if (this.inIgnoredSection(iThread)) break block2;
            if (!this.collectTrace) {
                boolean bl = false;
                String string = "This method should be called only when logging is enabled";
                throw new IllegalStateException(string.toString());
            }
            TraceCollector traceCollector = this.traceCollector;
            if (traceCollector != null) {
                traceCollector.addStateRepresentation(iThread);
            }
        }
    }

    public final int currentThreadNumber() {
        Thread t = Thread.currentThread();
        return t instanceof FixedActiveThreadsExecutor.TestThread ? ((FixedActiveThreadsExecutor.TestThread)t).getIThread() : this.nThreads;
    }

    public static final /* synthetic */ TraceCollector access$getTraceCollector$p(ManagedStrategy $this) {
        return $this.traceCollector;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy$TraceCollector;", "", "(Lorg/jetbrains/kotlinx/lincheck/strategy/managed/ManagedStrategy;)V", "_trace", "", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/TracePoint;", "trace", "", "getTrace", "()Ljava/util/List;", "addStateRepresentation", "", "iThread", "", "finishThread", "newSwitch", "reason", "Lorg/jetbrains/kotlinx/lincheck/strategy/managed/SwitchReason;", "passCodeLocation", "tracePoint", "lincheck"})
    private final class TraceCollector {
        @NotNull
        private final List<TracePoint> _trace = new ArrayList();
        @NotNull
        private final List<TracePoint> trace = this._trace;

        @NotNull
        public final List<TracePoint> getTrace() {
            return this.trace;
        }

        public final void newSwitch(int iThread, @NotNull SwitchReason reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            ((Collection)this._trace).add(new SwitchEventTracePoint(iThread, ManagedStrategy.this.getCurrentActorId()[iThread], reason, CollectionsKt.toList((Iterable)ManagedStrategy.this.callStackTrace[iThread])));
        }

        public final void finishThread(int iThread) {
            ((Collection)this._trace).add(new FinishThreadTracePoint(iThread));
        }

        public final void passCodeLocation(@Nullable TracePoint tracePoint) {
            if (tracePoint != null) {
                ((Collection)this._trace).add(tracePoint);
            }
        }

        public final void addStateRepresentation(int iThread) {
            String string = ManagedStrategy.this.runner.constructStateRepresentation();
            Intrinsics.checkNotNull((Object)string);
            String stateRepresentation = string;
            List callStackTrace = CollectionsKt.toList((Iterable)((TracePoint)CollectionsKt.last(this._trace)).getCallStackTrace$lincheck());
            ((Collection)this._trace).add(new StateRepresentationTracePoint(iThread, ManagedStrategy.this.getCurrentActorId()[iThread], stateRepresentation, callStackTrace));
        }
    }
}

