/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.strategy.managed;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/lincheck/strategy/managed/LoopDetector;", "", "hangingDetectionThreshold", "", "(I)V", "lastIThread", "operationCounts", "", "<set-?>", "totalOperations", "getTotalOperations", "()I", "reset", "", "iThread", "visitCodeLocation", "", "codeLocation", "lincheck"})
final class LoopDetector {
    private final int hangingDetectionThreshold;
    private int lastIThread;
    @NotNull
    private final Map<Integer, Integer> operationCounts;
    private int totalOperations;

    public LoopDetector(int hangingDetectionThreshold) {
        this.hangingDetectionThreshold = hangingDetectionThreshold;
        this.lastIThread = -1;
        this.operationCounts = new LinkedHashMap();
    }

    public final int getTotalOperations() {
        return this.totalOperations;
    }

    public final boolean visitCodeLocation(int iThread, int codeLocation) {
        int n = this.totalOperations;
        this.totalOperations = n + 1;
        if (this.lastIThread != iThread) {
            this.reset(iThread);
        }
        if (codeLocation == -1) {
            return false;
        }
        int count = ((Number)this.operationCounts.getOrDefault(codeLocation, 0)).intValue() + 1;
        Integer n2 = codeLocation;
        Integer n3 = count;
        this.operationCounts.put(n2, n3);
        return count > this.hangingDetectionThreshold;
    }

    public final void reset(int iThread) {
        this.operationCounts.clear();
        this.lastIThread = iThread;
    }
}

