/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.runner;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.ExecutionClassLoader;
import org.jetbrains.kotlinx.lincheck.TransformationClassLoader;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.runner.InvocationResult;
import org.jetbrains.kotlinx.lincheck.strategy.Strategy;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B3\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010.\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010/\u001a\u00020*H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u000203H\u0016J\b\u00105\u001a\u00020*H\u0016J\u0018\u00106\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u00107\u001a\u00020,H\u0016J\u0014\u00108\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u00109\u001a\u000201H\u0002J\b\u0010:\u001a\u00020\u0016H\u0016J\u000e\u0010;\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0018\u0010<\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010@\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010A\u001a\u00020BH&R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\u00020\f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\t\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001e\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlinx/lincheck/runner/Runner;", "Ljava/io/Closeable;", "strategy", "Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "_testClass", "Ljava/lang/Class;", "validationFunctions", "", "Ljava/lang/reflect/Method;", "stateRepresentationFunction", "(Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;Ljava/lang/Class;Ljava/util/List;Ljava/lang/reflect/Method;)V", "classLoader", "Lorg/jetbrains/kotlinx/lincheck/ExecutionClassLoader;", "getClassLoader$annotations", "()V", "getClassLoader", "()Lorg/jetbrains/kotlinx/lincheck/ExecutionClassLoader;", "completedOrSuspendedThreads", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCompletedOrSuspendedThreads", "()Ljava/util/concurrent/atomic/AtomicInteger;", "isParallelExecutionCompleted", "", "()Z", "scenario", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "getScenario", "()Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "setScenario", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;)V", "getStateRepresentationFunction", "()Ljava/lang/reflect/Method;", "getStrategy", "()Lorg/jetbrains/kotlinx/lincheck/strategy/Strategy;", "testClass", "getTestClass", "()Ljava/lang/Class;", "setTestClass", "(Ljava/lang/Class;)V", "getValidationFunctions", "()Ljava/util/List;", "afterCoroutineCancelled", "", "iThread", "", "afterCoroutineResumed", "afterCoroutineSuspended", "close", "constructStateRepresentation", "", "createTransformer", "Lorg/objectweb/asm/ClassVisitor;", "cv", "initialize", "isCoroutineResumed", "actorId", "loadClass", "className", "needsTransformation", "onActorStart", "onFailure", "e", "", "onFinish", "onStart", "run", "Lorg/jetbrains/kotlinx/lincheck/runner/InvocationResult;", "lincheck"})
public abstract class Runner
implements Closeable {
    @NotNull
    private final Strategy strategy;
    @NotNull
    private final Class<?> _testClass;
    @NotNull
    private final List<Method> validationFunctions;
    @Nullable
    private final Method stateRepresentationFunction;
    @NotNull
    private ExecutionScenario scenario;
    protected Class<?> testClass;
    @NotNull
    private final ExecutionClassLoader classLoader;
    @NotNull
    private final AtomicInteger completedOrSuspendedThreads;

    protected Runner(@NotNull Strategy strategy, @NotNull Class<?> _testClass, @NotNull List<Method> validationFunctions, @Nullable Method stateRepresentationFunction) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter(_testClass, (String)"_testClass");
        Intrinsics.checkNotNullParameter(validationFunctions, (String)"validationFunctions");
        this.strategy = strategy;
        this._testClass = _testClass;
        this.validationFunctions = validationFunctions;
        this.stateRepresentationFunction = stateRepresentationFunction;
        this.scenario = this.strategy.getScenario();
        this.classLoader = this.needsTransformation() || this.strategy.needsTransformation() ? (ExecutionClassLoader)new TransformationClassLoader(this.strategy, this) : new ExecutionClassLoader();
        this.completedOrSuspendedThreads = new AtomicInteger(0);
    }

    @NotNull
    protected final Strategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    protected final List<Method> getValidationFunctions() {
        return this.validationFunctions;
    }

    @Nullable
    protected final Method getStateRepresentationFunction() {
        return this.stateRepresentationFunction;
    }

    @NotNull
    protected final ExecutionScenario getScenario() {
        return this.scenario;
    }

    protected final void setScenario(@NotNull ExecutionScenario executionScenario) {
        Intrinsics.checkNotNullParameter((Object)executionScenario, (String)"<set-?>");
        this.scenario = executionScenario;
    }

    @NotNull
    protected final Class<?> getTestClass() {
        Class<?> clazz = this.testClass;
        if (clazz != null) {
            return clazz;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testClass");
        return null;
    }

    protected final void setTestClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
        this.testClass = clazz;
    }

    @NotNull
    public final ExecutionClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static /* synthetic */ void getClassLoader$annotations() {
    }

    @NotNull
    protected final AtomicInteger getCompletedOrSuspendedThreads() {
        return this.completedOrSuspendedThreads;
    }

    public void initialize() {
        this.scenario = UtilsKt.convertForLoader(this.strategy.getScenario(), (ClassLoader)this.classLoader);
        String string = this._testClass.getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"_testClass.typeName");
        this.setTestClass(this.loadClass(string));
    }

    @Nullable
    public String constructStateRepresentation() {
        return null;
    }

    private final Class<?> loadClass(String className) {
        Class<?> clazz = this.classLoader.loadClass(className);
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"classLoader.loadClass(className)");
        return clazz;
    }

    @Nullable
    public ClassVisitor createTransformer(@NotNull ClassVisitor cv) {
        Intrinsics.checkNotNullParameter((Object)cv, (String)"cv");
        return null;
    }

    public boolean needsTransformation() {
        return false;
    }

    @NotNull
    public abstract InvocationResult run();

    public void onStart(int iThread) {
    }

    public void onFinish(int iThread) {
    }

    public void onFailure(int iThread, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public void afterCoroutineSuspended(int iThread) {
        throw new UnsupportedOperationException("Coroutines are not supported");
    }

    public void afterCoroutineResumed(int iThread) {
        throw new UnsupportedOperationException("Coroutines are not supported");
    }

    public void afterCoroutineCancelled(int iThread) {
        throw new UnsupportedOperationException("Coroutines are not supported");
    }

    public boolean isCoroutineResumed(int iThread, int actorId) {
        throw new UnsupportedOperationException("Coroutines are not supported");
    }

    public final void onActorStart(int iThread) {
        this.strategy.onActorStart(iThread);
    }

    @Override
    public void close() {
    }

    public final boolean isParallelExecutionCompleted() {
        return this.completedOrSuspendedThreads.get() == this.scenario.getThreads();
    }
}

