/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.paramgen;

import java.util.Random;

public class ExpandingRangeIntGenerator {
    private final Random random;
    private static final int DEFAULT_START_VALUE = 0;
    private int begin;
    private int end;
    private final int minBegin;
    private final int maxEnd;
    private NextExpansionDirection nextExpansionDirection = NextExpansionDirection.UP;

    public ExpandingRangeIntGenerator(Random random, int begin, int end, int minBegin, int maxEnd) {
        this.random = random;
        this.begin = begin;
        this.end = end;
        this.minBegin = minBegin;
        this.maxEnd = maxEnd;
    }

    public int nextInt() {
        this.checkRangeExpansionAbility();
        if (this.nextExpansionDirection == NextExpansionDirection.DISABLED || !this.random.nextBoolean()) {
            return this.generateFromRandomRange(this.begin, this.end);
        }
        if (this.nextExpansionDirection == NextExpansionDirection.DOWN) {
            this.nextExpansionDirection = NextExpansionDirection.UP;
            return --this.begin;
        }
        this.nextExpansionDirection = NextExpansionDirection.DOWN;
        return ++this.end;
    }

    private void checkRangeExpansionAbility() {
        if (this.begin == this.minBegin && this.end == this.maxEnd) {
            this.nextExpansionDirection = NextExpansionDirection.DISABLED;
            return;
        }
        if (this.begin == this.minBegin) {
            this.nextExpansionDirection = NextExpansionDirection.UP;
            return;
        }
        if (this.end == this.maxEnd) {
            this.nextExpansionDirection = NextExpansionDirection.DOWN;
        }
    }

    private int generateFromRandomRange(int rangeLowerBound, int rangeUpperBound) {
        return rangeLowerBound + this.random.nextInt(rangeUpperBound - rangeLowerBound + 1);
    }

    public static ExpandingRangeIntGenerator create(Random random, String configuration, int minBegin, int maxEnd, String type) {
        if (configuration.isEmpty()) {
            return new ExpandingRangeIntGenerator(random, 0, 0, minBegin, maxEnd);
        }
        String[] args = configuration.replaceAll("\\s", "").split(":");
        if (args.length != 2) {
            throw new IllegalArgumentException("Configuration should have two arguments (begin and end) separated by colon");
        }
        int begin = Integer.parseInt(args[0]);
        int end = Integer.parseInt(args[1]);
        if (begin < minBegin || end - 1 > maxEnd) {
            throw new IllegalArgumentException("Illegal range for " + type + " type: [" + begin + "; " + end + ")");
        }
        int startValue = begin + (end - begin) / 2;
        if (end < begin) {
            throw new IllegalArgumentException("end must be >= than begin");
        }
        if (maxEnd < minBegin) {
            throw new IllegalArgumentException("maxEnd must be >= than minBegin");
        }
        if (end > maxEnd) {
            throw new IllegalArgumentException("end must be <= than maxEnd");
        }
        return new ExpandingRangeIntGenerator(random, startValue, startValue, begin, end);
    }

    private static enum NextExpansionDirection {
        UP,
        DOWN,
        DISABLED;

    }
}

