/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.paramgen;

import org.jetbrains.kotlinx.lincheck.RandomProvider;
import org.jetbrains.kotlinx.lincheck.paramgen.ExpandingRangeIntGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;

public class DoubleGen
implements ParameterGenerator<Double> {
    private static final float DEFAULT_STEP = 0.1f;
    private static final float DEFAULT_BEGIN = -10.0f;
    private static final float DEFAULT_END = 10.0f;
    private final ExpandingRangeIntGenerator intGenerator;
    private final double step;
    private final double begin;

    public DoubleGen(RandomProvider randomProvider, String configuration) {
        double end;
        double begin;
        double step = 0.0;
        if (configuration.isEmpty()) {
            begin = -10.0;
            end = 10.0;
            step = 0.1f;
        } else {
            String[] args = configuration.replaceAll("\\s", "").split(":");
            switch (args.length) {
                case 2: {
                    begin = Double.parseDouble(args[0]);
                    end = Double.parseDouble(args[1]);
                    break;
                }
                case 3: {
                    begin = Double.parseDouble(args[0]);
                    step = Double.parseDouble(args[1]);
                    end = Double.parseDouble(args[2]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Configuration should have two (begin and end) or three (begin, step and end) arguments separated by colon");
                }
            }
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Illegal range for type double: begin must be < end");
        }
        double delta = end - begin;
        if (step == 0.0) {
            step = delta / 100.0;
        }
        int maxSteps = (int)(delta / step);
        this.intGenerator = new ExpandingRangeIntGenerator(randomProvider.createRandom(), maxSteps / 2, maxSteps / 2, 0, maxSteps);
        this.step = step;
        this.begin = begin;
    }

    @Override
    public Double generate() {
        return this.begin + this.step * (double)this.intGenerator.nextInt();
    }
}

