/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck.execution;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.ActorKt;
import org.jetbrains.kotlinx.lincheck.paramgen.ParameterGenerator;
import org.jetbrains.kotlinx.lincheck.paramgen.ThreadIdGenKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\b0\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlinx/lincheck/execution/ActorGenerator;", "", "method", "Ljava/lang/reflect/Method;", "parameterGenerators", "", "Lorg/jetbrains/kotlinx/lincheck/paramgen/ParameterGenerator;", "handledExceptions", "Ljava/lang/Class;", "", "useOnce", "", "cancellableOnSuspension", "allowExtraSuspension", "blocking", "causesBlocking", "promptCancellation", "(Ljava/lang/reflect/Method;Ljava/util/List;Ljava/util/List;ZZZZZZ)V", "isSuspendable", "()Z", "getUseOnce", "generate", "Lorg/jetbrains/kotlinx/lincheck/Actor;", "threadId", "", "random", "Ljava/util/Random;", "toString", "", "lincheck"})
public final class ActorGenerator {
    @NotNull
    private final Method method;
    @NotNull
    private final List<ParameterGenerator<?>> parameterGenerators;
    @NotNull
    private final List<Class<? extends Throwable>> handledExceptions;
    private final boolean useOnce;
    private final boolean allowExtraSuspension;
    private final boolean blocking;
    private final boolean causesBlocking;
    private final boolean cancellableOnSuspension;
    private final boolean promptCancellation;

    public ActorGenerator(@NotNull Method method, @NotNull List<? extends ParameterGenerator<?>> parameterGenerators, @NotNull List<? extends Class<? extends Throwable>> handledExceptions, boolean useOnce, boolean cancellableOnSuspension, boolean allowExtraSuspension, boolean blocking, boolean causesBlocking, boolean promptCancellation) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(parameterGenerators, (String)"parameterGenerators");
        Intrinsics.checkNotNullParameter(handledExceptions, (String)"handledExceptions");
        this.method = method;
        this.parameterGenerators = parameterGenerators;
        this.handledExceptions = handledExceptions;
        this.useOnce = useOnce;
        this.allowExtraSuspension = allowExtraSuspension;
        this.blocking = blocking;
        this.causesBlocking = causesBlocking;
        this.cancellableOnSuspension = cancellableOnSuspension && this.isSuspendable();
        this.promptCancellation = cancellableOnSuspension && promptCancellation;
    }

    public final boolean getUseOnce() {
        return this.useOnce;
    }

    @NotNull
    public final Actor generate(int threadId, @NotNull Random random) {
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Iterable iterable = this.parameterGenerators;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParameterGenerator parameterGenerator = (ParameterGenerator)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.generate());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            it = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it == ThreadIdGenKt.getTHREAD_ID_TOKEN() ? Integer.valueOf(threadId) : it);
        }
        List parameters = (List)destination$iv$iv;
        boolean cancelOnSuspension = this.cancellableOnSuspension & random.nextBoolean();
        boolean promptCancellation = cancelOnSuspension & this.promptCancellation & random.nextBoolean();
        return new Actor(this.method, parameters, this.handledExceptions, cancelOnSuspension, this.allowExtraSuspension, this.blocking, this.causesBlocking, promptCancellation, false, 256, null);
    }

    public final boolean isSuspendable() {
        return ActorKt.isSuspendable(this.method);
    }

    @NotNull
    public String toString() {
        String string = this.method.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.toString()");
        return string;
    }
}

