/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.lincheck;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.lincheck.Actor;
import org.jetbrains.kotlinx.lincheck.CTestConfiguration;
import org.jetbrains.kotlinx.lincheck.CTestConfigurationKt;
import org.jetbrains.kotlinx.lincheck.CTestStructure;
import org.jetbrains.kotlinx.lincheck.LinChecker;
import org.jetbrains.kotlinx.lincheck.LincheckAssertionError;
import org.jetbrains.kotlinx.lincheck.LoggingLevel;
import org.jetbrains.kotlinx.lincheck.Options;
import org.jetbrains.kotlinx.lincheck.RandomProvider;
import org.jetbrains.kotlinx.lincheck.Reporter;
import org.jetbrains.kotlinx.lincheck.ReporterKt;
import org.jetbrains.kotlinx.lincheck.UtilsKt;
import org.jetbrains.kotlinx.lincheck.annotations.LogLevel;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionGenerator;
import org.jetbrains.kotlinx.lincheck.execution.ExecutionScenario;
import org.jetbrains.kotlinx.lincheck.strategy.LincheckFailure;
import org.jetbrains.kotlinx.lincheck.verifier.Verifier;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0001-B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\u000f\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u000bH\u0002J\f\u0010\u001d\u001a\u00020\u0011*\u00020\u0011H\u0002J\u001c\u0010\u001e\u001a\n \u000e*\u0004\u0018\u00010\u001f0\u001f*\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\n \u000e*\u0004\u0018\u00010#0#*\u00020\u000bH\u0002J\u0014\u0010$\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010\u001b*\u00020\u00112\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020#H\u0002J&\u0010(\u001a\u0004\u0018\u00010\u001b*\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u0016\u0010(\u001a\u0004\u0018\u00010\u001b*\u00020\u00112\u0006\u0010%\u001a\u00020\u000bH\u0002J\f\u0010,\u001a\u00020\u0019*\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0018\u0010\u0017\u001a\u00020\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlinx/lincheck/LinChecker;", "", "testClass", "Ljava/lang/Class;", "options", "Lorg/jetbrains/kotlinx/lincheck/Options;", "(Ljava/lang/Class;Lorg/jetbrains/kotlinx/lincheck/Options;)V", "reporter", "Lorg/jetbrains/kotlinx/lincheck/Reporter;", "testConfigurations", "", "Lorg/jetbrains/kotlinx/lincheck/CTestConfiguration;", "testStructure", "Lorg/jetbrains/kotlinx/lincheck/CTestStructure;", "kotlin.jvm.PlatformType", "hasPostPartAndSuspendableActors", "", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;", "getHasPostPartAndSuspendableActors", "(Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionScenario;)Z", "hasSuspendableActorsInInitPart", "getHasSuspendableActorsInInitPart", "isParallelPartEmpty", "isValid", "check", "", "checkImpl", "Lorg/jetbrains/kotlinx/lincheck/strategy/LincheckFailure;", "checkImpl$lincheck", "copy", "createExecutionGenerator", "Lorg/jetbrains/kotlinx/lincheck/execution/ExecutionGenerator;", "randomProvider", "Lorg/jetbrains/kotlinx/lincheck/RandomProvider;", "createVerifier", "Lorg/jetbrains/kotlinx/lincheck/verifier/Verifier;", "minimize", "testCfg", "run", "verifier", "tryMinimize", "threadId", "", "position", "validate", "Companion", "lincheck"})
public final class LinChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<?> testClass;
    private final CTestStructure testStructure;
    @NotNull
    private final List<CTestConfiguration> testConfigurations;
    @NotNull
    private final Reporter reporter;
    private static final int VERIFIER_REFRESH_CYCLE = 100;

    public LinChecker(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        this.testClass = testClass;
        this.testStructure = CTestStructure.getFromTestClass(this.testClass);
        Object object = options;
        if (object == null || (object = object.getLogLevel$lincheck()) == null) {
            LogLevel logLevel = this.testClass.getAnnotation(LogLevel.class);
            object = logLevel != null ? logLevel.value() : ReporterKt.DEFAULT_LOG_LEVEL;
        }
        Object logLevel = object;
        this.reporter = new Reporter((LoggingLevel)((Object)logLevel));
        Options<?, ?> options2 = options;
        this.testConfigurations = options2 != null ? CollectionsKt.listOf(options2.createTestConfigurations(this.testClass)) : CTestConfigurationKt.createFromTestClassAnnotations(this.testClass);
    }

    public final void check() {
        LincheckFailure lincheckFailure = this.checkImpl$lincheck();
        if (lincheckFailure == null) {
            return;
        }
        LincheckFailure failure = lincheckFailure;
        throw new LincheckAssertionError(failure);
    }

    @Nullable
    public final LincheckFailure checkImpl$lincheck() {
        if (!(!((Collection)this.testConfigurations).isEmpty())) {
            boolean $i$a$-check-LinChecker$checkImpl$22 = false;
            String $i$a$-check-LinChecker$checkImpl$22 = "No Lincheck test configuration to run";
            throw new IllegalStateException($i$a$-check-LinChecker$checkImpl$22.toString());
        }
        for (CTestConfiguration testCfg : this.testConfigurations) {
            LincheckFailure failure;
            LincheckFailure lincheckFailure = failure = this.checkImpl(testCfg);
            if (lincheckFailure == null) continue;
            return lincheckFailure;
        }
        return null;
    }

    private final LincheckFailure checkImpl(CTestConfiguration $this$checkImpl) {
        RandomProvider randomProvider = this.testStructure.randomProvider;
        Intrinsics.checkNotNullExpressionValue((Object)randomProvider, (String)"testStructure.randomProvider");
        ExecutionGenerator exGen = this.createExecutionGenerator($this$checkImpl, randomProvider);
        int n = $this$checkImpl.getCustomScenarios().size();
        for (int i = 0; i < n; ++i) {
            LincheckFailure failure;
            Verifier verifier = this.createVerifier($this$checkImpl);
            ExecutionScenario scenario = $this$checkImpl.getCustomScenarios().get(i);
            this.validate(scenario);
            this.reporter.logIteration(i + 1, $this$checkImpl.getCustomScenarios().size(), scenario);
            Intrinsics.checkNotNullExpressionValue((Object)verifier, (String)"verifier");
            LincheckFailure lincheckFailure = failure = this.run(scenario, $this$checkImpl, verifier);
            if (lincheckFailure == null) continue;
            return lincheckFailure;
        }
        Verifier verifier = null;
        verifier = this.createVerifier($this$checkImpl);
        n = $this$checkImpl.getIterations();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            boolean bl = false;
            if ((i2 + 1) % 100 == 0) {
                verifier = this.createVerifier($this$checkImpl);
            }
            ExecutionScenario scenario = exGen.nextExecution();
            Intrinsics.checkNotNullExpressionValue((Object)scenario, (String)"scenario");
            this.validate(scenario);
            this.reporter.logIteration(i2 + 1 + $this$checkImpl.getCustomScenarios().size(), $this$checkImpl.getIterations(), scenario);
            Verifier verifier2 = verifier;
            Intrinsics.checkNotNullExpressionValue((Object)verifier2, (String)"verifier");
            LincheckFailure failure = this.run(scenario, $this$checkImpl, verifier2);
            if (failure == null) continue;
            LincheckFailure minimizedFailedIteration = !$this$checkImpl.getMinimizeFailedScenario() ? failure : this.minimize(failure, $this$checkImpl);
            this.reporter.logFailedIteration(minimizedFailedIteration);
            return minimizedFailedIteration;
        }
        return null;
    }

    private final LincheckFailure minimize(LincheckFailure $this$minimize, CTestConfiguration testCfg) {
        this.reporter.logScenarioMinimization($this$minimize.getScenario());
        LincheckFailure minimizedFailure = $this$minimize;
        while (this.tryMinimize(minimizedFailure.getScenario(), testCfg) != null) {
        }
        return minimizedFailure;
    }

    private final LincheckFailure tryMinimize(ExecutionScenario $this$tryMinimize, CTestConfiguration testCfg) {
        int j;
        int n = $this$tryMinimize.parallelExecution.size() + -1;
        if (0 <= n) {
            do {
                int i;
                int n2;
                if (0 > (n2 = $this$tryMinimize.parallelExecution.get(i = n--).size() + -1)) continue;
                do {
                    LincheckFailure failure;
                    int j2 = n2--;
                    LincheckFailure lincheckFailure = failure = this.tryMinimize($this$tryMinimize, i + 1, j2, testCfg);
                    if (lincheckFailure == null) continue;
                    return lincheckFailure;
                } while (0 <= n2);
            } while (0 <= n);
        }
        if (0 <= (n = $this$tryMinimize.initExecution.size() + -1)) {
            do {
                LincheckFailure failure;
                j = n--;
                LincheckFailure lincheckFailure = failure = this.tryMinimize($this$tryMinimize, 0, j, testCfg);
                if (lincheckFailure == null) continue;
                return lincheckFailure;
            } while (0 <= n);
        }
        if (0 <= (n = $this$tryMinimize.postExecution.size() + -1)) {
            do {
                LincheckFailure failure;
                j = n--;
                LincheckFailure lincheckFailure = failure = this.tryMinimize($this$tryMinimize, $this$tryMinimize.getThreads() + 1, j, testCfg);
                if (lincheckFailure == null) continue;
                return lincheckFailure;
            } while (0 <= n);
        }
        return null;
    }

    private final LincheckFailure tryMinimize(ExecutionScenario $this$tryMinimize, int threadId, int position, CTestConfiguration testCfg) {
        LincheckFailure lincheckFailure;
        ExecutionScenario newScenario = this.copy($this$tryMinimize);
        List actors = TypeIntrinsics.asMutableList(UtilsKt.get(newScenario, threadId));
        actors.remove(position);
        if (actors.isEmpty() && threadId != 0 && threadId != newScenario.getThreads() + 1) {
            newScenario.parallelExecution.remove(threadId - 1);
        }
        if (this.isValid(newScenario)) {
            Verifier verifier = this.createVerifier(testCfg);
            Intrinsics.checkNotNullExpressionValue((Object)verifier, (String)"verifier");
            lincheckFailure = this.run(newScenario, testCfg, verifier);
        } else {
            lincheckFailure = null;
        }
        return lincheckFailure;
    }

    private final LincheckFailure run(ExecutionScenario $this$run, CTestConfiguration testCfg, Verifier verifier) {
        List<Method> list = this.testStructure.validationFunctions;
        Intrinsics.checkNotNullExpressionValue(list, (String)"testStructure.validationFunctions");
        return testCfg.createStrategy(this.testClass, $this$run, list, this.testStructure.stateRepresentation, verifier).run();
    }

    /*
     * WARNING - void declaration
     */
    private final ExecutionScenario copy(ExecutionScenario $this$copy) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list = new ArrayList($this$copy.initExecution);
        List<List<Actor>> list2 = $this$copy.parallelExecution;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"parallelExecution");
        Iterable iterable = list2;
        List list3 = list;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list4 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArrayList((Collection)it));
        }
        List list5 = new ArrayList($this$copy.postExecution);
        List list6 = (List)destination$iv$iv;
        List list7 = list3;
        return new ExecutionScenario(list7, list6, list5);
    }

    private final boolean isValid(ExecutionScenario $this$isValid) {
        return !this.isParallelPartEmpty($this$isValid) && (!$this$isValid.hasSuspendableActors() || !this.getHasSuspendableActorsInInitPart($this$isValid) && !this.getHasPostPartAndSuspendableActors($this$isValid));
    }

    private final void validate(ExecutionScenario $this$validate) {
        if (!(!this.isParallelPartEmpty($this$validate))) {
            boolean $i$a$-require-LinChecker$validate$42 = false;
            String $i$a$-require-LinChecker$validate$42 = "The generated scenario has empty parallel part";
            throw new IllegalArgumentException($i$a$-require-LinChecker$validate$42.toString());
        }
        if ($this$validate.hasSuspendableActors()) {
            if (!(!this.getHasSuspendableActorsInInitPart($this$validate))) {
                boolean $i$a$-require-LinChecker$validate$52 = false;
                String $i$a$-require-LinChecker$validate$52 = "The generated scenario for the test class with suspendable methods contains suspendable actors in initial part";
                throw new IllegalArgumentException($i$a$-require-LinChecker$validate$52.toString());
            }
            if (!(!this.getHasPostPartAndSuspendableActors($this$validate))) {
                boolean bl = false;
                String string = "The generated scenario  for the test class with suspendable methods has non-empty post part";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    private final boolean getHasSuspendableActorsInInitPart(ExecutionScenario $this$hasSuspendableActorsInInitPart) {
        return $this$hasSuspendableActorsInInitPart.initExecution.stream().anyMatch(arg_0 -> LinChecker._get_hasSuspendableActorsInInitPart_$lambda-6((KProperty1)hasSuspendableActorsInInitPart.1.INSTANCE, arg_0));
    }

    private final boolean getHasPostPartAndSuspendableActors(ExecutionScenario $this$hasPostPartAndSuspendableActors) {
        return $this$hasPostPartAndSuspendableActors.parallelExecution.stream().anyMatch(LinChecker::_get_hasPostPartAndSuspendableActors_$lambda-8) && $this$hasPostPartAndSuspendableActors.postExecution.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isParallelPartEmpty(ExecutionScenario $this$isParallelPartEmpty) {
        void $this$mapTo$iv$iv;
        List<List<Actor>> list = $this$isParallelPartEmpty.parallelExecution;
        Intrinsics.checkNotNullExpressionValue(list, (String)"parallelExecution");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.size());
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)) == 0;
    }

    private final Verifier createVerifier(CTestConfiguration $this$createVerifier) {
        Object[] objectArray = new Class[]{Class.class};
        Constructor<? extends Verifier> constructor = $this$createVerifier.getVerifierClass().getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{$this$createVerifier.getSequentialSpecification()};
        return constructor.newInstance(objectArray);
    }

    private final ExecutionGenerator createExecutionGenerator(CTestConfiguration $this$createExecutionGenerator, RandomProvider randomProvider) {
        Object[] objectArray = new Class[]{CTestConfiguration.class, CTestStructure.class, RandomProvider.class};
        Constructor<? extends ExecutionGenerator> constructor = $this$createExecutionGenerator.getGeneratorClass().getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{$this$createExecutionGenerator, this.testStructure, randomProvider};
        return constructor.newInstance(objectArray);
    }

    private static final boolean _get_hasSuspendableActorsInInitPart_$lambda-6(KProperty1 $tmp0, Actor p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final boolean _get_hasPostPartAndSuspendableActors_$lambda-8$lambda-7(Actor it) {
        return it.isSuspendable();
    }

    private static final boolean _get_hasPostPartAndSuspendableActors_$lambda-8(List actors) {
        return actors.stream().anyMatch(LinChecker::_get_hasPostPartAndSuspendableActors_$lambda-8$lambda-7);
    }

    @JvmStatic
    @JvmOverloads
    public static final void check(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
        Companion.check(testClass, options);
    }

    @JvmStatic
    @JvmOverloads
    public static final void check(@NotNull Class<?> testClass) {
        Companion.check(testClass);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0012\b\u0002\u0010\t\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlinx/lincheck/LinChecker$Companion;", "", "()V", "VERIFIER_REFRESH_CYCLE", "", "check", "", "testClass", "Ljava/lang/Class;", "options", "Lorg/jetbrains/kotlinx/lincheck/Options;", "lincheck"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void check(@NotNull Class<?> testClass, @Nullable Options<?, ?> options) {
            Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
            new LinChecker(testClass, options).check();
        }

        public static /* synthetic */ void check$default(Companion companion, Class clazz, Options options, int n, Object object) {
            if ((n & 2) != 0) {
                options = null;
            }
            companion.check(clazz, options);
        }

        @JvmStatic
        @JvmOverloads
        public final void check(@NotNull Class<?> testClass) {
            Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
            org.jetbrains.kotlinx.lincheck.LinChecker$Companion.check$default(this, testClass, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

