/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.lookup;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.kover.api.KoverSourceSetFilter;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH$J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Lkotlinx/kover/lookup/LookupAdapter;", "", "()V", "filterSourceSet", "", "name", "", "sourceSetFilters", "Lkotlinx/kover/api/KoverSourceSetFilter;", "lookup", "Lkotlinx/kover/lookup/LookupAdapter$Dirs;", "project", "Lorg/gradle/api/Project;", "lookupSafe", "Dirs", "kover"})
public abstract class LookupAdapter {
    @NotNull
    protected abstract Dirs lookup(@NotNull Project var1, @NotNull KoverSourceSetFilter var2);

    @NotNull
    public final Dirs lookupSafe(@NotNull Project project, @NotNull KoverSourceSetFilter sourceSetFilters) {
        Dirs dirs;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceSetFilters, (String)"sourceSetFilters");
        try {
            dirs = this.lookup(project, sourceSetFilters);
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (!(throwable instanceof NoSuchMethodError || throwable instanceof NoSuchFieldError || throwable instanceof ClassNotFoundException || throwable instanceof NoClassDefFoundError)) {
                throw e;
            }
            project.getLogger().info("Problem occurred in Kover source set adapter", e);
            dirs = new Dirs(null, null, 3, null);
        }
        return dirs;
    }

    protected final boolean filterSourceSet(@NotNull String name, @NotNull KoverSourceSetFilter sourceSetFilters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)sourceSetFilters, (String)"sourceSetFilters");
        if (sourceSetFilters.getExcludes().contains(name)) {
            return false;
        }
        return !sourceSetFilters.getExcludeTests() || !Intrinsics.areEqual((Object)name, (Object)"test") && !StringsKt.endsWith$default((String)name, (String)"Test", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"test", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"androidTest", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lkotlinx/kover/lookup/LookupAdapter$Dirs;", "", "sources", "", "Ljava/io/File;", "outputs", "(Ljava/util/List;Ljava/util/List;)V", "getOutputs", "()Ljava/util/List;", "getSources", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kover"})
    public static final class Dirs {
        @NotNull
        private final List<File> sources;
        @NotNull
        private final List<File> outputs;

        @NotNull
        public final List<File> getSources() {
            return this.sources;
        }

        @NotNull
        public final List<File> getOutputs() {
            return this.outputs;
        }

        public Dirs(@NotNull List<? extends File> sources, @NotNull List<? extends File> outputs) {
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            this.sources = sources;
            this.outputs = outputs;
        }

        public /* synthetic */ Dirs(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            this(list, list2);
        }

        public Dirs() {
            this(null, null, 3, null);
        }

        @NotNull
        public final List<File> component1() {
            return this.sources;
        }

        @NotNull
        public final List<File> component2() {
            return this.outputs;
        }

        @NotNull
        public final Dirs copy(@NotNull List<? extends File> sources, @NotNull List<? extends File> outputs) {
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            return new Dirs(sources, outputs);
        }

        public static /* synthetic */ Dirs copy$default(Dirs dirs, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = dirs.sources;
            }
            if ((n & 2) != 0) {
                list2 = dirs.outputs;
            }
            return dirs.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "Dirs(sources=" + this.sources + ", outputs=" + this.outputs + ")";
        }

        public int hashCode() {
            List<File> list = this.sources;
            List<File> list2 = this.outputs;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Dirs)) break block3;
                    Dirs dirs = (Dirs)object;
                    if (!Intrinsics.areEqual(this.sources, dirs.sources) || !Intrinsics.areEqual(this.outputs, dirs.outputs)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

