/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.engines.commons;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.api.CoverageEngineVariant;
import kotlinx.kover.api.CoverageEngineVendor;
import kotlinx.kover.api.KoverClassFilter;
import kotlinx.kover.engines.commons.AgentFilters;
import kotlinx.kover.engines.commons.EngineManager;
import kotlinx.kover.engines.commons.ReportVerificationRule;
import kotlinx.kover.engines.intellij.IntellijAgentKt;
import kotlinx.kover.engines.intellij.IntellijEngineKt;
import kotlinx.kover.engines.intellij.IntellijReportsKt;
import kotlinx.kover.engines.intellij.IntellijVerificationKt;
import kotlinx.kover.engines.jacoco.JacocoAgentKt;
import kotlinx.kover.engines.jacoco.JacocoEngineKt;
import kotlinx.kover.engines.jacoco.JacocoReportsKt;
import kotlinx.kover.tasks.EngineDetails;
import kotlinx.kover.tasks.ProjectFiles;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017JN\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u000bJJ\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000f\u00a8\u0006&"}, d2={"Lkotlinx/kover/engines/commons/EngineManager;", "", "()V", "buildAgentArgs", "", "", "details", "Lkotlinx/kover/tasks/EngineDetails;", "task", "Lorg/gradle/api/Task;", "reportFile", "Ljava/io/File;", "filters", "Lkotlinx/kover/engines/commons/AgentFilters;", "dependencies", "", "engineVariant", "Lkotlinx/kover/api/CoverageEngineVariant;", "findJarFile", "variant", "config", "Lorg/gradle/api/artifacts/Configuration;", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "report", "", "exec", "Lorg/gradle/process/ExecOperations;", "projectFiles", "", "Lkotlinx/kover/tasks/ProjectFiles;", "classFilter", "Lkotlinx/kover/api/KoverClassFilter;", "xmlFile", "htmlDir", "verify", "rules", "Lkotlinx/kover/engines/commons/ReportVerificationRule;", "kover"})
public final class EngineManager {
    @NotNull
    public static final EngineManager INSTANCE;

    @NotNull
    public final List<String> buildAgentArgs(@NotNull EngineDetails details, @NotNull Task task2, @NotNull File reportFile, @NotNull AgentFilters filters) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)reportFile, (String)"reportFile");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        if (details.getVariant().getVendor$kover() == CoverageEngineVendor.INTELLIJ) {
            list = IntellijAgentKt.buildIntellijAgentJvmArgs(task2, details.getJarFile(), reportFile, filters);
        } else {
            reportFile.getParentFile().mkdirs();
            list = JacocoAgentKt.buildJacocoAgentJvmArgs(task2, details.getJarFile(), reportFile, filters);
        }
        return list;
    }

    public final void report(@NotNull EngineDetails details, @NotNull Task task2, @NotNull ExecOperations exec, @NotNull Map<String, ? extends ProjectFiles> projectFiles, @NotNull KoverClassFilter classFilter, @Nullable File xmlFile, @Nullable File htmlDir) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        Intrinsics.checkNotNullParameter(projectFiles, (String)"projectFiles");
        Intrinsics.checkNotNullParameter((Object)classFilter, (String)"classFilter");
        if (details.getVariant().getVendor$kover() == CoverageEngineVendor.INTELLIJ) {
            IntellijReportsKt.intellijReport(task2, exec, projectFiles, classFilter, xmlFile, htmlDir, details.getClasspath());
        } else {
            JacocoReportsKt.jacocoReport(task2, projectFiles, xmlFile, htmlDir, details.getClasspath());
        }
    }

    @Nullable
    public final String verify(@NotNull EngineDetails details, @NotNull Task task2, @NotNull ExecOperations exec, @NotNull Map<String, ? extends ProjectFiles> projectFiles, @NotNull KoverClassFilter classFilter, @NotNull List<ReportVerificationRule> rules) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
        Intrinsics.checkNotNullParameter(projectFiles, (String)"projectFiles");
        Intrinsics.checkNotNullParameter((Object)classFilter, (String)"classFilter");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        return details.getVariant().getVendor$kover() == CoverageEngineVendor.INTELLIJ ? IntellijVerificationKt.intellijVerification(task2, exec, projectFiles, classFilter, rules, details.getClasspath()) : JacocoReportsKt.jacocoVerification(task2, projectFiles, rules, details.getClasspath());
    }

    @NotNull
    public final File findJarFile(@NotNull CoverageEngineVariant variant, @NotNull Configuration config, @NotNull ArchiveOperations archiveOperations) {
        File file;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)archiveOperations, (String)"archiveOperations");
        if (variant.getVendor$kover() == CoverageEngineVendor.INTELLIJ) {
            FileCollection fileCollection = config.fileCollection((Spec)findJarFile.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"config.fileCollection { \u2026ntellij-coverage-agent\" }");
            File file2 = fileCollection.getSingleFile();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"config.fileCollection { \u2026erage-agent\" }.singleFile");
        } else {
            FileCollection fileCollection = config.fileCollection((Spec)findJarFile.fatJar.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"config.fileCollection { \u2026e == \"org.jacoco.agent\" }");
            File fatJar2 = fileCollection.getSingleFile();
            FileCollection fileCollection2 = archiveOperations.zipTree((Object)fatJar2).filter((Spec)findJarFile.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"archiveOperations.zipTre\u2026me == \"jacocoagent.jar\" }");
            File file3 = fileCollection2.getSingleFile();
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"archiveOperations.zipTre\u2026coagent.jar\" }.singleFile");
        }
        return file;
    }

    @NotNull
    public final List<String> dependencies(@NotNull CoverageEngineVariant engineVariant) {
        Intrinsics.checkNotNullParameter((Object)engineVariant, (String)"engineVariant");
        return engineVariant.getVendor$kover() == CoverageEngineVendor.INTELLIJ ? IntellijEngineKt.getIntellijDependencies(engineVariant.getVersion$kover()) : JacocoEngineKt.getJacocoDependencies(engineVariant.getVersion$kover());
    }

    private EngineManager() {
    }

    static {
        EngineManager engineManager;
        INSTANCE = engineManager = new EngineManager();
    }
}

