/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.api.CoverageEngine;
import kotlinx.kover.api.VerificationRule;
import kotlinx.kover.engines.intellij.IntelliJCoverageKt;
import kotlinx.kover.engines.jacoco.JacocoCoverageKt;
import kotlinx.kover.tasks.KoverCommonTask;
import kotlinx.kover.tasks.KoverXmlReportTask;
import kotlinx.kover.tasks.VerificationRuleImpl;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\u0014\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\b\u0010\u0010\u001a\u00020\u000bH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/kover/tasks/KoverVerificationTask;", "Lkotlinx/kover/tasks/KoverCommonTask;", "()V", "rules", "", "Lkotlinx/kover/api/VerificationRule;", "getRules", "()Ljava/util/List;", "rulesInternal", "", "intellij", "", "jacoco", "rule", "configureRule", "Lorg/gradle/api/Action;", "verify", "kover"})
public class KoverVerificationTask
extends KoverCommonTask {
    @NotNull
    private final List<VerificationRule> rulesInternal;

    public KoverVerificationTask() {
        boolean bl = false;
        this.rulesInternal = new ArrayList();
    }

    @Nested
    @NotNull
    public final List<VerificationRule> getRules() {
        return this.rulesInternal;
    }

    public final void rule(@NotNull Action<VerificationRule> configureRule) {
        Intrinsics.checkNotNullParameter(configureRule, (String)"configureRule");
        KoverVerificationTask koverVerificationTask = this;
        Collection collection = koverVerificationTask.rulesInternal;
        Object object = new Object[]{this.getProject().getObjects()};
        object = this.getProject().getObjects().newInstance(VerificationRuleImpl.class, object);
        boolean bl = false;
        boolean bl2 = false;
        VerificationRuleImpl it = (VerificationRuleImpl)object;
        boolean bl3 = false;
        configureRule.execute((Object)it);
        bl = false;
        collection.add(object);
    }

    @TaskAction
    public final void verify() {
        if (this.getCoverageEngine$kover().get() == CoverageEngine.INTELLIJ) {
            this.intellij();
        } else {
            this.jacoco();
        }
    }

    private final void intellij() {
        Object object = (KoverXmlReportTask)((Object)this.getProject().getTasks().withType(KoverXmlReportTask.class).findByName("koverXmlReport"));
        if (object == null) {
            throw new GradleException("Kover: task 'koverXmlReport' not exists but it is required for verification");
        }
        KoverXmlReportTask koverXmlReportTask = object;
        KoverXmlReportTask xmlReport = koverXmlReportTask;
        File xmlFile = ((RegularFile)xmlReport.getXmlReportFile().get()).getAsFile();
        if (!xmlFile.exists()) {
            xmlFile = new File(this.getTemporaryDir(), "counters.xml");
            Task task = (Task)this;
            object = xmlReport.getBinaryReportFiles().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xmlReport.binaryReportFiles.get()");
            Iterable iterable = (Iterable)object;
            object = xmlReport.getSrcDirs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xmlReport.srcDirs.get()");
            Iterable iterable2 = (Iterable)object;
            object = xmlReport.getOutputDirs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xmlReport.outputDirs.get()");
            Iterable iterable3 = (Iterable)object;
            object = xmlReport.getClasspath$kover().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xmlReport.classpath.get()");
            IntelliJCoverageKt.intellijReport(task, iterable, iterable2, iterable3, xmlFile, null, (FileCollection)object);
        }
        Task task = (Task)this;
        object = xmlFile;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xmlFile");
        IntelliJCoverageKt.intellijVerification(task, (File)object, (Iterable<? extends VerificationRule>)this.rulesInternal);
    }

    private final void jacoco() {
        Task task = (Task)this;
        Object object = this.getBinaryReportFiles().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binaryReportFiles.get()");
        Iterable iterable = (Iterable)object;
        object = this.getSrcDirs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"srcDirs.get()");
        Iterable iterable2 = (Iterable)object;
        object = this.getOutputDirs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputDirs.get()");
        Iterable iterable3 = (Iterable)object;
        object = this.getClasspath$kover().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classpath.get()");
        JacocoCoverageKt.jacocoVerification(task, iterable, iterable2, iterable3, (FileCollection)object, (Iterable<? extends VerificationRule>)this.rulesInternal);
    }
}

