/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tools.jacoco;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.commons.ReportContext;
import kotlinx.kover.gradle.plugin.commons.VerificationBound;
import kotlinx.kover.gradle.plugin.commons.VerificationRule;
import kotlinx.kover.gradle.plugin.dsl.AggregationType;
import kotlinx.kover.gradle.plugin.dsl.CoverageUnit;
import kotlinx.kover.gradle.plugin.dsl.GroupingEntityType;
import kotlinx.kover.gradle.plugin.tools.jacoco.CommonJacocoParameters;
import kotlinx.kover.gradle.plugin.tools.jacoco.CommonsKt;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoRuleWrapper;
import kotlinx.kover.gradle.plugin.tools.jacoco.JacocoVerifyAction;
import kotlinx.kover.gradle.plugin.tools.jacoco.VerifyParameters;
import kotlinx.kover.gradle.plugin.tools.kover.KoverFeaturesIntegrationKt;
import kotlinx.kover.gradle.plugin.util.UtilKt;
import org.gradle.api.Action;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.check.Limit;
import org.jacoco.report.check.Rule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\n\u001a\u00020\u000b*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a\"\u0010\r\u001a\u00020\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011*\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0017*\u00020\u0018H\u0002\u001a\u0010\u0010\u0015\u001a\u00060\u0019j\u0002`\u001a*\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\n\u0010\u001b\"\u00020\u00192\u00020\u0019\u00a8\u0006\u001c"}, d2={"errorMessageRegex", "Lkotlin/text/Regex;", "asAggType", "Lkotlinx/kover/gradle/plugin/dsl/AggregationType;", "", "line", "asCoverageUnit", "Lkotlinx/kover/gradle/plugin/dsl/CoverageUnit;", "asIsMax", "", "asValue", "Ljava/math/BigDecimal;", "aggregationType", "doJacocoVerify", "", "Lkotlinx/kover/gradle/plugin/commons/ReportContext;", "rules", "", "Lkotlinx/kover/gradle/plugin/commons/VerificationRule;", "output", "Ljava/io/File;", "toJacoco", "Lkotlinx/kover/gradle/plugin/tools/jacoco/JacocoRuleWrapper;", "Lorg/jacoco/report/check/Limit;", "Lkotlinx/kover/gradle/plugin/commons/VerificationBound;", "Lorg/jacoco/report/check/Rule;", "Lkotlinx/kover/gradle/plugin/tools/jacoco/JacocoRule;", "JacocoRule", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nVerification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Verification.kt\nkotlinx/kover/gradle/plugin/tools/jacoco/VerificationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1557#2:214\n1628#2,3:215\n1557#2:218\n1628#2,3:219\n*S KotlinDebug\n*F\n+ 1 Verification.kt\nkotlinx/kover/gradle/plugin/tools/jacoco/VerificationKt\n*L\n117#1:214\n117#1:215,3\n129#1:218\n129#1:219,3\n*E\n"})
public final class VerificationKt {
    @NotNull
    private static final Regex errorMessageRegex = new Regex("Rule violated for (\\w+) (.+): (\\w+) (.+) is ([\\d\\.]+), but expected (\\w+) is ([\\d\\.]+)");

    public static final void doJacocoVerify(@NotNull ReportContext $this$doJacocoVerify, @NotNull List<? extends VerificationRule> rules, @NotNull File output) {
        Intrinsics.checkNotNullParameter((Object)$this$doJacocoVerify, (String)"<this>");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        WorkQueue workQueue2 = $this$doJacocoVerify.getServices().getWorkerExecutor().classLoaderIsolation(new Action($this$doJacocoVerify){
            final /* synthetic */ ReportContext $this_doJacocoVerify;
            {
                this.$this_doJacocoVerify = $receiver;
            }

            public final void execute(ClassLoaderWorkerSpec $this$classLoaderIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$classLoaderIsolation, (String)"$this$classLoaderIsolation");
                Object[] objectArray = new Object[]{this.$this_doJacocoVerify.getClasspath()};
                $this$classLoaderIsolation.getClasspath().from(objectArray);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)workQueue2, (String)"ReportContext.doJacocoVe\u2026coVerify.classpath)\n    }");
        WorkQueue workQueue3 = workQueue2;
        workQueue3.submit(JacocoVerifyAction.class, new Action(output, rules, $this$doJacocoVerify){
            final /* synthetic */ File $output;
            final /* synthetic */ List<VerificationRule> $rules;
            final /* synthetic */ ReportContext $this_doJacocoVerify;
            {
                this.$output = $output;
                this.$rules = $rules;
                this.$this_doJacocoVerify = $receiver;
            }

            public final void execute(VerifyParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                $this$submit.getOutputFile().set(this.$output);
                $this$submit.getRulesProperty().convention((Iterable)this.$rules);
                CommonsKt.fillCommonParameters((CommonJacocoParameters)$this$submit, this.$this_doJacocoVerify);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List<JacocoRuleWrapper> toJacoco(List<? extends VerificationRule> $this$toJacoco) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toJacoco;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void rule;
            VerificationRule verificationRule = (VerificationRule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new JacocoRuleWrapper(VerificationKt.toJacoco((VerificationRule)rule), KoverFeaturesIntegrationKt.convert((VerificationRule)rule)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Rule toJacoco(VerificationRule $this$toJacoco) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ICoverageNode.ElementType elementType;
        Rule rule = new Rule();
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toJacoco.getEntityType().ordinal()]) {
            case 1: {
                elementType = ICoverageNode.ElementType.BUNDLE;
                break;
            }
            case 2: {
                elementType = ICoverageNode.ElementType.CLASS;
                break;
            }
            case 3: {
                elementType = ICoverageNode.ElementType.PACKAGE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        rule.setElement(elementType);
        Iterable iterable = $this$toJacoco.getBounds$kover_gradle_plugin();
        Rule rule2 = rule;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bound;
            VerificationBound verificationBound = (VerificationBound)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(VerificationKt.toJacoco((VerificationBound)bound));
        }
        rule2.setLimits((List)destination$iv$iv);
        return rule;
    }

    private static final Limit toJacoco(VerificationBound $this$toJacoco) {
        ICoverageNode.CounterEntity counterEntity;
        Limit limit = new Limit();
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toJacoco.getMetric().ordinal()]) {
            case 1: {
                counterEntity = ICoverageNode.CounterEntity.LINE;
                break;
            }
            case 2: {
                counterEntity = ICoverageNode.CounterEntity.INSTRUCTION;
                break;
            }
            case 3: {
                counterEntity = ICoverageNode.CounterEntity.BRANCH;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ICoverageNode.CounterEntity entity = counterEntity;
        limit.setCounter(entity.name());
        BigDecimal min = $this$toJacoco.getMinValue();
        BigDecimal max = $this$toJacoco.getMaxValue();
        ICounter.CounterValue value = null;
        switch (WhenMappings.$EnumSwitchMapping$2[$this$toJacoco.getAggregation().ordinal()]) {
            case 1: {
                value = ICounter.CounterValue.COVEREDCOUNT;
                break;
            }
            case 2: {
                value = ICounter.CounterValue.MISSEDCOUNT;
                break;
            }
            case 3: {
                value = ICounter.CounterValue.COVEREDRATIO;
                BigDecimal bigDecimal = min;
                min = bigDecimal != null && (bigDecimal = bigDecimal.divide(UtilKt.getONE_HUNDRED())) != null ? bigDecimal.setScale(4) : null;
                BigDecimal bigDecimal2 = max;
                max = bigDecimal2 != null && (bigDecimal2 = bigDecimal2.divide(UtilKt.getONE_HUNDRED())) != null ? bigDecimal2.setScale(4) : null;
                break;
            }
            case 4: {
                value = ICounter.CounterValue.MISSEDRATIO;
                BigDecimal bigDecimal = min;
                min = bigDecimal != null && (bigDecimal = bigDecimal.divide(UtilKt.getONE_HUNDRED())) != null ? bigDecimal.setScale(4) : null;
                BigDecimal bigDecimal3 = max;
                max = bigDecimal3 != null && (bigDecimal3 = bigDecimal3.divide(UtilKt.getONE_HUNDRED())) != null ? bigDecimal3.setScale(4) : null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        limit.setValue(value.name());
        if (min != null) {
            limit.setMinimum(min.toPlainString());
        }
        if (max != null) {
            limit.setMaximum(max.toPlainString());
        }
        return limit;
    }

    private static final CoverageUnit asCoverageUnit(String $this$asCoverageUnit, String line) {
        CoverageUnit coverageUnit;
        switch ($this$asCoverageUnit) {
            case "lines": {
                coverageUnit = CoverageUnit.LINE;
                break;
            }
            case "instructions": {
                coverageUnit = CoverageUnit.INSTRUCTION;
                break;
            }
            case "branches": {
                coverageUnit = CoverageUnit.BRANCH;
                break;
            }
            default: {
                throw new KoverCriticalException("Unknown JaCoCo metric type '" + $this$asCoverageUnit + "' in verification error:\n" + line, null, 2, null);
            }
        }
        return coverageUnit;
    }

    private static final AggregationType asAggType(String $this$asAggType, String line) {
        AggregationType aggregationType;
        switch ($this$asAggType) {
            case "covered ratio": {
                aggregationType = AggregationType.COVERED_PERCENTAGE;
                break;
            }
            case "missed ratio": {
                aggregationType = AggregationType.MISSED_PERCENTAGE;
                break;
            }
            case "covered count": {
                aggregationType = AggregationType.COVERED_COUNT;
                break;
            }
            case "missed count": {
                aggregationType = AggregationType.MISSED_COUNT;
                break;
            }
            default: {
                throw new KoverCriticalException("Unknown JaCoCo aggregation type '" + $this$asAggType + "' in verification error:\n" + line, null, 2, null);
            }
        }
        return aggregationType;
    }

    private static final boolean asIsMax(String $this$asIsMax, String line) {
        boolean bl;
        String string = $this$asIsMax;
        if (Intrinsics.areEqual((Object)string, (Object)"minimum")) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)string, (Object)"maximum")) {
            bl = true;
        } else {
            throw new KoverCriticalException("Unknown JaCoCo direction '" + $this$asIsMax + "' in verification error:\n" + line, null, 2, null);
        }
        return bl;
    }

    private static final BigDecimal asValue(String $this$asValue, String line, AggregationType aggregationType) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = StringsKt.toBigDecimalOrNull((String)$this$asValue);
        if (bigDecimal2 == null) {
            throw new KoverCriticalException("Illegal JaCoCo metric value '" + $this$asValue + "' in verification error:\n" + line, null, 2, null);
        }
        BigDecimal value = bigDecimal2;
        if (aggregationType.isPercentage()) {
            BigDecimal bigDecimal3 = value.multiply(UtilKt.getONE_HUNDRED());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
            BigDecimal bigDecimal4 = bigDecimal3.stripTrailingZeros();
            bigDecimal = bigDecimal4;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"{\n        (value * ONE_H\u2026tripTrailingZeros()\n    }");
        } else {
            bigDecimal = value;
        }
        return bigDecimal;
    }

    public static final /* synthetic */ List access$toJacoco(List $receiver) {
        return VerificationKt.toJacoco($receiver);
    }

    public static final /* synthetic */ Regex access$getErrorMessageRegex$p() {
        return errorMessageRegex;
    }

    public static final /* synthetic */ CoverageUnit access$asCoverageUnit(String $receiver, String line) {
        return VerificationKt.asCoverageUnit($receiver, line);
    }

    public static final /* synthetic */ AggregationType access$asAggType(String $receiver, String line) {
        return VerificationKt.asAggType($receiver, line);
    }

    public static final /* synthetic */ BigDecimal access$asValue(String $receiver, String line, AggregationType aggregationType) {
        return VerificationKt.asValue($receiver, line, aggregationType);
    }

    public static final /* synthetic */ boolean access$asIsMax(String $receiver, String line) {
        return VerificationKt.asIsMax($receiver, line);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[GroupingEntityType.values().length];
            try {
                nArray[GroupingEntityType.APPLICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupingEntityType.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GroupingEntityType.PACKAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CoverageUnit.values().length];
            try {
                nArray[CoverageUnit.LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageUnit.INSTRUCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageUnit.BRANCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[AggregationType.values().length];
            try {
                nArray[AggregationType.COVERED_COUNT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.MISSED_COUNT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.COVERED_PERCENTAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AggregationType.MISSED_PERCENTAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

