/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.locators;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.appliers.origin.AllVariantOrigins;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.locators.KotlinAndroidLocatorKt;
import kotlinx.kover.gradle.plugin.locators.KotlinJvmLocatorKt;
import kotlinx.kover.gradle.plugin.locators.KotlinMultiPlatformLocatorKt;
import kotlinx.kover.gradle.plugin.util.DynamicBean;
import kotlinx.kover.gradle.plugin.util.DynamicBeanKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.AppliedPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlinx/kover/gradle/plugin/locators/ProvidedVariantsLocator;", "", "project", "Lorg/gradle/api/Project;", "callback", "Lkotlin/Function1;", "Lkotlinx/kover/gradle/plugin/appliers/origin/AllVariantOrigins;", "Lkotlin/ParameterName;", "name", "sources", "", "(Lorg/gradle/api/Project;Lkotlin/jvm/functions/Function1;)V", "finilized", "", "reasons", "", "", "androidEnqueue", "reason", "enqueue", "finalize", "scheduleDequeue", "simpleEnqueue", "kover-gradle-plugin"})
public final class ProvidedVariantsLocator {
    @NotNull
    private final Project project;
    @NotNull
    private final Function1<AllVariantOrigins, Unit> callback;
    @NotNull
    private final Set<String> reasons;
    private boolean finilized;

    public ProvidedVariantsLocator(@NotNull Project project, @NotNull Function1<? super AllVariantOrigins, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.project = project;
        this.callback = callback;
        this.reasons = new LinkedHashSet();
        this.simpleEnqueue("no-plugin");
        this.project.getPluginManager().withPlugin("kotlin", new Action(){

            public final void execute(AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.simpleEnqueue("kotlin");
            }
        });
        this.project.getPluginManager().withPlugin("kotlin-multiplatform", new Action(){

            public final void execute(AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.simpleEnqueue("kotlin-multiplatform");
            }
        });
        this.project.getPluginManager().withPlugin("kotlin-android", new Action(){

            public final void execute(AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.simpleEnqueue("kotlin-android");
            }
        });
        this.project.getPluginManager().withPlugin("com.android.application", new Action(){

            public final void execute(AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.androidEnqueue("com.android.application");
            }
        });
        this.project.getPluginManager().withPlugin("com.android.library", new Action(){

            public final void execute(AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.androidEnqueue("com.android.library");
            }
        });
        this.project.getPluginManager().withPlugin("com.android.dynamic-feature", new Action(){

            public final void execute(AppliedPlugin $this$withPlugin) {
                Intrinsics.checkNotNullParameter((Object)$this$withPlugin, (String)"$this$withPlugin");
                this.androidEnqueue("com.android.dynamic-feature");
            }
        });
    }

    private final void simpleEnqueue(String reason) {
        this.enqueue(reason);
        this.scheduleDequeue(reason);
    }

    private final void androidEnqueue(String reason) {
        Object[] objectArray;
        DynamicBean androidComponents;
        this.enqueue(reason);
        Action dequeueAction2 = new Action(this, reason){
            final /* synthetic */ ProvidedVariantsLocator this$0;
            final /* synthetic */ String $reason;
            {
                this.this$0 = $receiver;
                this.$reason = $reason;
            }

            public final void execute(Object $this$Action) {
                Intrinsics.checkNotNullParameter((Object)$this$Action, (String)"$this$Action");
                ProvidedVariantsLocator.access$scheduleDequeue(this.this$0, this.$reason);
            }
        };
        Object object = this.project.getExtensions().findByName("androidComponents");
        DynamicBean dynamicBean = androidComponents = object != null ? DynamicBeanKt.bean(object) : null;
        if (androidComponents != null && androidComponents.hasFunction("finalizeDsl", objectArray = new Object[]{this.callback})) {
            objectArray = new Object[]{dequeueAction2};
            androidComponents.invoke("finalizeDsl", objectArray);
        } else {
            dequeueAction2.execute((Object)Unit.INSTANCE);
        }
    }

    private final void enqueue(String reason) {
        if (this.finilized) {
            throw new KoverCriticalException("Attempt to queue after finalizing.", null, 2, null);
        }
        ((Collection)this.reasons).add(reason);
    }

    private final void scheduleDequeue(String reason) {
        this.project.afterEvaluate(new Action(this, reason){
            final /* synthetic */ ProvidedVariantsLocator this$0;
            final /* synthetic */ String $reason;
            {
                this.this$0 = $receiver;
                this.$reason = $reason;
            }

            public final void execute(Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                if (ProvidedVariantsLocator.access$getReasons$p(this.this$0).isEmpty()) {
                    throw new KoverCriticalException("Error when searching for finalizing configuration variant.", null, 2, null);
                }
                ProvidedVariantsLocator.access$getReasons$p(this.this$0).remove(this.$reason);
                if (ProvidedVariantsLocator.access$getReasons$p(this.this$0).isEmpty()) {
                    ProvidedVariantsLocator.access$finalize(this.this$0);
                }
            }
        });
    }

    private final void finalize() {
        this.finilized = true;
        AllVariantOrigins variants = this.project.getPluginManager().hasPlugin("kotlin") ? KotlinJvmLocatorKt.locateKotlinJvmVariants(this.project) : (this.project.getPluginManager().hasPlugin("kotlin-android") ? KotlinAndroidLocatorKt.locateKotlinAndroidVariants(this.project) : (this.project.getPluginManager().hasPlugin("kotlin-multiplatform") ? KotlinMultiPlatformLocatorKt.locateKotlinMultiplatformVariants(this.project) : new AllVariantOrigins(null, CollectionsKt.emptyList())));
        this.callback.invoke((Object)variants);
    }

    public static final /* synthetic */ void access$scheduleDequeue(ProvidedVariantsLocator $this, String reason) {
        $this.scheduleDequeue(reason);
    }

    public static final /* synthetic */ Set access$getReasons$p(ProvidedVariantsLocator $this) {
        return $this.reasons;
    }

    public static final /* synthetic */ void access$finalize(ProvidedVariantsLocator $this) {
        $this.finalize();
    }
}

