/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.appliers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.kover.gradle.plugin.appliers.KoverContext;
import kotlinx.kover.gradle.plugin.appliers.artifacts.AbstractVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.artifacts.AndroidVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.artifacts.CustomVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.artifacts.JvmVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.artifacts.TotalVariantArtifacts;
import kotlinx.kover.gradle.plugin.appliers.instrumentation.JvmTestTaskConfiguratorKt;
import kotlinx.kover.gradle.plugin.appliers.origin.AllVariantOrigins;
import kotlinx.kover.gradle.plugin.appliers.origin.AndroidVariantOrigin;
import kotlinx.kover.gradle.plugin.appliers.origin.JvmVariantOrigin;
import kotlinx.kover.gradle.plugin.appliers.tasks.VariantReportsSet;
import kotlinx.kover.gradle.plugin.commons.KoverCriticalException;
import kotlinx.kover.gradle.plugin.commons.KoverIllegalConfigException;
import kotlinx.kover.gradle.plugin.commons.ReportVariantType;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverReportSetConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.KoverVariantCreateConfigImpl;
import kotlinx.kover.gradle.plugin.dsl.internal.MergingOptionality;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001c\u0010\r\u001a\u00020\u000e*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"createVariant", "Lkotlinx/kover/gradle/plugin/appliers/artifacts/AndroidVariantArtifacts;", "Lkotlinx/kover/gradle/plugin/appliers/origin/AndroidVariantOrigin;", "koverContext", "Lkotlinx/kover/gradle/plugin/appliers/KoverContext;", "config", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverVariantCreateConfigImpl;", "Lkotlinx/kover/gradle/plugin/appliers/artifacts/JvmVariantArtifacts;", "Lkotlinx/kover/gradle/plugin/appliers/origin/JvmVariantOrigin;", "finalizing", "", "origins", "Lkotlinx/kover/gradle/plugin/appliers/origin/AllVariantOrigins;", "reportsConfig", "Lkotlinx/kover/gradle/plugin/dsl/internal/KoverReportSetConfigImpl;", "variantName", "", "projectPath", "variantConfig", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFinalizeKover.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FinalizeKover.kt\nkotlinx/kover/gradle/plugin/appliers/FinalizeKoverKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n*L\n1#1,189:1\n1863#2,2:190\n1557#2:192\n1628#2,3:193\n1863#2,2:197\n1863#2,2:199\n1863#2,2:209\n1#3:196\n216#4,2:201\n216#4:203\n216#4,2:204\n217#4:206\n216#4,2:207\n216#4,2:211\n50#5:213\n*S KotlinDebug\n*F\n+ 1 FinalizeKover.kt\nkotlinx/kover/gradle/plugin/appliers/FinalizeKoverKt\n*L\n30#1:190,2\n53#1:192\n53#1:193,3\n59#1:197,2\n63#1:199,2\n126#1:209,2\n66#1:201,2\n72#1:203\n83#1:204,2\n72#1:206\n111#1:207,2\n138#1:211,2\n147#1:213\n*E\n"})
public final class FinalizeKoverKt {
    /*
     * WARNING - void declaration
     */
    public static final void finalizing(@NotNull KoverContext $this$finalizing, @NotNull AllVariantOrigins origins) {
        Object element$iv;
        void $this$mapTo$iv$iv;
        JvmVariantArtifacts jvmVariant;
        Object action;
        Intrinsics.checkNotNullParameter((Object)$this$finalizing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)origins, (String)"origins");
        Iterable $this$forEach$iv = $this$finalizing.getProjectExtension().getFinalizeActions$kover_gradle_plugin();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            action = (Function0)element$iv2;
            boolean bl = false;
            try {
                action.invoke();
            }
            catch (Exception e) {
                throw new KoverCriticalException("An error occurred while executing before Kover finalize action", e);
            }
        }
        JvmVariantOrigin jvmVariantOrigin = origins.getJvm();
        JvmVariantArtifacts jvmVariantArtifacts = jvmVariant = jvmVariantOrigin != null ? FinalizeKoverKt.createVariant(jvmVariantOrigin, $this$finalizing, FinalizeKoverKt.variantConfig($this$finalizing, "jvm")) : null;
        if (jvmVariant != null) {
            Project project = $this$finalizing.getProject();
            Provider<CoverageTool> provider = $this$finalizing.getToolProvider();
            String string = $this$finalizing.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
            new VariantReportsSet(project, "jvm", ReportVariantType.JVM, provider, FinalizeKoverKt.reportsConfig($this$finalizing, "jvm", string), $this$finalizing.getReporterClasspath(), (Provider<Boolean>)((Provider)$this$finalizing.getProjectExtension().getKoverDisabled$kover_gradle_plugin())).assign$kover_gradle_plugin(jvmVariant);
        }
        Iterable $this$map$iv = origins.getAndroid();
        boolean $i$f$map = false;
        action = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void providedDetails;
            AndroidVariantOrigin androidVariantOrigin = (AndroidVariantOrigin)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FinalizeKoverKt.createVariant((AndroidVariantOrigin)providedDetails, $this$finalizing, FinalizeKoverKt.variantConfig($this$finalizing, providedDetails.getBuildVariant().getBuildVariant())));
        }
        List androidVariants = (List)destination$iv$iv;
        Map variantArtifacts = new LinkedHashMap();
        JvmVariantArtifacts jvmVariantArtifacts2 = jvmVariant;
        if (jvmVariantArtifacts2 != null) {
            JvmVariantArtifacts it = jvmVariantArtifacts2;
            boolean bl = false;
            variantArtifacts.put("jvm", it);
        }
        Iterable $this$forEach$iv2 = androidVariants;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            AndroidVariantArtifacts it = (AndroidVariantArtifacts)element$iv3;
            boolean bl = false;
            variantArtifacts.put(it.getVariantName(), it);
        }
        TotalVariantArtifacts totalVariant = new TotalVariantArtifacts($this$finalizing.getProject(), $this$finalizing.getToolProvider(), $this$finalizing.getKoverBucketConfiguration(), FinalizeKoverKt.variantConfig($this$finalizing, ""), $this$finalizing.getProjectExtension());
        Map<String, KoverReportSetConfigImpl> $this$forEach$iv3 = variantArtifacts.values();
        boolean $i$f$forEach3 = false;
        Iterator<Object> iterator = $this$forEach$iv3.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            AbstractVariantArtifacts it = (AbstractVariantArtifacts)element$iv;
            boolean bl = false;
            totalVariant.mergeWith(it);
        }
        $this$finalizing.getTotalReports().assign$kover_gradle_plugin(totalVariant);
        $this$forEach$iv3 = $this$finalizing.getProjectExtension().getCurrentProject().getProvidedVariants$kover_gradle_plugin();
        $i$f$forEach3 = false;
        iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String name = (String)it.getKey();
            if (variantArtifacts.containsKey(name)) continue;
            throw new KoverIllegalConfigException("It is unacceptable to configure provided variant '" + name + "', since there is no such variant in the project.\nAcceptable variants: " + variantArtifacts.keySet());
        }
        $this$forEach$iv3 = $this$finalizing.getProjectExtension().getCurrentProject().getCustomVariants$kover_gradle_plugin();
        $i$f$forEach3 = false;
        iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String name = (String)it.getKey();
            KoverVariantCreateConfigImpl config = (KoverVariantCreateConfigImpl)it.getValue();
            if (Intrinsics.areEqual((Object)name, (Object)"jvm")) {
                throw new KoverIllegalConfigException("It is unacceptable to create a custom reports variant 'jvm', because this name is reserved for JVM code");
            }
            if (variantArtifacts.containsKey(name)) {
                throw new KoverIllegalConfigException("It is unacceptable to create a custom reports variant '" + name + "', because this name is reserved for provided Android reports variant.");
            }
            CustomVariantArtifacts customVariant = new CustomVariantArtifacts($this$finalizing.getProject(), name, $this$finalizing.getToolProvider(), $this$finalizing.getKoverBucketConfiguration(), config, $this$finalizing.getProjectExtension());
            Map<String, MergingOptionality> $this$forEach$iv4 = config.getVariantsByName$kover_gradle_plugin();
            boolean $i$f$forEach4 = false;
            Iterator<Map.Entry<String, MergingOptionality>> iterator2 = $this$forEach$iv4.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, MergingOptionality> element$iv4;
                Map.Entry<String, MergingOptionality> entry = element$iv4 = iterator2.next();
                boolean bl2 = false;
                String mergedName = entry.getKey();
                MergingOptionality optionality = entry.getValue();
                AbstractVariantArtifacts mergedVariant = (AbstractVariantArtifacts)variantArtifacts.get(mergedName);
                if (mergedVariant != null) {
                    if (optionality.getWithDependencies()) {
                        customVariant.mergeWithDependencies(mergedVariant);
                        continue;
                    }
                    customVariant.mergeWith(mergedVariant);
                    continue;
                }
                if (optionality.getOptional()) continue;
                throw new KoverIllegalConfigException("Could not find the provided variant '" + mergedName + "' to create a custom variant '" + name + "'.\nSpecify an existing 'jvm' variant or Android build variant name, or delete the merge.");
            }
            variantArtifacts.put(name, customVariant);
            Project project = $this$finalizing.getProject();
            Provider<CoverageTool> provider = $this$finalizing.getToolProvider();
            String string = $this$finalizing.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
            new VariantReportsSet(project, name, ReportVariantType.CUSTOM, provider, FinalizeKoverKt.reportsConfig($this$finalizing, name, string), $this$finalizing.getReporterClasspath(), (Provider<Boolean>)((Provider)$this$finalizing.getProjectExtension().getKoverDisabled$kover_gradle_plugin())).assign$kover_gradle_plugin(customVariant);
        }
        $this$forEach$iv3 = $this$finalizing.getProjectExtension().getCurrentProject().getVariantsToCopy$kover_gradle_plugin();
        $i$f$forEach3 = false;
        iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            AbstractVariantArtifacts originalVariant;
            Object it = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String name = (String)it.getKey();
            String originVariantName = (String)it.getValue();
            if ((AbstractVariantArtifacts)variantArtifacts.get(originVariantName) == null) {
                throw new KoverIllegalConfigException("Cannot create a variant '" + name + "': the original variant '" + originVariantName + "' does not exist.");
            }
            Project project = $this$finalizing.getProject();
            Provider<CoverageTool> provider = $this$finalizing.getToolProvider();
            String string = $this$finalizing.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
            new VariantReportsSet(project, name, ReportVariantType.CUSTOM, provider, FinalizeKoverKt.reportsConfig($this$finalizing, name, string), $this$finalizing.getReporterClasspath(), (Provider<Boolean>)((Provider)$this$finalizing.getProjectExtension().getKoverDisabled$kover_gradle_plugin())).assign$kover_gradle_plugin(originalVariant);
        }
        $this$forEach$iv3 = androidVariants;
        $i$f$forEach3 = false;
        iterator = $this$forEach$iv3.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            AndroidVariantArtifacts androidVariant = (AndroidVariantArtifacts)element$iv;
            boolean bl = false;
            Project project = $this$finalizing.getProject();
            String string = androidVariant.getVariantName();
            Provider<CoverageTool> provider = $this$finalizing.getToolProvider();
            String string2 = androidVariant.getVariantName();
            String string3 = $this$finalizing.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.path");
            new VariantReportsSet(project, string, ReportVariantType.ANDROID, provider, FinalizeKoverKt.reportsConfig($this$finalizing, string2, string3), $this$finalizing.getReporterClasspath(), (Provider<Boolean>)((Provider)$this$finalizing.getProjectExtension().getKoverDisabled$kover_gradle_plugin())).assign$kover_gradle_plugin(androidVariant);
        }
        $this$forEach$iv3 = $this$finalizing.getProjectExtension().getReports().getByName$kover_gradle_plugin();
        $i$f$forEach3 = false;
        iterator = $this$forEach$iv3.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String requestedVariant = (String)object.getKey();
            if (variantArtifacts.containsKey(requestedVariant) || $this$finalizing.getProjectExtension().getCurrentProject().getVariantsToCopy$kover_gradle_plugin().containsKey(requestedVariant)) continue;
            throw new KoverIllegalConfigException("It is not possible to configure the '" + requestedVariant + "' variant because it does not exist");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final KoverVariantCreateConfigImpl variantConfig(KoverContext $this$variantConfig, String variantName) {
        KoverVariantCreateConfigImpl koverVariantCreateConfigImpl = $this$variantConfig.getProjectExtension().getCurrentProject().getCustomVariants$kover_gradle_plugin().get(variantName);
        if (koverVariantCreateConfigImpl == null) {
            void $this$newInstance$iv;
            boolean bl = false;
            ObjectFactory objectFactory = $this$variantConfig.getProjectExtension().getCurrentProject().getObjects();
            Object[] objectArray = new Object[]{variantName};
            Object[] parameters$iv = objectArray;
            boolean $i$f$newInstance = false;
            KoverVariantCreateConfigImpl variantConfig = (KoverVariantCreateConfigImpl)$this$newInstance$iv.newInstance(KoverVariantCreateConfigImpl.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
            variantConfig.deriveFrom$kover_gradle_plugin($this$variantConfig.getProjectExtension().getCurrentProject());
            koverVariantCreateConfigImpl = variantConfig;
        }
        return koverVariantCreateConfigImpl;
    }

    private static final KoverReportSetConfigImpl reportsConfig(KoverContext $this$reportsConfig, String variantName, String projectPath) {
        KoverReportSetConfigImpl koverReportSetConfigImpl = $this$reportsConfig.getProjectExtension().getReports().getByName$kover_gradle_plugin().get(variantName);
        if (koverReportSetConfigImpl == null) {
            boolean bl = false;
            koverReportSetConfigImpl = $this$reportsConfig.getProjectExtension().getReports().createReportSet$kover_gradle_plugin(variantName, projectPath);
        }
        return koverReportSetConfigImpl;
    }

    private static final JvmVariantArtifacts createVariant(JvmVariantOrigin $this$createVariant, KoverContext koverContext, KoverVariantCreateConfigImpl config) {
        JvmTestTaskConfiguratorKt.instrument($this$createVariant.getTests(), koverContext, (Provider<Boolean>)((Provider)koverContext.getProjectExtension().getKoverDisabled$kover_gradle_plugin()), koverContext.getProjectExtension().getCurrentProject());
        return new JvmVariantArtifacts(koverContext.getProject(), koverContext.getToolProvider(), koverContext.getKoverBucketConfiguration(), $this$createVariant, config, koverContext.getProjectExtension());
    }

    private static final AndroidVariantArtifacts createVariant(AndroidVariantOrigin $this$createVariant, KoverContext koverContext, KoverVariantCreateConfigImpl config) {
        JvmTestTaskConfiguratorKt.instrument($this$createVariant.getTests(), koverContext, (Provider<Boolean>)((Provider)koverContext.getProjectExtension().getKoverDisabled$kover_gradle_plugin()), koverContext.getProjectExtension().getCurrentProject());
        return new AndroidVariantArtifacts(koverContext.getProject(), $this$createVariant.getBuildVariant().getBuildVariant(), koverContext.getToolProvider(), koverContext.getKoverBucketConfiguration(), $this$createVariant, config, koverContext.getProjectExtension());
    }
}

