/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.aggregation.settings.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlinx.kover.features.jvm.KoverFeatures;
import kotlinx.kover.gradle.aggregation.commons.artifacts.ArtifactSerializer;
import kotlinx.kover.gradle.aggregation.commons.artifacts.ProjectArtifactInfo;
import kotlinx.kover.gradle.aggregation.settings.tasks.FiltersInput;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00110\u0010*\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0004J\u0014\u0010\u0014\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0004R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\b8EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lkotlinx/kover/gradle/aggregation/settings/tasks/AbstractKoverTask;", "Lorg/gradle/api/DefaultTask;", "()V", "artifacts", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getArtifacts", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "projectPath", "", "getProjectPath", "()Ljava/lang/String;", "rootDir", "Ljava/io/File;", "getRootDir", "()Ljava/io/File;", "data", "", "Lkotlinx/kover/gradle/aggregation/commons/artifacts/ProjectArtifactInfo;", "", "Lorg/gradle/api/file/FileSystemLocation;", "filterProjectSources", "filters", "Lkotlinx/kover/gradle/aggregation/settings/tasks/FiltersInput;", "kover-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractKoverTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKoverTask.kt\nkotlinx/kover/gradle/aggregation/settings/tasks/AbstractKoverTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1557#2:61\n1628#2,3:62\n1557#2:65\n1628#2,3:66\n1202#2,2:69\n1230#2,4:71\n2632#2,3:75\n1755#2,3:78\n*S KotlinDebug\n*F\n+ 1 AbstractKoverTask.kt\nkotlinx/kover/gradle/aggregation/settings/tasks/AbstractKoverTask\n*L\n32#1:61\n32#1:62,3\n33#1:65\n33#1:66,3\n34#1:69,2\n34#1:71,4\n42#1:75,3\n51#1:78,3\n*E\n"})
public abstract class AbstractKoverTask
extends DefaultTask {
    @NotNull
    private final File rootDir;
    @NotNull
    private final String projectPath;

    public AbstractKoverTask() {
        File file = this.getProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        this.rootDir = file;
        String string = this.getProject().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.path");
        this.projectPath = string;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getArtifacts();

    @Internal
    @NotNull
    protected final File getRootDir() {
        return this.rootDir;
    }

    @Internal
    @NotNull
    protected final String getProjectPath() {
        return this.projectPath;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Map<String, ProjectArtifactInfo> data(@NotNull Set<? extends FileSystemLocation> $this$data) {
        void $this$associateByTo$iv$iv;
        File location;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$data, (String)"<this>");
        Iterable $this$map$iv = $this$data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FileSystemLocation fileSystemLocation = (FileSystemLocation)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(location.getAsFile());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            location = (File)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            void var11_16 = file;
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            Reader reader = var11_16;
            reader = new InputStreamReader((InputStream)new FileInputStream((File)((Object)reader)), charset);
            object.add(ArtifactSerializer.INSTANCE.deserialize(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n), this.rootDir));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ProjectArtifactInfo bl = (ProjectArtifactInfo)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getPath(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    @NotNull
    protected final ProjectArtifactInfo filterProjectSources(@NotNull ProjectArtifactInfo $this$filterProjectSources, @NotNull FiltersInput filters) {
        String filter;
        Intrinsics.checkNotNullParameter((Object)$this$filterProjectSources, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Set<String> included = filters.getIncludedProjects();
        Set<String> excluded = filters.getExcludedProjects();
        if (!((Collection)included).isEmpty()) {
            boolean notIncluded;
            block10: {
                boolean bl;
                Iterable $this$none$iv = included;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        filter = (String)element$iv;
                        boolean bl2 = false;
                        if (!new Regex(KoverFeatures.INSTANCE.koverWildcardToRegex(filter)).matches((CharSequence)$this$filterProjectSources.getPath())) continue;
                        bl = false;
                        break block10;
                    }
                    bl = notIncluded = true;
                }
            }
            if (notIncluded) {
                return new ProjectArtifactInfo($this$filterProjectSources.getPath(), $this$filterProjectSources.getReports(), MapsKt.emptyMap());
            }
        }
        if (!((Collection)excluded).isEmpty()) {
            boolean excl;
            block11: {
                boolean bl;
                Iterable $this$any$iv = excluded;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        filter = (String)element$iv;
                        boolean bl3 = false;
                        if (!new Regex(KoverFeatures.INSTANCE.koverWildcardToRegex(filter)).matches((CharSequence)$this$filterProjectSources.getPath())) continue;
                        bl = true;
                        break block11;
                    }
                    bl = excl = false;
                }
            }
            if (excl) {
                return new ProjectArtifactInfo($this$filterProjectSources.getPath(), $this$filterProjectSources.getReports(), MapsKt.emptyMap());
            }
        }
        return $this$filterProjectSources;
    }
}

