/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.aggregation.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.kover.gradle.aggregation.settings.dsl.BoundSettings;
import kotlinx.kover.gradle.aggregation.settings.dsl.VerificationRuleSettings;
import kotlinx.kover.gradle.aggregation.settings.dsl.intern.KoverSettingsExtensionImpl;
import org.gradle.api.Action;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\"\u0010\f\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lkotlinx/kover/gradle/aggregation/settings/KoverParametersProcessor;", "", "()V", "process", "", "settingsExtension", "Lkotlinx/kover/gradle/aggregation/settings/dsl/intern/KoverSettingsExtensionImpl;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "parseCollection", "Lkotlinx/kover/gradle/aggregation/settings/KoverParametersProcessor$ArgCollection;", "", "readAppendableArgument", "Lorg/gradle/api/provider/HasMultipleValues;", "propertyName", "ArgCollection", "kover-gradle-plugin"})
public final class KoverParametersProcessor {
    @NotNull
    public static final KoverParametersProcessor INSTANCE = new KoverParametersProcessor();

    private KoverParametersProcessor() {
    }

    public final void process(@NotNull KoverSettingsExtensionImpl settingsExtension, @NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)settingsExtension, (String)"settingsExtension");
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        Provider provider = providers.gradleProperty("kover");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.gradleProperty(\"kover\")");
        Provider koverProperty = provider;
        if (koverProperty.isPresent()) {
            boolean disabled = StringsKt.equals((String)((String)koverProperty.get()), (String)"false", (boolean)true);
            settingsExtension.getCoverageIsEnabled().set((Object)(!disabled ? 1 : 0));
        }
        Provider provider2 = providers.gradleProperty("kover.verify.warn");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providers.gradleProperty(\"kover.verify.warn\")");
        Provider verifyWarn = provider2;
        if (verifyWarn.isPresent()) {
            Object object = verifyWarn.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"verifyWarn.get()");
            String string = ((String)object).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Boolean bl = StringsKt.toBooleanStrictOrNull((String)string);
            if (bl != null) {
                Boolean bl2 = bl;
                boolean warn = bl2;
                boolean bl3 = false;
                settingsExtension.getReports().getVerify().getWarningInsteadOfFailure().set((Object)warn);
            }
        }
        List ruleSettings = new ArrayList();
        Provider provider3 = providers.gradleProperty("kover.verify.min");
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"providers.gradleProperty(\"kover.verify.min\")");
        Provider minVerify = provider3;
        if (minVerify.isPresent()) {
            Object object = minVerify.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"minVerify.get()");
            Integer n = StringsKt.toIntOrNull((String)((String)object));
            if (n != null) {
                Integer n2 = n;
                int min = ((Number)n2).intValue();
                boolean bl = false;
                ((Collection)ruleSettings).add(new Function1<VerificationRuleSettings, Unit>(min){
                    final /* synthetic */ int $min;
                    {
                        this.$min = $min;
                        super(1);
                    }

                    public final void invoke(VerificationRuleSettings $this$null) {
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        $this$null.bound((Action<BoundSettings>)new Action(this.$min){
                            final /* synthetic */ int $min;
                            {
                                this.$min = $min;
                            }

                            public final void execute(BoundSettings $this$bound) {
                                Intrinsics.checkNotNullParameter((Object)$this$bound, (String)"$this$bound");
                                $this$bound.getMinValue().set((Object)this.$min);
                            }
                        });
                    }
                });
            }
        }
        Provider provider4 = providers.gradleProperty("kover.verify.max");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"providers.gradleProperty(\"kover.verify.max\")");
        Provider maxVerify = provider4;
        if (maxVerify.isPresent()) {
            Object object = maxVerify.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"maxVerify.get()");
            Integer n = StringsKt.toIntOrNull((String)((String)object));
            if (n != null) {
                Integer n3 = n;
                int max = ((Number)n3).intValue();
                boolean bl = false;
                ((Collection)ruleSettings).add(new Function1<VerificationRuleSettings, Unit>(max){
                    final /* synthetic */ int $max;
                    {
                        this.$max = $max;
                        super(1);
                    }

                    public final void invoke(VerificationRuleSettings $this$null) {
                        Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                        $this$null.bound((Action<BoundSettings>)new Action(this.$max){
                            final /* synthetic */ int $max;
                            {
                                this.$max = $max;
                            }

                            public final void execute(BoundSettings $this$bound) {
                                Intrinsics.checkNotNullParameter((Object)$this$bound, (String)"$this$bound");
                                $this$bound.getMaxValue().set((Object)this.$max);
                            }
                        });
                    }
                });
            }
        }
        if (!((Collection)ruleSettings).isEmpty()) {
            settingsExtension.getReports().getVerify().rule("CLI parameters", (Action<VerificationRuleSettings>)new Action(ruleSettings){
                final /* synthetic */ List<Function1<VerificationRuleSettings, Unit>> $ruleSettings;
                {
                    this.$ruleSettings = $ruleSettings;
                }

                public final void execute(VerificationRuleSettings $this$rule) {
                    Intrinsics.checkNotNullParameter((Object)$this$rule, (String)"$this$rule");
                    Iterable $this$forEach$iv = this.$ruleSettings;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Function1 setting = (Function1)element$iv;
                        boolean bl = false;
                        setting.invoke((Object)$this$rule);
                    }
                }
            });
        }
        this.readAppendableArgument((HasMultipleValues<String>)((HasMultipleValues)settingsExtension.getReports().getIncludedProjects()), providers, "kover.projects.includes");
        this.readAppendableArgument((HasMultipleValues<String>)((HasMultipleValues)settingsExtension.getReports().getExcludedProjects()), providers, "kover.projects.excludes");
        this.readAppendableArgument((HasMultipleValues<String>)((HasMultipleValues)settingsExtension.getReports().getExcludedClasses()), providers, "kover.classes.excludes");
        this.readAppendableArgument((HasMultipleValues<String>)((HasMultipleValues)settingsExtension.getReports().getIncludedClasses()), providers, "kover.classes.includes");
        this.readAppendableArgument((HasMultipleValues<String>)((HasMultipleValues)settingsExtension.getReports().getExcludesAnnotatedBy()), providers, "kover.classes.excludesAnnotated");
        this.readAppendableArgument((HasMultipleValues<String>)((HasMultipleValues)settingsExtension.getReports().getIncludesAnnotatedBy()), providers, "kover.classes.includesAnnotated");
    }

    private final void readAppendableArgument(HasMultipleValues<String> $this$readAppendableArgument, ProviderFactory providers, String propertyName) {
        Provider provider = providers.gradleProperty(propertyName);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.gradleProperty(propertyName)");
        Provider propertyProvider = provider;
        if (propertyProvider.isPresent()) {
            Object object = propertyProvider.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"propertyProvider.get()");
            ArgCollection arg = this.parseCollection((String)object);
            if (!arg.getAppend()) {
                $this$readAppendableArgument.empty();
            }
            $this$readAppendableArgument.addAll((Iterable)arg.getValues());
        }
    }

    private final ArgCollection parseCollection(String $this$parseCollection) {
        String string;
        boolean append = StringsKt.startsWith$default((CharSequence)$this$parseCollection, (char)'+', (boolean)false, (int)2, null);
        if (append) {
            String string2 = $this$parseCollection.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = $this$parseCollection;
        }
        String str = string;
        char[] cArray = new char[]{','};
        List values = StringsKt.split$default((CharSequence)str, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        return new ArgCollection(append, values);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lkotlinx/kover/gradle/aggregation/settings/KoverParametersProcessor$ArgCollection;", "", "append", "", "values", "", "", "(ZLjava/util/List;)V", "getAppend", "()Z", "getValues", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "kover-gradle-plugin"})
    private static final class ArgCollection {
        private final boolean append;
        @NotNull
        private final List<String> values;

        public ArgCollection(boolean append, @NotNull List<String> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            this.append = append;
            this.values = values;
        }

        public final boolean getAppend() {
            return this.append;
        }

        @NotNull
        public final List<String> getValues() {
            return this.values;
        }

        public final boolean component1() {
            return this.append;
        }

        @NotNull
        public final List<String> component2() {
            return this.values;
        }

        @NotNull
        public final ArgCollection copy(boolean append, @NotNull List<String> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new ArgCollection(append, values);
        }

        public static /* synthetic */ ArgCollection copy$default(ArgCollection argCollection, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = argCollection.append;
            }
            if ((n & 2) != 0) {
                list = argCollection.values;
            }
            return argCollection.copy(bl, list);
        }

        @NotNull
        public String toString() {
            return "ArgCollection(append=" + this.append + ", values=" + this.values + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.append);
            result = result * 31 + ((Object)this.values).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgCollection)) {
                return false;
            }
            ArgCollection argCollection = (ArgCollection)other;
            if (this.append != argCollection.append) {
                return false;
            }
            return Intrinsics.areEqual(this.values, argCollection.values);
        }
    }
}

