/*
 * Copyright 2017-2023 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license.
 */

package kotlinx.kover.gradle.plugin.commons

/**
 * URLs to migration guidelines.
 */
internal object KoverMigrations {
    /** URL of migration guideline from versions 0.5.x to 0.6.0 */
    const val MIGRATION_0_5_TO_0_6 = "https://github.com/Kotlin/kotlinx-kover/blob/v0.6.0/docs/migration-to-0.6.0.md"
    /** URL of migration guideline from versions 0.6.x to 0.7.0 */
    const val MIGRATION_0_6_TO_0_7 = "https://github.com/Kotlin/kotlinx-kover/blob/v0.7.0/docs/gradle-plugin/migrations/migration-to-0.7.0.md"
    /** URL of migration guideline from versions 0.7.x to 0.8.0 */
    const val MIGRATION_0_7_TO_0_8 = "https://github.com/Kotlin/kotlinx-kover/blob/v0.8.0/docs/gradle-plugin/migrations/migration-to-0.8.0.md"
}
