/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks.reports;

import java.io.File;
import java.net.URI;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.dsl.tasks.KoverHtmlReport;
import kotlinx.kover.gradle.plugin.tasks.reports.AbstractKoverReportTask;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b!\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\u0013R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0016\u0010\u0003\u001a\u00020\u00048\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/reports/KoverHtmlTask;", "Lkotlinx/kover/gradle/plugin/tasks/reports/AbstractKoverReportTask;", "Lkotlinx/kover/gradle/plugin/dsl/tasks/KoverHtmlReport;", "variantName", "", "(Ljava/lang/String;)V", "charset", "Lorg/gradle/api/provider/Property;", "getCharset", "()Lorg/gradle/api/provider/Property;", "reportDir", "Lorg/gradle/api/file/DirectoryProperty;", "getReportDir", "()Lorg/gradle/api/file/DirectoryProperty;", "title", "getTitle", "getVariantName", "()Ljava/lang/String;", "generate", "", "printPath", "kover-gradle-plugin"})
public abstract class KoverHtmlTask
extends AbstractKoverReportTask
implements KoverHtmlReport {
    @NotNull
    private final String variantName;

    @Inject
    public KoverHtmlTask(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        this.variantName = variantName;
    }

    @Override
    @Internal
    @NotNull
    public String getVariantName() {
        return this.variantName;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReportDir();

    @Input
    @NotNull
    public abstract Property<String> getTitle();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getCharset();

    @TaskAction
    public final void generate() {
        File file = ((Directory)this.getReportDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"reportDir.get().asFile");
        File htmlDir = file;
        htmlDir.mkdirs();
        CoverageTool coverageTool = (CoverageTool)this.getTool().get();
        Object object = this.getTitle().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"title.get()");
        coverageTool.htmlReport(htmlDir, (String)object, (String)this.getCharset().getOrNull(), this.context());
    }

    public final void printPath() {
        String clickablePath = new URI("file", "", new File(((Directory)this.getReportDir().get()).getAsFile().getCanonicalPath(), "index.html").toURI().getPath(), null, null).toASCIIString();
        this.getLogger().lifecycle("Kover: HTML report for '" + this.getProjectPath() + "' " + clickablePath);
    }
}

