/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.tasks.internal;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import kotlinx.kover.gradle.plugin.tools.CoverageToolVariant;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.service.ServiceRegistry;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lkotlinx/kover/gradle/plugin/tasks/internal/KoverAgentJarTask;", "Lorg/gradle/api/DefaultTask;", "tool", "Lkotlinx/kover/gradle/plugin/tools/CoverageTool;", "(Lkotlinx/kover/gradle/plugin/tools/CoverageTool;)V", "agentClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAgentClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "agentJar", "Lorg/gradle/api/file/RegularFileProperty;", "getAgentJar", "()Lorg/gradle/api/file/RegularFileProperty;", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "toolVariant", "Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "getToolVariant", "()Lkotlinx/kover/gradle/plugin/tools/CoverageToolVariant;", "find", "", "kover-gradle-plugin"})
public class KoverAgentJarTask
extends DefaultTask {
    private final ArchiveOperations archiveOperations;
    @NotNull
    private final ConfigurableFileCollection agentClasspath;
    @NotNull
    private final RegularFileProperty agentJar;
    @NotNull
    private final CoverageToolVariant toolVariant;
    private final CoverageTool tool;

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final ConfigurableFileCollection getAgentClasspath() {
        return this.agentClasspath;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getAgentJar() {
        return this.agentJar;
    }

    @Nested
    @NotNull
    public final CoverageToolVariant getToolVariant() {
        return this.toolVariant;
    }

    @TaskAction
    public final void find() {
        File srcJar = this.tool.findJvmAgentJar((FileCollection)this.agentClasspath, this.archiveOperations);
        Object object = this.agentJar.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"agentJar.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"agentJar.get().asFile");
        FilesKt.copyTo$default((File)srcJar, (File)file, (boolean)true, (int)0, (int)4, null);
    }

    @Inject
    public KoverAgentJarTask(@NotNull CoverageTool tool) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        this.tool = tool;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project $this$serviceOf$iv = project;
        boolean $i$f$serviceOf = false;
        ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
        Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"(this as ProjectInternal).services");
        ServiceRegistry $this$get$iv$iv = serviceRegistry;
        boolean $i$f$get = false;
        Object object = $this$get$iv$iv.get(ArchiveOperations.class);
        Intrinsics.checkNotNull((Object)object);
        this.archiveOperations = (ArchiveOperations)object;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        ConfigurableFileCollection configurableFileCollection = project2.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.agentClasspath = configurableFileCollection;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        RegularFileProperty regularFileProperty = project3.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.agentJar = regularFileProperty;
        this.toolVariant = this.tool.getVariant();
    }
}

