/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.kover.gradle.plugin.appliers;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.kover.gradle.plugin.appliers.InstrumentationData;
import kotlinx.kover.gradle.plugin.appliers.JvmTestTaskApplier;
import kotlinx.kover.gradle.plugin.appliers.JvmTestTaskArgumentProvider;
import kotlinx.kover.gradle.plugin.commons.PathsKt;
import kotlinx.kover.gradle.plugin.tools.CoverageTool;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.testing.Test;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lkotlinx/kover/gradle/plugin/appliers/JvmTestTaskApplier;", "", "testTask", "Lorg/gradle/api/tasks/testing/Test;", "data", "Lkotlinx/kover/gradle/plugin/appliers/InstrumentationData;", "(Lorg/gradle/api/tasks/testing/Test;Lkotlinx/kover/gradle/plugin/appliers/InstrumentationData;)V", "apply", "", "kover-gradle-plugin"})
public final class JvmTestTaskApplier {
    private final Test testTask;
    private final InstrumentationData data;

    public final void apply() {
        Project project = this.testTask.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"testTask.project");
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"testTask.project.layout");
        DirectoryProperty directoryProperty = projectLayout.getBuildDirectory();
        String string = this.testTask.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testTask.name");
        Provider provider = directoryProperty.file(PathsKt.rawReportPath(string, this.data.getTool().getVariant().getVendor()));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"testTask.project.layout.\u2026ata.tool.variant.vendor))");
        Provider rawReportProvider = provider;
        this.testTask.dependsOn(new Object[]{this.data.getFindAgentJarTask()});
        Set excluded = SetsKt.plus(this.data.getExcludedClasses(), (Iterable)CollectionsKt.listOf((Object[])new String[]{"android.*", "com.android.*"}));
        Collection collection = this.testTask.getJvmArgumentProviders();
        File file = this.testTask.getTemporaryDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"testTask.temporaryDir");
        CoverageTool coverageTool = this.data.getTool();
        Provider provider2 = this.data.getFindAgentJarTask().map((Transformer)apply.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"data.findAgentJarTask.ma\u2026t.agentJar.get().asFile }");
        JvmTestTaskArgumentProvider jvmTestTaskArgumentProvider = new JvmTestTaskArgumentProvider(file, coverageTool, (Provider<File>)provider2, excluded, (Provider<RegularFile>)rawReportProvider);
        collection.add(jvmTestTaskArgumentProvider);
    }

    public JvmTestTaskApplier(@NotNull Test testTask, @NotNull InstrumentationData data) {
        Intrinsics.checkNotNullParameter((Object)testTask, (String)"testTask");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.testTask = testTask;
        this.data = data;
    }
}

