/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.internal.JsonReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkotlinx/serialization/json/internal/JsonParser;", "", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "reader", "Lkotlinx/serialization/json/internal/JsonReader;", "(Lkotlinx/serialization/json/JsonConfiguration;Lkotlinx/serialization/json/internal/JsonReader;)V", "isLenient", "", "read", "Lkotlinx/serialization/json/JsonElement;", "readArray", "readObject", "readValue", "isString", "kotlinx-serialization-runtime"})
public final class JsonParser {
    private final boolean isLenient;
    private final JsonReader reader;

    /*
     * WARNING - void declaration
     */
    private final JsonElement readObject() {
        void condition$iv;
        boolean condition$iv2;
        JsonReader this_$iv;
        JsonReader jsonReader = this.reader;
        byte expected$iv = 6;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
        if (this_$iv.tokenClass != expected$iv) {
            char c = (char)this_$iv.tokenClass;
            void var10_11 = this_$iv;
            boolean bl = false;
            String string = "Expected start of the object";
            Void void_ = var10_11.fail(string, JsonReader.access$getTokenPosition$p(this_$iv));
            throw null;
        }
        this.reader.nextToken();
        this_$iv = this.reader;
        expected$iv = this.reader.tokenClass != 4 ? (byte)1 : 0;
        int position$iv = this.reader.currentPosition;
        boolean $i$f$require$kotlinx_serialization_runtime2 = false;
        if (!condition$iv2) {
            JsonReader jsonReader2 = this_$iv;
            boolean bl = false;
            String string = "Unexpected leading comma";
            Void void_ = jsonReader2.fail(string, position$iv);
            throw null;
        }
        condition$iv2 = false;
        LinkedHashMap result = new LinkedHashMap();
        boolean valueExpected = false;
        while (this.reader.getCanBeginValue()) {
            void this_$iv2;
            valueExpected = false;
            String key = this.isLenient ? this.reader.takeString() : this.reader.takeStringQuoted();
            JsonReader $i$f$require$kotlinx_serialization_runtime2 = this.reader;
            byte expected$iv22 = 5;
            boolean $i$f$requireTokenClass$kotlinx_serialization_runtime2 = false;
            if (this_$iv2.tokenClass != expected$iv22) {
                char c = (char)this_$iv2.tokenClass;
                void var10_13 = this_$iv2;
                boolean bl = false;
                String string = "Expected ':'";
                Void void_ = var10_13.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv2));
                throw null;
            }
            this.reader.nextToken();
            JsonElement element = this.read();
            ((Map)result).put(key, element);
            if (this.reader.tokenClass != 4) {
                void this_$iv3;
                JsonReader expected$iv22 = this.reader;
                byte expected$iv3 = 7;
                boolean $i$f$requireTokenClass$kotlinx_serialization_runtime3 = false;
                if (this_$iv3.tokenClass == expected$iv3) continue;
                char bl = (char)this_$iv3.tokenClass;
                void var10_14 = this_$iv3;
                boolean bl2 = false;
                String string = "Expected end of the object or comma";
                Void void_ = var10_14.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv3));
                throw null;
            }
            valueExpected = true;
            this.reader.nextToken();
        }
        JsonReader key = this.reader;
        boolean element = !valueExpected && this.reader.tokenClass == 7;
        int position$iv2 = this.reader.currentPosition;
        boolean $i$f$require$kotlinx_serialization_runtime3 = false;
        if (condition$iv == false) {
            void this_$iv4;
            void var10_15 = this_$iv4;
            boolean bl = false;
            String string = "Expected end of the object";
            Void void_ = var10_15.fail(string, position$iv2);
            throw null;
        }
        this.reader.nextToken();
        return new JsonObject(result);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonElement readArray() {
        void condition$iv;
        boolean condition$iv2;
        JsonReader this_$iv;
        JsonReader jsonReader = this.reader;
        byte expected$iv = 8;
        boolean $i$f$requireTokenClass$kotlinx_serialization_runtime = false;
        if (this_$iv.tokenClass != expected$iv) {
            char c = (char)this_$iv.tokenClass;
            void var9_11 = this_$iv;
            boolean bl = false;
            String string = "Expected start of the array";
            Void void_ = var9_11.fail(string, JsonReader.access$getTokenPosition$p(this_$iv));
            throw null;
        }
        this.reader.nextToken();
        this_$iv = this.reader;
        expected$iv = this.reader.tokenClass != 4 ? (byte)1 : 0;
        int position$iv = this.reader.currentPosition;
        boolean $i$f$require$kotlinx_serialization_runtime2 = false;
        if (!condition$iv2) {
            JsonReader jsonReader2 = this_$iv;
            boolean bl = false;
            String string = "Unexpected leading comma";
            Void void_ = jsonReader2.fail(string, position$iv);
            throw null;
        }
        condition$iv2 = false;
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        boolean valueExpected = false;
        while (this.reader.getCanBeginValue()) {
            valueExpected = false;
            JsonElement element = this.read();
            result.add(element);
            if (this.reader.tokenClass != 4) {
                void this_$iv2;
                JsonReader $i$f$require$kotlinx_serialization_runtime2 = this.reader;
                byte expected$iv2 = 9;
                boolean $i$f$requireTokenClass$kotlinx_serialization_runtime2 = false;
                if (this_$iv2.tokenClass == expected$iv2) continue;
                char c = (char)this_$iv2.tokenClass;
                void var9_13 = this_$iv2;
                boolean bl = false;
                String string = "Expected end of the array or comma";
                Void void_ = var9_13.fail(string, JsonReader.access$getTokenPosition$p((JsonReader)this_$iv2));
                throw null;
            }
            valueExpected = true;
            this.reader.nextToken();
        }
        JsonReader element = this.reader;
        boolean this_$iv2 = !valueExpected;
        int position$iv2 = this.reader.currentPosition;
        boolean $i$f$require$kotlinx_serialization_runtime3 = false;
        if (condition$iv == false) {
            void this_$iv3;
            void var9_14 = this_$iv3;
            boolean bl = false;
            String string = "Unexpected trailing comma";
            Void void_ = var9_14.fail(string, position$iv2);
            throw null;
        }
        this.reader.nextToken();
        return new JsonArray((List<? extends JsonElement>)result);
    }

    private final JsonElement readValue(boolean isString) {
        String str = this.isLenient ? this.reader.takeString() : (isString ? this.reader.takeStringQuoted() : this.reader.takeString());
        return new JsonLiteral(str, isString);
    }

    @NotNull
    public final JsonElement read() {
        JsonElement jsonElement;
        if (!this.reader.getCanBeginValue()) {
            Void void_ = JsonReader.fail$default(this.reader, "Can't begin reading value from here", 0, 2, null);
            throw null;
        }
        switch (this.reader.tokenClass) {
            case 10: {
                JsonNull jsonNull = JsonNull.INSTANCE;
                boolean bl = false;
                boolean bl2 = false;
                JsonNull it = jsonNull;
                boolean bl3 = false;
                this.reader.nextToken();
                jsonElement = jsonNull;
                break;
            }
            case 1: {
                jsonElement = this.readValue(true);
                break;
            }
            case 0: {
                jsonElement = this.readValue(false);
                break;
            }
            case 6: {
                jsonElement = this.readObject();
                break;
            }
            case 8: {
                jsonElement = this.readArray();
                break;
            }
            default: {
                Void void_ = JsonReader.fail$default(this.reader, "Can't begin reading element, unexpected token", 0, 2, null);
                throw null;
            }
        }
        return jsonElement;
    }

    public JsonParser(@NotNull JsonConfiguration configuration, @NotNull JsonReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.reader = reader;
        this.isLenient = configuration.isLenient$kotlinx_serialization_runtime();
    }
}

