/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNamingStrategy;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JsonSchemaCacheKt;
import kotlinx.serialization.json.internal.AbstractJsonTreeDecoder;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000fH\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkotlinx/serialization/json/internal/JsonTreeDecoder;", "Lkotlinx/serialization/json/internal/AbstractJsonTreeDecoder;", "json", "Lkotlinx/serialization/json/Json;", "value", "Lkotlinx/serialization/json/JsonObject;", "polymorphicDiscriminator", "", "polyDescriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "position", "", "forceNull", "", "coerceInputValue", "descriptor", "index", "tag", "decodeElementIndex", "absenceIsNull", "decodeNotNullMark", "elementName", "currentElement", "Lkotlinx/serialization/json/JsonElement;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nTreeJsonDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/JsonTreeDecoder\n+ 2 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 3 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt$tryCoerceValue$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/AbstractJsonTreeDecoder\n+ 6 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n*L\n1#1,342:1\n125#2,22:343\n147#2,4:366\n131#3:365\n1#4:370\n73#5:371\n270#6,8:372\n*S KotlinDebug\n*F\n+ 1 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/JsonTreeDecoder\n*L\n204#1:343,22\n204#1:366,4\n204#1:365\n265#1:371\n265#1:372,8\n*E\n"})
class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    @NotNull
    private final JsonObject value;
    @Nullable
    private final SerialDescriptor polyDescriptor;
    private int position;
    private boolean forceNull;

    public JsonTreeDecoder(@NotNull Json json, @NotNull JsonObject value, @Nullable String polymorphicDiscriminator, @Nullable SerialDescriptor polyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(json, value, polymorphicDiscriminator, null);
        this.value = value;
        this.polyDescriptor = polyDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json, jsonObject, string, serialDescriptor);
    }

    @Override
    @NotNull
    public JsonObject getValue() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor, int index, String tag) {
        boolean bl;
        boolean it;
        Json $this$tryCoerceValue_u24default$iv = this.getJson();
        boolean $i$f$tryCoerceValue = false;
        boolean isOptional$iv = descriptor.isElementOptional(index);
        SerialDescriptor elementDescriptor$iv = descriptor.getElementDescriptor(index);
        if (isOptional$iv && !elementDescriptor$iv.isNullable()) {
            it = true;
            bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)elementDescriptor$iv.getKind(), (Object)SerialKind.ENUM.INSTANCE)) return false;
        if (elementDescriptor$iv.isNullable()) {
            it = false;
            bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return false;
            }
        }
        boolean bl2 = false;
        JsonElement jsonElement = this.currentElement(tag);
        if (!(jsonElement instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        if (jsonPrimitive == null) return false;
        String string = JsonElementKt.getContentOrNull(jsonPrimitive);
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex(elementDescriptor$iv, $this$tryCoerceValue_u24default$iv, enumValue$iv);
        boolean coerceToNull$iv = !$this$tryCoerceValue_u24default$iv.getConfiguration().getExplicitNulls() && elementDescriptor$iv.isNullable();
        if (enumIndex$iv != -3) return false;
        if (isOptional$iv) return true;
        if (!coerceToNull$iv) return false;
        return true;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        while (this.position < descriptor.getElementsCount()) {
            int n = this.position;
            this.position = n + 1;
            String name = this.getTag(descriptor, n);
            int index = this.position - 1;
            this.forceNull = false;
            if (!((Map)this.getValue()).containsKey(name) && !this.absenceIsNull(descriptor, index) || this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor, index, name)) continue;
            return index;
        }
        return -1;
    }

    private final boolean absenceIsNull(SerialDescriptor descriptor, int index) {
        this.forceNull = !this.getJson().getConfiguration().getExplicitNulls() && !descriptor.isElementOptional(index) && descriptor.getElementDescriptor(index).isNullable();
        return this.forceNull;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.forceNull && super.decodeNotNullMark();
    }

    @NotNull
    protected String elementName(@NotNull SerialDescriptor descriptor, int index) {
        Object v1;
        String baseName;
        JsonNamingStrategy strategy;
        block6: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            strategy = JsonNamesMapKt.namingStrategy(descriptor, this.getJson());
            baseName = descriptor.getElementName(index);
            if (strategy == null) {
                if (!this.configuration.getUseAlternativeNames()) {
                    return baseName;
                }
                if (this.getValue().keySet().contains(baseName)) {
                    return baseName;
                }
            }
            Map<String, Integer> deserializationNamesMap = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor);
            Iterable iterable = this.getValue().keySet();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                Integer n = deserializationNamesMap.get(it);
                int n2 = index;
                if (!(n != null && n == n2)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        String string = v1;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        JsonNamingStrategy jsonNamingStrategy = strategy;
        String fallbackName = jsonNamingStrategy != null ? jsonNamingStrategy.serialNameForJson(descriptor, index, baseName) : null;
        String string2 = fallbackName;
        if (string2 == null) {
            string2 = baseName;
        }
        return string2;
    }

    @Override
    @NotNull
    protected JsonElement currentElement(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return (JsonElement)MapsKt.getValue((Map)this.getValue(), (Object)tag);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor == this.polyDescriptor) {
            void value$iv;
            AbstractJsonTreeDecoder abstractJsonTreeDecoder = this;
            JsonElement jsonElement = this.currentObject();
            SerialDescriptor descriptor$iv = this.polyDescriptor;
            boolean $i$f$cast = false;
            String serialName$iv$iv = descriptor$iv.getSerialName();
            boolean $i$f$cast2 = false;
            if (!(value$iv instanceof JsonObject)) {
                void this_$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Expected ").append(Reflection.getOrCreateKotlinClass(JsonObject.class).getSimpleName()).append(", but had ").append(Reflection.getOrCreateKotlinClass(value$iv.getClass()).getSimpleName()).append(" as the serialized body of ").append(serialName$iv$iv).append(" at element: ");
                int n = -1;
                boolean bl = false;
                String string = AbstractJsonTreeDecoder.access$renderTagStack((AbstractJsonTreeDecoder)this_$iv);
                throw JsonExceptionsKt.JsonDecodingException(n, stringBuilder.append(string).toString(), value$iv.toString());
            }
            return new JsonTreeDecoder(this.getJson(), (JsonObject)value$iv, this.getPolymorphicDiscriminator(), this.polyDescriptor);
        }
        return super.beginStructure(descriptor);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (JsonNamesMapKt.ignoreUnknownKeys(descriptor, this.getJson()) || descriptor.getKind() instanceof PolymorphicKind) {
            return;
        }
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy(descriptor, this.getJson());
        if (strategy == null && !this.configuration.getUseAlternativeNames()) {
            set = JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)descriptor);
        } else if (strategy != null) {
            set = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor).keySet();
        } else {
            Set set2 = JsonInternalDependenciesKt.jsonCachedSerialNames((SerialDescriptor)descriptor);
            Map<String, Integer> map = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get(descriptor, JsonNamesMapKt.getJsonDeserializationNamesKey());
            Set set3 = map != null ? map.keySet() : null;
            if (set3 == null) {
                set3 = SetsKt.emptySet();
            }
            set = SetsKt.plus((Set)set2, (Iterable)set3);
        }
        Set names = set;
        for (String key : this.getValue().keySet()) {
            if (names.contains(key) || Intrinsics.areEqual((Object)key, (Object)this.getPolymorphicDiscriminator())) continue;
            throw JsonExceptionsKt.JsonDecodingException(-1, "Encountered an unknown key '" + key + "' at element: " + this.renderTagStack() + "\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder or '@JsonIgnoreUnknownKeys' annotation to ignore unknown keys.\nJSON input: " + JsonExceptionsKt.minify$default(this.getValue().toString(), 0, 1, null));
        }
    }
}

