/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.internal.ByteArrayPool8k;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/serialization/json/internal/CharsetReader;", "", "inputStream", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "<init>", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V", "decoder", "Ljava/nio/charset/CharsetDecoder;", "byteBuffer", "Ljava/nio/ByteBuffer;", "hasLeftoverPotentiallySurrogateChar", "", "leftoverChar", "", "read", "", "array", "", "offset", "length", "doRead", "fillByteBuffer", "oneShotReadSlowPath", "release", "", "kotlinx-serialization-json"})
public final class CharsetReader {
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private final Charset charset;
    @NotNull
    private final CharsetDecoder decoder;
    @NotNull
    private final ByteBuffer byteBuffer;
    private boolean hasLeftoverPotentiallySurrogateChar;
    private char leftoverChar;

    public CharsetReader(@NotNull InputStream inputStream, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.inputStream = inputStream;
        this.charset = charset;
        this.decoder = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.byteBuffer = ByteBuffer.wrap(ByteArrayPool8k.INSTANCE.take());
        this.byteBuffer.flip();
    }

    public final int read(@NotNull char[] array, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length == 0) {
            return 0;
        }
        if (!((0 <= offset ? offset < array.length : false) && length >= 0 && offset + length <= array.length)) {
            boolean $i$a$-require-CharsetReader$read$22 = false;
            String $i$a$-require-CharsetReader$read$22 = "Unexpected arguments: " + offset + ", " + length + ", " + array.length;
            throw new IllegalArgumentException($i$a$-require-CharsetReader$read$22.toString());
        }
        int offset2 = offset;
        int length2 = length;
        int bytesRead = 0;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            array[offset2] = this.leftoverChar;
            ++offset2;
            this.hasLeftoverPotentiallySurrogateChar = false;
            bytesRead = 1;
            if (--length2 == 0) {
                return bytesRead;
            }
        }
        if (length2 == 1) {
            int c = this.oneShotReadSlowPath();
            if (c == -1) {
                return bytesRead == 0 ? -1 : bytesRead;
            }
            array[offset2] = (char)c;
            return bytesRead + 1;
        }
        return this.doRead(array, offset2, length2) + bytesRead;
    }

    private final int doRead(char[] array, int offset, int length) {
        CharBuffer charBuffer = CharBuffer.wrap(array, offset, length);
        if (charBuffer.position() != 0) {
            charBuffer = charBuffer.slice();
        }
        boolean isEof = false;
        while (true) {
            CoderResult cr;
            if ((cr = this.decoder.decode(this.byteBuffer, charBuffer, isEof)).isUnderflow()) {
                if (isEof || !charBuffer.hasRemaining()) break;
                int n = this.fillByteBuffer();
                if (n >= 0) continue;
                isEof = true;
                if (charBuffer.position() == 0 && !this.byteBuffer.hasRemaining()) break;
                this.decoder.reset();
                continue;
            }
            if (cr.isOverflow()) {
                boolean bl;
                boolean bl2 = bl = charBuffer.position() > 0;
                if (!_Assertions.ENABLED || bl) break;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            cr.throwException();
        }
        if (isEof) {
            this.decoder.reset();
        }
        return charBuffer.position() == 0 ? -1 : charBuffer.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int fillByteBuffer() {
        this.byteBuffer.compact();
        try {
            int limit = this.byteBuffer.limit();
            int position = this.byteBuffer.position();
            int remaining = position <= limit ? limit - position : 0;
            int bytesRead = this.inputStream.read(this.byteBuffer.array(), this.byteBuffer.arrayOffset() + position, remaining);
            if (bytesRead < 0) {
                int n = bytesRead;
                return n;
            }
            ByteBuffer byteBuffer = this.byteBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
            ((Buffer)byteBuffer).position(position + bytesRead);
        }
        finally {
            this.byteBuffer.flip();
        }
        return this.byteBuffer.remaining();
    }

    private final int oneShotReadSlowPath() {
        int n;
        if (this.hasLeftoverPotentiallySurrogateChar) {
            this.hasLeftoverPotentiallySurrogateChar = false;
            return this.leftoverChar;
        }
        char[] array = new char[2];
        int bytesRead = this.read(array, 0, 2);
        switch (bytesRead) {
            case -1: {
                n = -1;
                break;
            }
            case 1: {
                n = array[0];
                break;
            }
            case 2: {
                this.leftoverChar = array[1];
                this.hasLeftoverPotentiallySurrogateChar = true;
                n = array[0];
                break;
            }
            default: {
                throw new IllegalStateException(("Unreachable state: " + bytesRead).toString());
            }
        }
        return n;
    }

    public final void release() {
        byte[] byArray = this.byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        ByteArrayPool8k.INSTANCE.release(byArray);
    }
}

