/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.core.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.BytePacketBuilderBase;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.Input;
import kotlinx.io.core.InputKt;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.internal.DangerousInternalIoApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\b*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\b*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\b*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\b*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u001e\u0010\u0013\u001a\u00020\b*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u001a\u0016\u0010\u0015\u001a\u00020\b*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0016"}, d2={"$unsafeAppend$", "", "Lkotlinx/io/core/ByteReadPacket;", "builder", "Lkotlinx/io/core/BytePacketBuilder;", "afterHeadWrite", "Lkotlinx/io/core/Output;", "current", "Lkotlinx/io/core/IoBuffer;", "afterWriteHeadFallback", "completeReadHead", "Lkotlinx/io/core/Input;", "completeReadHeadFallback", "prepareNextReadHeadFallback", "prepareReadFirstHead", "minSize", "", "prepareReadHeadFallback", "prepareReadNextHead", "prepareWriteHead", "capacity", "prepareWriteHeadFallback", "kotlinx-io"})
public final class UnsafeKt {
    @DangerousInternalIoApi
    public static final void $unsafeAppend$(@NotNull ByteReadPacket $receiver, @NotNull BytePacketBuilder builder) {
        block1: {
            IoBuffer ioBuffer;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            int builderSize = builder.getSize();
            IoBuffer builderHead = builder.getHead();
            if (builderSize <= PacketJVMKt.getPACKET_MAX_COPY_SIZE() && builderHead.getNext() == null && $receiver.tryWriteAppend$kotlinx_io(builderHead)) {
                builder.afterBytesStolen$kotlinx_io();
                return;
            }
            IoBuffer ioBuffer2 = builder.stealAll$kotlinx_io();
            if (ioBuffer2 == null) break block1;
            IoBuffer chain = ioBuffer = ioBuffer2;
            boolean bl = false;
            $receiver.append$kotlinx_io(chain);
        }
    }

    @DangerousInternalIoApi
    @Nullable
    public static final IoBuffer prepareReadFirstHead(@NotNull Input $receiver, int minSize) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver instanceof ByteReadPacketBase) {
            return ((ByteReadPacketBase)$receiver).prepareReadHead(minSize);
        }
        if ($receiver instanceof IoBuffer) {
            return ((IoBuffer)$receiver).canRead() ? (IoBuffer)$receiver : null;
        }
        return UnsafeKt.prepareReadHeadFallback($receiver, minSize);
    }

    private static final IoBuffer prepareReadHeadFallback(@NotNull Input $receiver, int minSize) {
        if ($receiver.getEndOfInput()) {
            return null;
        }
        IoBuffer buffer = IoBuffer.Companion.getPool().borrow();
        while (buffer.getReadRemaining() < minSize) {
            int rc = $receiver.peekTo(buffer);
            if (rc > 0) continue;
            buffer.release(IoBuffer.Companion.getPool());
            return null;
        }
        return buffer;
    }

    @DangerousInternalIoApi
    public static final void completeReadHead(@NotNull Input $receiver, @NotNull IoBuffer current) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        if (current == $receiver) {
            return;
        }
        if ($receiver instanceof ByteReadPacketBase) {
            int remaining = current.getReadRemaining();
            if (remaining == 0) {
                ((ByteReadPacketBase)$receiver).ensureNext(current);
            } else if (current.getEndGap() < IoBuffer.Companion.getReservedSize()) {
                ((ByteReadPacketBase)$receiver).fixGapAfterRead(current);
            } else {
                ((ByteReadPacketBase)$receiver).updateHeadRemaining(remaining);
            }
            return;
        }
        UnsafeKt.completeReadHeadFallback($receiver, current);
    }

    private static final void completeReadHeadFallback(@NotNull Input $receiver, IoBuffer current) {
        int discardAmount = current.getCapacity() - current.getWriteRemaining() - current.getReadRemaining();
        InputKt.discardExact($receiver, discardAmount);
        current.release(IoBuffer.Companion.getPool());
    }

    @DangerousInternalIoApi
    @Nullable
    public static final IoBuffer prepareReadNextHead(@NotNull Input $receiver, @NotNull IoBuffer current) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        if (current == $receiver) {
            return ((IoBuffer)$receiver).canRead() ? (IoBuffer)$receiver : null;
        }
        if ($receiver instanceof ByteReadPacketBase) {
            return ((ByteReadPacketBase)$receiver).ensureNextHead(current);
        }
        return UnsafeKt.prepareNextReadHeadFallback($receiver, current);
    }

    private static final IoBuffer prepareNextReadHeadFallback(@NotNull Input $receiver, IoBuffer current) {
        int discardAmount = current.getCapacity() - current.getWriteRemaining() - current.getReadRemaining();
        InputKt.discardExact($receiver, discardAmount);
        current.resetForWrite();
        if ($receiver.getEndOfInput() || $receiver.peekTo(current) <= 0) {
            current.release(IoBuffer.Companion.getPool());
            return null;
        }
        return current;
    }

    @DangerousInternalIoApi
    @NotNull
    public static final IoBuffer prepareWriteHead(@NotNull Output $receiver, int capacity, @Nullable IoBuffer current) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver instanceof BytePacketBuilderBase) {
            return ((BytePacketBuilderBase)$receiver).prepareWriteHead(capacity);
        }
        return UnsafeKt.prepareWriteHeadFallback($receiver, current);
    }

    private static final IoBuffer prepareWriteHeadFallback(@NotNull Output $receiver, IoBuffer current) {
        if (current != null) {
            OutputKt.writeFully$default($receiver, current, 0, 2, null);
            current.resetForWrite();
            return current;
        }
        return IoBuffer.Companion.getPool().borrow();
    }

    @DangerousInternalIoApi
    public static final void afterHeadWrite(@NotNull Output $receiver, @NotNull IoBuffer current) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        if ($receiver instanceof BytePacketBuilderBase) {
            ((BytePacketBuilderBase)$receiver).afterHeadWrite();
            return;
        }
        UnsafeKt.afterWriteHeadFallback($receiver, current);
    }

    private static final void afterWriteHeadFallback(@NotNull Output $receiver, IoBuffer current) {
        OutputKt.writeFully$default($receiver, current, 0, 2, null);
        current.release(IoBuffer.Companion.getPool());
    }
}

