/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.charsets;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.io.charsets.MalformedInputException;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.Input;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.core.Output;
import kotlinx.io.core.OutputKt;
import kotlinx.io.core.internal.RequireFailureCapture;
import kotlinx.io.core.internal.UTF8Kt;
import kotlinx.io.core.internal.UnsafeKt;
import kotlinx.io.internal.jvm.ErrorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0014\u001a\u00020\u0001*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u001e\u0010\u001b\u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0001\u001a \u0010\u001d\u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a \u0010\u001f\u001a\u00020\u0011*\u00060\tj\u0002`\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a\u0018\u0010 \u001a\u00020!*\u00060\rj\u0002`\u000e2\u0006\u0010\u0017\u001a\u00020\"H\u0000\u001a0\u0010#\u001a\u00020\u0001*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\"H\u0000\u001a*\u0010'\u001a\u00020(*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020\u00012\b\b\u0002\u0010&\u001a\u00020\u0001\u001a(\u0010)\u001a\u00020(*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0001H\u0002\u001a\u001e\u0010*\u001a\u00020+*\u00060\rj\u0002`\u000e2\u0006\u0010\u0015\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020-\u001a\f\u0010.\u001a\u00020+*\u00020/H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0006\u001a\u00060\u0007j\u0002`\b*\u00060\tj\u0002`\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u001d\u0010\u0006\u001a\u00060\u0007j\u0002`\b*\u00060\rj\u0002`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000f\"\u0019\u0010\u0010\u001a\u00020\u0011*\u00060\u0007j\u0002`\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013*\n\u00100\"\u00020\u00072\u00020\u0007*\n\u00101\"\u00020\t2\u00020\t*\n\u00102\"\u00020\r2\u00020\r*\n\u00103\"\u0002042\u000204\u00a8\u00065"}, d2={"DECODE_CHAR_BUFFER_SIZE", "", "EmptyByteBuffer", "Ljava/nio/ByteBuffer;", "EmptyCharBuffer", "Ljava/nio/CharBuffer;", "charset", "Ljava/nio/charset/Charset;", "Lkotlinx/io/charsets/Charset;", "Ljava/nio/charset/CharsetDecoder;", "Lkotlinx/io/charsets/CharsetDecoder;", "getCharset", "(Ljava/nio/charset/CharsetDecoder;)Ljava/nio/charset/Charset;", "Ljava/nio/charset/CharsetEncoder;", "Lkotlinx/io/charsets/CharsetEncoder;", "(Ljava/nio/charset/CharsetEncoder;)Ljava/nio/charset/Charset;", "name", "", "getName", "(Ljava/nio/charset/Charset;)Ljava/lang/String;", "decode", "input", "Lkotlinx/io/core/Input;", "dst", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "max", "decodeExactBytes", "inputLength", "decodeImplByteBuffer", "Lkotlinx/io/core/ByteReadPacketBase;", "decodeImplSlow", "encodeComplete", "", "Lkotlinx/io/core/IoBuffer;", "encodeImpl", "", "fromIndex", "toIndex", "encodeToByteArray", "", "encodeToByteArraySlow", "encodeUTF8", "", "Lkotlinx/io/core/ByteReadPacket;", "Lkotlinx/io/core/Output;", "throwExceptionWrapped", "Ljava/nio/charset/CoderResult;", "Charset", "CharsetDecoder", "CharsetEncoder", "Charsets", "Lkotlin/text/Charsets;", "kotlinx-io"})
public final class CharsetJVMKt {
    private static final int DECODE_CHAR_BUFFER_SIZE = 8192;
    private static final CharBuffer EmptyCharBuffer;
    private static final ByteBuffer EmptyByteBuffer;

    public static /* synthetic */ void Charset$annotations() {
    }

    @NotNull
    public static final String getName(@NotNull Charset $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.name();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name()");
        return string;
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetEncoder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Charset charset = $receiver.charset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"charset()");
        return charset;
    }

    @NotNull
    public static final byte[] encodeToByteArray(@NotNull CharsetEncoder $receiver, @NotNull CharSequence input, int fromIndex, int toIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (input instanceof String) {
            if (fromIndex == 0 && toIndex == input.length()) {
                byte[] byArray = ((String)input).getBytes($receiver.charset());
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(input as java.lang.String).getBytes(charset())");
                return byArray;
            }
            String string = (String)input;
            String string2 = string.substring(fromIndex, toIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes($receiver.charset());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(input.substring(fromInd\u2026ring).getBytes(charset())");
            return byArray;
        }
        return CharsetJVMKt.encodeToByteArraySlow($receiver, input, fromIndex, toIndex);
    }

    @NotNull
    public static /* synthetic */ byte[] encodeToByteArray$default(CharsetEncoder charsetEncoder, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        return CharsetJVMKt.encodeToByteArray(charsetEncoder, charSequence, n, n2);
    }

    private static final byte[] encodeToByteArraySlow(@NotNull CharsetEncoder $receiver, CharSequence input, int fromIndex, int toIndex) {
        byte[] existingArray;
        Object object;
        byte[] it;
        byte[] byArray;
        ByteBuffer result = $receiver.encode(CharBuffer.wrap(input, fromIndex, toIndex));
        if (result.hasArray() && result.arrayOffset() == 0) {
            byte[] byArray2 = result.array();
            if (byArray2 != null) {
                it = byArray = byArray2;
                boolean bl = false;
                object = it.length == result.remaining() ? byArray : null;
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        byte[] byArray3 = existingArray = object;
        if (existingArray == null) {
            it = byArray = new byte[result.remaining()];
            boolean bl = false;
            result.get(it);
            byArray3 = byArray;
        }
        return byArray3;
    }

    /*
     * WARNING - void declaration
     */
    public static final int encodeImpl(@NotNull CharsetEncoder $receiver, @NotNull CharSequence input, int fromIndex, int toIndex, @NotNull IoBuffer dst) {
        void this_$iv$iv$iv;
        CoderResult result;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        CharBuffer cb = CharBuffer.wrap(input, fromIndex, toIndex);
        int before = cb.remaining();
        IoBuffer ioBuffer = dst;
        int size$iv = 0;
        boolean $i$f$writeDirect = false;
        int rem$iv = this_$iv.getWriteRemaining();
        boolean condition$iv$iv = size$iv <= rem$iv;
        boolean $i$f$require = false;
        if (!condition$iv$iv) {
            RequireFailureCapture m$iv$iv = new RequireFailureCapture(size$iv, rem$iv){
                final /* synthetic */ int $size$inlined;
                final /* synthetic */ int $rem$inlined;
                {
                    this.$size$inlined = n;
                    this.$rem$inlined = n2;
                }

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "size " + this.$size$inlined + " is greater than buffer's remaining capacity " + this.$rem$inlined;
                    throw (Throwable)new IllegalArgumentException(string2);
                }
            };
            Void void_ = m$iv$iv.doFail();
            throw null;
        }
        ByteBuffer buffer$iv = this_$iv.writeBuffer;
        int positionBefore$iv = buffer$iv.position();
        ByteBuffer bb = buffer$iv;
        boolean bl = false;
        CoderResult coderResult = result = $receiver.encode(cb, bb, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"result");
        if (coderResult.isMalformed() || result.isUnmappable()) {
            CharsetJVMKt.throwExceptionWrapped(result);
        }
        int delta$iv = buffer$iv.position() - positionBefore$iv;
        if (delta$iv < 0 || delta$iv > rem$iv) {
            Void void_ = ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
            throw null;
        }
        void this_$iv$iv = this_$iv;
        boolean $i$f$afterWrite = false;
        void var19_21 = this_$iv$iv;
        ByteBuffer byteBuffer = this_$iv$iv.readBuffer;
        boolean $i$f$getWritePosition = false;
        int n = this_$iv$iv$iv.writeBuffer.position();
        byteBuffer.limit(n);
        return before - cb.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void encodeUTF8(@NotNull CharsetEncoder $receiver, @NotNull ByteReadPacket input, @NotNull Output dst) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        if (CharsetJVMKt.getCharset($receiver) == Charsets.UTF_8) {
            OutputKt.writePacket(dst, input);
            return;
        }
        IoBuffer tmp = IoBuffer.Companion.getPool().borrow();
        int readSize = 1;
        try {
            void this_$iv$iv$iv;
            void this_$iv$iv;
            void this_$iv;
            IoBuffer ioBuffer = tmp;
            int size$iv = 0;
            boolean $i$f$writeDirect = false;
            int rem$iv = this_$iv.getWriteRemaining();
            boolean condition$iv$iv = size$iv <= rem$iv;
            boolean $i$f$require = false;
            if (!condition$iv$iv) {
                RequireFailureCapture m$iv$iv = new RequireFailureCapture(size$iv, rem$iv){
                    final /* synthetic */ int $size$inlined;
                    final /* synthetic */ int $rem$inlined;
                    {
                        this.$size$inlined = n;
                        this.$rem$inlined = n2;
                    }

                    @NotNull
                    public Void doFail() {
                        String string;
                        boolean bl = false;
                        String string2 = string = "size " + this.$size$inlined + " is greater than buffer's remaining capacity " + this.$rem$inlined;
                        throw (Throwable)new IllegalArgumentException(string2);
                    }
                };
                Void void_ = m$iv$iv.doFail();
                throw null;
            }
            ByteBuffer buffer$iv = this_$iv.writeBuffer;
            int positionBefore$iv = buffer$iv.position();
            ByteBuffer tmpBb = buffer$iv;
            boolean bl = false;
            CharBuffer charBuffer = tmpBb.asCharBuffer();
            if (charBuffer == null) {
                Intrinsics.throwNpe();
            }
            CharBuffer cb = charBuffer;
            while (input.getRemaining() > 0L) {
                int n;
                IoBuffer chunk;
                block48: {
                    cb.clear();
                    chunk = input.prepareReadHead(readSize);
                    if (chunk == null) {
                        break;
                    }
                    IoBuffer $receiver$iv = chunk;
                    boolean $i$f$decodeUTF8 = false;
                    int byteCount$iv = 0;
                    int value$iv = 0;
                    int lastByteCount$iv = 0;
                    while ($receiver$iv.canRead()) {
                        block53: {
                            block54: {
                                boolean bl2;
                                boolean bl3;
                                boolean bl4;
                                char ch;
                                block52: {
                                    boolean bl5;
                                    int n2;
                                    int v$iv = $receiver$iv.readByte() & 0xFF;
                                    if ((v$iv & 0x80) == 0) {
                                        boolean bl6;
                                        if (byteCount$iv != 0) {
                                            Void void_ = UTF8Kt.malformedByteCount(byteCount$iv);
                                            throw null;
                                        }
                                        char ch2 = (char)v$iv;
                                        n2 = 0;
                                        if (cb.hasRemaining()) {
                                            cb.put(ch2);
                                            bl6 = true;
                                        } else {
                                            bl6 = false;
                                        }
                                        if (bl6) continue;
                                        $receiver$iv.pushBack(1);
                                        n = -1;
                                        break block48;
                                    }
                                    if (byteCount$iv == 0) {
                                        int mask$iv = 128;
                                        value$iv = v$iv;
                                        n2 = 1;
                                        int n3 = 6;
                                        while (n2 <= n3 && (value$iv & mask$iv) != 0) {
                                            void i$iv;
                                            value$iv &= ~mask$iv;
                                            mask$iv >>= 1;
                                            ++byteCount$iv;
                                            ++i$iv;
                                        }
                                        lastByteCount$iv = byteCount$iv--;
                                        if (byteCount$iv <= $receiver$iv.getReadRemaining()) continue;
                                        $receiver$iv.pushBack(1);
                                        n = lastByteCount$iv;
                                        break block48;
                                    }
                                    value$iv = value$iv << 6 | v$iv & 0x7F;
                                    if (--byteCount$iv != 0) continue;
                                    if (!UTF8Kt.isBmpCodePoint(value$iv)) break block52;
                                    ch = (char)value$iv;
                                    bl4 = false;
                                    if (cb.hasRemaining()) {
                                        cb.put(ch);
                                        bl5 = true;
                                    } else {
                                        bl5 = false;
                                    }
                                    if (!bl5) {
                                        $receiver$iv.pushBack(lastByteCount$iv);
                                        n = -1;
                                        break block48;
                                    }
                                    break block53;
                                }
                                if (!UTF8Kt.isValidCodePoint(value$iv)) {
                                    Void void_ = UTF8Kt.malformedCodePoint(value$iv);
                                    throw null;
                                }
                                ch = (char)UTF8Kt.highSurrogate(value$iv);
                                bl4 = false;
                                if (cb.hasRemaining()) {
                                    cb.put(ch);
                                    bl3 = true;
                                } else {
                                    bl3 = false;
                                }
                                if (!bl3) break block54;
                                ch = (char)UTF8Kt.lowSurrogate(value$iv);
                                bl4 = false;
                                if (cb.hasRemaining()) {
                                    cb.put(ch);
                                    bl2 = true;
                                } else {
                                    bl2 = false;
                                }
                                if (bl2) break block53;
                            }
                            $receiver$iv.pushBack(lastByteCount$iv);
                            n = -1;
                            break block48;
                        }
                        value$iv = 0;
                    }
                    n = 0;
                }
                int rc = n;
                input.updateHeadRemaining(chunk.getReadRemaining());
                cb.flip();
                int writeSize = 1;
                if (cb.hasRemaining()) {
                    Output $receiver$iv = dst;
                    int initialSize$iv = 1;
                    boolean $i$f$writeWhileSize = false;
                    IoBuffer tail$iv = UnsafeKt.prepareWriteHead($receiver$iv, initialSize$iv, null);
                    try {
                        int size$iv2 = 0;
                        while (true) {
                            void this_$iv$iv$iv2;
                            int delta$iv;
                            CoderResult cr;
                            void this_$iv2;
                            IoBuffer view = tail$iv;
                            boolean bl7 = false;
                            IoBuffer ioBuffer2 = view;
                            int size$iv3 = writeSize;
                            boolean $i$f$writeDirect2 = false;
                            int rem$iv2 = this_$iv2.getWriteRemaining();
                            boolean condition$iv$iv2 = size$iv3 <= rem$iv2;
                            boolean $i$f$require2 = false;
                            if (!condition$iv$iv2) {
                                RequireFailureCapture m$iv$iv = new RequireFailureCapture(size$iv3, rem$iv2){
                                    final /* synthetic */ int $size$inlined;
                                    final /* synthetic */ int $rem$inlined;
                                    {
                                        this.$size$inlined = n;
                                        this.$rem$inlined = n2;
                                    }

                                    @NotNull
                                    public Void doFail() {
                                        String string;
                                        boolean bl = false;
                                        String string2 = string = "size " + this.$size$inlined + " is greater than buffer's remaining capacity " + this.$rem$inlined;
                                        throw (Throwable)new IllegalArgumentException(string2);
                                    }
                                };
                                Void void_ = m$iv$iv.doFail();
                                throw null;
                            }
                            ByteBuffer buffer$iv2 = this_$iv2.writeBuffer;
                            int positionBefore$iv2 = buffer$iv2.position();
                            ByteBuffer to = buffer$iv2;
                            boolean bl8 = false;
                            CoderResult coderResult = cr = $receiver.encode(cb, to, false);
                            Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"cr");
                            if (coderResult.isUnmappable() || cr.isMalformed()) {
                                CharsetJVMKt.throwExceptionWrapped(cr);
                            }
                            if (cr.isOverflow() && to.hasRemaining()) {
                                int n4 = writeSize;
                                writeSize = n4 + 1;
                            } else {
                                writeSize = 1;
                            }
                            if ((delta$iv = buffer$iv2.position() - positionBefore$iv2) < 0 || delta$iv > rem$iv2) {
                                Void void_ = ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv3);
                                throw null;
                            }
                            this_$iv$iv = this_$iv2;
                            boolean $i$f$afterWrite = false;
                            void var38_63 = this_$iv$iv;
                            ByteBuffer byteBuffer = this_$iv$iv.readBuffer;
                            boolean $i$f$getWritePosition = false;
                            int n5 = this_$iv$iv$iv2.writeBuffer.position();
                            byteBuffer.limit(n5);
                            int n6 = size$iv2 = cb.hasRemaining() ? writeSize : 0;
                            if (size$iv2 <= 0) {
                                break;
                            }
                            tail$iv = UnsafeKt.prepareWriteHead($receiver$iv, size$iv2, tail$iv);
                        }
                    }
                    finally {
                        UnsafeKt.afterHeadWrite($receiver$iv, tail$iv);
                    }
                }
                if (rc <= 0) continue;
                readSize = rc;
                break;
            }
            cb.clear();
            cb.flip();
            int completeSize = 1;
            Output $receiver$iv = dst;
            int initialSize$iv = 1;
            boolean $i$f$writeWhileSize = false;
            IoBuffer tail$iv = UnsafeKt.prepareWriteHead($receiver$iv, initialSize$iv, null);
            try {
                int size$iv4 = 0;
                while (true) {
                    void this_$iv$iv$iv3;
                    int delta$iv;
                    CoderResult cr;
                    void this_$iv3;
                    IoBuffer chunk = tail$iv;
                    boolean bl9 = false;
                    IoBuffer view = chunk;
                    int size$iv5 = completeSize;
                    boolean $i$f$writeDirect3 = false;
                    int rem$iv3 = this_$iv3.getWriteRemaining();
                    boolean condition$iv$iv3 = size$iv5 <= rem$iv3;
                    boolean $i$f$require3 = false;
                    if (!condition$iv$iv3) {
                        RequireFailureCapture m$iv$iv = new RequireFailureCapture(size$iv5, rem$iv3){
                            final /* synthetic */ int $size$inlined;
                            final /* synthetic */ int $rem$inlined;
                            {
                                this.$size$inlined = n;
                                this.$rem$inlined = n2;
                            }

                            @NotNull
                            public Void doFail() {
                                String string;
                                boolean bl = false;
                                String string2 = string = "size " + this.$size$inlined + " is greater than buffer's remaining capacity " + this.$rem$inlined;
                                throw (Throwable)new IllegalArgumentException(string2);
                            }
                        };
                        Void void_ = m$iv$iv.doFail();
                        throw null;
                    }
                    ByteBuffer buffer$iv3 = this_$iv3.writeBuffer;
                    int positionBefore$iv3 = buffer$iv3.position();
                    ByteBuffer to = buffer$iv3;
                    boolean bl10 = false;
                    CoderResult coderResult = cr = $receiver.encode(cb, to, true);
                    Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"cr");
                    if (coderResult.isMalformed() || cr.isUnmappable()) {
                        CharsetJVMKt.throwExceptionWrapped(cr);
                    }
                    if (cr.isOverflow()) {
                        int n = completeSize;
                        completeSize = n + 1;
                    } else {
                        completeSize = 0;
                    }
                    if ((delta$iv = buffer$iv3.position() - positionBefore$iv3) < 0 || delta$iv > rem$iv3) {
                        Void void_ = ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv5);
                        throw null;
                    }
                    void this_$iv$iv2 = this_$iv3;
                    boolean $i$f$afterWrite = false;
                    this_$iv$iv = this_$iv$iv2;
                    ByteBuffer byteBuffer = this_$iv$iv2.readBuffer;
                    boolean $i$f$getWritePosition = false;
                    int n = this_$iv$iv$iv3.writeBuffer.position();
                    byteBuffer.limit(n);
                    size$iv4 = completeSize;
                    if (size$iv4 <= 0) {
                        break;
                    }
                    tail$iv = UnsafeKt.prepareWriteHead($receiver$iv, size$iv4, tail$iv);
                }
            }
            finally {
                UnsafeKt.afterHeadWrite($receiver$iv, tail$iv);
            }
            int delta$iv = buffer$iv.position() - positionBefore$iv;
            if (delta$iv < 0 || delta$iv > rem$iv) {
                Void void_ = ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
                throw null;
            }
            void this_$iv$iv3 = this_$iv;
            boolean $i$f$afterWrite = false;
            void var44_71 = this_$iv$iv3;
            ByteBuffer byteBuffer = this_$iv$iv3.readBuffer;
            boolean $i$f$getWritePosition = false;
            int n = this_$iv$iv$iv.writeBuffer.position();
            byteBuffer.limit(n);
        }
        finally {
            tmp.release(IoBuffer.Companion.getPool());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean encodeComplete(@NotNull CharsetEncoder $receiver, @NotNull IoBuffer dst) {
        void this_$iv$iv$iv;
        int delta$iv;
        CoderResult result;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        boolean completed = false;
        IoBuffer ioBuffer = dst;
        int size$iv = 0;
        boolean $i$f$writeDirect = false;
        int rem$iv = this_$iv.getWriteRemaining();
        boolean condition$iv$iv = size$iv <= rem$iv;
        boolean $i$f$require = false;
        if (!condition$iv$iv) {
            RequireFailureCapture m$iv$iv = new RequireFailureCapture(size$iv, rem$iv){
                final /* synthetic */ int $size$inlined;
                final /* synthetic */ int $rem$inlined;
                {
                    this.$size$inlined = n;
                    this.$rem$inlined = n2;
                }

                @NotNull
                public Void doFail() {
                    String string;
                    boolean bl = false;
                    String string2 = string = "size " + this.$size$inlined + " is greater than buffer's remaining capacity " + this.$rem$inlined;
                    throw (Throwable)new IllegalArgumentException(string2);
                }
            };
            Void void_ = m$iv$iv.doFail();
            throw null;
        }
        ByteBuffer buffer$iv = this_$iv.writeBuffer;
        int positionBefore$iv = buffer$iv.position();
        ByteBuffer bb = buffer$iv;
        boolean bl = false;
        CoderResult coderResult = result = $receiver.encode(EmptyCharBuffer, bb, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"result");
        if (coderResult.isMalformed() || result.isUnmappable()) {
            CharsetJVMKt.throwExceptionWrapped(result);
        }
        if (result.isUnderflow()) {
            completed = true;
        }
        if ((delta$iv = buffer$iv.position() - positionBefore$iv) < 0 || delta$iv > rem$iv) {
            Void void_ = ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
            throw null;
        }
        void this_$iv$iv = this_$iv;
        boolean $i$f$afterWrite = false;
        void var15_17 = this_$iv$iv;
        ByteBuffer byteBuffer = this_$iv$iv.readBuffer;
        boolean $i$f$getWritePosition = false;
        int n = this_$iv$iv$iv.writeBuffer.position();
        byteBuffer.limit(n);
        return completed;
    }

    @NotNull
    public static final Charset getCharset(@NotNull CharsetDecoder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Charset charset = $receiver.charset();
        if (charset == null) {
            Intrinsics.throwNpe();
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int decode(@NotNull CharsetDecoder $receiver, @NotNull Input input, @NotNull Appendable dst, int max) {
        CoderResult cr;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        int copied = 0;
        CharBuffer cb = CharBuffer.allocate(8192);
        int readSize = 1;
        Input $receiver$iv = input;
        int initialSize$iv = 1;
        boolean $i$f$takeWhileSize = false;
        boolean release$iv = true;
        IoBuffer ioBuffer = UnsafeKt.prepareReadFirstHead($receiver$iv, initialSize$iv);
        if (ioBuffer == null) {
        } else {
            IoBuffer current$iv = ioBuffer;
            int size$iv = initialSize$iv;
            try {
                do {
                    IoBuffer next$iv;
                    IoBuffer ioBuffer2;
                    int before$iv = current$iv.getReadRemaining();
                    int after$iv = 0;
                    if (before$iv >= size$iv) {
                        try {
                            int n;
                            IoBuffer buffer = current$iv;
                            boolean bl = false;
                            int rem = max - copied;
                            if (rem == 0) {
                                n = 0;
                            } else {
                                int delta$iv;
                                IoBuffer this_$iv = buffer;
                                boolean $i$f$readDirect = false;
                                ByteBuffer bb$iv = this_$iv.readBuffer;
                                int positionBefore$iv = bb$iv.position();
                                int limit$iv = bb$iv.limit();
                                ByteBuffer bb = bb$iv;
                                boolean bl2 = false;
                                cb.clear();
                                if (rem < 8192) {
                                    cb.limit(rem);
                                }
                                CoderResult rc = $receiver.decode(bb, cb, false);
                                cb.flip();
                                copied += cb.remaining();
                                dst.append(cb);
                                CoderResult coderResult = rc;
                                Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"rc");
                                if (coderResult.isMalformed() || rc.isUnmappable()) {
                                    CharsetJVMKt.throwExceptionWrapped(rc);
                                }
                                if (rc.isUnderflow() && bb.hasRemaining()) {
                                    int n2 = readSize;
                                    readSize = n2 + 1;
                                } else {
                                    readSize = 1;
                                }
                                if ((delta$iv = bb$iv.position() - positionBefore$iv) < 0) {
                                    Void void_ = ErrorsKt.negativeShiftError(delta$iv);
                                    throw null;
                                }
                                if (bb$iv.limit() != limit$iv) {
                                    Void void_ = ErrorsKt.limitChangeError();
                                    throw null;
                                }
                                n = readSize;
                            }
                            size$iv = n;
                        }
                        finally {
                            after$iv = current$iv.getReadRemaining();
                        }
                    } else {
                        after$iv = before$iv;
                    }
                    release$iv = false;
                    if (after$iv == 0) {
                        ioBuffer2 = UnsafeKt.prepareReadNextHead($receiver$iv, current$iv);
                    } else if (after$iv < size$iv || current$iv.getEndGap() < IoBuffer.Companion.getReservedSize()) {
                        UnsafeKt.completeReadHead($receiver$iv, current$iv);
                        ioBuffer2 = UnsafeKt.prepareReadFirstHead($receiver$iv, size$iv);
                    } else {
                        ioBuffer2 = next$iv = current$iv;
                    }
                    if (next$iv == null) {
                        release$iv = false;
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($receiver$iv, current$iv);
                }
            }
        }
        do {
            cb.clear();
            int rem = max - copied;
            if (rem == 0) break;
            if (rem < 8192) {
                cb.limit(rem);
            }
            cr = $receiver.decode(EmptyByteBuffer, cb, true);
            cb.flip();
            copied += cb.remaining();
            dst.append(cb);
            CoderResult coderResult = cr;
            Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"cr");
            if (!coderResult.isUnmappable() && !cr.isMalformed()) continue;
            CharsetJVMKt.throwExceptionWrapped(cr);
        } while (cr.isOverflow());
        return copied;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decodeExactBytes(@NotNull CharsetDecoder $receiver, @NotNull Input input, int inputLength) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        if (inputLength == 0) {
            return "";
        }
        if (input instanceof ByteReadPacketBase && ((ByteReadPacketBase)input).getHeadRemaining() >= inputLength) {
            if (((ByteReadPacketBase)input).getHead().readBuffer.hasArray()) {
                void offset$iv;
                void bytes$iv;
                ByteBuffer bb = ((ByteReadPacketBase)input).getHead().readBuffer;
                byte[] byArray = bb.array();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bb.array()");
                byte[] byArray2 = byArray;
                int n = bb.arrayOffset() + bb.position();
                Charset charset = $receiver.charset();
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"charset()");
                Charset charset$iv = charset;
                boolean $i$f$String = false;
                String text = new String((byte[])bytes$iv, (int)offset$iv, inputLength, charset$iv);
                ((ByteReadPacketBase)input).discardExact(inputLength);
                return text;
            }
            return CharsetJVMKt.decodeImplByteBuffer($receiver, (ByteReadPacketBase)input, inputLength);
        }
        return CharsetJVMKt.decodeImplSlow($receiver, input, inputLength);
    }

    private static final String decodeImplByteBuffer(@NotNull CharsetDecoder $receiver, ByteReadPacketBase input, int inputLength) {
        CoderResult rc;
        CharBuffer cb = CharBuffer.allocate(inputLength);
        ByteBuffer bb = input.getHead().readBuffer;
        int limit = bb.limit();
        bb.limit(bb.position() + inputLength);
        CoderResult coderResult = rc = $receiver.decode(input.getHead().readBuffer, cb, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"rc");
        if (coderResult.isMalformed() || rc.isUnmappable()) {
            CharsetJVMKt.throwExceptionWrapped(rc);
        }
        bb.limit(limit);
        cb.flip();
        String string = cb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cb.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String decodeImplSlow(@NotNull CharsetDecoder $receiver, Input input, int inputLength) {
        CharBuffer cb = CharBuffer.allocate(inputLength);
        int remainingInputBytes = inputLength;
        boolean lastChunk = false;
        int readSize = 1;
        Input $receiver$iv = input;
        int initialSize$iv = 1;
        boolean $i$f$takeWhileSize = false;
        boolean release$iv = true;
        IoBuffer ioBuffer = UnsafeKt.prepareReadFirstHead($receiver$iv, initialSize$iv);
        if (ioBuffer == null) {
        } else {
            IoBuffer current$iv = ioBuffer;
            int size$iv = initialSize$iv;
            try {
                do {
                    IoBuffer next$iv;
                    IoBuffer ioBuffer2;
                    int before$iv = current$iv.getReadRemaining();
                    int after$iv = 0;
                    if (before$iv >= size$iv) {
                        try {
                            int n;
                            IoBuffer buffer = current$iv;
                            boolean bl = false;
                            if (!cb.hasRemaining() || remainingInputBytes == 0) {
                                n = 0;
                            } else {
                                CoderResult rc;
                                int positionBefore;
                                IoBuffer this_$iv = buffer;
                                boolean $i$f$readDirect = false;
                                ByteBuffer bb$iv = this_$iv.readBuffer;
                                int positionBefore$iv = bb$iv.position();
                                int limit$iv = bb$iv.limit();
                                ByteBuffer bb = bb$iv;
                                boolean bl2 = false;
                                int limitBefore = bb.limit();
                                boolean bl3 = lastChunk = limitBefore - (positionBefore = bb.position()) >= remainingInputBytes;
                                if (lastChunk) {
                                    bb.limit(positionBefore + remainingInputBytes);
                                }
                                CoderResult coderResult = rc = $receiver.decode(bb, cb, lastChunk);
                                Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"rc");
                                if (coderResult.isMalformed() || rc.isUnmappable()) {
                                    CharsetJVMKt.throwExceptionWrapped(rc);
                                }
                                if (rc.isUnderflow() && bb.hasRemaining()) {
                                    int n2 = readSize;
                                    readSize = n2 + 1;
                                } else {
                                    readSize = 1;
                                }
                                bb.limit(limitBefore);
                                remainingInputBytes -= bb.position() - positionBefore;
                                int delta$iv = bb$iv.position() - positionBefore$iv;
                                if (delta$iv < 0) {
                                    Void void_ = ErrorsKt.negativeShiftError(delta$iv);
                                    throw null;
                                }
                                if (bb$iv.limit() != limit$iv) {
                                    Void void_ = ErrorsKt.limitChangeError();
                                    throw null;
                                }
                                n = readSize;
                            }
                            size$iv = n;
                        }
                        finally {
                            after$iv = current$iv.getReadRemaining();
                        }
                    } else {
                        after$iv = before$iv;
                    }
                    release$iv = false;
                    if (after$iv == 0) {
                        ioBuffer2 = UnsafeKt.prepareReadNextHead($receiver$iv, current$iv);
                    } else if (after$iv < size$iv || current$iv.getEndGap() < IoBuffer.Companion.getReservedSize()) {
                        UnsafeKt.completeReadHead($receiver$iv, current$iv);
                        ioBuffer2 = UnsafeKt.prepareReadFirstHead($receiver$iv, size$iv);
                    } else {
                        ioBuffer2 = next$iv = current$iv;
                    }
                    if (next$iv == null) {
                        release$iv = false;
                        break;
                    }
                    current$iv = next$iv;
                    release$iv = true;
                } while (size$iv > 0);
            }
            finally {
                if (release$iv) {
                    UnsafeKt.completeReadHead($receiver$iv, current$iv);
                }
            }
        }
        if (cb.hasRemaining() && !lastChunk) {
            CoderResult rc;
            CoderResult coderResult = rc = $receiver.decode(EmptyByteBuffer, cb, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)coderResult, (String)"rc");
            if (coderResult.isMalformed() || rc.isUnmappable()) {
                CharsetJVMKt.throwExceptionWrapped(rc);
            }
        }
        if (remainingInputBytes > 0) {
            throw (Throwable)new EOFException("Not enough bytes available: had only " + (inputLength - remainingInputBytes) + " instead of " + inputLength);
        }
        if (remainingInputBytes < 0) {
            throw (Throwable)((Object)new AssertionError((Object)"remainingInputBytes < 0"));
        }
        cb.flip();
        String string = cb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cb.toString()");
        return string;
    }

    private static final void throwExceptionWrapped(@NotNull CoderResult $receiver) {
        try {
            $receiver.throwException();
        }
        catch (java.nio.charset.MalformedInputException original) {
            String string = original.getMessage();
            if (string == null) {
                string = "Failed to decode bytes";
            }
            throw (Throwable)new MalformedInputException(string);
        }
    }

    static {
        CharBuffer charBuffer = CharBuffer.allocate(0);
        if (charBuffer == null) {
            Intrinsics.throwNpe();
        }
        EmptyCharBuffer = charBuffer;
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        if (byteBuffer == null) {
            Intrinsics.throwNpe();
        }
        EmptyByteBuffer = byteBuffer;
    }
}

