/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.protocol;

import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.HMAC;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocket;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImpl;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;
import org.jetbrains.kotlinx.jupyter.protocol.SocketWithCancellationBase;
import org.jetbrains.kotlinx.jupyter.protocol.SocketWrapper;
import org.jetbrains.kotlinx.jupyter.protocol.SocketWrapperKt;
import org.jetbrains.kotlinx.jupyter.util.SerializersKt;
import org.slf4j.Logger;
import org.zeromq.ZMQ;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0010H\u0002J'\u0010!\u001a\u00020\u00112\u001d\u0010\"\u001a\u0019\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\b\u0013H\u0016JF\u0010$\u001a\u001d\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012\u00a2\u0006\u0002\b\u00132!\u0010%\u001a\u001d\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u0010H\u0016J+\u0010'\u001a\u00020\u00112!\u0010%\u001a\u001d\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u000f\u0010(\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\r\u001a#\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012\u00a2\u0006\u0002\b\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/SocketWrapper;", "Lorg/jetbrains/kotlinx/jupyter/protocol/SocketWithCancellationBase;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSocket;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "name", "", "socket", "Lorg/zeromq/ZMQ$Socket;", "address", "hmac", "Lorg/jetbrains/kotlinx/jupyter/protocol/HMAC;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;Ljava/lang/String;Lorg/zeromq/ZMQ$Socket;Ljava/lang/String;Lorg/jetbrains/kotlinx/jupyter/protocol/HMAC;)V", "callbacks", "", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/RawMessage;", "", "Lorg/jetbrains/kotlinx/jupyter/protocol/SocketRawMessageCallback;", "Lkotlin/ExtensionFunctionType;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "getName", "()Ljava/lang/String;", "bind", "", "close", "connect", "doReceiveRawMessage", "doSendRawMessage", "msg", "onData", "body", "", "onRawMessage", "callback", "receiveRawMessage", "removeCallback", "runCallbacksOnMessage", "()Lkotlin/Unit;", "sendRawMessage", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nSocketWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketWrapper.kt\norg/jetbrains/kotlinx/jupyter/protocol/SocketWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 5 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,181:1\n1855#2,2:182\n1855#2,2:184\n1549#2:186\n1620#2,2:187\n1622#2:191\n1#3:189\n113#4:190\n96#5:192\n*S KotlinDebug\n*F\n+ 1 SocketWrapper.kt\norg/jetbrains/kotlinx/jupyter/protocol/SocketWrapper\n*L\n63#1:182,2\n83#1:184,2\n88#1:186\n88#1:187,2\n88#1:191\n90#1:190\n129#1:192\n*E\n"})
public final class SocketWrapper
extends SocketWithCancellationBase
implements JupyterSocket {
    @NotNull
    private final String name;
    @NotNull
    private final String address;
    @NotNull
    private final HMAC hmac;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final Set<Function2<JupyterSocket, RawMessage, Unit>> callbacks;

    public SocketWrapper(@NotNull KernelLoggerFactory loggerFactory2, @NotNull String name, @NotNull ZMQ.Socket socket, @NotNull String address, @NotNull HMAC hmac2) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)hmac2, (String)"hmac");
        super(socket);
        this.name = name;
        this.address = address;
        this.hmac = hmac2;
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory2, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        this.lock = new ReentrantLock();
        this.callbacks = new LinkedHashSet();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean bind() {
        boolean res2 = this.bind(this.address);
        this.logger.debug("[" + this.name + "] listen: " + this.address);
        return res2;
    }

    @Override
    public boolean connect() {
        boolean res2 = this.connect(this.address);
        this.logger.debug("[" + this.name + "] connected: " + this.address);
        return res2;
    }

    @Override
    @NotNull
    public Function2<JupyterSocket, RawMessage, Unit> onRawMessage(@NotNull Function2<? super JupyterSocket, ? super RawMessage, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.add(callback);
        return callback;
    }

    @Override
    public void removeCallback(@NotNull Function2<? super JupyterSocket, ? super RawMessage, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.remove(callback);
    }

    public void onData(@NotNull Function2<? super JupyterSocket, ? super byte[], Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        body.invoke((Object)this, (Object)this.recv());
    }

    @Override
    @Nullable
    public Unit runCallbacksOnMessage() {
        Unit unit;
        RawMessage rawMessage = this.receiveRawMessage();
        if (rawMessage != null) {
            RawMessage message2 = rawMessage;
            boolean bl = false;
            Iterable $this$forEach$iv = this.callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function2 callback = (Function2)element$iv;
                boolean bl2 = false;
                try {
                    callback.invoke((Object)this, (Object)message2);
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        throw e;
                    }
                    this.logger.error("Exception thrown while processing a message", e);
                }
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Override
    public void sendRawMessage(@NotNull RawMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.debug("[{}] snd>: {}", (Object)this.name, (Object)msg);
        this.doSendRawMessage(msg);
    }

    /*
     * WARNING - void declaration
     */
    private final void doSendRawMessage(RawMessage msg) {
        void $this$mapTo$iv$iv;
        Object it;
        this.assertNotCancelled();
        Iterable $this$forEach$iv = msg.getId();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (byte[])element$iv;
            boolean bl = false;
            this.sendMore((byte[])it);
        }
        this.sendMore(SocketWrapperKt.access$getMESSAGE_DELIMITER$p());
        Object[] $i$f$forEach22 = new KProperty1[]{doSendRawMessage.properties.1.INSTANCE, doSendRawMessage.properties.2.INSTANCE, doSendRawMessage.properties.3.INSTANCE, doSendRawMessage.properties.4.INSTANCE};
        List properties2 = CollectionsKt.listOf((Object[])$i$f$forEach22);
        Iterable $this$map$iv = properties2;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Collection collection;
            block6: {
                block5: {
                    void prop;
                    KProperty1 kProperty1 = (KProperty1)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    object = (JsonElement)prop.get((Object)msg);
                    if (object == null) break block5;
                    JsonElement it2 = object;
                    boolean bl2 = false;
                    StringFormat $this$encodeToString$iv = (StringFormat)RawMessageImplKt.getMessageFormat();
                    boolean $i$f$encodeToString = false;
                    $this$encodeToString$iv.getSerializersModule();
                    String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)it2);
                    object = string;
                    if (string == null) break block5;
                    byte[] byArray = object.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    object = byArray;
                    if (byArray != null) break block6;
                }
                object = SocketWrapperKt.access$getEmptyJsonObjectStringBytes$p();
            }
            collection.add(object);
        }
        List signableMsg = (List)destination$iv$iv;
        this.sendMore(this.hmac.invoke(signableMsg));
        int n = signableMsg.size() - 1;
        for (int i = 0; i < n; ++i) {
            this.sendMore((byte[])signableMsg.get(i));
        }
        this.send((byte[])CollectionsKt.last((List)signableMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RawMessage receiveRawMessage() {
        RawMessage rawMessage;
        try {
            RawMessage rawMessage2;
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                rawMessage2 = this.doReceiveRawMessage();
            }
            finally {
                lock.unlock();
            }
            RawMessage msg = rawMessage2;
            this.logger.debug("[{}] >rcv: {}", (Object)this.name, (Object)msg);
        }
        catch (SignatureException e) {
            this.logger.error("[" + this.name + "] " + e.getMessage());
            rawMessage = null;
        }
        return rawMessage;
    }

    private final RawMessage doReceiveRawMessage() {
        this.assertNotCancelled();
        List ids2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.recv()), (Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ SocketWrapper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final byte[] invoke() {
                return this.this$0.recv();
            }
        })), (Function1)doReceiveRawMessage.ids.2.INSTANCE));
        String string = this.recvString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String sig = string;
        byte[] header = this.recv();
        byte[] parentHeader = this.recv();
        byte[] metadata = this.recv();
        byte[] content = this.recv();
        byte[][] byArrayArray = new byte[][]{header, parentHeader, metadata, content};
        String calculatedSig = this.hmac.invoke(byArrayArray);
        if (!Intrinsics.areEqual((Object)sig, (Object)calculatedSig)) {
            throw new SignatureException("Invalid signature: expected " + calculatedSig + ", received " + sig + " - " + ids2);
        }
        JsonElement jsonElement = SocketWrapper.doReceiveRawMessage$parseJson(header);
        Intrinsics.checkNotNull((Object)jsonElement);
        JsonElement jsonElement2 = SocketWrapper.doReceiveRawMessage$parseJson(parentHeader);
        JsonElement jsonElement3 = SocketWrapper.doReceiveRawMessage$parseJson(metadata);
        return new RawMessageImpl(ids2, JsonElementKt.getJsonObject((JsonElement)jsonElement), (JsonObject)(jsonElement2 != null ? JsonElementKt.getJsonObject((JsonElement)jsonElement2) : null), (JsonObject)(jsonElement3 != null ? JsonElementKt.getJsonObject((JsonElement)jsonElement3) : null), SocketWrapper.doReceiveRawMessage$orEmptyObject(SocketWrapper.doReceiveRawMessage$parseJson(content)));
    }

    @Override
    public void close() {
        this.callbacks.clear();
        super.close();
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonElement doReceiveRawMessage$parseJson(byte[] $this$doReceiveRawMessage_u24parseJson) {
        void this_$iv;
        Json json = (Json)Json.Default;
        String string$iv = new String($this$doReceiveRawMessage_u24parseJson, Charsets.UTF_8);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        JsonElement json2 = (JsonElement)this_$iv.decodeFromString((DeserializationStrategy)JsonElement.Companion.serializer(), string$iv);
        return json2 instanceof JsonObject && ((JsonObject)json2).isEmpty() ? null : json2;
    }

    private static final JsonElement doReceiveRawMessage$orEmptyObject(JsonElement $this$doReceiveRawMessage_u24orEmptyObject) {
        JsonElement jsonElement = $this$doReceiveRawMessage_u24orEmptyObject;
        if (jsonElement == null) {
            jsonElement = (JsonElement)SerializersKt.getEMPTY((Json)((Json)Json.Default));
        }
        return jsonElement;
    }
}

