/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelHost;
import org.jetbrains.kotlinx.jupyter.api.LibraryLoader;
import org.jetbrains.kotlinx.jupyter.api.Notebook;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesDefinitionDeclaration;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesInstantiable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesProducerDeclaration;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibrariesScanResult;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinitionProducer;
import org.jetbrains.kotlinx.jupyter.config.LoggingKt;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.util.AcceptanceRule;
import org.jetbrains.kotlinx.jupyter.util.AcceptanceRulesKt;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016JN\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00152\u0018\b\u0002\u0010\u0019\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u001b0\u001aJ9\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001aH\u0002\u00a2\u0006\u0002\u0010\"J:\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0015H\u0002J2\u0010%\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0019\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u001b0\u001aH\u0002JF\u0010&\u001a\b\u0012\u0004\u0012\u0002H'0\u001a\"\f\b\u0000\u0010'*\u0006\u0012\u0002\b\u00030\u001f*\b\u0012\u0004\u0012\u0002H'0(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0019\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u001b0(H\u0002J\u001e\u0010\u001c\u001a\u00020!*\u0006\u0012\u0002\b\u00030)2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001aH\u0002R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner;", "Lorg/jetbrains/kotlinx/jupyter/api/LibraryLoader;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;)V", "discardedFQNs", "", "", "Lorg/jetbrains/kotlinx/jupyter/api/TypeName;", "logger", "Lorg/slf4j/Logger;", "processedFQNs", "addLibrariesByScanResult", "", "host", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelHost;", "notebook", "Lorg/jetbrains/kotlinx/jupyter/api/Notebook;", "classLoader", "Ljava/lang/ClassLoader;", "libraryOptions", "", "scanResult", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesScanResult;", "addLibrariesFromClassLoader", "integrationTypeNameRules", "", "Lorg/jetbrains/kotlinx/jupyter/util/AcceptanceRule;", "instantiate", "T", "data", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesInstantiable;", "arguments", "", "(Ljava/lang/ClassLoader;Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibrariesInstantiable;Ljava/util/List;)Ljava/lang/Object;", "instantiateLibraries", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "scanForLibraries", "filterNamesToLoad", "I", "", "Ljava/lang/Class;", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nLibrariesScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibrariesScanner.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,203:1\n766#2:204\n857#2,2:205\n1549#2:208\n1620#2,2:209\n1622#2:212\n1611#2:213\n1855#2:214\n1856#2:216\n1612#2:217\n1855#2,2:218\n1726#2,3:221\n113#3:207\n96#4:211\n1#5:215\n6523#6:220\n37#7,2:224\n*S KotlinDebug\n*F\n+ 1 LibrariesScanner.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesScanner\n*L\n36#1:204\n36#1:205,2\n88#1:208\n88#1:209,2\n88#1:212\n131#1:213\n131#1:214\n131#1:216\n131#1:217\n137#1:218,2\n184#1:221,3\n63#1:207\n90#1:211\n131#1:215\n171#1:220\n190#1:224,2\n*E\n"})
public final class LibrariesScanner
implements LibraryLoader {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<String> processedFQNs;
    @NotNull
    private final Set<String> discardedFQNs;

    public LibrariesScanner(@NotNull KernelLoggerFactory loggerFactory2) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory2, (String)"loggerFactory");
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory2, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        this.processedFQNs = new LinkedHashSet();
        this.discardedFQNs = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    private final <I extends LibrariesInstantiable<?>> List<I> filterNamesToLoad(Iterable<? extends I> $this$filterNamesToLoad, KotlinKernelHost host, Iterable<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$filterTo$iv$iv;
        Iterable<? extends I> $this$filter$iv = $this$filterNamesToLoad;
        boolean $i$f$filter = false;
        Iterable<? extends I> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            LibrariesInstantiable it = (LibrariesInstantiable)element$iv$iv;
            boolean bl2 = false;
            String typeName = it.getFqn();
            Object object = new Boolean[]{host.acceptsIntegrationTypeName(typeName), AcceptanceRulesKt.accepts(integrationTypeNameRules, (Object)typeName)};
            Boolean acceptance = AcceptanceRulesKt.unionAcceptance((Boolean[])object);
            this.logger.debug("Acceptance result for " + typeName + ": " + acceptance);
            object = acceptance;
            if (Intrinsics.areEqual((Object)object, (Object)true)) {
                bl = this.processedFQNs.add(typeName);
            } else if (Intrinsics.areEqual((Object)object, (Object)false)) {
                this.discardedFQNs.add(typeName);
                bl = false;
            } else if (object == null) {
                bl = !this.discardedFQNs.contains(typeName) && this.processedFQNs.add(typeName);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void addLibrariesFromClassLoader(@NotNull ClassLoader classLoader, @NotNull KotlinKernelHost host, @NotNull Notebook notebook2, @NotNull Map<String, String> libraryOptions, @NotNull List<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)notebook2, (String)"notebook");
        Intrinsics.checkNotNullParameter(libraryOptions, (String)"libraryOptions");
        Intrinsics.checkNotNullParameter(integrationTypeNameRules, (String)"integrationTypeNameRules");
        LibrariesScanResult scanResult = this.scanForLibraries(classLoader, host, integrationTypeNameRules);
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        this.logger.debug("Scanning for libraries is done. Detected FQNs: " + $this$encodeToString$iv.encodeToString((SerializationStrategy)LibrariesScanResult.Companion.serializer(), (Object)scanResult));
        List<LibraryDefinition> libraries = this.instantiateLibraries(classLoader, scanResult, notebook2, libraryOptions);
        this.logger.debug("Number of detected definitions: " + libraries.size());
        host.addLibraries((Collection)libraries);
    }

    public static /* synthetic */ void addLibrariesFromClassLoader$default(LibrariesScanner librariesScanner2, ClassLoader classLoader, KotlinKernelHost kotlinKernelHost, Notebook notebook2, Map map, List list, int n, Object object) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        librariesScanner2.addLibrariesFromClassLoader(classLoader, kotlinKernelHost, notebook2, map, list);
    }

    public void addLibrariesByScanResult(@NotNull KotlinKernelHost host, @NotNull Notebook notebook2, @NotNull ClassLoader classLoader, @NotNull Map<String, String> libraryOptions, @NotNull LibrariesScanResult scanResult) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)notebook2, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(libraryOptions, (String)"libraryOptions");
        Intrinsics.checkNotNullParameter((Object)scanResult, (String)"scanResult");
        host.scheduleExecution((Function1)new Function1<KotlinKernelHost, Unit>(this, classLoader, scanResult, notebook2, libraryOptions, host){
            final /* synthetic */ LibrariesScanner this$0;
            final /* synthetic */ ClassLoader $classLoader;
            final /* synthetic */ LibrariesScanResult $scanResult;
            final /* synthetic */ Notebook $notebook;
            final /* synthetic */ Map<String, String> $libraryOptions;
            final /* synthetic */ KotlinKernelHost $host;
            {
                this.this$0 = $receiver;
                this.$classLoader = $classLoader;
                this.$scanResult = $scanResult;
                this.$notebook = $notebook;
                this.$libraryOptions = $libraryOptions;
                this.$host = $host;
                super(1);
            }

            public final void invoke(@NotNull KotlinKernelHost $this$scheduleExecution) {
                Intrinsics.checkNotNullParameter((Object)$this$scheduleExecution, (String)"$this$scheduleExecution");
                List libraries = LibrariesScanner.access$instantiateLibraries(this.this$0, this.$classLoader, this.$scanResult, this.$notebook, this.$libraryOptions);
                this.$host.addLibraries((Collection)libraries);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final LibrariesScanResult scanForLibraries(ClassLoader classLoader, KotlinKernelHost host, List<? extends AcceptanceRule<String>> integrationTypeNameRules) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Enumeration<URL> enumeration = classLoader.getResources("META-INF/kotlin-jupyter-libraries/libraries.json");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
        ArrayList<URL> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable iterable = arrayList;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            URL uRL = (URL)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)url);
            void var14_14 = url;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)var14_14);
            String contents = new String(byArray, charset);
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            collection.add((LibrariesScanResult)this_$iv.decodeFromString((DeserializationStrategy)LibrariesScanResult.Companion.serializer(), contents));
        }
        List results = (List)destination$iv$iv;
        List definitions = new ArrayList();
        List producers = new ArrayList();
        for (LibrariesScanResult result2 : results) {
            definitions.addAll(result2.getDefinitions());
            producers.addAll(result2.getProducers());
        }
        return new LibrariesScanResult(LibrariesScanner.scanForLibraries$filterNames(definitions, this, host, integrationTypeNameRules), LibrariesScanner.scanForLibraries$filterNames(producers, this, host, integrationTypeNameRules));
    }

    static /* synthetic */ LibrariesScanResult scanForLibraries$default(LibrariesScanner librariesScanner2, ClassLoader classLoader, KotlinKernelHost kotlinKernelHost, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return librariesScanner2.scanForLibraries(classLoader, kotlinKernelHost, list);
    }

    private final List<LibraryDefinition> instantiateLibraries(ClassLoader classLoader, LibrariesScanResult scanResult, Notebook notebook2, Map<String, String> libraryOptions) {
        List definitions = new ArrayList();
        Object[] objectArray = new Object[]{notebook2, libraryOptions};
        List arguments = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$mapNotNullTo$iv = scanResult.getDefinitions();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            LibraryDefinition it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            LibrariesDefinitionDeclaration declaration = (LibrariesDefinitionDeclaration)element$iv;
            boolean bl2 = false;
            if ((LibraryDefinition)LibrariesScanner.instantiateLibraries$withErrorsHandling(this, (LibrariesInstantiable)declaration, (Function0)new Function0<LibraryDefinition>(this, classLoader, declaration, (List<? extends Object>)arguments){
                final /* synthetic */ LibrariesScanner this$0;
                final /* synthetic */ ClassLoader $classLoader;
                final /* synthetic */ LibrariesDefinitionDeclaration $declaration;
                final /* synthetic */ List<Object> $arguments;
                {
                    this.this$0 = $receiver;
                    this.$classLoader = $classLoader;
                    this.$declaration = $declaration;
                    this.$arguments = $arguments;
                    super(0);
                }

                @Nullable
                public final LibraryDefinition invoke() {
                    return (LibraryDefinition)LibrariesScanner.access$instantiate(this.this$0, this.$classLoader, (LibrariesInstantiable)this.$declaration, this.$arguments);
                }
            }) == null) continue;
            boolean bl3 = false;
            ((Collection)definitions).add(it$iv);
        }
        Iterable $this$forEach$iv = scanResult.getProducers();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LibrariesProducerDeclaration declaration = (LibrariesProducerDeclaration)element$iv;
            boolean bl = false;
            LibrariesScanner.instantiateLibraries$withErrorsHandling(this, (LibrariesInstantiable)declaration, (Function0)new Function0<Unit>(this, classLoader, declaration, (List<? extends Object>)arguments, notebook2, (List<LibraryDefinition>)definitions){
                final /* synthetic */ LibrariesScanner this$0;
                final /* synthetic */ ClassLoader $classLoader;
                final /* synthetic */ LibrariesProducerDeclaration $declaration;
                final /* synthetic */ List<Object> $arguments;
                final /* synthetic */ Notebook $notebook;
                final /* synthetic */ List<LibraryDefinition> $definitions;
                {
                    this.this$0 = $receiver;
                    this.$classLoader = $classLoader;
                    this.$declaration = $declaration;
                    this.$arguments = $arguments;
                    this.$notebook = $notebook;
                    this.$definitions = $definitions;
                    super(0);
                }

                public final void invoke() {
                    block1: {
                        LibraryDefinitionProducer libraryDefinitionProducer = (LibraryDefinitionProducer)LibrariesScanner.access$instantiate(this.this$0, this.$classLoader, (LibrariesInstantiable)this.$declaration, this.$arguments);
                        if (libraryDefinitionProducer == null) break block1;
                        LibraryDefinitionProducer libraryDefinitionProducer2 = libraryDefinitionProducer;
                        Notebook notebook2 = this.$notebook;
                        List<LibraryDefinition> list = this.$definitions;
                        LibraryDefinitionProducer $this$invoke_u24lambda_u241 = libraryDefinitionProducer2;
                        boolean bl = false;
                        Iterable $this$forEach$iv = $this$invoke_u24lambda_u241.getDefinitions(notebook2);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            LibraryDefinition it = (LibraryDefinition)element$iv;
                            boolean bl2 = false;
                            list.add(it);
                        }
                    }
                }
            });
        }
        return definitions;
    }

    private final <T> T instantiate(ClassLoader classLoader, LibrariesInstantiable<T> data, List<? extends Object> arguments) {
        Class<?> clazz = classLoader.loadClass(data.getFqn());
        if (clazz == null) {
            this.logger.warn("Library " + data.getFqn() + " wasn't found in classloader " + classLoader);
            return null;
        }
        return (T)this.instantiate(clazz, arguments);
    }

    /*
     * WARNING - void declaration
     */
    private final Object instantiate(Class<?> $this$instantiate, List<? extends Object> arguments) {
        void $this$sortedByDescending$iv;
        Object obj;
        Object object = obj = JvmClassMappingKt.getKotlinClass($this$instantiate).getObjectInstance();
        if (object != null) {
            return object;
        }
        int argsCount = arguments.size();
        Constructor<?>[] constructorArray = $this$instantiate.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
        Object[] objectArray = constructorArray;
        boolean $i$f$sortedByDescending = false;
        List myConstructors = ArraysKt.sortedWith((Object[])$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Constructor it = (Constructor)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getParameterCount());
                it = (Constructor)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getParameterCount()));
            }
        });
        StringBuilder errorStringBuilder = new StringBuilder();
        for (Constructor constructor : myConstructors) {
            boolean isSuitable;
            int parameterCount;
            block7: {
                boolean bl;
                void $this$all$iv;
                parameterCount = constructor.getParameterCount();
                if (parameterCount > argsCount) {
                    StringBuilder stringBuilder = errorStringBuilder.append("\t" + constructor + ": more than " + argsCount + " parameters");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                    continue;
                }
                Class<?>[] classArray = constructor.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
                Iterable iterable = ArraysKt.zip((Object[])classArray, (Iterable)arguments);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Object arg;
                        Pair pair = (Pair)element$iv;
                        boolean bl2 = false;
                        Class paramType = (Class)pair.component1();
                        if (paramType.isInstance(arg = pair.component2())) continue;
                        bl = false;
                        break block7;
                    }
                    bl = isSuitable = true;
                }
            }
            if (!isSuitable) {
                StringBuilder stringBuilder = errorStringBuilder.append("\t" + constructor + ": wrong parameter types");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                continue;
            }
            Collection $this$toTypedArray$iv = CollectionsKt.take((Iterable)arguments, (int)parameterCount);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            Object t = constructor.newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
            return t;
        }
        Object notFoundReason = myConstructors.isEmpty() ? "no single constructor found" : "no single constructor is applicable\n" + errorStringBuilder;
        throw new ReplException("No suitable constructor found. Reason: " + (String)notFoundReason, null, 2, null);
    }

    private static final <I extends LibrariesInstantiable<?>> List<I> scanForLibraries$filterNames(Iterable<? extends I> $this$scanForLibraries_u24filterNames, LibrariesScanner this$0, KotlinKernelHost $host, List<? extends AcceptanceRule<String>> $integrationTypeNameRules) {
        return this$0.filterNamesToLoad($this$scanForLibraries_u24filterNames, $host, (Iterable<? extends AcceptanceRule<String>>)$integrationTypeNameRules);
    }

    private static final <T> T instantiateLibraries$withErrorsHandling(LibrariesScanner this$0, LibrariesInstantiable<?> declaration, Function0<? extends T> action) {
        Object object;
        try {
            object = action.invoke();
        }
        catch (Throwable e) {
            String errorMessage = "Failed to load library integration class '" + declaration.getFqn() + "'";
            LoggingKt.errorForUser$default(this$0.logger, null, errorMessage, e, 1, null);
            throw new ReplException(errorMessage, e);
        }
        return (T)object;
    }

    public static final /* synthetic */ List access$instantiateLibraries(LibrariesScanner $this, ClassLoader classLoader, LibrariesScanResult scanResult, Notebook notebook2, Map libraryOptions) {
        return $this.instantiateLibraries(classLoader, scanResult, notebook2, libraryOptions);
    }

    public static final /* synthetic */ Object access$instantiate(LibrariesScanner $this, ClassLoader classLoader, LibrariesInstantiable data, List arguments) {
        return $this.instantiate(classLoader, data, arguments);
    }
}

