/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinitionProducer;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionRequest;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplException;
import org.jetbrains.kotlinx.jupyter.libraries.LibrariesProcessor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryReferenceParser;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.TrivialLibraryDefinitionProducer;
import org.jetbrains.kotlinx.jupyter.magics.ParsingKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0013H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesProcessorImpl;", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibrariesProcessor;", "libraryResolver", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "libraryReferenceParser", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParser;", "kernelVersion", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "(Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParser;Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;)V", "_requests", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryResolutionRequest;", "requests", "", "getRequests", "()Ljava/util/Collection;", "checkKernelVersionRequirements", "", "name", "", "library", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "processNewLibraries", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinitionProducer;", "arg", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nLibrariesProcessorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibrariesProcessorImpl.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesProcessorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1549#2:53\n1620#2,3:54\n*S KotlinDebug\n*F\n+ 1 LibrariesProcessorImpl.kt\norg/jetbrains/kotlinx/jupyter/libraries/LibrariesProcessorImpl\n*L\n39#1:53\n39#1:54,3\n*E\n"})
public final class LibrariesProcessorImpl
implements LibrariesProcessor {
    @Nullable
    private final LibraryResolver libraryResolver;
    @NotNull
    private final LibraryReferenceParser libraryReferenceParser;
    @Nullable
    private final KotlinKernelVersion kernelVersion;
    @NotNull
    private final List<LibraryResolutionRequest> _requests;

    public LibrariesProcessorImpl(@Nullable LibraryResolver libraryResolver2, @NotNull LibraryReferenceParser libraryReferenceParser2, @Nullable KotlinKernelVersion kernelVersion) {
        Intrinsics.checkNotNullParameter((Object)libraryReferenceParser2, (String)"libraryReferenceParser");
        this.libraryResolver = libraryResolver2;
        this.libraryReferenceParser = libraryReferenceParser2;
        this.kernelVersion = kernelVersion;
        this._requests = new ArrayList();
    }

    @Override
    @NotNull
    public Collection<LibraryResolutionRequest> getRequests() {
        return this._requests;
    }

    private final void checkKernelVersionRequirements(String name, LibraryDefinition library) {
        KotlinKernelVersion kotlinKernelVersion = library.getMinKernelVersion();
        if (kotlinKernelVersion != null) {
            KotlinKernelVersion minVersion = kotlinKernelVersion;
            boolean bl = false;
            KotlinKernelVersion kotlinKernelVersion2 = this.kernelVersion;
            if (kotlinKernelVersion2 != null) {
                KotlinKernelVersion currentVersion = kotlinKernelVersion2;
                boolean bl2 = false;
                if (currentVersion.compareTo(minVersion) < 0) {
                    throw new ReplException(StringsKt.trimIndent((String)("\n                        Library '" + name + "' requires at least " + minVersion + " version of kernel.\n                        Current kernel version is " + currentVersion + ".\n                        Please update kernel, see https://github.com/Kotlin/kotlin-jupyter#updating for more info.\n                        ")), null, 2, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryDefinitionProducer> processNewLibraries(@NotNull String arg) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Iterable $this$map$iv = ParsingKt.splitLibraryCalls(arg);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair<LibraryReference, List<Variable>> pair = this.libraryReferenceParser.parseReferenceWithArgs((String)it);
            LibraryReference libRef = (LibraryReference)pair.component1();
            List vars = (List)pair.component2();
            LibraryResolver libraryResolver2 = this.libraryResolver;
            if (libraryResolver2 == null || (libraryResolver2 = libraryResolver2.resolve(libRef, vars)) == null) {
                throw new ReplException("Unknown library '" + libRef + "'", null, 2, null);
            }
            LibraryResolver library = libraryResolver2;
            this._requests.add(new LibraryResolutionRequest(libRef, vars, (LibraryDefinition)library));
            this.checkKernelVersionRequirements(libRef.toString(), (LibraryDefinition)library);
            collection.add(new TrivialLibraryDefinitionProducer((LibraryDefinition)library));
        }
        return (List)destination$iv$iv;
    }
}

